/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.distributed.internal;

import com.gemstone.gemfire.SystemFailure;
import com.gemstone.gemfire.distributed.internal.PoolStatHelper;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.java.util.concurrent.SynchronousQueueNoSpin;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class PooledExecutorWithDMStats
extends ThreadPoolExecutor {
    protected final PoolStatHelper stats;
    protected BlockingQueue<Runnable> bufferQueue;
    private Thread bufferConsumer;

    public PooledExecutorWithDMStats(BlockingQueue<Runnable> q, int maxPoolSize, PoolStatHelper stats, ThreadFactory tf, int msTimeout, RejectedExecutionHandler reh) {
        super(PooledExecutorWithDMStats.getCorePoolSize(maxPoolSize), maxPoolSize, msTimeout, TimeUnit.MILLISECONDS, q, tf, reh);
        this.stats = stats;
    }

    private static BlockingQueue<Runnable> initQ(BlockingQueue<Runnable> q) {
        if (q instanceof SynchronousQueue || q instanceof SynchronousQueueNoSpin) {
            return q;
        }
        return new SynchronousQueueNoSpin<Runnable>();
    }

    private static RejectedExecutionHandler initREH(BlockingQueue<Runnable> q) {
        if (q instanceof SynchronousQueue || q instanceof SynchronousQueueNoSpin) {
            return new ThreadPoolExecutor.CallerRunsPolicy();
        }
        return new BufferHandler();
    }

    public PooledExecutorWithDMStats(BlockingQueue<Runnable> q, int maxPoolSize, PoolStatHelper stats, ThreadFactory tf, int msTimeout) {
        this(PooledExecutorWithDMStats.initQ(q), maxPoolSize, stats, tf, msTimeout, PooledExecutorWithDMStats.initREH(q));
        if (!(q instanceof SynchronousQueue)) {
            this.bufferQueue = q;
            final BlockingQueue<Runnable> takeQueue = q;
            final BlockingQueue<Runnable> putQueue = this.getQueue();
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    try {
                        while (true) {
                            SystemFailure.checkFailure();
                            putQueue.put(takeQueue.take());
                        }
                    }
                    catch (InterruptedException ie) {
                        Thread.currentThread().interrupt();
                        return;
                    }
                }
            };
            this.bufferConsumer = tf.newThread(r);
            this.bufferConsumer.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        try {
            super.shutdown();
        }
        finally {
            this.terminated();
        }
    }

    @Override
    protected void terminated() {
        if (this.bufferConsumer != null) {
            this.bufferConsumer.interrupt();
        }
        super.terminated();
    }

    public List shutdownNow() {
        this.terminated();
        List<Runnable> l = super.shutdownNow();
        if (this.bufferQueue != null) {
            this.bufferQueue.drainTo(l);
        }
        return l;
    }

    public PooledExecutorWithDMStats(BlockingQueue<Runnable> q, int poolSize, PoolStatHelper stats, ThreadFactory tf) {
        this(q, poolSize, stats, tf, Integer.getInteger("gemfire.IDLE_THREAD_TIMEOUT", 1800000));
    }

    public PooledExecutorWithDMStats(BlockingQueue<Runnable> q, int poolSize, ThreadFactory tf) {
        this(q, poolSize, null, tf);
    }

    @Override
    protected final void beforeExecute(Thread t, Runnable r) {
        if (this.stats != null) {
            this.stats.startJob();
        }
    }

    @Override
    protected final void afterExecute(Runnable r, Throwable ex) {
        if (this.stats != null) {
            this.stats.endJob();
        }
    }

    private static int getCorePoolSize(int maxSize) {
        if (maxSize == Integer.MAX_VALUE) {
            return 0;
        }
        return 1;
    }

    public static class BufferHandler
    implements RejectedExecutionHandler {
        @Override
        public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
            if (executor.isShutdown()) {
                throw new RejectedExecutionException(LocalizedStrings.PooledExecutorWithDMStats_EXECUTOR_HAS_BEEN_SHUTDOWN.toLocalizedString());
            }
            try {
                PooledExecutorWithDMStats pool = (PooledExecutorWithDMStats)executor;
                pool.bufferQueue.put(r);
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
                RejectedExecutionException e = new RejectedExecutionException(LocalizedStrings.PooledExecutorWithDMStats_INTERRUPTED.toLocalizedString());
                e.initCause(ie);
                throw e;
            }
        }
    }

    public static class BlockHandler
    implements RejectedExecutionHandler {
        @Override
        public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
            if (executor.isShutdown()) {
                throw new RejectedExecutionException(LocalizedStrings.PooledExecutorWithDMStats_EXECUTOR_HAS_BEEN_SHUTDOWN.toLocalizedString());
            }
            try {
                executor.getQueue().put(r);
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
                RejectedExecutionException e = new RejectedExecutionException(LocalizedStrings.PooledExecutorWithDMStats_INTERRUPTED.toLocalizedString());
                e.initCause(ie);
                throw e;
            }
        }
    }
}

