/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.distributed.internal;

import com.gemstone.gemfire.CancelException;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.GemFireCache;
import com.gemstone.gemfire.cache.client.internal.locator.ClientConnectionRequest;
import com.gemstone.gemfire.cache.client.internal.locator.ClientReplacementRequest;
import com.gemstone.gemfire.cache.client.internal.locator.GetAllServersRequest;
import com.gemstone.gemfire.cache.client.internal.locator.LocatorListRequest;
import com.gemstone.gemfire.cache.client.internal.locator.LocatorStatusRequest;
import com.gemstone.gemfire.cache.client.internal.locator.LocatorStatusResponse;
import com.gemstone.gemfire.cache.client.internal.locator.QueueConnectionRequest;
import com.gemstone.gemfire.cache.client.internal.locator.ServerLocationRequest;
import com.gemstone.gemfire.cache.client.internal.locator.wan.LocatorDiscovery;
import com.gemstone.gemfire.cache.client.internal.locator.wan.LocatorHelper;
import com.gemstone.gemfire.cache.client.internal.locator.wan.LocatorJoinMessage;
import com.gemstone.gemfire.cache.client.internal.locator.wan.LocatorMembershipListener;
import com.gemstone.gemfire.cache.client.internal.locator.wan.LocatorMembershipListenerImpl;
import com.gemstone.gemfire.cache.client.internal.locator.wan.RemoteLocatorJoinRequest;
import com.gemstone.gemfire.cache.client.internal.locator.wan.RemoteLocatorJoinResponse;
import com.gemstone.gemfire.cache.client.internal.locator.wan.RemoteLocatorPingRequest;
import com.gemstone.gemfire.cache.client.internal.locator.wan.RemoteLocatorPingResponse;
import com.gemstone.gemfire.cache.client.internal.locator.wan.RemoteLocatorRequest;
import com.gemstone.gemfire.cache.client.internal.locator.wan.RemoteLocatorResponse;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.Locator;
import com.gemstone.gemfire.distributed.LockServiceDestroyedException;
import com.gemstone.gemfire.distributed.internal.DM;
import com.gemstone.gemfire.distributed.internal.DistributionConfig;
import com.gemstone.gemfire.distributed.internal.DistributionConfigImpl;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.distributed.internal.LocatorStats;
import com.gemstone.gemfire.distributed.internal.PoolStatHelper;
import com.gemstone.gemfire.distributed.internal.ProductUseLog;
import com.gemstone.gemfire.distributed.internal.ResourceEvent;
import com.gemstone.gemfire.distributed.internal.ServerLocator;
import com.gemstone.gemfire.distributed.internal.SharedConfiguration;
import com.gemstone.gemfire.distributed.internal.membership.QuorumChecker;
import com.gemstone.gemfire.distributed.internal.membership.jgroup.JGroupMember;
import com.gemstone.gemfire.internal.SocketCreator;
import com.gemstone.gemfire.internal.admin.remote.DistributionLocatorId;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.InternalLogWriter;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.internal.logging.LogWriterFactory;
import com.gemstone.gemfire.internal.logging.LoggingThreadGroup;
import com.gemstone.gemfire.internal.logging.log4j.LocalizedMessage;
import com.gemstone.gemfire.internal.logging.log4j.LogMarker;
import com.gemstone.gemfire.internal.logging.log4j.LogWriterAppenders;
import com.gemstone.gemfire.internal.logging.log4j.LogWriterLogger;
import com.gemstone.gemfire.management.internal.JmxManagerLocator;
import com.gemstone.gemfire.management.internal.JmxManagerLocatorRequest;
import com.gemstone.gemfire.management.internal.JmxManagerLocatorResponse;
import com.gemstone.gemfire.management.internal.cli.CliUtil;
import com.gemstone.gemfire.management.internal.configuration.domain.SharedConfigurationStatus;
import com.gemstone.gemfire.management.internal.configuration.handlers.ConfigurationRequestHandler;
import com.gemstone.gemfire.management.internal.configuration.handlers.SharedConfigurationStatusRequestHandler;
import com.gemstone.gemfire.management.internal.configuration.messages.ConfigurationRequest;
import com.gemstone.gemfire.management.internal.configuration.messages.SharedConfigurationStatusRequest;
import com.gemstone.gemfire.management.internal.configuration.messages.SharedConfigurationStatusResponse;
import com.gemstone.org.jgroups.stack.GossipData;
import com.gemstone.org.jgroups.stack.GossipServer;
import com.gemstone.org.jgroups.stack.IpAddress;
import com.gemstone.org.jgroups.stack.tcpserver.TcpClient;
import com.gemstone.org.jgroups.stack.tcpserver.TcpHandler;
import com.gemstone.org.jgroups.stack.tcpserver.TcpServer;
import com.gemstone.org.jgroups.util.GemFireTracer;
import java.io.File;
import java.io.IOException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.logging.log4j.Logger;

public class InternalLocator
extends Locator
implements InternalDistributedSystem.ConnectListener {
    private static final Logger logger = LogService.getLogger();
    private static final long EXPIRY_MS = 60000L;
    private static final int SHARED_CONFIG_STATUS_TIMEOUT = 10000;
    public static final String FORCE_LOCATOR_DM_TYPE = "Locator.forceLocatorDMType";
    public static final String INHIBIT_DM_BANNER = "Locator.inhibitDMBanner";
    private final TcpServer server;
    private final LocatorHandler handler;
    private InternalDistributedSystem myDs;
    private Cache myCache;
    private File stateFile;
    private ProductUseLog productUseLog;
    private boolean peerLocator;
    private ServerLocator serverLocator;
    protected volatile LocatorStats stats;
    private Properties env;
    private GossipServer gossipServer;
    private DistributionConfigImpl config;
    private final LocatorMembershipListenerImpl locatorListener;
    private ConcurrentMap<Integer, Set<DistributionLocatorId>> allLocatorsInfo = new ConcurrentHashMap<Integer, Set<DistributionLocatorId>>();
    private ConcurrentMap<Integer, Set<String>> allServerLocatorsInfo = new ConcurrentHashMap<Integer, Set<String>>();
    private volatile boolean stoppedForReconnect;
    private final AtomicBoolean shutdownHandled = new AtomicBoolean(false);
    private final ExecutorService _executor;
    private SharedConfiguration sharedConfig;
    private volatile boolean isSharedConfigurationStarted = false;
    private Thread restartThread;
    private static InternalLocator locator;
    private static final Object locatorLock;

    public boolean isSharedConfigurationEnabled() {
        return this.config.getEnableClusterConfiguration();
    }

    public boolean loadFromSharedConfigDir() {
        return this.config.getLoadClusterConfigFromDir();
    }

    public boolean isSharedConfigurationRunning() {
        if (this.sharedConfig != null) {
            return this.sharedConfig.getStatus() == SharedConfigurationStatus.RUNNING;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InternalLocator getLocator() {
        Object object = locatorLock;
        synchronized (object) {
            return locator;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean hasLocator() {
        Object object = locatorLock;
        synchronized (object) {
            return locator != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean removeLocator(InternalLocator l) {
        if (l == null) {
            return false;
        }
        Object object = locatorLock;
        synchronized (object) {
            if (InternalLocator.hasLocator() && l.equals(locator)) {
                locator = null;
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InternalLocator createLocator(int port, File logFile, File stateFile, InternalLogWriter logger, InternalLogWriter securityLogger, InetAddress bindAddress, String hostnameForClients, Properties distributedSystemProperties, boolean startDistributedSystem) throws IOException {
        Object object = locatorLock;
        synchronized (object) {
            InternalLocator l;
            if (InternalLocator.hasLocator()) {
                throw new IllegalStateException("A locator can not be created because one already exists in this JVM.");
            }
            locator = l = new InternalLocator(port, logFile, stateFile, logger, securityLogger, bindAddress, hostnameForClients, distributedSystemProperties, null, startDistributedSystem);
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setLocator(InternalLocator l) {
        Object object = locatorLock;
        synchronized (object) {
            if (locator != null && locator != l) {
                throw new IllegalStateException("A locator can not be created because one already exists in this JVM.");
            }
            locator = l;
        }
    }

    public static InternalLocator startLocator(int port, File logFile, File stateFile, InternalLogWriter logger, InternalLogWriter securityLogger, InetAddress bindAddress, Properties dsProperties, boolean peerLocator, boolean enableServerLocator, String hostnameForClients, boolean loadSharedConfigFromDir) throws IOException {
        return InternalLocator.startLocator(port, logFile, stateFile, logger, securityLogger, bindAddress, true, dsProperties, peerLocator, enableServerLocator, hostnameForClients, loadSharedConfigFromDir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InternalLocator startLocator(int port, File logFile, File stateFile, InternalLogWriter logger, InternalLogWriter securityLogger, InetAddress bindAddress, boolean startDistributedSystem, Properties dsProperties, boolean peerLocator, boolean enableServerLocator, String hostnameForClients, boolean loadSharedConfigFromDir) throws IOException {
        InternalLocator internalLocator;
        if (!peerLocator && !enableServerLocator) {
            throw new IllegalArgumentException(LocalizedStrings.InternalLocator_EITHER_PEER_LOCATOR_OR_SERVER_LOCATOR_MUST_BE_ENABLED.toLocalizedString());
        }
        System.setProperty(FORCE_LOCATOR_DM_TYPE, "true");
        InternalLocator slocator = null;
        boolean startedLocator = false;
        try {
            InternalDistributedSystem sys;
            slocator = InternalLocator.createLocator(port, logFile, stateFile, logger, securityLogger, bindAddress, hostnameForClients, dsProperties, startDistributedSystem);
            if (enableServerLocator) {
                slocator.handler.willHaveServerLocator = true;
            }
            if (peerLocator) {
                slocator.startPeerLocation(startDistributedSystem);
            }
            if (startDistributedSystem) {
                slocator.startDistributedSystem();
                InternalDistributedSystem ids = slocator.myDs;
                if (ids != null) {
                    ids.getDistributionManager().addHostedLocators(ids.getDistributedMember(), InternalLocator.getLocatorStrings(), slocator.isSharedConfigurationEnabled());
                }
            }
            if ((sys = InternalDistributedSystem.getConnectedInstance()) != null) {
                slocator.startServerLocation(sys);
            }
            slocator.endStartLocator(null);
            startedLocator = true;
            internalLocator = slocator;
            System.getProperties().remove(FORCE_LOCATOR_DM_TYPE);
        }
        catch (Throwable throwable) {
            System.getProperties().remove(FORCE_LOCATOR_DM_TYPE);
            if (!startedLocator) {
                InternalLocator.removeLocator(slocator);
            }
            throw throwable;
        }
        if (!startedLocator) {
            InternalLocator.removeLocator(slocator);
        }
        return internalLocator;
    }

    public static boolean isDedicatedLocator() {
        InternalLocator internalLocator = InternalLocator.getLocator();
        if (internalLocator == null) {
            return false;
        }
        InternalDistributedSystem ids = internalLocator.myDs;
        if (ids == null) {
            return false;
        }
        DM dm = ids.getDistributionManager();
        if (dm.isLoner()) {
            return false;
        }
        DistributionManager distMgr = (DistributionManager)ids.getDistributionManager();
        return distMgr.getDMType() == 11;
    }

    public static LocatorStatusResponse statusLocator(int port, InetAddress bindAddress) throws IOException {
        int timeout = Integer.MAX_VALUE;
        try {
            return (LocatorStatusResponse)TcpClient.requestToServer(bindAddress, port, new LocatorStatusRequest(), Integer.MAX_VALUE, true);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public static void stopLocator(int port, InetAddress bindAddress) throws ConnectException {
        TcpClient.stop(bindAddress, port);
    }

    public static String[] getLocatorInfo(InetAddress host, int port) {
        return TcpClient.getInfo(host, port);
    }

    private InternalLocator(int port, File logF, File stateF, InternalLogWriter logWriter, InternalLogWriter securityLogWriter, InetAddress bindAddress, String hostnameForClients, Properties distributedSystemProperties, DistributionConfigImpl cfg, boolean startDistributedSystem) {
        boolean hasLogFileButConfigDoesNot;
        final LoggingThreadGroup loggingThreadGroup = LoggingThreadGroup.createThreadGroup("WAN Locator Discovery Logger Group", logger);
        ThreadFactory threadFactory = new ThreadFactory(){

            @Override
            public Thread newThread(Runnable task) {
                Thread thread = new Thread(loggingThreadGroup, task, "WAN Locator Discovery Thread");
                thread.setDaemon(true);
                return thread;
            }
        };
        this._executor = Executors.newCachedThreadPool(threadFactory);
        this.port = port;
        this.logFile = logF;
        this.bindAddress = bindAddress;
        this.hostnameForClients = hostnameForClients;
        this.stateFile = stateF == null ? new File("locator" + port + "state.dat") : stateF;
        File productUseFile = new File("locator" + port + "views.log");
        this.productUseLog = new ProductUseLog(productUseFile);
        this.config = cfg;
        this.env = new Properties();
        if (bindAddress != null && !bindAddress.isAnyLocalAddress()) {
            this.env.setProperty("bind-address", bindAddress.getHostAddress());
        }
        if (distributedSystemProperties != null) {
            this.env.putAll((Map<?, ?>)distributedSystemProperties);
        }
        this.env.setProperty("cache-xml-file", "");
        if (this.config == null) {
            this.config = new DistributionConfigImpl(this.env);
            this.env.clear();
            this.env.putAll((Map<?, ?>)this.config.getProps());
        }
        boolean bl = hasLogFileButConfigDoesNot = this.logFile != null && this.config.getLogFile().toString().equals(DistributionConfig.DEFAULT_LOG_FILE.toString());
        if (logWriter == null && hasLogFileButConfigDoesNot) {
            this.config.unsafeSetLogFile(this.logFile);
        }
        boolean hasLogFile = this.config.getLogFile() != null && !this.config.getLogFile().equals(new File(""));
        boolean hasSecurityLogFile = this.config.getSecurityLogFile() != null && !this.config.getSecurityLogFile().equals(new File(""));
        LogService.configureLoggers(hasLogFile, hasSecurityLogFile);
        if (hasLogFile || hasSecurityLogFile) {
            if (hasLogFile) {
                LogWriterAppenders.getOrCreateAppender(LogWriterAppenders.Identifier.MAIN, true, false, this.config, !startDistributedSystem);
            }
            if (hasSecurityLogFile) {
                LogWriterAppenders.getOrCreateAppender(LogWriterAppenders.Identifier.SECURITY, true, false, this.config, false);
            }
        }
        if (logWriter == null) {
            logWriter = LogWriterFactory.createLogWriterLogger(false, false, this.config, !startDistributedSystem);
            if (logger.isDebugEnabled()) {
                logger.debug("LogWriter for locator is created.");
            }
        }
        if (securityLogWriter == null) {
            securityLogWriter = LogWriterFactory.createLogWriterLogger(false, true, this.config, false);
            ((LogWriterLogger)logWriter).setLogWriterLevel(this.config.getSecurityLogLevel());
            securityLogWriter.fine("SecurityLogWriter for locator is created.");
        }
        this.locatorListener = new LocatorMembershipListenerImpl(this);
        this.handler = new LocatorHandler(this.port, this, this.locatorListener);
        GemFireTracer.setLogWriter(logWriter);
        GemFireTracer.setSecurityLogWriter(securityLogWriter);
        LoggingThreadGroup group = LoggingThreadGroup.createThreadGroup("Distribution locators", logger);
        this.stats = new LocatorStats();
        this.server = new TcpServer(this.port, this.bindAddress, null, this.config, this.handler, new DelayedPoolStatHelper(), group, this.toString());
    }

    private void startTcpServer() throws IOException {
        logger.info(LocalizedMessage.create(LocalizedStrings.InternalLocator_STARTING_0, this));
        this.server.start();
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            logger.warn(LocalizedMessage.create(LocalizedStrings.ONE_ARG, "Interrupted"), (Throwable)ie);
        }
    }

    public SharedConfiguration getSharedConfiguration() {
        return this.sharedConfig;
    }

    public DistributionConfigImpl getConfig() {
        return this.config;
    }

    public void startPeerLocation(boolean withDS) throws IOException {
        if (this.isPeerLocator()) {
            throw new IllegalStateException(LocalizedStrings.InternalLocator_PEER_LOCATION_IS_ALREADY_RUNNING_FOR_0.toLocalizedString(this));
        }
        logger.info(LocalizedMessage.create(LocalizedStrings.InternalLocator_STARTING_PEER_LOCATION_FOR_0, this));
        String locatorsProp = this.config.getLocators();
        boolean locatorsAreCoordinators = false;
        boolean networkPartitionDetectionEnabled = this.config.getEnableNetworkPartitionDetection();
        if (networkPartitionDetectionEnabled) {
            locatorsAreCoordinators = true;
        } else {
            String prop = this.config.getSecurityPeerAuthInit();
            boolean bl = locatorsAreCoordinators = prop != null && prop.length() > 0;
            if (!locatorsAreCoordinators) {
                locatorsAreCoordinators = Boolean.getBoolean("gemfire.disable-floating-coordinator");
            }
        }
        if (locatorsAreCoordinators) {
            logger.info(LocalizedMessage.create(LocalizedStrings.InternalLocator_FORCING_GROUP_COORDINATION_INTO_LOCATORS));
        }
        this.gossipServer = new GossipServer(this.port, 60000L, this.bindAddress, this.stateFile, locatorsProp, locatorsAreCoordinators, networkPartitionDetectionEnabled, withDS);
        this.handler.addHandler(GossipData.class, this.gossipServer);
        this.peerLocator = true;
        if (!this.server.isAlive()) {
            this.startTcpServer();
        }
    }

    public GossipServer getGossipServer() {
        return this.gossipServer;
    }

    public void startDistributedSystem() throws UnknownHostException {
        InternalDistributedSystem existing = InternalDistributedSystem.getConnectedInstance();
        if (existing != null) {
            logger.info(LocalizedMessage.create(LocalizedStrings.InternalLocator_USING_EXISTING_DISTRIBUTED_SYSTEM__0, existing));
            if (this.getGossipServer() != null) {
                IpAddress addr = ((JGroupMember)existing.getDistributedMember().getNetMember()).getAddress();
                this.getGossipServer().setLocalAddress(addr);
            }
            this.startCache(existing);
        } else {
            if (System.getProperty("p2p.joinTimeout", "").length() == 0) {
                System.setProperty("p2p.joinTimeout", "5000");
            }
            StringBuilder sb = new StringBuilder(100);
            if (this.bindAddress != null) {
                sb.append(this.bindAddress.getHostAddress());
            } else {
                sb.append(SocketCreator.getLocalHost().getHostAddress());
            }
            sb.append('[').append(this.port).append(']');
            String thisLocator = sb.toString();
            if (this.peerLocator) {
                boolean setLocatorsProp = false;
                String locatorsProp = this.config.getLocators();
                if (locatorsProp != null && locatorsProp.trim().length() > 0) {
                    if (!locatorsProp.contains(thisLocator)) {
                        locatorsProp = locatorsProp + "," + thisLocator;
                        setLocatorsProp = true;
                    }
                } else {
                    locatorsProp = thisLocator;
                    setLocatorsProp = true;
                }
                if (setLocatorsProp) {
                    Properties updateEnv = new Properties();
                    updateEnv.setProperty("locators", locatorsProp);
                    this.config.setApiProps(updateEnv);
                    String propName = "gemfire.locators";
                    if (System.getProperty(propName) != null) {
                        System.setProperty(propName, locatorsProp);
                    }
                }
            }
            Properties connectEnv = new Properties();
            connectEnv.put("ds-config", this.config);
            logger.info(LocalizedMessage.create(LocalizedStrings.InternalLocator_STARTING_DISTRIBUTED_SYSTEM));
            logger.info(LogMarker.CONFIG, LocalizedMessage.create(LocalizedStrings.InternalDistributedSystem_STARTUP_CONFIGURATIONN_0, this.config.toLoggerString()));
            this.myDs = (InternalDistributedSystem)DistributedSystem.connect(connectEnv);
            this.myDs.addDisconnectListener(new InternalDistributedSystem.DisconnectListener(){

                @Override
                public void onDisconnect(InternalDistributedSystem sys) {
                    InternalLocator.this.stop(false, false);
                }
            });
            this.startCache(this.myDs);
            logger.info(LocalizedMessage.create(LocalizedStrings.InternalLocator_LOCATOR_STARTED_ON__0, thisLocator));
            this.myDs.setDependentLocator(this);
        }
    }

    private void startCache(DistributedSystem ds) {
        GemFireCacheImpl gfc = GemFireCacheImpl.getInstance();
        if (gfc == null) {
            logger.info("Creating cache for locator.");
            this.myCache = new CacheFactory(ds.getProperties()).create();
            gfc = (GemFireCacheImpl)this.myCache;
        } else {
            logger.info("Using existing cache for locator.");
            ((InternalDistributedSystem)ds).handleResourceEvent(ResourceEvent.LOCATOR_START, this);
        }
        this.startJmxManagerLocationService(gfc);
        this.startSharedConfigurationService(gfc);
    }

    public void endStartLocator(InternalDistributedSystem distributedSystem) throws UnknownHostException {
        this.env = null;
        if (distributedSystem == null) {
            distributedSystem = InternalDistributedSystem.getConnectedInstance();
        }
        if (distributedSystem != null) {
            this.onConnect(distributedSystem);
        } else {
            InternalDistributedSystem.addConnectListener(this);
        }
        this.exchangeLocalLocators(this.config, this.locatorListener);
        this.exchangeRemoteLocators(this.config, this.locatorListener);
    }

    public void startServerLocation(InternalDistributedSystem distributedSystem) throws IOException {
        if (this.isServerLocator()) {
            throw new IllegalStateException(LocalizedStrings.InternalLocator_SERVER_LOCATION_IS_ALREADY_RUNNING_FOR_0.toLocalizedString(this));
        }
        logger.info(LocalizedMessage.create(LocalizedStrings.InternalLocator_STARTING_SERVER_LOCATION_FOR_0, this));
        if (distributedSystem == null && (distributedSystem = InternalDistributedSystem.getConnectedInstance()) == null) {
            throw new IllegalStateException(LocalizedStrings.InternalLocator_SINCE_SERVER_LOCATION_IS_ENABLED_THE_DISTRIBUTED_SYSTEM_MUST_BE_CONNECTED.toLocalizedString());
        }
        this.productUseLog.monitorUse(distributedSystem);
        ServerLocator sl = new ServerLocator(this.port, this.bindAddress, this.hostnameForClients, this.logFile, this.productUseLog, this.getConfig().getName(), distributedSystem, this.stats);
        this.handler.addHandler(LocatorListRequest.class, sl);
        this.handler.addHandler(ClientConnectionRequest.class, sl);
        this.handler.addHandler(QueueConnectionRequest.class, sl);
        this.handler.addHandler(ClientReplacementRequest.class, sl);
        this.handler.addHandler(GetAllServersRequest.class, sl);
        this.handler.addHandler(LocatorStatusRequest.class, sl);
        this.serverLocator = sl;
        if (!this.server.isAlive()) {
            this.startTcpServer();
        }
    }

    private void exchangeLocalLocators(DistributionConfigImpl config, LocatorMembershipListener locatorListener) {
        String localLocator = config.getStartLocator();
        DistributionLocatorId locatorId = null;
        locatorId = localLocator.equals("") ? new DistributionLocatorId(this.port, config.getBindAddress()) : new DistributionLocatorId(localLocator);
        LocatorHelper.addLocator(config.getDistributedSystemId(), locatorId, this, locatorListener, null);
        RemoteLocatorJoinRequest request = this.buildRemoteDSJoinRequest(config);
        StringTokenizer locatorsOnThisVM = new StringTokenizer(config.getLocators(), ",");
        while (locatorsOnThisVM.hasMoreTokens()) {
            DistributionLocatorId localLocatorId = new DistributionLocatorId(locatorsOnThisVM.nextToken());
            if (locatorId.equals(localLocatorId)) continue;
            LocatorDiscovery localDiscovery = new LocatorDiscovery(this, localLocatorId, request, locatorListener);
            LocatorDiscovery.LocalLocatorDiscovery localLocatorDiscovery = localDiscovery.new LocatorDiscovery.LocalLocatorDiscovery();
            this._executor.execute(localLocatorDiscovery);
        }
    }

    private void exchangeRemoteLocators(DistributionConfigImpl config, LocatorMembershipListener locatorListener) {
        RemoteLocatorJoinRequest request = this.buildRemoteDSJoinRequest(config);
        String remoteDustributedSystems = config.getRemoteLocators();
        if (remoteDustributedSystems.length() > 0) {
            StringTokenizer remoteLocators = new StringTokenizer(remoteDustributedSystems, ",");
            while (remoteLocators.hasMoreTokens()) {
                DistributionLocatorId remoteLocatorId = new DistributionLocatorId(remoteLocators.nextToken());
                LocatorDiscovery localDiscovery = new LocatorDiscovery(this, remoteLocatorId, request, locatorListener);
                LocatorDiscovery.RemoteLocatorDiscovery remoteLocatorDiscovery = localDiscovery.new LocatorDiscovery.RemoteLocatorDiscovery();
                this._executor.execute(remoteLocatorDiscovery);
            }
        }
    }

    private RemoteLocatorJoinRequest buildRemoteDSJoinRequest(DistributionConfigImpl config) {
        String localLocator = config.getStartLocator();
        DistributionLocatorId locatorId = null;
        locatorId = localLocator.equals("") ? new DistributionLocatorId(this.port, config.getBindAddress()) : new DistributionLocatorId(localLocator);
        RemoteLocatorJoinRequest request = new RemoteLocatorJoinRequest(config.getDistributedSystemId(), locatorId, "");
        return request;
    }

    @Override
    public void stop() {
        this.stop(false, true);
    }

    public boolean getStoppedForReconnect() {
        return this.stoppedForReconnect;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(boolean stopForReconnect, boolean waitForDisconnect) {
        boolean isDebugEnabled = logger.isDebugEnabled();
        if (this.server.isShuttingDown()) {
            if (!stopForReconnect && waitForDisconnect) {
                long endOfWait = System.currentTimeMillis() + 60000L;
                if (isDebugEnabled && this.server.isAlive()) {
                    logger.debug("sleeping to wait for the locator server to shut down...");
                }
                while (this.server.isAlive() && System.currentTimeMillis() < endOfWait) {
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        return;
                    }
                }
                if (isDebugEnabled) {
                    if (this.server.isAlive()) {
                        logger.debug("60 seconds have elapsed waiting for the locator server to shut down - terminating wait and returning");
                    } else {
                        logger.debug("the locator server has shut down");
                    }
                }
            }
            return;
        }
        this.stoppedForReconnect = stopForReconnect;
        if (this.server.isAlive()) {
            logger.info(LocalizedMessage.create(LocalizedStrings.InternalLocator_STOPPING__0, this));
            try {
                InternalLocator.stopLocator(this.port, this.bindAddress);
            }
            catch (ConnectException ignore) {
                // empty catch block
            }
            boolean interrupted = Thread.interrupted();
            try {
                this.server.join(60000L);
            }
            catch (InterruptedException ex) {
                interrupted = true;
                logger.warn(LocalizedMessage.create(LocalizedStrings.InternalLocator_INTERRUPTED_WHILE_STOPPING__0, this), (Throwable)ex);
            }
            finally {
                if (interrupted) {
                    Thread.currentThread().interrupt();
                }
            }
            if (this.server.isAlive()) {
                logger.fatal(LocalizedMessage.create(LocalizedStrings.InternalLocator_COULD_NOT_STOP__0__IN_60_SECONDS, this));
            }
        }
        InternalLocator.removeLocator(this);
        this.handleShutdown();
        logger.info(LocalizedMessage.create(LocalizedStrings.InternalLocator_0__IS_STOPPED, this));
        if (this.stoppedForReconnect && this.myDs != null) {
            this.launchRestartThread();
        }
    }

    public boolean isStopped() {
        return this.server == null || !this.server.isAlive();
    }

    private void handleShutdown() {
        if (!this.shutdownHandled.compareAndSet(false, true)) {
            return;
        }
        this.productUseLog.close();
        if (this.myDs != null) {
            this.myDs.setDependentLocator(null);
        }
        if (this.myCache != null && !this.stoppedForReconnect) {
            logger.info("Closing locator's cache");
            try {
                this.myCache.close();
            }
            catch (RuntimeException ex) {
                logger.info("Could not close locator's cache because: {}", (Throwable)ex);
            }
        }
        if (this.stats != null) {
            this.stats.close();
        }
        this.allLocatorsInfo.clear();
        this.allServerLocatorsInfo.clear();
        this.isSharedConfigurationStarted = false;
        if (this.myDs != null && !this.stoppedForReconnect && this.myDs.isConnected()) {
            logger.info(LocalizedMessage.create(LocalizedStrings.InternalLocator_DISCONNECTING_DISTRIBUTED_SYSTEM_FOR_0, this));
            this.myDs.disconnect();
        }
    }

    public void waitToStop() throws InterruptedException {
        boolean restarted;
        do {
            restarted = false;
            this.server.join();
            if (!this.stoppedForReconnect) continue;
            restarted = this.myDs.waitUntilReconnected(-1L, TimeUnit.SECONDS);
        } while (restarted);
    }

    private void launchRestartThread() {
        LoggingThreadGroup group = LoggingThreadGroup.createThreadGroup("Locator restart thread group");
        this.restartThread = new Thread(group, "Location services restart thread"){

            @Override
            public void run() {
                try {
                    boolean restarted = InternalLocator.this.attemptReconnect();
                    logger.info("attemptReconnect returned {}", restarted);
                }
                catch (InterruptedException e) {
                    logger.info("attempt to restart location services was interrupted", (Throwable)e);
                }
                catch (IOException e) {
                    logger.info("attempt to restart location services terminated", (Throwable)e);
                }
                InternalLocator.this.restartThread = null;
            }
        };
        this.restartThread.setDaemon(true);
        this.restartThread.start();
    }

    public boolean attemptReconnect() throws InterruptedException, IOException {
        boolean restarted = false;
        if (this.stoppedForReconnect) {
            logger.info("attempting to restart locator");
            boolean tcpServerStarted = false;
            InternalDistributedSystem ds = this.myDs;
            long waitTime = ds.getConfig().getMaxWaitTimeForReconnect() / 2;
            QuorumChecker checker = null;
            while (ds.getReconnectedSystem() == null && !ds.isReconnectCancelled()) {
                boolean start;
                if (checker == null && (checker = this.myDs.getQuorumChecker()) != null) {
                    logger.info("The distributed system returned this quorum checker: {}", checker);
                }
                if (checker != null && !tcpServerStarted && (start = checker.checkForQuorum(3 * this.myDs.getConfig().getMemberTimeout()))) {
                    logger.info("starting peer location");
                    this.allLocatorsInfo.clear();
                    this.allServerLocatorsInfo.clear();
                    this.stoppedForReconnect = false;
                    this.myDs = null;
                    this.myCache = null;
                    this.restartWithoutDS();
                    tcpServerStarted = true;
                    InternalLocator.setLocator(this);
                }
                ds.waitUntilReconnected(waitTime, TimeUnit.MILLISECONDS);
            }
            InternalDistributedSystem newSystem = (InternalDistributedSystem)ds.getReconnectedSystem();
            if (newSystem != null) {
                if (!tcpServerStarted) {
                    this.allLocatorsInfo.clear();
                    this.allServerLocatorsInfo.clear();
                    this.stoppedForReconnect = false;
                }
                this.restartWithDS(newSystem, GemFireCacheImpl.getInstance());
                InternalLocator.setLocator(this);
                restarted = true;
            }
        }
        return restarted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restartWithoutDS() throws IOException {
        Object object = locatorLock;
        synchronized (object) {
            if (locator != this && InternalLocator.hasLocator()) {
                throw new IllegalStateException("A locator can not be created because one already exists in this JVM.");
            }
            this.myDs = null;
            this.myCache = null;
            logger.info("Locator restart: initializing TcpServer peer location services");
            this.server.restarting(null, null, null);
            if (this.productUseLog.isClosed()) {
                this.productUseLog.reopen();
            }
            if (!this.server.isAlive()) {
                logger.info("Locator restart: starting TcpServer");
                this.startTcpServer();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restartWithDS(InternalDistributedSystem newSystem, GemFireCacheImpl newCache) throws IOException {
        Object object = locatorLock;
        synchronized (object) {
            if (locator != this && InternalLocator.hasLocator()) {
                throw new IllegalStateException("A locator can not be created because one already exists in this JVM.");
            }
            this.myDs = newSystem;
            this.myCache = newCache;
            this.myDs.setDependentLocator(this);
            logger.info("Locator restart: initializing TcpServer");
            if (this.isSharedConfigurationEnabled()) {
                this.sharedConfig = new SharedConfiguration(newCache);
            }
            this.server.restarting(newSystem, newCache, this.sharedConfig);
            if (this.productUseLog.isClosed()) {
                this.productUseLog.reopen();
            }
            this.productUseLog.monitorUse(newSystem);
            this.isSharedConfigurationStarted = true;
            if (this.isSharedConfigurationEnabled()) {
                ExecutorService es = newCache.getDistributionManager().getThreadPool();
                es.submit(new SharedConfigurationRunnable());
            }
            if (!this.server.isAlive()) {
                logger.info("Locator restart: starting TcpServer");
                this.startTcpServer();
            }
            logger.info("Locator restart: initializing JMX manager");
            this.startJmxManagerLocationService(newCache);
            this.endStartLocator(this.myDs);
            logger.info("Locator restart completed");
        }
    }

    @Override
    public DistributedSystem getDistributedSystem() {
        return this.myDs;
    }

    @Override
    public boolean isPeerLocator() {
        return this.peerLocator;
    }

    @Override
    public boolean isServerLocator() {
        return this.serverLocator != null;
    }

    public ServerLocator getServerLocatorAdvisee() {
        return this.serverLocator;
    }

    public SharedConfigurationStatusResponse getSharedConfigurationStatus() {
        ExecutorService es = ((GemFireCacheImpl)this.myCache).getDistributionManager().getWaitingThreadPool();
        Future<SharedConfigurationStatusResponse> statusFuture = es.submit(new FetchSharedConfigStatus());
        SharedConfigurationStatusResponse response = null;
        try {
            response = statusFuture.get(5L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            logger.info("Exception occured while fetching the status {}", CliUtil.stackTraceAsString(e));
            response = new SharedConfigurationStatusResponse();
            response.setStatus(SharedConfigurationStatus.UNDETERMINED);
        }
        return response;
    }

    @Override
    public void onConnect(InternalDistributedSystem sys) {
        try {
            this.stats.hookupStats(sys, SocketCreator.getLocalHost().getCanonicalHostName() + "-" + this.server.getBindAddress().toString());
        }
        catch (UnknownHostException uhe) {
            uhe.printStackTrace();
        }
    }

    public static Collection<String> getLocatorStrings() {
        Collection<String> locatorStrings = null;
        try {
            Collection<DistributionLocatorId> locatorIds = DistributionLocatorId.asDistributionLocatorIds(InternalLocator.getLocators());
            locatorStrings = DistributionLocatorId.asStrings(locatorIds);
        }
        catch (UnknownHostException e) {
            locatorStrings = null;
        }
        if (locatorStrings == null || locatorStrings.isEmpty()) {
            return null;
        }
        return locatorStrings;
    }

    @Override
    public Set<String> getRemoteLocatorInfo(int dsId) {
        return (Set)this.allServerLocatorsInfo.get(dsId);
    }

    public ConcurrentMap<Integer, Set<DistributionLocatorId>> getAllLocatorsInfo() {
        return this.allLocatorsInfo;
    }

    @Override
    public ConcurrentMap<Integer, Set<String>> getAllServerLocatorsInfo() {
        return this.allServerLocatorsInfo;
    }

    public void startSharedConfigurationService(GemFireCacheImpl gfc) {
        if (this.config.getEnableClusterConfiguration() && !this.isSharedConfigurationStarted) {
            if (!InternalLocator.isDedicatedLocator()) {
                logger.info("Cluster configuration service is only supported in dedicated locators");
                return;
            }
            this.isSharedConfigurationStarted = true;
            this.installSharedConfigStatus();
            ExecutorService es = gfc.getDistributionManager().getThreadPool();
            es.submit(new SharedConfigurationRunnable());
        } else {
            logger.info("Cluster configuration service is disabled");
        }
    }

    public void startJmxManagerLocationService(GemFireCacheImpl gfc) {
        if (gfc.getJmxManagerAdvisor() != null && !this.handler.isHandled(JmxManagerLocatorRequest.class)) {
            this.handler.addHandler(JmxManagerLocatorRequest.class, new JmxManagerLocator(gfc));
        }
    }

    public void installSharedConfigDistribution() {
        if (!this.handler.isHandled(ConfigurationRequest.class)) {
            this.handler.addHandler(ConfigurationRequest.class, new ConfigurationRequestHandler(this.sharedConfig));
            logger.info("ConfigRequestHandler installed");
        }
    }

    public void installSharedConfigStatus() {
        if (!this.handler.isHandled(SharedConfigurationStatusRequest.class)) {
            this.handler.addHandler(SharedConfigurationStatusRequest.class, new SharedConfigurationStatusRequestHandler());
            logger.info("SharedConfigStatusRequestHandler installed");
        }
    }

    static {
        locatorLock = new Object();
    }

    protected class DelayedPoolStatHelper
    implements PoolStatHelper {
        protected DelayedPoolStatHelper() {
        }

        @Override
        public void startJob() {
            InternalLocator.this.stats.incRequestInProgress(1);
        }

        @Override
        public void endJob() {
            InternalLocator.this.stats.incRequestInProgress(-1);
        }
    }

    private static class LocatorHandler
    implements TcpHandler {
        private volatile HashMap<Class, TcpHandler> handlerMapping = new HashMap();
        private volatile HashSet<TcpHandler> allHandlers = new HashSet();
        private TcpServer tcpServer;
        private final LocatorMembershipListenerImpl locatorListener;
        private final List<LocatorJoinMessage> locatorJoinMessages;
        private Object locatorJoinObject = new Object();
        InternalLocator interalLocator;
        boolean willHaveServerLocator;

        public LocatorHandler(int port, InternalLocator locator, LocatorMembershipListenerImpl listener) {
            this.locatorListener = listener;
            this.interalLocator = locator;
            this.locatorJoinMessages = new ArrayList<LocatorJoinMessage>();
        }

        @Override
        public synchronized void init(TcpServer tcpServer) {
            this.tcpServer = tcpServer;
            for (TcpHandler handler : this.allHandlers) {
                handler.init(tcpServer);
            }
        }

        @Override
        public void restarting(DistributedSystem ds, GemFireCache cache, SharedConfiguration sharedConfig) {
            if (ds != null) {
                for (TcpHandler handler : this.allHandlers) {
                    handler.restarting(ds, cache, sharedConfig);
                }
            }
        }

        @Override
        public Object processRequest(Object request) throws IOException {
            Object response;
            TcpHandler handler = this.handlerMapping.get(request.getClass());
            if (handler != null) {
                Object result = handler.processRequest(request);
                return result;
            }
            if (request instanceof RemoteLocatorJoinRequest) {
                response = this.updateAllLocatorInfo((RemoteLocatorJoinRequest)request);
            } else if (request instanceof LocatorJoinMessage) {
                response = this.informAboutRemoteLocators((LocatorJoinMessage)request);
            } else if (request instanceof RemoteLocatorPingRequest) {
                response = this.getPingResponse((RemoteLocatorPingRequest)request);
            } else if (request instanceof RemoteLocatorRequest) {
                response = this.getRemoteLocators((RemoteLocatorRequest)request);
            } else {
                if (!this.willHaveServerLocator || !(request instanceof ServerLocationRequest)) {
                    logger.warn(LocalizedMessage.create(LocalizedStrings.InternalLocator_EXPECTED_ONE_OF_THESE_0_BUT_RECEIVED_1, new Object[]{this.handlerMapping.keySet(), request}));
                }
                return null;
            }
            return response;
        }

        private synchronized Object updateAllLocatorInfo(RemoteLocatorJoinRequest request) {
            int distributedSystemId = request.getDistributedSystemId();
            DistributionLocatorId locator = request.getLocator();
            LocatorHelper.addLocator(distributedSystemId, locator, this.interalLocator, this.locatorListener, null);
            return new RemoteLocatorJoinResponse(this.interalLocator.getAllLocatorsInfo());
        }

        private Object getPingResponse(RemoteLocatorPingRequest request) {
            return new RemoteLocatorPingResponse();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Object informAboutRemoteLocators(LocatorJoinMessage request) {
            Object object = this.locatorJoinObject;
            synchronized (object) {
                if (this.locatorJoinMessages.contains(request)) {
                    return null;
                }
                this.locatorJoinMessages.add(request);
            }
            int distributedSystemId = request.getDistributedSystemId();
            DistributionLocatorId locator = request.getLocator();
            DistributionLocatorId sourceLocatorId = request.getSourceLocator();
            LocatorHelper.addLocator(distributedSystemId, locator, this.interalLocator, this.locatorListener, sourceLocatorId);
            return null;
        }

        private Object getRemoteLocators(RemoteLocatorRequest request) {
            int dsId = request.getDsId();
            Set<String> locators = this.interalLocator.getRemoteLocatorInfo(dsId);
            return new RemoteLocatorResponse(locators);
        }

        private JmxManagerLocatorResponse findJmxManager(JmxManagerLocatorRequest request) {
            JmxManagerLocatorResponse result = null;
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void shutDown() {
            try {
                for (TcpHandler handler : this.allHandlers) {
                    handler.shutDown();
                }
            }
            finally {
                this.interalLocator.handleShutdown();
            }
        }

        public synchronized boolean isHandled(Class clazz) {
            return this.handlerMapping.containsKey(clazz);
        }

        public synchronized void addHandler(Class clazz, TcpHandler handler) {
            HashMap<Class, TcpHandler> tmpHandlerMapping = new HashMap<Class, TcpHandler>(this.handlerMapping);
            HashSet<TcpHandler> tmpAllHandlers = new HashSet<TcpHandler>(this.allHandlers);
            tmpHandlerMapping.put(clazz, handler);
            if (tmpAllHandlers.add(handler) && this.tcpServer != null) {
                handler.init(this.tcpServer);
            }
            this.handlerMapping = tmpHandlerMapping;
            this.allHandlers = tmpAllHandlers;
        }

        @Override
        public void endRequest(Object request, long startTime) {
            TcpHandler handler = this.handlerMapping.get(request.getClass());
            if (handler != null) {
                handler.endRequest(request, startTime);
            }
        }

        @Override
        public void endResponse(Object request, long startTime) {
            TcpHandler handler = this.handlerMapping.get(request.getClass());
            if (handler != null) {
                handler.endResponse(request, startTime);
            }
        }
    }

    class FetchSharedConfigStatus
    implements Callable<SharedConfigurationStatusResponse> {
        static final int SLEEPTIME = 1000;
        static final byte MAX_RETRIES = 5;

        FetchSharedConfigStatus() {
        }

        @Override
        public SharedConfigurationStatusResponse call() throws Exception {
            SharedConfigurationStatusResponse response;
            SharedConfigurationStatus status;
            InternalLocator locator = InternalLocator.this;
            for (int i = 0; i < 5 && (locator.sharedConfig == null || (status = locator.sharedConfig.getStatus()) == SharedConfigurationStatus.STARTED && status == SharedConfigurationStatus.NOT_STARTED); ++i) {
                Thread.sleep(1000L);
            }
            if (locator.sharedConfig != null) {
                response = locator.sharedConfig.createStatusResponse();
            } else {
                response = new SharedConfigurationStatusResponse();
                response.setStatus(SharedConfigurationStatus.UNDETERMINED);
            }
            return response;
        }
    }

    class SharedConfigurationRunnable
    implements Runnable {
        private final InternalLocator locator;

        SharedConfigurationRunnable() {
            this.locator = InternalLocator.this;
        }

        @Override
        public void run() {
            try {
                if (this.locator.sharedConfig == null) {
                    this.locator.sharedConfig = new SharedConfiguration((GemFireCacheImpl)this.locator.myCache);
                }
                this.locator.sharedConfig.initSharedConfiguration(this.locator.loadFromSharedConfigDir());
                this.locator.installSharedConfigDistribution();
                logger.info("Cluster configuration service start up completed successfully and is now running ....");
            }
            catch (CancelException e) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Cluster configuration start up was cancelled", (Throwable)e);
                }
            }
            catch (LockServiceDestroyedException e) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Cluster configuration start up was cancelled", (Throwable)e);
                }
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }
}

