/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.distributed.internal;

import com.gemstone.gemfire.CancelException;
import com.gemstone.gemfire.InternalGemFireException;
import com.gemstone.gemfire.SystemFailure;
import com.gemstone.gemfire.distributed.internal.ConflationKey;
import com.gemstone.gemfire.distributed.internal.DM;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.distributed.internal.DistributionMessageObserver;
import com.gemstone.gemfire.distributed.internal.DistributionStats;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.distributed.internal.ReplySender;
import com.gemstone.gemfire.distributed.internal.SizeableRunnable;
import com.gemstone.gemfire.distributed.internal.deadlock.MessageDependencyMonitor;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.Assert;
import com.gemstone.gemfire.internal.DataSerializableFixedID;
import com.gemstone.gemfire.internal.Version;
import com.gemstone.gemfire.internal.cache.EventID;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.internal.logging.log4j.LocalizedMessage;
import com.gemstone.gemfire.internal.logging.log4j.LogMarker;
import com.gemstone.gemfire.internal.sequencelog.MessageLogger;
import com.gemstone.gemfire.internal.tcp.Connection;
import com.gemstone.gemfire.internal.util.Breadcrumbs;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import org.apache.logging.log4j.Logger;

public abstract class DistributionMessage
implements DataSerializableFixedID,
Cloneable {
    private static final Logger logger = LogService.getLogger();
    public static final InternalDistributedMember ALL_RECIPIENTS = null;
    protected static final short HAS_PROCESSOR_ID = 1;
    protected static final short HAS_TX_MEMBERID = 2;
    protected static final short HAS_TX_ID = 4;
    protected static final short POS_DUP = 8;
    protected static final short ENABLE_TIMESTATS = 16;
    protected static final short HAS_PROCESSOR_TYPE = 32;
    protected static final short UNRESERVED_FLAGS_START = 64;
    protected transient InternalDistributedMember sender;
    private transient InternalDistributedMember[] recipients = null;
    private transient long timeStamp = DistributionStats.getStatTime();
    private transient int bytesRead = 0;
    private transient boolean multicast = false;
    private transient boolean doDecMessagesBeingReceived = false;
    private transient ReplySender acker = null;

    protected DistributionMessage() {
    }

    protected static int getNextByteMask(int mask) {
        return DistributionMessage.getNextBitMask(mask, 128);
    }

    protected static final int getNextBitMask(int mask, int maxValue) {
        if ((mask <<= 1) > maxValue) {
            Assert.fail("exhausted bit flags with all available bits: 0x" + Integer.toHexString(mask) + ", max: 0x" + Integer.toHexString(maxValue));
        }
        return mask;
    }

    public static final byte getNumBits(int maxValue) {
        byte numBits = 1;
        while (1 << numBits <= maxValue) {
            numBits = (byte)(numBits + 1);
        }
        return numBits;
    }

    public void setDoDecMessagesBeingReceived(boolean v) {
        this.doDecMessagesBeingReceived = v;
    }

    public final void setReplySender(ReplySender acker) {
        this.acker = acker;
    }

    public ReplySender getReplySender(DM dm) {
        if (this.acker != null) {
            return this.acker;
        }
        return dm;
    }

    public final boolean isDirectAck() {
        return this.acker != null;
    }

    public boolean orderedDelivery() {
        int processorType = this.getProcessorType();
        switch (processorType) {
            case 74: {
                return true;
            }
            case 80: {
                return false;
            }
        }
        InternalDistributedSystem ids = InternalDistributedSystem.getAnyInstance();
        return ids != null && ids.threadOwnsResources();
    }

    public void setRecipient(InternalDistributedMember recipient) {
        if (this.recipients != null) {
            throw new IllegalStateException(LocalizedStrings.DistributionMessage_RECIPIENTS_CAN_ONLY_BE_SET_ONCE.toLocalizedString());
        }
        this.recipients = new InternalDistributedMember[]{recipient};
    }

    public void setMulticast(boolean v) {
        this.multicast = v;
    }

    public boolean getMulticast() {
        return this.multicast;
    }

    public boolean sendViaJGroups() {
        return false;
    }

    public void setRecipients(Collection recipients) {
        if (this.recipients != null) {
            throw new IllegalStateException(LocalizedStrings.DistributionMessage_RECIPIENTS_CAN_ONLY_BE_SET_ONCE.toLocalizedString());
        }
        this.recipients = recipients.toArray(new InternalDistributedMember[recipients.size()]);
    }

    public void resetRecipients() {
        this.recipients = null;
        this.multicast = false;
    }

    public Set getSuccessfulRecipients() {
        InternalDistributedMember[] plannedRecipients = this.recipients;
        HashSet<InternalDistributedMember> successfulRecipients = new HashSet<InternalDistributedMember>(Arrays.asList(plannedRecipients));
        return successfulRecipients;
    }

    public InternalDistributedMember[] getRecipients() {
        if (this.multicast) {
            return new InternalDistributedMember[]{ALL_RECIPIENTS};
        }
        if (this.recipients != null) {
            return this.recipients;
        }
        return new InternalDistributedMember[]{ALL_RECIPIENTS};
    }

    public boolean forAll() {
        return this.recipients == null || this.multicast || this.recipients.length > 0 && this.recipients[0] == ALL_RECIPIENTS;
    }

    public String getRecipientsDescription() {
        if (this.recipients == null) {
            return "<recipients: ALL>";
        }
        if (this.multicast) {
            return "<recipients: multcast>";
        }
        if (this.recipients.length > 0 && this.recipients[0] == ALL_RECIPIENTS) {
            return "<recipients: ALL>";
        }
        StringBuffer sb = new StringBuffer(100);
        sb.append("<recipients: ");
        for (int i = 0; i < this.recipients.length; ++i) {
            if (i != 0) {
                sb.append(", ");
            }
            sb.append(this.recipients[i]);
        }
        sb.append(">");
        return sb.toString();
    }

    public InternalDistributedMember getSender() {
        return this.sender;
    }

    public void setSender(InternalDistributedMember _sender) {
        this.sender = _sender;
    }

    protected Executor getExecutor(DistributionManager dm) {
        return dm.getExecutor(this.getProcessorType(), this.sender);
    }

    public abstract int getProcessorType();

    protected abstract void process(DistributionManager var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void scheduleAction(DistributionManager dm) {
        String reason;
        if (logger.isTraceEnabled(LogMarker.DM)) {
            logger.trace(LogMarker.DM, "Processing '{}'", this);
        }
        if ((reason = dm.getCancelCriterion().cancelInProgress()) != null) {
            if (logger.isDebugEnabled()) {
                logger.debug("ScheduleAction: cancel in progress ({}); skipping<{}>", reason, this);
            }
            return;
        }
        if (MessageLogger.isEnabled()) {
            MessageLogger.logMessage(this, this.getSender(), dm.getDistributionManagerId());
        }
        MessageDependencyMonitor.processingMessage(this);
        long time = 0L;
        if (DistributionStats.enableClockStats) {
            time = DistributionStats.getStatTime();
            dm.getStats().incMessageProcessingScheduleTime(time - this.getTimestamp());
        }
        this.setBreadcrumbsInReceiver();
        try {
            DistributionMessageObserver observer = DistributionMessageObserver.getInstance();
            if (observer != null) {
                observer.beforeProcessMessage(dm, this);
            }
            this.process(dm);
            if (observer != null) {
                observer.afterProcessMessage(dm, this);
            }
        }
        catch (CancelException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("Cancelled caught processing {}: {}", this, e.getMessage(), e);
            }
        }
        catch (VirtualMachineError err) {
            SystemFailure.initiateFailure(err);
            throw err;
        }
        catch (Throwable t) {
            SystemFailure.checkFailure();
            logger.fatal(LocalizedMessage.create(LocalizedStrings.DistributionMessage_UNCAUGHT_EXCEPTION_PROCESSING__0, this), t);
        }
        finally {
            if (this.doDecMessagesBeingReceived) {
                dm.getStats().decMessagesBeingReceived(this.bytesRead);
            }
            dm.getStats().incProcessedMessages(1L);
            if (DistributionStats.enableClockStats) {
                dm.getStats().incProcessedMessagesTime(time);
            }
            Breadcrumbs.clearBreadcrumb();
            MessageDependencyMonitor.doneProcessing(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void schedule(final DistributionManager dm) {
        boolean inlineProcess = DistributionManager.INLINE_PROCESS && this.getProcessorType() == 74 && !DistributionMessage.isPreciousThread();
        inlineProcess |= this.getInlineProcess();
        inlineProcess |= Connection.isDominoThread();
        if (inlineProcess |= this.acker != null) {
            dm.getStats().incNumSerialThreads(1);
            try {
                this.scheduleAction(dm);
            }
            finally {
                dm.getStats().incNumSerialThreads(-1);
            }
        }
        try {
            this.getExecutor(dm).execute(new SizeableRunnable(this.getBytesRead()){

                @Override
                public void run() {
                    DistributionMessage.this.scheduleAction(dm);
                }

                public String toString() {
                    return "Processing {" + DistributionMessage.this.toString() + "}";
                }
            });
        }
        catch (RejectedExecutionException ex) {
            if (!dm.shutdownInProgress()) {
                logger.warn(LocalizedMessage.create(LocalizedStrings.DistributionMessage_0__SCHEDULE_REJECTED, this.toString()), (Throwable)ex);
            }
        }
        catch (VirtualMachineError err) {
            SystemFailure.initiateFailure(err);
            throw err;
        }
        catch (Throwable t) {
            SystemFailure.checkFailure();
            logger.fatal(LocalizedMessage.create(LocalizedStrings.DistributionMessage_UNCAUGHT_EXCEPTION_PROCESSING__0, this), t);
            throw new InternalGemFireException(LocalizedStrings.DistributionMessage_UNEXPECTED_ERROR_SCHEDULING_MESSAGE.toLocalizedString(), t);
        }
    }

    public static boolean isPreciousThread() {
        String thrname = Thread.currentThread().getName();
        return thrname.startsWith("UDP");
    }

    public boolean getInlineProcess() {
        return false;
    }

    public void setBreadcrumbsInReceiver() {
        if (Breadcrumbs.ENABLED) {
            EventID evID;
            String sender = null;
            String procId = "";
            long pid = this.getProcessorId();
            if (pid != 0L) {
                procId = " processorId=" + pid;
            }
            if ((sender = Thread.currentThread().getName().startsWith("P2P Message Reader") ? procId : "sender=" + this.getSender() + procId).length() > 0) {
                Breadcrumbs.setReceiveSide(sender);
            }
            if ((evID = this.getEventID()) != null) {
                Breadcrumbs.setEventId(evID);
            }
        }
    }

    public void setBreadcrumbsInSender() {
        if (Breadcrumbs.ENABLED) {
            String procId = "";
            long pid = this.getProcessorId();
            if (pid != 0L) {
                procId = "processorId=" + pid;
            }
            if (this.recipients != null && this.recipients.length <= 10) {
                Breadcrumbs.setSendSide(procId + " recipients=" + Arrays.toString(this.recipients));
            } else if (procId.length() > 0) {
                Breadcrumbs.setSendSide(procId);
            }
            EventID evID = this.getEventID();
            if (evID != null) {
                Breadcrumbs.setEventId(evID);
            }
        }
    }

    public EventID getEventID() {
        return null;
    }

    public void reset() {
        this.resetRecipients();
        this.sender = null;
    }

    @Override
    public void toData(DataOutput out) throws IOException {
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
    }

    public long getTimestamp() {
        return this.timeStamp;
    }

    public long resetTimestamp() {
        if (DistributionStats.enableClockStats) {
            long now = DistributionStats.getStatTime();
            long result = now - this.timeStamp;
            this.timeStamp = now;
            return result;
        }
        return 0L;
    }

    public void setBytesRead(int bytesRead) {
        this.bytesRead = bytesRead;
    }

    public int getBytesRead() {
        return this.bytesRead;
    }

    public ConflationKey getConflationKey() {
        return null;
    }

    public int getProcessorId() {
        return 0;
    }

    public boolean isSevereAlertCompatible() {
        return false;
    }

    public boolean isInternal() {
        return false;
    }

    public boolean containsRegionContentChange() {
        return false;
    }

    public String getShortClassName() {
        String cname = this.getClass().getName();
        return cname.substring(this.getClass().getPackage().getName().length() + 1);
    }

    public String toString() {
        String cname = this.getShortClassName();
        StringBuilder sb = new StringBuilder(cname);
        sb.append('@').append(Integer.toHexString(System.identityHashCode(this)));
        sb.append(" processorId=").append(this.getProcessorId());
        sb.append(" sender=").append(this.getSender());
        return sb.toString();
    }

    @Override
    public Version[] getSerializationVersions() {
        return null;
    }
}

