/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.distributed.internal;

import com.gemstone.gemfire.GemFireConfigException;
import com.gemstone.gemfire.GemFireIOException;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.internal.AbstractDistributionConfig;
import com.gemstone.gemfire.distributed.internal.DistributionConfig;
import com.gemstone.gemfire.distributed.internal.FlowControlParams;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.internal.ConfigSource;
import com.gemstone.gemfire.internal.SocketCreator;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.process.ProcessLauncherContext;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;

public class DistributionConfigImpl
extends AbstractDistributionConfig
implements Serializable {
    private static final long serialVersionUID = 4096393792893825167L;
    private String name = "";
    private int tcpPort = 0;
    private int mcastPort = 10334;
    private int mcastTtl = 32;
    private int socketLeaseTime = 60000;
    private int socketBufferSize = 32768;
    private boolean conserveSockets = true;
    private String roles = "";
    private InetAddress mcastAddress = DEFAULT_MCAST_ADDRESS;
    private String bindAddress = "";
    private String serverBindAddress = "";
    private String locators = "";
    private int locatorWaitTime;
    private File logFile = DEFAULT_LOG_FILE;
    protected File deployWorkingDir = DEFAULT_DEPLOY_WORKING_DIR;
    protected String licenseDataManagement = "";
    protected String licenseApplicationCache = "";
    protected File licenseWorkingDir = DEFAULT_LICENSE_WORKING_DIR;
    protected File writableWorkingDir = DEFAULT_LICENSE_WORKING_DIR;
    protected int licenseServerTimeout = 10000;
    protected int logLevel = 700;
    private String startLocator = "";
    private int startLocatorPort;
    protected boolean statisticSamplingEnabled = true;
    protected int statisticSampleRate = 1000;
    protected File statisticArchiveFile = DEFAULT_STATISTIC_ARCHIVE_FILE;
    private int ackWaitThreshold = 15;
    private int ackForceDisconnectThreshold = 0;
    private File cacheXmlFile = Boolean.getBoolean("Locator.forceLocatorDMType") ? new File("") : DEFAULT_CACHE_XML_FILE;
    protected int archiveDiskSpaceLimit = 0;
    protected int archiveFileSizeLimit = 0;
    protected int logDiskSpaceLimit = 0;
    protected int logFileSizeLimit = 0;
    protected boolean sslEnabled = false;
    protected String sslProtocols = "any";
    protected String sslCiphers = "any";
    protected boolean sslRequireAuthentication = true;
    protected boolean clusterSSLEnabled = false;
    protected String clusterSSLProtocols = "any";
    protected String clusterSSLCiphers = "any";
    protected boolean clusterSSLRequireAuthentication = true;
    protected String clusterSSLKeyStore = "";
    protected String clusterSSLKeyStoreType = "";
    protected String clusterSSLKeyStorePassword = "";
    protected String clusterSSLTrustStore = "";
    protected String clusterSSLTrustStorePassword = "";
    protected int mcastSendBufferSize = 65535;
    protected int mcastRecvBufferSize = 0x100000;
    protected FlowControlParams mcastFlowControl = DEFAULT_MCAST_FLOW_CONTROL;
    protected int udpSendBufferSize = 65535;
    protected int udpRecvBufferSize = 0x100000;
    protected int udpFragmentSize = 60000;
    protected boolean disableTcp = false;
    protected boolean enableTimeStatistics = false;
    protected int memberTimeout = 5000;
    protected int[] membershipPortRange = DEFAULT_MEMBERSHIP_PORT_RANGE;
    private int maxWaitTimeForReconnect = 60000;
    private int maxNumReconnectTries = 3;
    protected int asyncDistributionTimeout = 0;
    protected int asyncQueueTimeout = 60000;
    protected int asyncMaxQueueSize = 8;
    private String clientConflation = "server";
    private String durableClientId = "";
    private int durableClientTimeout = 300;
    private String securityClientAuthInit = "";
    private String securityClientAuthenticator = "";
    private String securityClientDHAlgo = "";
    private String securityPeerAuthInit = "";
    private String securityPeerAuthenticator = "";
    private String securityClientAccessor = "";
    private String securityClientAccessorPP = "";
    protected int securityLogLevel = 700;
    private boolean enableNetworkPartitionDetection = false;
    private boolean disableAutoReconnect = false;
    private File securityLogFile = DEFAULT_SECURITY_LOG_FILE;
    private int securityPeerMembershipTimeout = 1000;
    private Properties security = new Properties();
    private Properties userDefinedProps = new Properties();
    public static final String SECURITY_SYSTEM_PREFIX = "gemfire.sys.";
    private boolean removeUnresponsiveClient = false;
    private boolean deltaPropagation = true;
    private Map props;
    private int distributedSystemId = -1;
    private String remoteLocators = "";
    private boolean enforceUniqueHost = DistributionConfig.DEFAULT_ENFORCE_UNIQUE_HOST;
    private String redundancyZone = DistributionConfig.DEFAULT_REDUNDANCY_ZONE;
    private Properties sslProperties = new Properties();
    private Properties clusterSSLProperties = new Properties();
    private String groups = "";
    protected boolean enableSharedConfiguration = true;
    protected boolean useSharedConfiguration = true;
    protected boolean loadSharedConfigurationFromDir = false;
    protected String clusterConfigDir = DistributionConfig.DEFAULT_CLUSTER_CONFIGURATION_DIR;
    private int httpServicePort = 7070;
    private String httpServiceBindAddress = "";
    private boolean startDevRestApi = false;
    private int memcachedPort;
    private String memcachedProtocol = DEFAULT_MEMCACHED_PROTOCOL;
    private String memcachedBindAddress = "";
    private boolean jmxManager = Boolean.getBoolean("Locator.forceLocatorDMType");
    private boolean jmxManagerStart = false;
    private int jmxManagerPort = 1099;
    private String jmxManagerBindAddress = "";
    private String jmxManagerHostnameForClients = "";
    private String jmxManagerPasswordFile = "";
    private String jmxManagerAccessFile = "";
    private int jmxManagerHttpPort = 7070;
    private int jmxManagerUpdateRate = 2000;
    private boolean jmxManagerSSL = false;
    private boolean jmxManagerSSLEnabled = false;
    private boolean jmxManagerSslRequireAuthentication = true;
    private String jmxManagerSslProtocols = "any";
    private String jmxManagerSslCiphers = "any";
    private Properties jmxManagerSslProperties = new Properties();
    protected String jmxManagerSSLKeyStore = "";
    protected String jmxManagerSSLKeyStoreType = "";
    protected String jmxManagerSSLKeyStorePassword = "";
    protected String jmxManagerSSLTrustStore = "";
    protected String jmxManagerSSLTrustStorePassword = "";
    private boolean serverSSLEnabled = false;
    private boolean serverSslRequireAuthentication = true;
    private String serverSslProtocols = "any";
    private String serverSslCiphers = "any";
    private Properties serverSslProperties = new Properties();
    protected String serverSSLKeyStore = "";
    protected String serverSSLKeyStoreType = "";
    protected String serverSSLKeyStorePassword = "";
    protected String serverSSLTrustStore = "";
    protected String serverSSLTrustStorePassword = "";
    private boolean gatewaySSLEnabled = false;
    private boolean gatewaySslRequireAuthentication = true;
    private String gatewaySslProtocols = "any";
    private String gatewaySslCiphers = "any";
    private Properties gatewaySslProperties = new Properties();
    protected String gatewaySSLKeyStore = "";
    protected String gatewaySSLKeyStoreType = "";
    protected String gatewaySSLKeyStorePassword = "";
    protected String gatewaySSLTrustStore = "";
    protected String gatewaySSLTrustStorePassword = "";
    private boolean httpServiceSSLEnabled = false;
    private boolean httpServiceSSLRequireAuthentication = false;
    private String httpServiceSSLProtocols = "any";
    private String httpServiceSSLCiphers = "any";
    private Properties httpServiceSSLProperties = new Properties();
    protected String httpServiceSSLKeyStore = "";
    protected String httpServiceSSLKeyStoreType = "";
    protected String httpServiceSSLKeyStorePassword = "";
    protected String httpServiceSSLTrustStore = "";
    protected String httpServiceSSLTrustStorePassword = "";
    private Map<String, ConfigSource> sourceMap = Collections.synchronizedMap(new HashMap());
    protected String userCommandPackages = "";
    protected boolean modifiable = false;

    public DistributionConfigImpl(DistributionConfig other) {
        this.name = other.getName();
        this.tcpPort = other.getTcpPort();
        this.mcastPort = other.getMcastPort();
        this.mcastTtl = other.getMcastTtl();
        this.socketLeaseTime = other.getSocketLeaseTime();
        this.socketBufferSize = other.getSocketBufferSize();
        this.conserveSockets = other.getConserveSockets();
        this.roles = other.getRoles();
        this.mcastAddress = other.getMcastAddress();
        this.bindAddress = other.getBindAddress();
        this.serverBindAddress = other.getServerBindAddress();
        this.locators = ((DistributionConfigImpl)other).locators;
        this.locatorWaitTime = other.getLocatorWaitTime();
        this.remoteLocators = other.getRemoteLocators();
        this.startLocator = other.getStartLocator();
        this.startLocatorPort = ((DistributionConfigImpl)other).startLocatorPort;
        this.deployWorkingDir = other.getDeployWorkingDir();
        this.licenseDataManagement = other.getLicenseDataManagement();
        this.licenseApplicationCache = other.getLicenseApplicationCache();
        this.licenseWorkingDir = other.getLicenseWorkingDir();
        this.writableWorkingDir = other.getWritableWorkingDir();
        this.licenseServerTimeout = other.getLicenseServerTimeout();
        this.logFile = other.getLogFile();
        this.logLevel = other.getLogLevel();
        this.statisticSamplingEnabled = other.getStatisticSamplingEnabled();
        this.statisticSampleRate = other.getStatisticSampleRate();
        this.statisticArchiveFile = other.getStatisticArchiveFile();
        this.ackWaitThreshold = other.getAckWaitThreshold();
        this.ackForceDisconnectThreshold = other.getAckSevereAlertThreshold();
        this.cacheXmlFile = other.getCacheXmlFile();
        this.archiveDiskSpaceLimit = other.getArchiveDiskSpaceLimit();
        this.archiveFileSizeLimit = other.getArchiveFileSizeLimit();
        this.logDiskSpaceLimit = other.getLogDiskSpaceLimit();
        this.logFileSizeLimit = other.getLogFileSizeLimit();
        this.sslEnabled = other.getSSLEnabled();
        this.sslProtocols = other.getSSLProtocols();
        this.sslCiphers = other.getSSLCiphers();
        this.sslRequireAuthentication = other.getSSLRequireAuthentication();
        this.clusterSSLEnabled = other.getClusterSSLEnabled();
        this.clusterSSLProtocols = other.getClusterSSLProtocols();
        this.clusterSSLCiphers = other.getClusterSSLCiphers();
        this.clusterSSLRequireAuthentication = other.getClusterSSLRequireAuthentication();
        this.clusterSSLKeyStore = other.getClusterSSLKeyStore();
        this.clusterSSLKeyStoreType = other.getClusterSSLKeyStoreType();
        this.clusterSSLKeyStorePassword = other.getClusterSSLKeyStorePassword();
        this.clusterSSLTrustStore = other.getClusterSSLTrustStore();
        this.clusterSSLTrustStorePassword = other.getClusterSSLTrustStorePassword();
        this.asyncDistributionTimeout = other.getAsyncDistributionTimeout();
        this.asyncQueueTimeout = other.getAsyncQueueTimeout();
        this.asyncMaxQueueSize = other.getAsyncMaxQueueSize();
        this.modifiable = true;
        this.mcastSendBufferSize = other.getMcastSendBufferSize();
        this.mcastRecvBufferSize = other.getMcastRecvBufferSize();
        this.mcastFlowControl = other.getMcastFlowControl();
        this.udpSendBufferSize = other.getUdpSendBufferSize();
        this.udpRecvBufferSize = other.getUdpRecvBufferSize();
        this.udpFragmentSize = other.getUdpFragmentSize();
        this.disableTcp = other.getDisableTcp();
        this.enableTimeStatistics = other.getEnableTimeStatistics();
        this.memberTimeout = other.getMemberTimeout();
        this.membershipPortRange = other.getMembershipPortRange();
        this.maxWaitTimeForReconnect = other.getMaxWaitTimeForReconnect();
        this.maxNumReconnectTries = other.getMaxNumReconnectTries();
        this.clientConflation = other.getClientConflation();
        this.durableClientId = other.getDurableClientId();
        this.durableClientTimeout = other.getDurableClientTimeout();
        this.enableNetworkPartitionDetection = other.getEnableNetworkPartitionDetection();
        this.disableAutoReconnect = other.getDisableAutoReconnect();
        this.securityClientAuthInit = other.getSecurityClientAuthInit();
        this.securityClientAuthenticator = other.getSecurityClientAuthenticator();
        this.securityClientDHAlgo = other.getSecurityClientDHAlgo();
        this.securityPeerAuthInit = other.getSecurityPeerAuthInit();
        this.securityPeerAuthenticator = other.getSecurityPeerAuthenticator();
        this.securityClientAccessor = other.getSecurityClientAccessor();
        this.securityClientAccessorPP = other.getSecurityClientAccessorPP();
        this.securityPeerMembershipTimeout = other.getSecurityPeerMembershipTimeout();
        this.securityLogLevel = other.getSecurityLogLevel();
        this.securityLogFile = other.getSecurityLogFile();
        this.security.putAll((Map<?, ?>)other.getSecurityProps());
        this.removeUnresponsiveClient = other.getRemoveUnresponsiveClient();
        this.deltaPropagation = other.getDeltaPropagation();
        this.distributedSystemId = other.getDistributedSystemId();
        this.redundancyZone = other.getRedundancyZone();
        this.enforceUniqueHost = other.getEnforceUniqueHost();
        this.sslProperties = other.getSSLProperties();
        this.clusterSSLProperties = other.getClusterSSLProperties();
        this.jmxManagerSslProperties = other.getJmxSSLProperties();
        this.userDefinedProps.putAll((Map<?, ?>)other.getUserDefinedProps());
        this.groups = other.getGroups();
        this.jmxManager = other.getJmxManager();
        this.jmxManagerStart = other.getJmxManagerStart();
        this.jmxManagerSSL = other.getJmxManagerSSL();
        this.jmxManagerSSLEnabled = other.getJmxManagerSSLEnabled();
        this.jmxManagerSslRequireAuthentication = other.getJmxManagerSSLRequireAuthentication();
        this.jmxManagerSslProtocols = other.getJmxManagerSSLProtocols();
        this.jmxManagerSslCiphers = other.getJmxManagerSSLCiphers();
        this.jmxManagerSSLKeyStore = other.getJmxManagerSSLKeyStore();
        this.jmxManagerSSLKeyStoreType = other.getJmxManagerSSLKeyStoreType();
        this.jmxManagerSSLKeyStorePassword = other.getJmxManagerSSLKeyStorePassword();
        this.jmxManagerSSLTrustStore = other.getJmxManagerSSLTrustStore();
        this.jmxManagerSSLTrustStorePassword = other.getJmxManagerSSLTrustStorePassword();
        this.jmxManagerSslProperties = other.getJmxSSLProperties();
        this.jmxManagerPort = other.getJmxManagerPort();
        this.jmxManagerBindAddress = other.getJmxManagerBindAddress();
        this.jmxManagerHostnameForClients = other.getJmxManagerHostnameForClients();
        this.jmxManagerPasswordFile = other.getJmxManagerPasswordFile();
        this.jmxManagerAccessFile = other.getJmxManagerAccessFile();
        this.jmxManagerHttpPort = other.getJmxManagerHttpPort();
        this.jmxManagerUpdateRate = other.getJmxManagerUpdateRate();
        this.memcachedPort = other.getMemcachedPort();
        this.memcachedProtocol = other.getMemcachedProtocol();
        this.memcachedBindAddress = other.getMemcachedBindAddress();
        this.userCommandPackages = other.getUserCommandPackages();
        this.enableSharedConfiguration = other.getEnableClusterConfiguration();
        this.loadSharedConfigurationFromDir = other.getLoadClusterConfigFromDir();
        this.clusterConfigDir = other.getClusterConfigDir();
        this.useSharedConfiguration = other.getUseSharedConfiguration();
        this.serverSSLEnabled = other.getServerSSLEnabled();
        this.serverSslRequireAuthentication = other.getServerSSLRequireAuthentication();
        this.serverSslProtocols = other.getServerSSLProtocols();
        this.serverSslCiphers = other.getServerSSLCiphers();
        this.serverSSLKeyStore = other.getServerSSLKeyStore();
        this.serverSSLKeyStoreType = other.getServerSSLKeyStoreType();
        this.serverSSLKeyStorePassword = other.getServerSSLKeyStorePassword();
        this.serverSSLTrustStore = other.getServerSSLTrustStore();
        this.serverSSLTrustStorePassword = other.getServerSSLTrustStorePassword();
        this.serverSslProperties = other.getServerSSLProperties();
        this.gatewaySSLEnabled = other.getGatewaySSLEnabled();
        this.gatewaySslRequireAuthentication = other.getGatewaySSLRequireAuthentication();
        this.gatewaySslProtocols = other.getGatewaySSLProtocols();
        this.gatewaySslCiphers = other.getGatewaySSLCiphers();
        this.gatewaySSLKeyStore = other.getGatewaySSLKeyStore();
        this.gatewaySSLKeyStoreType = other.getGatewaySSLKeyStoreType();
        this.gatewaySSLKeyStorePassword = other.getGatewaySSLKeyStorePassword();
        this.gatewaySSLTrustStore = other.getGatewaySSLTrustStore();
        this.gatewaySSLTrustStorePassword = other.getGatewaySSLTrustStorePassword();
        this.gatewaySslProperties = other.getGatewaySSLProperties();
        this.httpServicePort = other.getHttpServicePort();
        this.httpServiceBindAddress = other.getHttpServiceBindAddress();
        this.httpServiceSSLEnabled = other.getHttpServiceSSLEnabled();
        this.httpServiceSSLCiphers = other.getHttpServiceSSLCiphers();
        this.httpServiceSSLProtocols = other.getHttpServiceSSLProtocols();
        this.httpServiceSSLRequireAuthentication = other.getHttpServiceSSLRequireAuthentication();
        this.httpServiceSSLKeyStore = other.getHttpServiceSSLKeyStore();
        this.httpServiceSSLKeyStorePassword = other.getHttpServiceSSLKeyStorePassword();
        this.httpServiceSSLKeyStoreType = other.getHttpServiceSSLKeyStoreType();
        this.httpServiceSSLTrustStore = other.getHttpServiceSSLTrustStore();
        this.httpServiceSSLTrustStorePassword = other.getHttpServiceSSLTrustStorePassword();
        this.httpServiceSSLProperties = other.getHttpServiceSSLProperties();
        this.startDevRestApi = other.getStartDevRestApi();
        Map<String, ConfigSource> otherSources = ((DistributionConfigImpl)other).sourceMap;
        if (otherSources != null) {
            this.sourceMap = new HashMap<String, ConfigSource>(otherSources);
        }
    }

    @Override
    protected boolean _modifiableDefault() {
        return this.modifiable;
    }

    private DistributionConfigImpl() {
    }

    public DistributionConfigImpl(Properties nonDefault) {
        this(nonDefault, false, false);
    }

    public DistributionConfigImpl(Properties nonDefault, boolean ignoreGemFirePropsFile) {
        this(nonDefault, ignoreGemFirePropsFile, false);
    }

    public DistributionConfigImpl(Properties nonDefault, boolean ignoreGemFirePropsFile, boolean isConnected) {
        HashMap<Object, Object> props = new HashMap<Object, Object>();
        if (!ignoreGemFirePropsFile) {
            props.putAll(this.loadPropertiesFromURL(DistributedSystem.getPropertyFileURL(), false));
        }
        props.putAll(this.loadPropertiesFromURL(DistributedSystem.getSecurityPropertiesFileURL(), true));
        if (nonDefault != null) {
            props.putAll(nonDefault);
            this.setSource(nonDefault, ConfigSource.api());
        }
        for (Map.Entry entry : props.entrySet()) {
            Map.Entry ent = entry;
            if (!((String)ent.getKey()).startsWith("custom-")) continue;
            this.userDefinedProps.put(ent.getKey(), ent.getValue());
        }
        String[] attNames = this.getAttributeNames();
        HashSet<String> attNameSet = new HashSet<String>();
        for (int index2 = 0; index2 < attNames.length; ++index2) {
            attNameSet.add("gemfire." + attNames[index2]);
        }
        Properties sysProps = (Properties)System.getProperties().clone();
        for (Map.Entry<Object, Object> sysEntry : sysProps.entrySet()) {
            String sysValue;
            String sysName = (String)sysEntry.getKey();
            if (!attNameSet.contains(sysName) && !sysName.startsWith("gemfire.security-") && !sysName.startsWith("gemfire.javax.net.ssl") || (sysValue = (String)sysEntry.getValue()) == null) continue;
            String attName = sysName.substring("gemfire.".length());
            props.put(attName, sysValue);
            this.sourceMap.put(attName, ConfigSource.sysprop());
        }
        sysProps.clear();
        Properties overriddenDefaults = ProcessLauncherContext.getOverriddenDefaults();
        if (!overriddenDefaults.isEmpty()) {
            for (String key2 : overriddenDefaults.stringPropertyNames()) {
                String property2 = key2.substring("gemfire.default.".length());
                if (props.containsKey(property2)) continue;
                props.put(property2, overriddenDefaults.getProperty(key2));
                this.sourceMap.put(property2, ConfigSource.launcher());
            }
        }
        if (!isConnected) {
            this.validateOldSSLVsNewSSLProperties(props);
        }
        this.initialize(props);
        if (this.securityPeerAuthInit != null && this.securityPeerAuthInit.length() > 0) {
            System.setProperty("gemfire.sys.security-peer-auth-init", this.securityPeerAuthInit);
        }
        if (this.securityPeerAuthenticator != null && this.securityPeerAuthenticator.length() > 0) {
            System.setProperty("gemfire.sys.security-peer-authenticator", this.securityPeerAuthenticator);
        }
        for (Map.Entry<Object, Object> entry : this.security.entrySet()) {
            System.setProperty(SECURITY_SYSTEM_PREFIX + (String)entry.getKey(), (String)entry.getValue());
        }
        this.computeMcastPortDefault();
        if (!isConnected) {
            this.copySSLPropsToClusterSSLProps();
            this.copySSLPropsToServerSSLProps();
            this.copySSLPropsToJMXSSLProps();
            this.copyClusterSSLPropsToGatewaySSLProps();
            this.copySSLPropsToHTTPSSLProps();
        }
    }

    private void validateOldSSLVsNewSSLProperties(Map props) {
        String sslEnabledString = (String)props.get("ssl-enabled");
        String clusterSSLEnabledString = (String)props.get("cluster-ssl-enabled");
        if (sslEnabledString != null && clusterSSLEnabledString != null) {
            boolean sslEnabled = new Boolean(sslEnabledString);
            boolean clusterSSLEnabled = new Boolean(clusterSSLEnabledString);
            if (sslEnabled && clusterSSLEnabled) {
                throw new IllegalArgumentException("Gemfire property 'ssl-enabled' and 'cluster-ssl-enabled' can not be used at the same time. Prefer way is to use all 'cluster-ssl*' properties instead of 'ssl-*'.");
            }
        }
        String sslCipher = (String)props.get("ssl-ciphers");
        String clusterSSLCipher = (String)props.get("cluster-ssl-ciphers");
        if (sslCipher != null && sslCipher != "any" && clusterSSLCipher != null && clusterSSLCipher != "any") {
            throw new IllegalArgumentException("Gemfire property 'ssl-cipher' and 'cluster-ssl-cipher' can not be used at the same time. Prefer way is to use all 'cluster-ssl*' properties instead of 'ssl-*'.");
        }
        String sslProtocol = (String)props.get("ssl-protocols");
        String clusterSSLProtocol = (String)props.get("cluster-ssl-protocols");
        if (sslProtocol != null && sslProtocol != "any" && clusterSSLProtocol != null && clusterSSLProtocol != "any") {
            throw new IllegalArgumentException("Gemfire property 'ssl-protocols' and 'cluster-ssl-protocols' can not be used at the same time. Prefer way is to use all 'cluster-ssl*' properties instead of 'ssl-*'.");
        }
        String sslReqAuthString = (String)props.get("ssl-require-authentication");
        String clusterReqAuthString = (String)props.get("cluster-ssl-require-authentication");
        if (sslReqAuthString != null && clusterReqAuthString != null) {
            boolean sslReqAuth = new Boolean(sslReqAuthString);
            boolean clusterSSLReqAuth = new Boolean(clusterReqAuthString);
            if (!sslReqAuth && !clusterSSLReqAuth) {
                throw new IllegalArgumentException("Gemfire property 'ssl-require-authentication' and 'cluster-ssl-require-authentication' can not be used at the same time. Prefer way is to use all 'cluster-ssl*' properties instead of 'ssl-*'.");
            }
        }
        String jmxSSLString = (String)props.get("jmx-manager-ssl");
        String jmxSSLEnabledString = (String)props.get("jmx-manager-ssl-enabled");
        if (jmxSSLString != null && jmxSSLEnabledString != null) {
            boolean jmxSSL = new Boolean(jmxSSLString);
            boolean jmxSSLEnabled = new Boolean(jmxSSLEnabledString);
            if (jmxSSL && jmxSSLEnabled) {
                throw new IllegalArgumentException("Gemfire property 'jmx-manager-ssl' and 'jmx-manager-ssl-enabled' can not be used at the same time. Prefer way is to use 'jmx-manager-ssl-enabled' instead of 'jmx-manager-ssl'.");
            }
        }
    }

    private void copySSLPropsToClusterSSLProps() {
        boolean p2pSSLOverRidden;
        boolean clusterSSLOverriden = this.sourceMap.get("cluster-ssl-enabled") != null;
        boolean bl = p2pSSLOverRidden = this.sourceMap.get("ssl-enabled") != null;
        if (p2pSSLOverRidden && !clusterSSLOverriden) {
            this.clusterSSLEnabled = this.sslEnabled;
            this.sourceMap.put("cluster-ssl-enabled", this.sourceMap.get("ssl-enabled"));
            if (this.sourceMap.get("ssl-ciphers") != null) {
                this.clusterSSLCiphers = this.sslCiphers;
                this.sourceMap.put("cluster-ssl-ciphers", this.sourceMap.get("ssl-ciphers"));
            }
            if (this.sourceMap.get("ssl-protocols") != null) {
                this.clusterSSLProtocols = this.sslProtocols;
                this.sourceMap.put("cluster-ssl-protocols", this.sourceMap.get("ssl-protocols"));
            }
            if (this.sourceMap.get("ssl-require-authentication") != null) {
                this.clusterSSLRequireAuthentication = this.sslRequireAuthentication;
                this.sourceMap.put("cluster-ssl-require-authentication", this.sourceMap.get("ssl-require-authentication"));
            }
            this.clusterSSLProperties.putAll((Map<?, ?>)this.sslProperties);
        }
    }

    private void copySSLPropsToJMXSSLProps() {
        boolean clusterSSLOverRidden;
        boolean jmxSSLEnabledOverriden = this.sourceMap.get("jmx-manager-ssl-enabled") != null;
        boolean jmxSSLOverriden = this.sourceMap.get("jmx-manager-ssl") != null;
        boolean bl = clusterSSLOverRidden = this.sourceMap.get("cluster-ssl-enabled") != null;
        if (jmxSSLOverriden && !jmxSSLEnabledOverriden) {
            this.jmxManagerSSLEnabled = this.jmxManagerSSL;
            this.sourceMap.put("jmx-manager-ssl-enabled", this.sourceMap.get("jmx-manager-ssl"));
        }
        if (clusterSSLOverRidden && !jmxSSLOverriden && !jmxSSLEnabledOverriden) {
            this.jmxManagerSSLEnabled = this.clusterSSLEnabled;
            this.sourceMap.put("jmx-manager-ssl-enabled", this.sourceMap.get("cluster-ssl-enabled"));
            if (this.sourceMap.get("cluster-ssl-ciphers") != null) {
                this.jmxManagerSslCiphers = this.clusterSSLCiphers;
                this.sourceMap.put("jmx-manager-ssl-ciphers", this.sourceMap.get("cluster-ssl-ciphers"));
            }
            if (this.sourceMap.get("cluster-ssl-protocols") != null) {
                this.jmxManagerSslProtocols = this.clusterSSLProtocols;
                this.sourceMap.put("jmx-manager-ssl-protocols", this.sourceMap.get("cluster-ssl-protocols"));
            }
            if (this.sourceMap.get("cluster-ssl-require-authentication") != null) {
                this.jmxManagerSslRequireAuthentication = this.clusterSSLRequireAuthentication;
                this.sourceMap.put("jmx-manager-ssl-require-authentication", this.sourceMap.get("cluster-ssl-require-authentication"));
            }
            if (this.sourceMap.get("cluster-ssl-keystore") != null) {
                this.jmxManagerSSLKeyStore = this.clusterSSLKeyStore;
                this.sourceMap.put("jmx-manager-ssl-keystore", this.sourceMap.get("cluster-ssl-keystore"));
            }
            if (this.sourceMap.get("cluster-ssl-keystore-type") != null) {
                this.jmxManagerSSLKeyStoreType = this.clusterSSLKeyStoreType;
                this.sourceMap.put("jmx-manager-ssl-keystore-type", this.sourceMap.get("cluster-ssl-keystore-type"));
            }
            if (this.sourceMap.get("cluster-ssl-keystore-password") != null) {
                this.jmxManagerSSLKeyStorePassword = this.clusterSSLKeyStorePassword;
                this.sourceMap.put("jmx-manager-ssl-keystore-password", this.sourceMap.get("cluster-ssl-keystore-password"));
            }
            if (this.sourceMap.get("cluster-ssl-truststore") != null) {
                this.jmxManagerSSLTrustStore = this.clusterSSLTrustStore;
                this.sourceMap.put("jmx-manager-ssl-truststore", this.sourceMap.get("cluster-ssl-truststore"));
            }
            if (this.sourceMap.get("cluster-ssl-truststore-password") != null) {
                this.jmxManagerSSLTrustStorePassword = this.clusterSSLTrustStorePassword;
                this.sourceMap.put("jmx-manager-ssl-truststore-password", this.sourceMap.get("cluster-ssl-truststore-password"));
            }
            this.jmxManagerSslProperties.putAll((Map<?, ?>)this.clusterSSLProperties);
        }
        if (jmxSSLOverriden || jmxSSLEnabledOverriden) {
            if (this.sourceMap.get("jmx-manager-ssl-keystore") == null && this.sourceMap.get("cluster-ssl-keystore") != null) {
                this.jmxManagerSSLKeyStore = this.clusterSSLKeyStore;
                this.sourceMap.put("jmx-manager-ssl-keystore", this.sourceMap.get("cluster-ssl-keystore"));
            }
            if (this.sourceMap.get("jmx-manager-ssl-keystore-type") == null && this.sourceMap.get("cluster-ssl-keystore-type") != null) {
                this.jmxManagerSSLKeyStoreType = this.clusterSSLKeyStoreType;
                this.sourceMap.put("jmx-manager-ssl-keystore-type", this.sourceMap.get("cluster-ssl-keystore-type"));
            }
            if (this.sourceMap.get("jmx-manager-ssl-keystore-password") == null && this.sourceMap.get("cluster-ssl-keystore-password") != null) {
                this.jmxManagerSSLKeyStorePassword = this.clusterSSLKeyStorePassword;
                this.sourceMap.put("jmx-manager-ssl-keystore-password", this.sourceMap.get("cluster-ssl-keystore-password"));
            }
            if (this.sourceMap.get("jmx-manager-ssl-truststore") == null && this.sourceMap.get("cluster-ssl-truststore") != null) {
                this.jmxManagerSSLTrustStore = this.clusterSSLTrustStore;
                this.sourceMap.put("jmx-manager-ssl-truststore", this.sourceMap.get("cluster-ssl-truststore"));
            }
            if (this.sourceMap.get("jmx-manager-ssl-truststore-password") == null && this.sourceMap.get("cluster-ssl-truststore-password") != null) {
                this.jmxManagerSSLTrustStorePassword = this.clusterSSLTrustStorePassword;
                this.sourceMap.put("jmx-manager-ssl-truststore-password", this.sourceMap.get("cluster-ssl-truststore-password"));
            }
        }
    }

    private void copySSLPropsToHTTPSSLProps() {
        boolean clusterSSLOverRidden;
        boolean httpServiceSSLEnabledOverriden = this.sourceMap.get("http-service-ssl-enabled") != null;
        boolean bl = clusterSSLOverRidden = this.sourceMap.get("cluster-ssl-enabled") != null;
        if (clusterSSLOverRidden && !httpServiceSSLEnabledOverriden) {
            this.httpServiceSSLEnabled = this.clusterSSLEnabled;
            this.sourceMap.put("http-service-ssl-enabled", this.sourceMap.get("cluster-ssl-enabled"));
            if (this.sourceMap.get("cluster-ssl-ciphers") != null) {
                this.httpServiceSSLCiphers = this.clusterSSLCiphers;
                this.sourceMap.put("http-service-ssl-ciphers", this.sourceMap.get("cluster-ssl-ciphers"));
            }
            if (this.sourceMap.get("cluster-ssl-protocols") != null) {
                this.httpServiceSSLProtocols = this.clusterSSLProtocols;
                this.sourceMap.put("http-service-ssl-protocols", this.sourceMap.get("cluster-ssl-protocols"));
            }
            if (this.sourceMap.get("cluster-ssl-require-authentication") != null) {
                this.httpServiceSSLRequireAuthentication = this.clusterSSLRequireAuthentication;
                this.sourceMap.put("http-service-ssl-require-authentication", this.sourceMap.get("cluster-ssl-require-authentication"));
            }
            if (this.sourceMap.get("cluster-ssl-keystore") != null) {
                this.httpServiceSSLKeyStore = this.clusterSSLKeyStore;
                this.sourceMap.put("http-service-ssl-keystore", this.sourceMap.get("cluster-ssl-keystore"));
            }
            if (this.sourceMap.get("cluster-ssl-keystore-type") != null) {
                this.httpServiceSSLKeyStoreType = this.clusterSSLKeyStoreType;
                this.sourceMap.put("http-service-ssl-keystore-type", this.sourceMap.get("cluster-ssl-keystore-type"));
            }
            if (this.sourceMap.get("cluster-ssl-keystore-password") != null) {
                this.httpServiceSSLKeyStorePassword = this.clusterSSLKeyStorePassword;
                this.sourceMap.put("http-service-ssl-keystore-password", this.sourceMap.get("cluster-ssl-keystore-password"));
            }
            if (this.sourceMap.get("cluster-ssl-truststore") != null) {
                this.httpServiceSSLTrustStore = this.clusterSSLTrustStore;
                this.sourceMap.put("http-service-ssl-truststore", this.sourceMap.get("cluster-ssl-truststore"));
            }
            if (this.sourceMap.get("cluster-ssl-truststore-password") != null) {
                this.httpServiceSSLTrustStorePassword = this.clusterSSLTrustStorePassword;
                this.sourceMap.put("http-service-ssl-truststore-password", this.sourceMap.get("cluster-ssl-truststore-password"));
            }
            this.httpServiceSSLProperties.putAll((Map<?, ?>)this.clusterSSLProperties);
        }
        if (httpServiceSSLEnabledOverriden) {
            if (this.sourceMap.get("http-service-ssl-keystore") == null && this.sourceMap.get("cluster-ssl-keystore") != null) {
                this.httpServiceSSLKeyStore = this.clusterSSLKeyStore;
                this.sourceMap.put("http-service-ssl-keystore", this.sourceMap.get("cluster-ssl-keystore"));
            }
            if (this.sourceMap.get("http-service-ssl-keystore-type") == null && this.sourceMap.get("cluster-ssl-keystore-type") != null) {
                this.httpServiceSSLKeyStoreType = this.clusterSSLKeyStoreType;
                this.sourceMap.put("http-service-ssl-keystore-type", this.sourceMap.get("cluster-ssl-keystore-type"));
            }
            if (this.sourceMap.get("http-service-ssl-keystore-password") == null && this.sourceMap.get("cluster-ssl-keystore-password") != null) {
                this.httpServiceSSLKeyStorePassword = this.clusterSSLKeyStorePassword;
                this.sourceMap.put("http-service-ssl-keystore-password", this.sourceMap.get("cluster-ssl-keystore-password"));
            }
            if (this.sourceMap.get("http-service-ssl-truststore") == null && this.sourceMap.get("cluster-ssl-truststore") != null) {
                this.httpServiceSSLTrustStore = this.clusterSSLTrustStore;
                this.sourceMap.put("http-service-ssl-truststore", this.sourceMap.get("cluster-ssl-truststore"));
            }
            if (this.sourceMap.get("http-service-ssl-truststore-password") == null && this.sourceMap.get("cluster-ssl-truststore-password") != null) {
                this.httpServiceSSLTrustStorePassword = this.clusterSSLTrustStorePassword;
                this.sourceMap.put("http-service-ssl-truststore-password", this.sourceMap.get("cluster-ssl-truststore-password"));
            }
        }
    }

    private void copySSLPropsToServerSSLProps() {
        boolean clusterSSLOverRidden;
        boolean cacheServerSSLOverriden = this.sourceMap.get("server-ssl-enabled") != null;
        boolean bl = clusterSSLOverRidden = this.sourceMap.get("cluster-ssl-enabled") != null;
        if (clusterSSLOverRidden && !cacheServerSSLOverriden) {
            this.serverSSLEnabled = this.clusterSSLEnabled;
            this.sourceMap.put("server-ssl-enabled", this.sourceMap.get("cluster-ssl-enabled"));
            if (this.sourceMap.get("cluster-ssl-ciphers") != null) {
                this.serverSslCiphers = this.clusterSSLCiphers;
                this.sourceMap.put("server-ssl-ciphers", this.sourceMap.get("cluster-ssl-ciphers"));
            }
            if (this.sourceMap.get("cluster-ssl-protocols") != null) {
                this.serverSslProtocols = this.clusterSSLProtocols;
                this.sourceMap.put("server-ssl-protocols", this.sourceMap.get("cluster-ssl-protocols"));
            }
            if (this.sourceMap.get("cluster-ssl-require-authentication") != null) {
                this.serverSslRequireAuthentication = this.clusterSSLRequireAuthentication;
                this.sourceMap.put("server-ssl-require-authentication", this.sourceMap.get("cluster-ssl-require-authentication"));
            }
            if (this.sourceMap.get("cluster-ssl-keystore") != null) {
                this.serverSSLKeyStore = this.clusterSSLKeyStore;
                this.sourceMap.put("server-ssl-keystore", this.sourceMap.get("cluster-ssl-keystore"));
            }
            if (this.sourceMap.get("cluster-ssl-keystore-type") != null) {
                this.serverSSLKeyStoreType = this.clusterSSLKeyStoreType;
                this.sourceMap.put("server-ssl-keystore-type", this.sourceMap.get("cluster-ssl-keystore-type"));
            }
            if (this.sourceMap.get("cluster-ssl-keystore-password") != null) {
                this.serverSSLKeyStorePassword = this.clusterSSLKeyStorePassword;
                this.sourceMap.put("server-ssl-keystore-password", this.sourceMap.get("cluster-ssl-keystore-password"));
            }
            if (this.sourceMap.get("cluster-ssl-truststore") != null) {
                this.serverSSLTrustStore = this.clusterSSLTrustStore;
                this.sourceMap.put("server-ssl-truststore", this.sourceMap.get("cluster-ssl-truststore"));
            }
            if (this.sourceMap.get("cluster-ssl-truststore-password") != null) {
                this.serverSSLTrustStorePassword = this.clusterSSLTrustStorePassword;
                this.sourceMap.put("server-ssl-truststore-password", this.sourceMap.get("cluster-ssl-truststore-password"));
            }
            this.serverSslProperties.putAll((Map<?, ?>)this.clusterSSLProperties);
        }
        if (cacheServerSSLOverriden) {
            if (this.sourceMap.get("server-ssl-keystore") == null && this.sourceMap.get("cluster-ssl-keystore") != null) {
                this.serverSSLKeyStore = this.clusterSSLKeyStore;
                this.sourceMap.put("server-ssl-keystore", this.sourceMap.get("cluster-ssl-keystore"));
            }
            if (this.sourceMap.get("server-ssl-keystore-type") == null && this.sourceMap.get("cluster-ssl-keystore-type") != null) {
                this.serverSSLKeyStoreType = this.clusterSSLKeyStoreType;
                this.sourceMap.put("server-ssl-keystore-type", this.sourceMap.get("cluster-ssl-keystore-type"));
            }
            if (this.sourceMap.get("server-ssl-keystore-password") == null && this.sourceMap.get("cluster-ssl-keystore-password") != null) {
                this.serverSSLKeyStorePassword = this.clusterSSLKeyStorePassword;
                this.sourceMap.put("server-ssl-keystore-password", this.sourceMap.get("cluster-ssl-keystore-password"));
            }
            if (this.sourceMap.get("server-ssl-truststore") == null && this.sourceMap.get("cluster-ssl-truststore") != null) {
                this.serverSSLTrustStore = this.clusterSSLTrustStore;
                this.sourceMap.put("server-ssl-truststore", this.sourceMap.get("cluster-ssl-truststore"));
            }
            if (this.sourceMap.get("server-ssl-truststore-password") == null && this.sourceMap.get("cluster-ssl-truststore-password") != null) {
                this.serverSSLTrustStorePassword = this.clusterSSLTrustStorePassword;
                this.sourceMap.put("server-ssl-truststore-password", this.sourceMap.get("cluster-ssl-truststore-password"));
            }
        }
    }

    private void copyClusterSSLPropsToGatewaySSLProps() {
        boolean clusterSSLOverRidden;
        boolean gatewaySSLOverriden = this.sourceMap.get("gateway-ssl-enabled") != null;
        boolean bl = clusterSSLOverRidden = this.sourceMap.get("cluster-ssl-enabled") != null;
        if (clusterSSLOverRidden && !gatewaySSLOverriden) {
            this.gatewaySSLEnabled = this.clusterSSLEnabled;
            this.sourceMap.put("gateway-ssl-enabled", this.sourceMap.get("cluster-ssl-enabled"));
            if (this.sourceMap.get("cluster-ssl-ciphers") != null) {
                this.gatewaySslCiphers = this.clusterSSLCiphers;
                this.sourceMap.put("gateway-ssl-ciphers", this.sourceMap.get("cluster-ssl-ciphers"));
            }
            if (this.sourceMap.get("cluster-ssl-protocols") != null) {
                this.gatewaySslProtocols = this.clusterSSLProtocols;
                this.sourceMap.put("gateway-ssl-protocols", this.sourceMap.get("cluster-ssl-protocols"));
            }
            if (this.sourceMap.get("cluster-ssl-require-authentication") != null) {
                this.gatewaySslRequireAuthentication = this.clusterSSLRequireAuthentication;
                this.sourceMap.put("gateway-ssl-require-authentication", this.sourceMap.get("cluster-ssl-require-authentication"));
            }
            if (this.sourceMap.get("cluster-ssl-keystore") != null) {
                this.gatewaySSLKeyStore = this.clusterSSLKeyStore;
                this.sourceMap.put("gateway-ssl-keystore", this.sourceMap.get("cluster-ssl-keystore"));
            }
            if (this.sourceMap.get("cluster-ssl-keystore-type") != null) {
                this.gatewaySSLKeyStoreType = this.clusterSSLKeyStoreType;
                this.sourceMap.put("gateway-ssl-keystore-type", this.sourceMap.get("cluster-ssl-keystore-type"));
            }
            if (this.sourceMap.get("cluster-ssl-keystore-password") != null) {
                this.gatewaySSLKeyStorePassword = this.clusterSSLKeyStorePassword;
                this.sourceMap.put("gateway-ssl-keystore-password", this.sourceMap.get("cluster-ssl-keystore-password"));
            }
            if (this.sourceMap.get("cluster-ssl-truststore") != null) {
                this.gatewaySSLTrustStore = this.clusterSSLTrustStore;
                this.sourceMap.put("gateway-ssl-truststore", this.sourceMap.get("cluster-ssl-truststore"));
            }
            if (this.sourceMap.get("cluster-ssl-truststore-password") != null) {
                this.gatewaySSLTrustStorePassword = this.clusterSSLTrustStorePassword;
                this.sourceMap.put("gateway-ssl-truststore-password", this.sourceMap.get("cluster-ssl-truststore-password"));
            }
            this.gatewaySslProperties.putAll((Map<?, ?>)this.clusterSSLProperties);
        }
        if (gatewaySSLOverriden) {
            if (this.sourceMap.get("gateway-ssl-keystore") == null && this.sourceMap.get("cluster-ssl-keystore") != null) {
                this.gatewaySSLKeyStore = this.clusterSSLKeyStore;
                this.sourceMap.put("gateway-ssl-keystore", this.sourceMap.get("cluster-ssl-keystore"));
            }
            if (this.sourceMap.get("gateway-ssl-keystore-type") == null && this.sourceMap.get("cluster-ssl-keystore-type") != null) {
                this.gatewaySSLKeyStoreType = this.clusterSSLKeyStoreType;
                this.sourceMap.put("gateway-ssl-keystore-type", this.sourceMap.get("cluster-ssl-keystore-type"));
            }
            if (this.sourceMap.get("gateway-ssl-keystore-password") == null && this.sourceMap.get("cluster-ssl-keystore-password") != null) {
                this.gatewaySSLKeyStorePassword = this.clusterSSLKeyStorePassword;
                this.sourceMap.put("gateway-ssl-keystore-password", this.sourceMap.get("cluster-ssl-keystore-password"));
            }
            if (this.sourceMap.get("gateway-ssl-truststore") == null && this.sourceMap.get("cluster-ssl-truststore") != null) {
                this.gatewaySSLTrustStore = this.clusterSSLTrustStore;
                this.sourceMap.put("gateway-ssl-truststore", this.sourceMap.get("cluster-ssl-truststore"));
            }
            if (this.sourceMap.get("gateway-ssl-truststore-password") == null && this.sourceMap.get("cluster-ssl-truststore-password") != null) {
                this.gatewaySSLTrustStorePassword = this.clusterSSLTrustStorePassword;
                this.sourceMap.put("gateway-ssl-truststore-password", this.sourceMap.get("cluster-ssl-truststore-password"));
            }
        }
    }

    private void computeMcastPortDefault() {
        String locators;
        ConfigSource cs = this.getAttSourceMap().get("mcast-port");
        if (cs == null && (locators = this.getLocators()) != null && !locators.isEmpty()) {
            this.mcastPort = 0;
        }
    }

    public static DistributionConfigImpl produce(Properties props) {
        Object o;
        if (props != null && (o = props.get("ds-config")) instanceof DistributionConfigImpl) {
            return (DistributionConfigImpl)o;
        }
        return new DistributionConfigImpl(props, false, false);
    }

    public static DistributionConfigImpl produce(Properties props, boolean isConnected) {
        Object o;
        if (props != null && (o = props.get("ds-config")) instanceof DistributionConfigImpl) {
            return (DistributionConfigImpl)o;
        }
        return new DistributionConfigImpl(props, false, isConnected);
    }

    public void setApiProps(Properties apiProps) {
        if (apiProps != null) {
            this.setSource(apiProps, ConfigSource.api());
            this.modifiable = true;
            for (Map.Entry<Object, Object> me : apiProps.entrySet()) {
                String propVal;
                String propName = (String)me.getKey();
                this.props.put(propName, me.getValue());
                if (DistributionConfigImpl.specialPropName(propName) || (propVal = (String)me.getValue()) == null) continue;
                this.setAttribute(propName, propVal.trim(), this.sourceMap.get(propName));
            }
            this.computeMcastPortDefault();
            this.modifiable = false;
        }
    }

    public static boolean specialPropName(String propName) {
        return propName.equalsIgnoreCase("ssl-enabled") || propName.equalsIgnoreCase("cluster-ssl-enabled") || propName.equals("security-peer-auth-init") || propName.equals("security-peer-authenticator") || propName.equals("log-writer") || propName.equals("ds-config") || propName.equals("security-log-writer") || propName.equals("log-output-stream") || propName.equals("security-log-output-stream");
    }

    @Override
    protected Map<String, ConfigSource> getAttSourceMap() {
        return this.sourceMap;
    }

    @Override
    public Properties getUserDefinedProps() {
        return this.userDefinedProps;
    }

    public static void loadGemFireProperties(Properties p) throws GemFireIOException {
        DistributionConfigImpl.loadGemFireProperties(p, false);
    }

    public static void loadGemFireProperties(Properties p, boolean ignoreGemFirePropsFile) throws GemFireIOException {
        if (!ignoreGemFirePropsFile) {
            DistributionConfigImpl.loadPropertiesFromURL(p, DistributedSystem.getPropertyFileURL());
        }
        DistributionConfigImpl.loadPropertiesFromURL(p, DistributedSystem.getSecurityPropertiesFileURL());
    }

    private void setSource(Properties p, ConfigSource source) {
        if (source == null) {
            throw new IllegalArgumentException("Valid ConfigSource must be specified instead of null.");
        }
        for (Object k : p.keySet()) {
            this.sourceMap.put((String)k, source);
        }
    }

    private Properties loadPropertiesFromURL(URL url, boolean secure) {
        Properties result = new Properties();
        DistributionConfigImpl.loadPropertiesFromURL(result, url);
        if (!result.isEmpty()) {
            this.setSource(result, ConfigSource.file(url.toString(), secure));
        }
        return result;
    }

    private static void loadPropertiesFromURL(Properties p, URL url) {
        if (url != null) {
            try {
                p.load(url.openStream());
            }
            catch (IOException io) {
                throw new GemFireIOException(LocalizedStrings.DistributionConfigImpl_FAILED_READING_0.toLocalizedString(url), io);
            }
        }
    }

    private void initialize(Map props) {
        this.modifiable = true;
        this.props = props;
        for (Map.Entry me : props.entrySet()) {
            Object propVal;
            String propName = (String)me.getKey();
            if (DistributionConfigImpl.specialPropName(propName) || (propVal = me.getValue()) == null || !(propVal instanceof String)) continue;
            this.setAttribute(propName, ((String)propVal).trim(), this.sourceMap.get(propName));
        }
        if (props.containsKey("ssl-enabled")) {
            this.setAttribute("ssl-enabled", (String)props.get("ssl-enabled"), this.sourceMap.get("ssl-enabled"));
        }
        if (props.containsKey("cluster-ssl-enabled")) {
            this.setAttribute("cluster-ssl-enabled", (String)props.get("cluster-ssl-enabled"), this.sourceMap.get("cluster-ssl-enabled"));
        }
        if (props.containsKey("security-peer-auth-init")) {
            this.setAttribute("security-peer-auth-init", (String)props.get("security-peer-auth-init"), this.sourceMap.get("security-peer-auth-init"));
        }
        if (props.containsKey("security-peer-authenticator")) {
            this.setAttribute("security-peer-authenticator", (String)props.get("security-peer-authenticator"), this.sourceMap.get("security-peer-authenticator"));
        }
        this.modifiable = false;
    }

    @Override
    public void close() {
        Properties props = System.getProperties();
        props.remove("gemfire.sys.security-peer-auth-init");
        props.remove("gemfire.sys.security-peer-authenticator");
        Iterator<Object> iter = this.security.keySet().iterator();
        while (iter.hasNext()) {
            props.remove(SECURITY_SYSTEM_PREFIX + (String)iter.next());
        }
        System.setProperties(props);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getTcpPort() {
        return this.tcpPort;
    }

    @Override
    public int getMcastPort() {
        return this.mcastPort;
    }

    @Override
    public int getMcastTtl() {
        return this.mcastTtl;
    }

    @Override
    public int getSocketLeaseTime() {
        return this.socketLeaseTime;
    }

    @Override
    public int getSocketBufferSize() {
        return this.socketBufferSize;
    }

    @Override
    public boolean getConserveSockets() {
        return this.conserveSockets;
    }

    @Override
    public String getRoles() {
        return this.roles;
    }

    @Override
    public int getMaxWaitTimeForReconnect() {
        return this.maxWaitTimeForReconnect;
    }

    @Override
    public int getMaxNumReconnectTries() {
        return this.maxNumReconnectTries;
    }

    @Override
    public InetAddress getMcastAddress() {
        try {
            return this.mcastAddress;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public String getBindAddress() {
        return this.bindAddress;
    }

    @Override
    public String getServerBindAddress() {
        return this.serverBindAddress;
    }

    @Override
    public String getLocators() {
        if (this.startLocator != null && this.startLocator.length() > 0) {
            String locs = this.locators;
            String startL = this.getStartLocator();
            int comma = startL.indexOf(44);
            if (comma >= 0) {
                startL = startL.substring(0, comma);
            }
            if (locs.length() > 0) {
                if (locs.contains(startL)) {
                    return locs;
                }
                return locs + "," + startL;
            }
            return startL;
        }
        return this.locators;
    }

    @Override
    public String getStartLocator() {
        if (this.startLocatorPort > 0) {
            if (this.bindAddress != null) {
                return this.bindAddress + "[" + this.startLocatorPort + "]";
            }
            try {
                return SocketCreator.getHostName(SocketCreator.getLocalHost()) + "[" + this.startLocatorPort + "]";
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
        return this.startLocator;
    }

    @Override
    public File getDeployWorkingDir() {
        return this.deployWorkingDir;
    }

    @Override
    public String getLicenseDataManagement() {
        return this.licenseDataManagement;
    }

    @Override
    public String getLicenseApplicationCache() {
        return this.licenseApplicationCache;
    }

    @Override
    public File getLicenseWorkingDir() {
        if (this.licenseWorkingDir != null && !DEFAULT_LICENSE_WORKING_DIR.getAbsolutePath().equals(this.licenseWorkingDir.getAbsolutePath())) {
            return this.licenseWorkingDir;
        }
        if (this.writableWorkingDir != null) {
            return this.writableWorkingDir;
        }
        return this.licenseWorkingDir;
    }

    @Override
    public File getWritableWorkingDir() {
        return this.writableWorkingDir;
    }

    @Override
    public File getLogFile() {
        return this.logFile;
    }

    @Override
    public int getLogLevel() {
        return this.logLevel;
    }

    @Override
    public boolean getStatisticSamplingEnabled() {
        return this.statisticSamplingEnabled;
    }

    @Override
    public int getStatisticSampleRate() {
        return this.statisticSampleRate;
    }

    @Override
    public File getStatisticArchiveFile() {
        return this.statisticArchiveFile;
    }

    @Override
    public int getAckWaitThreshold() {
        return this.ackWaitThreshold;
    }

    @Override
    public int getAckSevereAlertThreshold() {
        return this.ackForceDisconnectThreshold;
    }

    @Override
    public File getCacheXmlFile() {
        return this.cacheXmlFile;
    }

    @Override
    public boolean getSSLEnabled() {
        return this.sslEnabled;
    }

    @Override
    public String getSSLProtocols() {
        return this.sslProtocols;
    }

    @Override
    public String getSSLCiphers() {
        return this.sslCiphers;
    }

    @Override
    public boolean getSSLRequireAuthentication() {
        return this.sslRequireAuthentication;
    }

    @Override
    public boolean getClusterSSLEnabled() {
        return this.clusterSSLEnabled;
    }

    @Override
    public String getClusterSSLProtocols() {
        return this.clusterSSLProtocols;
    }

    @Override
    public String getClusterSSLCiphers() {
        return this.clusterSSLCiphers;
    }

    @Override
    public boolean getClusterSSLRequireAuthentication() {
        return this.clusterSSLRequireAuthentication;
    }

    @Override
    public String getClusterSSLKeyStore() {
        return this.clusterSSLKeyStore;
    }

    @Override
    public String getClusterSSLKeyStoreType() {
        return this.clusterSSLKeyStoreType;
    }

    @Override
    public String getClusterSSLKeyStorePassword() {
        return this.clusterSSLKeyStorePassword;
    }

    @Override
    public String getClusterSSLTrustStore() {
        return this.clusterSSLTrustStore;
    }

    @Override
    public String getClusterSSLTrustStorePassword() {
        return this.clusterSSLTrustStorePassword;
    }

    @Override
    public int getAsyncDistributionTimeout() {
        return this.asyncDistributionTimeout;
    }

    @Override
    public int getAsyncQueueTimeout() {
        return this.asyncQueueTimeout;
    }

    @Override
    public int getAsyncMaxQueueSize() {
        return this.asyncMaxQueueSize;
    }

    @Override
    public String getUserCommandPackages() {
        return this.userCommandPackages;
    }

    @Override
    public int getHttpServicePort() {
        return this.httpServicePort;
    }

    @Override
    public void setHttpServicePort(int value2) {
        this.minMaxCheck("http-service-port", value2, 0, 65535);
        this.httpServicePort = value2;
    }

    @Override
    public String getHttpServiceBindAddress() {
        return this.httpServiceBindAddress;
    }

    @Override
    public void setHttpServiceBindAddress(String value2) {
        this.checkHttpServiceBindAddress(value2);
        this.httpServiceBindAddress = value2;
    }

    @Override
    public boolean getStartDevRestApi() {
        return this.startDevRestApi;
    }

    @Override
    public void setStartDevRestApi(boolean value2) {
        this.startDevRestApi = value2;
    }

    @Override
    public void setUserCommandPackages(String value2) {
        this.checkUserCommandPackages(value2);
        this.userCommandPackages = value2;
    }

    @Override
    public boolean getDeltaPropagation() {
        return this.deltaPropagation;
    }

    @Override
    public void setDeltaPropagation(boolean value2) {
        this.checkDeltaPropagationModifiable();
        this.deltaPropagation = value2;
    }

    @Override
    public void setName(String value2) {
        this.checkName(value2);
        if (value2 == null) {
            value2 = "";
        }
        this.name = value2;
    }

    @Override
    public void setTcpPort(int value2) {
        this.checkTcpPort(value2);
        this.tcpPort = value2;
    }

    @Override
    public void setMcastPort(int value2) {
        this.checkMcastPort(value2);
        this.mcastPort = value2;
    }

    @Override
    public void setMcastTtl(int value2) {
        this.checkMcastTtl(value2);
        this.mcastTtl = value2;
    }

    @Override
    public void setSocketLeaseTime(int value2) {
        this.checkSocketLeaseTime(value2);
        this.socketLeaseTime = value2;
    }

    @Override
    public void setSocketBufferSize(int value2) {
        this.checkSocketBufferSize(value2);
        this.socketBufferSize = value2;
    }

    @Override
    public void setConserveSockets(boolean value2) {
        this.checkConserveSockets(value2);
        this.conserveSockets = value2;
    }

    @Override
    public void setRoles(String value2) {
        this.checkRoles(value2);
        this.roles = value2;
    }

    @Override
    public void setMaxWaitTimeForReconnect(int value2) {
        this.maxWaitTimeForReconnect = value2;
    }

    @Override
    public void setMaxNumReconnectTries(int value2) {
        this.maxNumReconnectTries = value2;
    }

    @Override
    public void setMcastAddress(InetAddress value2) {
        this.checkMcastAddress(value2);
        this.mcastAddress = value2;
    }

    @Override
    public void setBindAddress(String value2) {
        this.checkBindAddress(value2);
        this.bindAddress = value2;
    }

    @Override
    public void setServerBindAddress(String value2) {
        this.checkServerBindAddress(value2);
        this.serverBindAddress = value2;
    }

    @Override
    public void setLocators(String value2) {
        if ((value2 = this.checkLocators(value2)) == null) {
            value2 = "";
        }
        this.locators = value2;
    }

    @Override
    public void setLocatorWaitTime(int value2) {
        this.locatorWaitTime = value2;
    }

    @Override
    public int getLocatorWaitTime() {
        return this.locatorWaitTime;
    }

    @Override
    public void setDeployWorkingDir(File value2) {
        this.checkDeployWorkingDir(value2);
        this.deployWorkingDir = value2;
    }

    @Override
    public void setLicenseDataManagement(String value2) {
        this.checkLicenseDataManagement(value2);
        this.licenseDataManagement = value2;
    }

    @Override
    public void setLicenseApplicationCache(String value2) {
        this.checkLicenseApplicationCache(value2);
        this.licenseApplicationCache = value2;
    }

    @Override
    public void setLicenseWorkingDir(File value2) {
        this.checkLicenseWorkingDir(value2);
        this.licenseWorkingDir = value2;
    }

    @Override
    public void setWritableWorkingDir(File value2) {
        this.checkLicenseWorkingDir(value2);
        this.writableWorkingDir = value2;
    }

    @Override
    public int getLicenseServerTimeout() {
        return this.licenseServerTimeout;
    }

    @Override
    public void setLicenseServerTimeout(int value2) {
        this.checkLicenseServerTimeout(value2);
        this.licenseServerTimeout = value2;
    }

    protected void checkLicenseServerTimeout(int value2) {
        this.minMaxCheck("license-server-timeout", value2, 1000, 3600000);
    }

    @Override
    public void setLogFile(File value2) {
        this.checkLogFile(value2);
        this.logFile = value2;
    }

    @Override
    public void setLogLevel(int value2) {
        this.checkLogLevel(value2);
        this.logLevel = value2;
    }

    public void unsafeSetLogFile(File value2) {
        this.logFile = value2;
    }

    @Override
    public void setStartLocator(String value2) {
        this.startLocatorPort = 0;
        if (value2 == null) {
            value2 = "";
        } else {
            boolean alldigits = true;
            for (int i = 0; i < value2.length(); ++i) {
                char c = value2.charAt(i);
                if (Character.isDigit(c)) continue;
                alldigits = false;
                break;
            }
            if (value2.length() > 0 && alldigits) {
                try {
                    int port = Integer.parseInt(value2);
                    if (port < 0 || port > 65535) {
                        throw new GemFireConfigException("Illegal port specified for start-locator");
                    }
                    this.startLocatorPort = port;
                }
                catch (NumberFormatException e) {
                    throw new GemFireConfigException("Illegal port specified for start-locator", e);
                }
            } else {
                this.checkStartLocator(value2);
            }
        }
        this.startLocator = value2;
    }

    @Override
    public void setStatisticSamplingEnabled(boolean value2) {
        this.checkStatisticSamplingEnabled(value2);
        this.statisticSamplingEnabled = value2;
    }

    @Override
    public void setStatisticSampleRate(int value2) {
        this.checkStatisticSampleRate(value2);
        if (value2 < 1000) {
            InternalDistributedSystem ids = InternalDistributedSystem.getConnectedInstance();
            if (ids != null) {
                ids.getLogWriter().info("Setting statistic-sample-rate to 1000 instead of the requested " + value2 + " because VSD does not work with sub-second sampling.");
            }
            value2 = 1000;
        }
        this.statisticSampleRate = value2;
    }

    @Override
    public void setStatisticArchiveFile(File value2) {
        this.checkStatisticArchiveFile(value2);
        if (value2 == null) {
            value2 = new File("");
        }
        this.statisticArchiveFile = value2;
    }

    @Override
    public void setCacheXmlFile(File value2) {
        this.checkCacheXmlFile(value2);
        this.cacheXmlFile = value2;
    }

    @Override
    public void setAckWaitThreshold(int value2) {
        this.checkAckWaitThreshold(value2);
        this.ackWaitThreshold = value2;
    }

    @Override
    public void setAckSevereAlertThreshold(int value2) {
        this.checkAckSevereAlertThreshold(value2);
        this.ackForceDisconnectThreshold = value2;
    }

    @Override
    public int getArchiveDiskSpaceLimit() {
        return this.archiveDiskSpaceLimit;
    }

    @Override
    public void setArchiveDiskSpaceLimit(int value2) {
        this.checkArchiveDiskSpaceLimit(value2);
        this.archiveDiskSpaceLimit = value2;
    }

    @Override
    public int getArchiveFileSizeLimit() {
        return this.archiveFileSizeLimit;
    }

    @Override
    public void setArchiveFileSizeLimit(int value2) {
        this.checkArchiveFileSizeLimit(value2);
        this.archiveFileSizeLimit = value2;
    }

    @Override
    public int getLogDiskSpaceLimit() {
        return this.logDiskSpaceLimit;
    }

    @Override
    public void setLogDiskSpaceLimit(int value2) {
        this.checkLogDiskSpaceLimit(value2);
        this.logDiskSpaceLimit = value2;
    }

    @Override
    public int getLogFileSizeLimit() {
        return this.logFileSizeLimit;
    }

    @Override
    public void setLogFileSizeLimit(int value2) {
        this.checkLogFileSizeLimit(value2);
        this.logFileSizeLimit = value2;
    }

    @Override
    public void setSSLEnabled(boolean value2) {
        this.checkSSLEnabled(value2 ? Boolean.TRUE : Boolean.FALSE);
        this.sslEnabled = value2;
    }

    @Override
    public void setSSLProtocols(String value2) {
        this.checkSSLProtocols(value2);
        this.sslProtocols = value2;
    }

    @Override
    public void setSSLCiphers(String value2) {
        this.checkSSLCiphers(value2);
        this.sslCiphers = value2;
    }

    @Override
    public void setSSLRequireAuthentication(boolean value2) {
        this.checkSSLRequireAuthentication(value2 ? Boolean.TRUE : Boolean.FALSE);
        this.sslRequireAuthentication = value2;
    }

    @Override
    public void setClusterSSLEnabled(boolean value2) {
        this.checkClusterSSLEnabled(value2 ? Boolean.TRUE : Boolean.FALSE);
        this.clusterSSLEnabled = value2;
    }

    @Override
    public void setClusterSSLProtocols(String value2) {
        this.checkClusterSSLProtocols(value2);
        this.clusterSSLProtocols = value2;
    }

    @Override
    public void setClusterSSLCiphers(String value2) {
        this.checkClusterSSLCiphers(value2);
        this.clusterSSLCiphers = value2;
    }

    @Override
    public void setClusterSSLRequireAuthentication(boolean value2) {
        this.checkClusterSSLRequireAuthentication(value2 ? Boolean.TRUE : Boolean.FALSE);
        this.clusterSSLRequireAuthentication = value2;
    }

    @Override
    public void setClusterSSLKeyStore(String value2) {
        this.checkClusterSSLKeyStore(value2);
        this.getClusterSSLProperties().setProperty("javax.net.ssl.keyStore", value2);
        this.clusterSSLKeyStore = value2;
    }

    @Override
    public void setClusterSSLKeyStoreType(String value2) {
        this.checkClusterSSLKeyStoreType(value2);
        this.getClusterSSLProperties().setProperty("javax.net.ssl.keyStoreType", value2);
        this.clusterSSLKeyStoreType = value2;
    }

    @Override
    public void setClusterSSLKeyStorePassword(String value2) {
        this.checkClusterSSLKeyStorePassword(value2);
        this.getClusterSSLProperties().setProperty("javax.net.ssl.keyStorePassword", value2);
        this.clusterSSLKeyStorePassword = value2;
    }

    @Override
    public void setClusterSSLTrustStore(String value2) {
        this.checkClusterSSLTrustStore(value2);
        this.getClusterSSLProperties().setProperty("javax.net.ssl.trustStore", value2);
        this.clusterSSLTrustStore = value2;
    }

    @Override
    public void setClusterSSLTrustStorePassword(String value2) {
        this.checkClusterSSLTrustStorePassword(value2);
        this.getClusterSSLProperties().setProperty("javax.net.ssl.trustStorePassword", value2);
        this.clusterSSLTrustStorePassword = value2;
    }

    @Override
    public int getMcastSendBufferSize() {
        return this.mcastSendBufferSize;
    }

    @Override
    public void setMcastSendBufferSize(int value2) {
        this.checkMcastSendBufferSize(value2);
        this.mcastSendBufferSize = value2;
    }

    @Override
    public int getMcastRecvBufferSize() {
        return this.mcastRecvBufferSize;
    }

    @Override
    public void setMcastRecvBufferSize(int value2) {
        this.checkMcastRecvBufferSize(value2);
        this.mcastRecvBufferSize = value2;
    }

    @Override
    public void setAsyncDistributionTimeout(int value2) {
        this.checkAsyncDistributionTimeout(value2);
        this.asyncDistributionTimeout = value2;
    }

    @Override
    public void setAsyncQueueTimeout(int value2) {
        this.checkAsyncQueueTimeout(value2);
        this.asyncQueueTimeout = value2;
    }

    @Override
    public void setAsyncMaxQueueSize(int value2) {
        this.checkAsyncMaxQueueSize(value2);
        this.asyncMaxQueueSize = value2;
    }

    @Override
    public FlowControlParams getMcastFlowControl() {
        return this.mcastFlowControl;
    }

    @Override
    public void setMcastFlowControl(FlowControlParams values) {
        this.checkMcastFlowControl(values);
        this.mcastFlowControl = values;
    }

    @Override
    public int getUdpFragmentSize() {
        return this.udpFragmentSize;
    }

    @Override
    public void setUdpFragmentSize(int value2) {
        this.checkUdpFragmentSize(value2);
        this.udpFragmentSize = value2;
    }

    @Override
    public int getUdpSendBufferSize() {
        return this.udpSendBufferSize;
    }

    @Override
    public void setUdpSendBufferSize(int value2) {
        this.checkUdpSendBufferSize(value2);
        this.udpSendBufferSize = value2;
    }

    @Override
    public int getUdpRecvBufferSize() {
        return this.udpRecvBufferSize;
    }

    @Override
    public void setUdpRecvBufferSize(int value2) {
        this.checkUdpRecvBufferSize(value2);
        this.udpRecvBufferSize = value2;
    }

    @Override
    public boolean getDisableTcp() {
        return this.disableTcp;
    }

    @Override
    public void setDisableTcp(boolean newValue) {
        this.disableTcp = newValue;
    }

    @Override
    public boolean getEnableTimeStatistics() {
        return this.enableTimeStatistics;
    }

    @Override
    public void setEnableTimeStatistics(boolean newValue) {
        this.enableTimeStatistics = newValue;
    }

    @Override
    public int getMemberTimeout() {
        return this.memberTimeout;
    }

    @Override
    public void setMemberTimeout(int value2) {
        this.checkMemberTimeout(value2);
        this.memberTimeout = value2;
    }

    @Override
    public String getClientConflation() {
        return this.clientConflation;
    }

    @Override
    public void setClientConflation(String value2) {
        this.checkClientConflation(value2);
        this.clientConflation = value2;
    }

    @Override
    public String getDurableClientId() {
        return this.durableClientId;
    }

    @Override
    public void setDurableClientId(String value2) {
        this.checkDurableClientId(value2);
        this.durableClientId = value2;
    }

    @Override
    public int getDurableClientTimeout() {
        return this.durableClientTimeout;
    }

    @Override
    public void setDurableClientTimeout(int value2) {
        this.checkDurableClientTimeout(value2);
        this.durableClientTimeout = value2;
    }

    @Override
    public String getSecurityClientAuthInit() {
        return this.securityClientAuthInit;
    }

    @Override
    public void setSecurityClientAuthInit(String value2) {
        this.checkSecurityClientAuthInit(value2);
        this.securityClientAuthInit = value2;
    }

    @Override
    public String getSecurityClientAuthenticator() {
        return this.securityClientAuthenticator;
    }

    @Override
    public boolean getEnableNetworkPartitionDetection() {
        return this.enableNetworkPartitionDetection;
    }

    @Override
    public void setEnableNetworkPartitionDetection(boolean value2) {
        this.enableNetworkPartitionDetection = value2;
    }

    @Override
    public boolean getDisableAutoReconnect() {
        return this.disableAutoReconnect;
    }

    @Override
    public void setDisableAutoReconnect(boolean value2) {
        this.disableAutoReconnect = value2;
    }

    @Override
    public void setSecurityClientAuthenticator(String value2) {
        this.checkSecurityClientAuthenticator(value2);
        this.securityClientAuthenticator = value2;
    }

    @Override
    public String getSecurityClientDHAlgo() {
        return this.securityClientDHAlgo;
    }

    @Override
    public void setSecurityClientDHAlgo(String value2) {
        this.checkSecurityClientDHAlgo(value2);
        this.securityClientDHAlgo = value2;
    }

    @Override
    public String getSecurityPeerAuthInit() {
        return this.securityPeerAuthInit;
    }

    @Override
    public void setSecurityPeerAuthInit(String value2) {
        this.checkSecurityPeerAuthInit(value2);
        this.securityPeerAuthInit = value2;
    }

    @Override
    public String getSecurityPeerAuthenticator() {
        return this.securityPeerAuthenticator;
    }

    @Override
    public void setSecurityPeerAuthenticator(String value2) {
        this.checkSecurityPeerAuthenticator(value2);
        this.securityPeerAuthenticator = value2;
    }

    @Override
    public String getSecurityClientAccessor() {
        return this.securityClientAccessor;
    }

    @Override
    public void setSecurityClientAccessor(String value2) {
        this.checkSecurityClientAccessor(value2);
        this.securityClientAccessor = value2;
    }

    @Override
    public String getSecurityClientAccessorPP() {
        return this.securityClientAccessorPP;
    }

    @Override
    public void setSecurityClientAccessorPP(String value2) {
        this.checkSecurityClientAccessorPP(value2);
        this.securityClientAccessorPP = value2;
    }

    @Override
    public int getSecurityLogLevel() {
        return this.securityLogLevel;
    }

    @Override
    public void setSecurityLogLevel(int value2) {
        this.checkSecurityLogLevel(value2);
        this.securityLogLevel = value2;
    }

    @Override
    public File getSecurityLogFile() {
        return this.securityLogFile;
    }

    @Override
    public void setSecurityLogFile(File value2) {
        this.checkSecurityLogFile(value2);
        this.securityLogFile = value2;
    }

    @Override
    public int getSecurityPeerMembershipTimeout() {
        return this.securityPeerMembershipTimeout;
    }

    @Override
    public void setSecurityPeerMembershipTimeout(int value2) {
        this.checkSecurityPeerMembershipTimeout(value2);
        this.securityPeerMembershipTimeout = value2;
    }

    @Override
    public Properties getSecurityProps() {
        return this.security;
    }

    @Override
    public String getSecurity(String attName) {
        String attValue = this.security.getProperty(attName);
        return attValue == null ? "" : attValue;
    }

    @Override
    public void setSecurity(String attName, String attValue) {
        this.checkSecurity(attName, attValue);
        this.security.setProperty(attName, attValue);
    }

    @Override
    public boolean getRemoveUnresponsiveClient() {
        return this.removeUnresponsiveClient;
    }

    @Override
    public void setRemoveUnresponsiveClient(boolean value2) {
        this.removeUnresponsiveClient = value2;
    }

    @Override
    public int getDistributedSystemId() {
        return this.distributedSystemId;
    }

    @Override
    public void setDistributedSystemId(int distributedSystemId) {
        this.checkDistributedSystemId(distributedSystemId);
        this.distributedSystemId = distributedSystemId;
    }

    @Override
    public boolean getEnforceUniqueHost() {
        return this.enforceUniqueHost;
    }

    @Override
    public String getRedundancyZone() {
        return this.redundancyZone;
    }

    @Override
    public void setEnforceUniqueHost(boolean enforceUniqueHost) {
        this.checkEnforceUniqueHostModifiable();
        this.enforceUniqueHost = enforceUniqueHost;
    }

    @Override
    public void setRedundancyZone(String redundancyZone) {
        this.checkRedundancyZoneModifiable();
        this.redundancyZone = redundancyZone;
    }

    @Override
    public void setSSLProperty(String attName, String attValue) {
        this.checkSSLPropertyModifiable();
        if (attName.startsWith("sysprop-")) {
            attName = attName.substring("sysprop-".length());
        }
        if (attName.endsWith("-jmx")) {
            this.jmxManagerSslProperties.setProperty(attName.substring(0, attName.length() - "-jmx".length()), attValue);
        } else {
            this.sslProperties.setProperty(attName, attValue);
            if (!this.jmxManagerSslProperties.containsKey(attName)) {
                this.jmxManagerSslProperties.setProperty(attName, attValue);
            }
            if (!this.serverSslProperties.containsKey(attName)) {
                this.serverSslProperties.setProperty(attName, attValue);
            }
            if (!this.gatewaySslProperties.containsKey(attName)) {
                this.gatewaySslProperties.setProperty(attName, attValue);
            }
        }
    }

    @Override
    public Properties getSSLProperties() {
        return this.sslProperties;
    }

    @Override
    public Properties getClusterSSLProperties() {
        return this.clusterSSLProperties;
    }

    @Override
    public Properties getJmxSSLProperties() {
        return this.jmxManagerSslProperties;
    }

    @Override
    public String getGroups() {
        return this.groups;
    }

    @Override
    public void setGroups(String value2) {
        this.checkGroups(value2);
        if (value2 == null) {
            value2 = "";
        }
        this.groups = value2;
    }

    @Override
    public boolean getJmxManager() {
        return this.jmxManager;
    }

    @Override
    public void setJmxManager(boolean value2) {
        this.jmxManager = value2;
    }

    @Override
    public boolean getJmxManagerStart() {
        return this.jmxManagerStart;
    }

    @Override
    public void setJmxManagerStart(boolean value2) {
        this.jmxManagerStart = value2;
    }

    @Override
    public boolean getJmxManagerSSL() {
        return this.jmxManagerSSL;
    }

    @Override
    public void setJmxManagerSSL(boolean value2) {
        this.jmxManagerSSL = value2;
    }

    @Override
    public boolean isJmxManagerSSLModifiable() {
        return false;
    }

    @Override
    public boolean getJmxManagerSSLEnabled() {
        return this.jmxManagerSSLEnabled;
    }

    @Override
    public void setJmxManagerSSLEnabled(boolean value2) {
        this.jmxManagerSSLEnabled = value2;
    }

    @Override
    public boolean getJmxManagerSSLRequireAuthentication() {
        return this.jmxManagerSslRequireAuthentication;
    }

    @Override
    public void setJmxManagerSSLRequireAuthentication(boolean jmxManagerSslRequireAuthentication) {
        this.jmxManagerSslRequireAuthentication = jmxManagerSslRequireAuthentication;
    }

    @Override
    public String getJmxManagerSSLProtocols() {
        return this.jmxManagerSslProtocols;
    }

    @Override
    public void setJmxManagerSSLProtocols(String protocols) {
        this.jmxManagerSslProtocols = protocols;
    }

    @Override
    public String getJmxManagerSSLCiphers() {
        return this.jmxManagerSslCiphers;
    }

    @Override
    public void setJmxManagerSSLCiphers(String ciphers) {
        this.jmxManagerSslCiphers = ciphers;
    }

    @Override
    public void setJmxManagerSSLKeyStore(String value2) {
        this.checkJmxManagerSSLKeyStore(value2);
        this.getJmxSSLProperties().setProperty("javax.net.ssl.keyStore", value2);
        this.jmxManagerSSLKeyStore = value2;
    }

    @Override
    public void setJmxManagerSSLKeyStoreType(String value2) {
        this.checkJmxManagerSSLKeyStoreType(value2);
        this.getJmxSSLProperties().setProperty("javax.net.ssl.keyStoreType", value2);
        this.jmxManagerSSLKeyStoreType = value2;
    }

    @Override
    public void setJmxManagerSSLKeyStorePassword(String value2) {
        this.checkJmxManagerSSLKeyStorePassword(value2);
        this.getJmxSSLProperties().setProperty("javax.net.ssl.keyStorePassword", value2);
        this.jmxManagerSSLKeyStorePassword = value2;
    }

    @Override
    public void setJmxManagerSSLTrustStore(String value2) {
        this.checkJmxManagerSSLTrustStore(value2);
        this.getJmxSSLProperties().setProperty("javax.net.ssl.trustStore", value2);
        this.jmxManagerSSLTrustStore = value2;
    }

    @Override
    public void setJmxManagerSSLTrustStorePassword(String value2) {
        this.checkJmxManagerSSLTrustStorePassword(value2);
        this.getJmxSSLProperties().setProperty("javax.net.ssl.trustStorePassword", value2);
        this.jmxManagerSSLTrustStorePassword = value2;
    }

    @Override
    public String getJmxManagerSSLKeyStore() {
        return this.jmxManagerSSLKeyStore;
    }

    @Override
    public String getJmxManagerSSLKeyStoreType() {
        return this.jmxManagerSSLKeyStoreType;
    }

    @Override
    public String getJmxManagerSSLKeyStorePassword() {
        return this.jmxManagerSSLKeyStorePassword;
    }

    @Override
    public String getJmxManagerSSLTrustStore() {
        return this.jmxManagerSSLTrustStore;
    }

    @Override
    public String getJmxManagerSSLTrustStorePassword() {
        return this.jmxManagerSSLTrustStorePassword;
    }

    @Override
    public int getJmxManagerPort() {
        return this.jmxManagerPort;
    }

    @Override
    public void setJmxManagerPort(int value2) {
        this.checkJmxManagerPort(value2);
        this.jmxManagerPort = value2;
    }

    @Override
    public String getJmxManagerBindAddress() {
        return this.jmxManagerBindAddress;
    }

    @Override
    public void setJmxManagerBindAddress(String value2) {
        if (value2 == null) {
            value2 = "";
        }
        this.checkJmxManagerBindAddress(value2);
        this.jmxManagerBindAddress = value2;
    }

    @Override
    public String getJmxManagerHostnameForClients() {
        return this.jmxManagerHostnameForClients;
    }

    @Override
    public void setJmxManagerHostnameForClients(String value2) {
        if (value2 == null) {
            value2 = "";
        }
        this.checkJmxManagerHostnameForClients(value2);
        this.jmxManagerHostnameForClients = value2;
    }

    @Override
    public String getJmxManagerPasswordFile() {
        return this.jmxManagerPasswordFile;
    }

    @Override
    public void setJmxManagerPasswordFile(String value2) {
        if (value2 == null) {
            value2 = "";
        }
        this.checkJmxManagerPasswordFile(value2);
        this.jmxManagerPasswordFile = value2;
    }

    @Override
    public String getJmxManagerAccessFile() {
        return this.jmxManagerAccessFile;
    }

    @Override
    public void setJmxManagerAccessFile(String value2) {
        if (value2 == null) {
            value2 = "";
        }
        this.checkJmxManagerAccessFile(value2);
        this.jmxManagerAccessFile = value2;
    }

    @Override
    public int getJmxManagerHttpPort() {
        return this.getHttpServicePort();
    }

    @Override
    public void setJmxManagerHttpPort(int value2) {
        this.setHttpServicePort(value2);
    }

    @Override
    public int getJmxManagerUpdateRate() {
        return this.jmxManagerUpdateRate;
    }

    @Override
    public void setJmxManagerUpdateRate(int value2) {
        this.checkJmxManagerUpdateRate(value2);
        this.jmxManagerUpdateRate = value2;
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DistributionConfigImpl other = (DistributionConfigImpl)obj;
        if (this.ackForceDisconnectThreshold != other.ackForceDisconnectThreshold) {
            return false;
        }
        if (this.ackWaitThreshold != other.ackWaitThreshold) {
            return false;
        }
        if (this.archiveDiskSpaceLimit != other.archiveDiskSpaceLimit) {
            return false;
        }
        if (this.archiveFileSizeLimit != other.archiveFileSizeLimit) {
            return false;
        }
        if (this.asyncDistributionTimeout != other.asyncDistributionTimeout) {
            return false;
        }
        if (this.asyncMaxQueueSize != other.asyncMaxQueueSize) {
            return false;
        }
        if (this.asyncQueueTimeout != other.asyncQueueTimeout) {
            return false;
        }
        if (this.bindAddress == null ? other.bindAddress != null : !this.bindAddress.equals(other.bindAddress)) {
            return false;
        }
        if (this.cacheXmlFile == null ? other.cacheXmlFile != null : !this.cacheXmlFile.equals(other.cacheXmlFile)) {
            return false;
        }
        if (this.clientConflation == null ? other.clientConflation != null : !this.clientConflation.equals(other.clientConflation)) {
            return false;
        }
        if (this.clusterSSLCiphers == null ? other.clusterSSLCiphers != null : !this.clusterSSLCiphers.equals(other.clusterSSLCiphers)) {
            return false;
        }
        if (this.clusterSSLEnabled != other.clusterSSLEnabled) {
            return false;
        }
        if (this.clusterSSLKeyStore == null ? other.clusterSSLKeyStore != null : !this.clusterSSLKeyStore.equals(other.clusterSSLKeyStore)) {
            return false;
        }
        if (this.clusterSSLKeyStorePassword == null ? other.clusterSSLKeyStorePassword != null : !this.clusterSSLKeyStorePassword.equals(other.clusterSSLKeyStorePassword)) {
            return false;
        }
        if (this.clusterSSLKeyStoreType == null ? other.clusterSSLKeyStoreType != null : !this.clusterSSLKeyStoreType.equals(other.clusterSSLKeyStoreType)) {
            return false;
        }
        if (this.clusterSSLProperties == null ? other.clusterSSLProperties != null : !this.clusterSSLProperties.equals(other.clusterSSLProperties)) {
            return false;
        }
        if (this.clusterSSLProtocols == null ? other.clusterSSLProtocols != null : !this.clusterSSLProtocols.equals(other.clusterSSLProtocols)) {
            return false;
        }
        if (this.clusterSSLRequireAuthentication != other.clusterSSLRequireAuthentication) {
            return false;
        }
        if (this.clusterSSLTrustStore == null ? other.clusterSSLTrustStore != null : !this.clusterSSLTrustStore.equals(other.clusterSSLTrustStore)) {
            return false;
        }
        if (this.clusterSSLTrustStorePassword == null ? other.clusterSSLTrustStorePassword != null : !this.clusterSSLTrustStorePassword.equals(other.clusterSSLTrustStorePassword)) {
            return false;
        }
        if (this.conserveSockets != other.conserveSockets) {
            return false;
        }
        if (this.deltaPropagation != other.deltaPropagation) {
            return false;
        }
        if (this.deployWorkingDir == null ? other.deployWorkingDir != null : !this.deployWorkingDir.equals(other.deployWorkingDir)) {
            return false;
        }
        if (this.disableAutoReconnect != other.disableAutoReconnect) {
            return false;
        }
        if (this.disableTcp != other.disableTcp) {
            return false;
        }
        if (this.distributedSystemId != other.distributedSystemId) {
            return false;
        }
        if (this.durableClientId == null ? other.durableClientId != null : !this.durableClientId.equals(other.durableClientId)) {
            return false;
        }
        if (this.durableClientTimeout != other.durableClientTimeout) {
            return false;
        }
        if (this.enableNetworkPartitionDetection != other.enableNetworkPartitionDetection) {
            return false;
        }
        if (this.enableSharedConfiguration != other.enableSharedConfiguration) {
            return false;
        }
        if (this.enableTimeStatistics != other.enableTimeStatistics) {
            return false;
        }
        if (this.enforceUniqueHost != other.enforceUniqueHost) {
            return false;
        }
        if (this.gatewaySSLEnabled != other.gatewaySSLEnabled) {
            return false;
        }
        if (this.gatewaySSLKeyStore == null ? other.gatewaySSLKeyStore != null : !this.gatewaySSLKeyStore.equals(other.gatewaySSLKeyStore)) {
            return false;
        }
        if (this.gatewaySSLKeyStorePassword == null ? other.gatewaySSLKeyStorePassword != null : !this.gatewaySSLKeyStorePassword.equals(other.gatewaySSLKeyStorePassword)) {
            return false;
        }
        if (this.gatewaySSLKeyStoreType == null ? other.gatewaySSLKeyStoreType != null : !this.gatewaySSLKeyStoreType.equals(other.gatewaySSLKeyStoreType)) {
            return false;
        }
        if (this.gatewaySSLTrustStore == null ? other.gatewaySSLTrustStore != null : !this.gatewaySSLTrustStore.equals(other.gatewaySSLTrustStore)) {
            return false;
        }
        if (this.gatewaySSLTrustStorePassword == null ? other.gatewaySSLTrustStorePassword != null : !this.gatewaySSLTrustStorePassword.equals(other.gatewaySSLTrustStorePassword)) {
            return false;
        }
        if (this.gatewaySslCiphers == null ? other.gatewaySslCiphers != null : !this.gatewaySslCiphers.equals(other.gatewaySslCiphers)) {
            return false;
        }
        if (this.gatewaySslProperties == null ? other.gatewaySslProperties != null : !this.gatewaySslProperties.equals(other.gatewaySslProperties)) {
            return false;
        }
        if (this.gatewaySslProtocols == null ? other.gatewaySslProtocols != null : !this.gatewaySslProtocols.equals(other.gatewaySslProtocols)) {
            return false;
        }
        if (this.gatewaySslRequireAuthentication != other.gatewaySslRequireAuthentication) {
            return false;
        }
        if (this.groups == null ? other.groups != null : !this.groups.equals(other.groups)) {
            return false;
        }
        if (this.httpServiceBindAddress == null ? other.httpServiceBindAddress != null : !this.httpServiceBindAddress.equals(other.httpServiceBindAddress)) {
            return false;
        }
        if (this.httpServicePort != other.httpServicePort) {
            return false;
        }
        if (this.jmxManager != other.jmxManager) {
            return false;
        }
        if (this.jmxManagerAccessFile == null ? other.jmxManagerAccessFile != null : !this.jmxManagerAccessFile.equals(other.jmxManagerAccessFile)) {
            return false;
        }
        if (this.jmxManagerBindAddress == null ? other.jmxManagerBindAddress != null : !this.jmxManagerBindAddress.equals(other.jmxManagerBindAddress)) {
            return false;
        }
        if (this.jmxManagerHostnameForClients == null ? other.jmxManagerHostnameForClients != null : !this.jmxManagerHostnameForClients.equals(other.jmxManagerHostnameForClients)) {
            return false;
        }
        if (this.jmxManagerHttpPort != other.jmxManagerHttpPort) {
            return false;
        }
        if (this.jmxManagerPasswordFile == null ? other.jmxManagerPasswordFile != null : !this.jmxManagerPasswordFile.equals(other.jmxManagerPasswordFile)) {
            return false;
        }
        if (this.jmxManagerPort != other.jmxManagerPort) {
            return false;
        }
        if (this.jmxManagerSSL != other.jmxManagerSSL) {
            return false;
        }
        if (this.jmxManagerSSLEnabled != other.jmxManagerSSLEnabled) {
            return false;
        }
        if (this.jmxManagerSSLKeyStore == null ? other.jmxManagerSSLKeyStore != null : !this.jmxManagerSSLKeyStore.equals(other.jmxManagerSSLKeyStore)) {
            return false;
        }
        if (this.jmxManagerSSLKeyStorePassword == null ? other.jmxManagerSSLKeyStorePassword != null : !this.jmxManagerSSLKeyStorePassword.equals(other.jmxManagerSSLKeyStorePassword)) {
            return false;
        }
        if (this.jmxManagerSSLKeyStoreType == null ? other.jmxManagerSSLKeyStoreType != null : !this.jmxManagerSSLKeyStoreType.equals(other.jmxManagerSSLKeyStoreType)) {
            return false;
        }
        if (this.jmxManagerSSLTrustStore == null ? other.jmxManagerSSLTrustStore != null : !this.jmxManagerSSLTrustStore.equals(other.jmxManagerSSLTrustStore)) {
            return false;
        }
        if (this.jmxManagerSSLTrustStorePassword == null ? other.jmxManagerSSLTrustStorePassword != null : !this.jmxManagerSSLTrustStorePassword.equals(other.jmxManagerSSLTrustStorePassword)) {
            return false;
        }
        if (this.jmxManagerSslCiphers == null ? other.jmxManagerSslCiphers != null : !this.jmxManagerSslCiphers.equals(other.jmxManagerSslCiphers)) {
            return false;
        }
        if (this.jmxManagerSslProperties == null ? other.jmxManagerSslProperties != null : !this.jmxManagerSslProperties.equals(other.jmxManagerSslProperties)) {
            return false;
        }
        if (this.jmxManagerSslProtocols == null ? other.jmxManagerSslProtocols != null : !this.jmxManagerSslProtocols.equals(other.jmxManagerSslProtocols)) {
            return false;
        }
        if (this.jmxManagerSslRequireAuthentication != other.jmxManagerSslRequireAuthentication) {
            return false;
        }
        if (this.jmxManagerStart != other.jmxManagerStart) {
            return false;
        }
        if (this.jmxManagerUpdateRate != other.jmxManagerUpdateRate) {
            return false;
        }
        if (this.licenseApplicationCache == null ? other.licenseApplicationCache != null : !this.licenseApplicationCache.equals(other.licenseApplicationCache)) {
            return false;
        }
        if (this.licenseDataManagement == null ? other.licenseDataManagement != null : !this.licenseDataManagement.equals(other.licenseDataManagement)) {
            return false;
        }
        if (this.licenseServerTimeout != other.licenseServerTimeout) {
            return false;
        }
        if (this.licenseWorkingDir == null ? other.licenseWorkingDir != null : !this.licenseWorkingDir.equals(other.licenseWorkingDir)) {
            return false;
        }
        if (this.loadSharedConfigurationFromDir != other.loadSharedConfigurationFromDir) {
            return false;
        }
        if (this.locators == null ? other.locators != null : !this.locators.equals(other.locators)) {
            return false;
        }
        if (this.locatorWaitTime != other.locatorWaitTime) {
            return false;
        }
        if (this.logDiskSpaceLimit != other.logDiskSpaceLimit) {
            return false;
        }
        if (this.logFile == null ? other.logFile != null : !this.logFile.equals(other.logFile)) {
            return false;
        }
        if (this.logFileSizeLimit != other.logFileSizeLimit) {
            return false;
        }
        if (this.logLevel != other.logLevel) {
            return false;
        }
        if (this.maxNumReconnectTries != other.maxNumReconnectTries) {
            return false;
        }
        if (this.maxWaitTimeForReconnect != other.maxWaitTimeForReconnect) {
            return false;
        }
        if (this.mcastAddress == null ? other.mcastAddress != null : !this.mcastAddress.equals(other.mcastAddress)) {
            return false;
        }
        if (this.mcastFlowControl == null ? other.mcastFlowControl != null : !this.mcastFlowControl.equals(other.mcastFlowControl)) {
            return false;
        }
        if (this.mcastPort != other.mcastPort) {
            return false;
        }
        if (this.mcastRecvBufferSize != other.mcastRecvBufferSize) {
            return false;
        }
        if (this.mcastSendBufferSize != other.mcastSendBufferSize) {
            return false;
        }
        if (this.mcastTtl != other.mcastTtl) {
            return false;
        }
        if (this.memberTimeout != other.memberTimeout) {
            return false;
        }
        if (!Arrays.equals(this.membershipPortRange, other.membershipPortRange)) {
            return false;
        }
        if (this.memcachedPort != other.memcachedPort) {
            return false;
        }
        if (this.memcachedProtocol == null ? other.memcachedProtocol != null : !this.memcachedProtocol.equals(other.memcachedProtocol)) {
            return false;
        }
        if (this.modifiable != other.modifiable) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.props == null ? other.props != null : !this.props.equals(other.props)) {
            return false;
        }
        if (this.redundancyZone == null ? other.redundancyZone != null : !this.redundancyZone.equals(other.redundancyZone)) {
            return false;
        }
        if (this.remoteLocators == null ? other.remoteLocators != null : !this.remoteLocators.equals(other.remoteLocators)) {
            return false;
        }
        if (this.removeUnresponsiveClient != other.removeUnresponsiveClient) {
            return false;
        }
        if (this.roles == null ? other.roles != null : !this.roles.equals(other.roles)) {
            return false;
        }
        if (this.security == null ? other.security != null : !this.security.equals(other.security)) {
            return false;
        }
        if (this.securityClientAccessor == null ? other.securityClientAccessor != null : !this.securityClientAccessor.equals(other.securityClientAccessor)) {
            return false;
        }
        if (this.securityClientAccessorPP == null ? other.securityClientAccessorPP != null : !this.securityClientAccessorPP.equals(other.securityClientAccessorPP)) {
            return false;
        }
        if (this.securityClientAuthInit == null ? other.securityClientAuthInit != null : !this.securityClientAuthInit.equals(other.securityClientAuthInit)) {
            return false;
        }
        if (this.securityClientAuthenticator == null ? other.securityClientAuthenticator != null : !this.securityClientAuthenticator.equals(other.securityClientAuthenticator)) {
            return false;
        }
        if (this.securityClientDHAlgo == null ? other.securityClientDHAlgo != null : !this.securityClientDHAlgo.equals(other.securityClientDHAlgo)) {
            return false;
        }
        if (this.securityLogFile == null ? other.securityLogFile != null : !this.securityLogFile.equals(other.securityLogFile)) {
            return false;
        }
        if (this.securityLogLevel != other.securityLogLevel) {
            return false;
        }
        if (this.securityPeerAuthInit == null ? other.securityPeerAuthInit != null : !this.securityPeerAuthInit.equals(other.securityPeerAuthInit)) {
            return false;
        }
        if (this.securityPeerAuthenticator == null ? other.securityPeerAuthenticator != null : !this.securityPeerAuthenticator.equals(other.securityPeerAuthenticator)) {
            return false;
        }
        if (this.securityPeerMembershipTimeout != other.securityPeerMembershipTimeout) {
            return false;
        }
        if (this.serverBindAddress == null ? other.serverBindAddress != null : !this.serverBindAddress.equals(other.serverBindAddress)) {
            return false;
        }
        if (this.serverSSLEnabled != other.serverSSLEnabled) {
            return false;
        }
        if (this.serverSSLKeyStore == null ? other.serverSSLKeyStore != null : !this.serverSSLKeyStore.equals(other.serverSSLKeyStore)) {
            return false;
        }
        if (this.serverSSLKeyStorePassword == null ? other.serverSSLKeyStorePassword != null : !this.serverSSLKeyStorePassword.equals(other.serverSSLKeyStorePassword)) {
            return false;
        }
        if (this.serverSSLKeyStoreType == null ? other.serverSSLKeyStoreType != null : !this.serverSSLKeyStoreType.equals(other.serverSSLKeyStoreType)) {
            return false;
        }
        if (this.serverSSLTrustStore == null ? other.serverSSLTrustStore != null : !this.serverSSLTrustStore.equals(other.serverSSLTrustStore)) {
            return false;
        }
        if (this.serverSSLTrustStorePassword == null ? other.serverSSLTrustStorePassword != null : !this.serverSSLTrustStorePassword.equals(other.serverSSLTrustStorePassword)) {
            return false;
        }
        if (this.serverSslCiphers == null ? other.serverSslCiphers != null : !this.serverSslCiphers.equals(other.serverSslCiphers)) {
            return false;
        }
        if (this.serverSslProperties == null ? other.serverSslProperties != null : !this.serverSslProperties.equals(other.serverSslProperties)) {
            return false;
        }
        if (this.serverSslProtocols == null ? other.serverSslProtocols != null : !this.serverSslProtocols.equals(other.serverSslProtocols)) {
            return false;
        }
        if (this.serverSslRequireAuthentication != other.serverSslRequireAuthentication) {
            return false;
        }
        if (this.socketBufferSize != other.socketBufferSize) {
            return false;
        }
        if (this.socketLeaseTime != other.socketLeaseTime) {
            return false;
        }
        if (this.sourceMap == null ? other.sourceMap != null : !this.sourceMap.equals(other.sourceMap)) {
            return false;
        }
        if (this.sslCiphers == null ? other.sslCiphers != null : !this.sslCiphers.equals(other.sslCiphers)) {
            return false;
        }
        if (this.sslEnabled != other.sslEnabled) {
            return false;
        }
        if (this.sslProperties == null ? other.sslProperties != null : !this.sslProperties.equals(other.sslProperties)) {
            return false;
        }
        if (this.sslProtocols == null ? other.sslProtocols != null : !this.sslProtocols.equals(other.sslProtocols)) {
            return false;
        }
        if (this.sslRequireAuthentication != other.sslRequireAuthentication) {
            return false;
        }
        if (this.startDevRestApi != other.startDevRestApi) {
            return false;
        }
        if (this.startLocator == null ? other.startLocator != null : !this.startLocator.equals(other.startLocator)) {
            return false;
        }
        if (this.startLocatorPort != other.startLocatorPort) {
            return false;
        }
        if (this.statisticArchiveFile == null ? other.statisticArchiveFile != null : !this.statisticArchiveFile.equals(other.statisticArchiveFile)) {
            return false;
        }
        if (this.statisticSampleRate != other.statisticSampleRate) {
            return false;
        }
        if (this.statisticSamplingEnabled != other.statisticSamplingEnabled) {
            return false;
        }
        if (this.tcpPort != other.tcpPort) {
            return false;
        }
        if (this.udpFragmentSize != other.udpFragmentSize) {
            return false;
        }
        if (this.udpRecvBufferSize != other.udpRecvBufferSize) {
            return false;
        }
        if (this.udpSendBufferSize != other.udpSendBufferSize) {
            return false;
        }
        if (this.useSharedConfiguration != other.useSharedConfiguration) {
            return false;
        }
        if (this.userCommandPackages == null ? other.userCommandPackages != null : !this.userCommandPackages.equals(other.userCommandPackages)) {
            return false;
        }
        if (this.userDefinedProps == null ? other.userDefinedProps != null : !this.userDefinedProps.equals(other.userDefinedProps)) {
            return false;
        }
        return !(this.writableWorkingDir == null ? other.writableWorkingDir != null : !this.writableWorkingDir.equals(other.writableWorkingDir));
    }

    public final int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.ackForceDisconnectThreshold;
        result = 31 * result + this.ackWaitThreshold;
        result = 31 * result + this.archiveDiskSpaceLimit;
        result = 31 * result + this.archiveFileSizeLimit;
        result = 31 * result + this.asyncDistributionTimeout;
        result = 31 * result + this.asyncMaxQueueSize;
        result = 31 * result + this.asyncQueueTimeout;
        result = 31 * result + (this.bindAddress == null ? 0 : this.bindAddress.hashCode());
        result = 31 * result + (this.cacheXmlFile == null ? 0 : this.cacheXmlFile.hashCode());
        result = 31 * result + (this.clientConflation == null ? 0 : this.clientConflation.hashCode());
        result = 31 * result + (this.clusterSSLCiphers == null ? 0 : this.clusterSSLCiphers.hashCode());
        result = 31 * result + (this.clusterSSLEnabled ? 1231 : 1237);
        result = 31 * result + (this.clusterSSLKeyStore == null ? 0 : this.clusterSSLKeyStore.hashCode());
        result = 31 * result + (this.clusterSSLKeyStorePassword == null ? 0 : this.clusterSSLKeyStorePassword.hashCode());
        result = 31 * result + (this.clusterSSLKeyStoreType == null ? 0 : this.clusterSSLKeyStoreType.hashCode());
        result = 31 * result + (this.clusterSSLProperties == null ? 0 : this.clusterSSLProperties.hashCode());
        result = 31 * result + (this.clusterSSLProtocols == null ? 0 : this.clusterSSLProtocols.hashCode());
        result = 31 * result + (this.clusterSSLRequireAuthentication ? 1231 : 1237);
        result = 31 * result + (this.clusterSSLTrustStore == null ? 0 : this.clusterSSLTrustStore.hashCode());
        result = 31 * result + (this.clusterSSLTrustStorePassword == null ? 0 : this.clusterSSLTrustStorePassword.hashCode());
        result = 31 * result + (this.conserveSockets ? 1231 : 1237);
        result = 31 * result + (this.deltaPropagation ? 1231 : 1237);
        result = 31 * result + (this.deployWorkingDir == null ? 0 : this.deployWorkingDir.hashCode());
        result = 31 * result + (this.disableAutoReconnect ? 1231 : 1237);
        result = 31 * result + (this.disableTcp ? 1231 : 1237);
        result = 31 * result + this.distributedSystemId;
        result = 31 * result + (this.durableClientId == null ? 0 : this.durableClientId.hashCode());
        result = 31 * result + this.durableClientTimeout;
        result = 31 * result + (this.enableNetworkPartitionDetection ? 1231 : 1237);
        result = 31 * result + (this.enableSharedConfiguration ? 1231 : 1237);
        result = 31 * result + (this.enableTimeStatistics ? 1231 : 1237);
        result = 31 * result + (this.enforceUniqueHost ? 1231 : 1237);
        result = 31 * result + (this.gatewaySSLEnabled ? 1231 : 1237);
        result = 31 * result + (this.gatewaySSLKeyStore == null ? 0 : this.gatewaySSLKeyStore.hashCode());
        result = 31 * result + (this.gatewaySSLKeyStorePassword == null ? 0 : this.gatewaySSLKeyStorePassword.hashCode());
        result = 31 * result + (this.gatewaySSLKeyStoreType == null ? 0 : this.gatewaySSLKeyStoreType.hashCode());
        result = 31 * result + (this.gatewaySSLTrustStore == null ? 0 : this.gatewaySSLTrustStore.hashCode());
        result = 31 * result + (this.gatewaySSLTrustStorePassword == null ? 0 : this.gatewaySSLTrustStorePassword.hashCode());
        result = 31 * result + (this.gatewaySslCiphers == null ? 0 : this.gatewaySslCiphers.hashCode());
        result = 31 * result + (this.gatewaySslProperties == null ? 0 : this.gatewaySslProperties.hashCode());
        result = 31 * result + (this.gatewaySslProtocols == null ? 0 : this.gatewaySslProtocols.hashCode());
        result = 31 * result + (this.gatewaySslRequireAuthentication ? 1231 : 1237);
        result = 31 * result + (this.groups == null ? 0 : this.groups.hashCode());
        result = 31 * result + (this.httpServiceBindAddress == null ? 0 : this.httpServiceBindAddress.hashCode());
        result = 31 * result + this.httpServicePort;
        result = 31 * result + (this.jmxManager ? 1231 : 1237);
        result = 31 * result + (this.jmxManagerAccessFile == null ? 0 : this.jmxManagerAccessFile.hashCode());
        result = 31 * result + (this.jmxManagerBindAddress == null ? 0 : this.jmxManagerBindAddress.hashCode());
        result = 31 * result + (this.jmxManagerHostnameForClients == null ? 0 : this.jmxManagerHostnameForClients.hashCode());
        result = 31 * result + this.jmxManagerHttpPort;
        result = 31 * result + (this.jmxManagerPasswordFile == null ? 0 : this.jmxManagerPasswordFile.hashCode());
        result = 31 * result + this.jmxManagerPort;
        result = 31 * result + (this.jmxManagerSSL ? 1231 : 1237);
        result = 31 * result + (this.jmxManagerSSLEnabled ? 1231 : 1237);
        result = 31 * result + (this.jmxManagerSSLKeyStore == null ? 0 : this.jmxManagerSSLKeyStore.hashCode());
        result = 31 * result + (this.jmxManagerSSLKeyStorePassword == null ? 0 : this.jmxManagerSSLKeyStorePassword.hashCode());
        result = 31 * result + (this.jmxManagerSSLKeyStoreType == null ? 0 : this.jmxManagerSSLKeyStoreType.hashCode());
        result = 31 * result + (this.jmxManagerSSLTrustStore == null ? 0 : this.jmxManagerSSLTrustStore.hashCode());
        result = 31 * result + (this.jmxManagerSSLTrustStorePassword == null ? 0 : this.jmxManagerSSLTrustStorePassword.hashCode());
        result = 31 * result + (this.jmxManagerSslCiphers == null ? 0 : this.jmxManagerSslCiphers.hashCode());
        result = 31 * result + (this.jmxManagerSslProperties == null ? 0 : this.jmxManagerSslProperties.hashCode());
        result = 31 * result + (this.jmxManagerSslProtocols == null ? 0 : this.jmxManagerSslProtocols.hashCode());
        result = 31 * result + (this.jmxManagerSslRequireAuthentication ? 1231 : 1237);
        result = 31 * result + (this.jmxManagerStart ? 1231 : 1237);
        result = 31 * result + this.jmxManagerUpdateRate;
        result = 31 * result + (this.licenseApplicationCache == null ? 0 : this.licenseApplicationCache.hashCode());
        result = 31 * result + (this.licenseDataManagement == null ? 0 : this.licenseDataManagement.hashCode());
        result = 31 * result + this.licenseServerTimeout;
        result = 31 * result + (this.licenseWorkingDir == null ? 0 : this.licenseWorkingDir.hashCode());
        result = 31 * result + (this.loadSharedConfigurationFromDir ? 1231 : 1237);
        result = 31 * result + (this.locators == null ? 0 : this.locators.hashCode());
        result = 31 * result + this.logDiskSpaceLimit;
        result = 31 * result + (this.logFile == null ? 0 : this.logFile.hashCode());
        result = 31 * result + this.logFileSizeLimit;
        result = 31 * result + this.logLevel;
        result = 31 * result + this.maxNumReconnectTries;
        result = 31 * result + this.maxWaitTimeForReconnect;
        result = 31 * result + (this.mcastAddress == null ? 0 : this.mcastAddress.hashCode());
        result = 31 * result + (this.mcastFlowControl == null ? 0 : this.mcastFlowControl.hashCode());
        result = 31 * result + this.mcastPort;
        result = 31 * result + this.mcastRecvBufferSize;
        result = 31 * result + this.mcastSendBufferSize;
        result = 31 * result + this.mcastTtl;
        result = 31 * result + this.memberTimeout;
        result = 31 * result + Arrays.hashCode(this.membershipPortRange);
        result = 31 * result + this.memcachedPort;
        result = 31 * result + (this.memcachedProtocol == null ? 0 : this.memcachedProtocol.hashCode());
        result = 31 * result + (this.modifiable ? 1231 : 1237);
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.props == null ? 0 : this.props.hashCode());
        result = 31 * result + (this.redundancyZone == null ? 0 : this.redundancyZone.hashCode());
        result = 31 * result + (this.remoteLocators == null ? 0 : this.remoteLocators.hashCode());
        result = 31 * result + (this.removeUnresponsiveClient ? 1231 : 1237);
        result = 31 * result + (this.roles == null ? 0 : this.roles.hashCode());
        result = 31 * result + (this.security == null ? 0 : this.security.hashCode());
        result = 31 * result + (this.securityClientAccessor == null ? 0 : this.securityClientAccessor.hashCode());
        result = 31 * result + (this.securityClientAccessorPP == null ? 0 : this.securityClientAccessorPP.hashCode());
        result = 31 * result + (this.securityClientAuthInit == null ? 0 : this.securityClientAuthInit.hashCode());
        result = 31 * result + (this.securityClientAuthenticator == null ? 0 : this.securityClientAuthenticator.hashCode());
        result = 31 * result + (this.securityClientDHAlgo == null ? 0 : this.securityClientDHAlgo.hashCode());
        result = 31 * result + (this.securityLogFile == null ? 0 : this.securityLogFile.hashCode());
        result = 31 * result + this.securityLogLevel;
        result = 31 * result + (this.securityPeerAuthInit == null ? 0 : this.securityPeerAuthInit.hashCode());
        result = 31 * result + (this.securityPeerAuthenticator == null ? 0 : this.securityPeerAuthenticator.hashCode());
        result = 31 * result + this.securityPeerMembershipTimeout;
        result = 31 * result + (this.serverBindAddress == null ? 0 : this.serverBindAddress.hashCode());
        result = 31 * result + (this.serverSSLEnabled ? 1231 : 1237);
        result = 31 * result + (this.serverSSLKeyStore == null ? 0 : this.serverSSLKeyStore.hashCode());
        result = 31 * result + (this.serverSSLKeyStorePassword == null ? 0 : this.serverSSLKeyStorePassword.hashCode());
        result = 31 * result + (this.serverSSLKeyStoreType == null ? 0 : this.serverSSLKeyStoreType.hashCode());
        result = 31 * result + (this.serverSSLTrustStore == null ? 0 : this.serverSSLTrustStore.hashCode());
        result = 31 * result + (this.serverSSLTrustStorePassword == null ? 0 : this.serverSSLTrustStorePassword.hashCode());
        result = 31 * result + (this.serverSslCiphers == null ? 0 : this.serverSslCiphers.hashCode());
        result = 31 * result + (this.serverSslProperties == null ? 0 : this.serverSslProperties.hashCode());
        result = 31 * result + (this.serverSslProtocols == null ? 0 : this.serverSslProtocols.hashCode());
        result = 31 * result + (this.serverSslRequireAuthentication ? 1231 : 1237);
        result = 31 * result + this.socketBufferSize;
        result = 31 * result + this.socketLeaseTime;
        result = 31 * result + (this.sourceMap == null ? 0 : this.sourceMap.hashCode());
        result = 31 * result + (this.sslCiphers == null ? 0 : this.sslCiphers.hashCode());
        result = 31 * result + (this.sslEnabled ? 1231 : 1237);
        result = 31 * result + (this.sslProperties == null ? 0 : this.sslProperties.hashCode());
        result = 31 * result + (this.sslProtocols == null ? 0 : this.sslProtocols.hashCode());
        result = 31 * result + (this.sslRequireAuthentication ? 1231 : 1237);
        result = 31 * result + (this.startDevRestApi ? 1231 : 1237);
        result = 31 * result + (this.startLocator == null ? 0 : this.startLocator.hashCode());
        result = 31 * result + this.startLocatorPort;
        result = 31 * result + (this.statisticArchiveFile == null ? 0 : this.statisticArchiveFile.hashCode());
        result = 31 * result + this.statisticSampleRate;
        result = 31 * result + (this.statisticSamplingEnabled ? 1231 : 1237);
        result = 31 * result + this.tcpPort;
        result = 31 * result + this.udpFragmentSize;
        result = 31 * result + this.udpRecvBufferSize;
        result = 31 * result + this.udpSendBufferSize;
        result = 31 * result + (this.useSharedConfiguration ? 1231 : 1237);
        result = 31 * result + (this.userCommandPackages == null ? 0 : this.userCommandPackages.hashCode());
        result = 31 * result + (this.userDefinedProps == null ? 0 : this.userDefinedProps.hashCode());
        result = 31 * result + (this.writableWorkingDir == null ? 0 : this.writableWorkingDir.hashCode());
        return result;
    }

    public static void main(String[] args) throws IOException {
        DistributionConfigImpl cfg = new DistributionConfigImpl();
        String fileName = "gemfire.properties";
        if (args != null && args.length > 0) {
            String temp = args[0].trim();
            fileName = "".equals(temp) ? fileName : temp;
        }
        cfg.toFile(new File(fileName));
    }

    public void checkForDisallowedDefaults() {
        if (Boolean.getBoolean("gemfire.disallowMcastDefaults") && this.getMcastPort() != 0 && this.getMcastAddress().equals(DistributionConfig.DEFAULT_MCAST_ADDRESS) && this.getMcastPort() == 10334) {
            throw new IllegalStateException("gemfire.disallowMcastDefaults set and default address and port are being used");
        }
    }

    @Override
    public int[] getMembershipPortRange() {
        return this.membershipPortRange;
    }

    @Override
    public void setMembershipPortRange(int[] range) {
        this.checkMembershipPortRange(range);
        this.membershipPortRange = range;
    }

    @Override
    public void setRemoteLocators(String value2) {
        this.remoteLocators = this.checkRemoteLocators(value2);
    }

    @Override
    public String getRemoteLocators() {
        return this.remoteLocators;
    }

    public Map getProps() {
        return this.props;
    }

    @Override
    public int getMemcachedPort() {
        return this.memcachedPort;
    }

    @Override
    public void setMemcachedPort(int value2) {
        this.checkMemcachedPort(value2);
        this.memcachedPort = value2;
    }

    @Override
    public String getMemcachedProtocol() {
        return this.memcachedProtocol;
    }

    @Override
    public void setMemcachedProtocol(String protocol) {
        this.checkMemcachedProtocol(protocol);
        this.memcachedProtocol = protocol;
    }

    @Override
    public String getMemcachedBindAddress() {
        return this.memcachedBindAddress;
    }

    @Override
    public void setMemcachedBindAddress(String bindAddress) {
        this.checkMemcachedBindAddress(bindAddress);
        this.memcachedBindAddress = bindAddress;
    }

    @Override
    public void setEnableClusterConfiguration(boolean value2) {
        this.checkEnableSharedConfiguration();
        this.enableSharedConfiguration = value2;
    }

    @Override
    public boolean getEnableClusterConfiguration() {
        return this.enableSharedConfiguration;
    }

    @Override
    public void setUseSharedConfiguration(boolean newValue) {
        this.checkUseSharedConfiguration();
        this.useSharedConfiguration = newValue;
    }

    @Override
    public boolean getUseSharedConfiguration() {
        return this.useSharedConfiguration;
    }

    @Override
    public void setLoadClusterConfigFromDir(boolean newValue) {
        this.checkLoadSharedConfigFromDir();
        this.loadSharedConfigurationFromDir = newValue;
    }

    @Override
    public boolean getLoadClusterConfigFromDir() {
        return this.loadSharedConfigurationFromDir;
    }

    @Override
    public void setClusterConfigDir(String clusterConfigDir) {
        this.checkClusterConfigDir();
        this.clusterConfigDir = clusterConfigDir;
    }

    @Override
    public String getClusterConfigDir() {
        return this.clusterConfigDir;
    }

    @Override
    public boolean getServerSSLEnabled() {
        return this.serverSSLEnabled;
    }

    @Override
    public void setServerSSLEnabled(boolean value2) {
        this.checkServerSSLEnabled();
        this.serverSSLEnabled = value2;
    }

    @Override
    public boolean getServerSSLRequireAuthentication() {
        return this.serverSslRequireAuthentication;
    }

    @Override
    public void setServerSSLRequireAuthentication(boolean value2) {
        this.checkServerSSLRequireAuthentication();
        this.serverSslRequireAuthentication = value2;
    }

    @Override
    public String getServerSSLProtocols() {
        return this.serverSslProtocols;
    }

    @Override
    public void setServerSSLProtocols(String protocols) {
        this.checkServerSSLProtocols();
        this.serverSslProtocols = protocols;
    }

    @Override
    public String getServerSSLCiphers() {
        return this.serverSslCiphers;
    }

    @Override
    public void setServerSSLCiphers(String ciphers) {
        this.checkServerSSLCiphers();
        this.serverSslCiphers = ciphers;
    }

    @Override
    public void setServerSSLKeyStore(String value2) {
        this.checkServerSSLKeyStore(value2);
        this.getServerSSLProperties().setProperty("javax.net.ssl.keyStore", value2);
        this.serverSSLKeyStore = value2;
    }

    @Override
    public void setServerSSLKeyStoreType(String value2) {
        this.checkServerSSLKeyStoreType(value2);
        this.getServerSSLProperties().setProperty("javax.net.ssl.keyStoreType", value2);
        this.serverSSLKeyStoreType = value2;
    }

    @Override
    public void setServerSSLKeyStorePassword(String value2) {
        this.checkServerSSLKeyStorePassword(value2);
        this.getServerSSLProperties().setProperty("javax.net.ssl.keyStorePassword", value2);
        this.serverSSLKeyStorePassword = value2;
    }

    @Override
    public void setServerSSLTrustStore(String value2) {
        this.checkServerSSLTrustStore(value2);
        this.getServerSSLProperties().setProperty("javax.net.ssl.trustStore", value2);
        this.serverSSLTrustStore = value2;
    }

    @Override
    public void setServerSSLTrustStorePassword(String value2) {
        this.checkServerSSLTrustStorePassword(value2);
        this.getServerSSLProperties().setProperty("javax.net.ssl.trustStorePassword", value2);
        this.serverSSLTrustStorePassword = value2;
    }

    @Override
    public String getServerSSLKeyStore() {
        return this.serverSSLKeyStore;
    }

    @Override
    public String getServerSSLKeyStoreType() {
        return this.serverSSLKeyStoreType;
    }

    @Override
    public String getServerSSLKeyStorePassword() {
        return this.serverSSLKeyStorePassword;
    }

    @Override
    public String getServerSSLTrustStore() {
        return this.serverSSLTrustStore;
    }

    @Override
    public String getServerSSLTrustStorePassword() {
        return this.serverSSLTrustStorePassword;
    }

    @Override
    public Properties getServerSSLProperties() {
        return this.serverSslProperties;
    }

    @Override
    public boolean getGatewaySSLEnabled() {
        return this.gatewaySSLEnabled;
    }

    @Override
    public void setGatewaySSLEnabled(boolean value2) {
        this.checkServerSSLEnabled();
        this.gatewaySSLEnabled = value2;
    }

    @Override
    public boolean getGatewaySSLRequireAuthentication() {
        return this.gatewaySslRequireAuthentication;
    }

    @Override
    public void setGatewaySSLRequireAuthentication(boolean value2) {
        this.checkGatewaySSLRequireAuthentication();
        this.gatewaySslRequireAuthentication = value2;
    }

    @Override
    public String getGatewaySSLProtocols() {
        return this.gatewaySslProtocols;
    }

    @Override
    public void setGatewaySSLProtocols(String protocols) {
        this.checkServerSSLProtocols();
        this.gatewaySslProtocols = protocols;
    }

    @Override
    public String getGatewaySSLCiphers() {
        return this.gatewaySslCiphers;
    }

    @Override
    public void setGatewaySSLCiphers(String ciphers) {
        this.checkGatewaySSLCiphers();
        this.gatewaySslCiphers = ciphers;
    }

    @Override
    public void setGatewaySSLKeyStore(String value2) {
        this.checkGatewaySSLKeyStore(value2);
        this.getGatewaySSLProperties().setProperty("javax.net.ssl.keyStore", value2);
        this.gatewaySSLKeyStore = value2;
    }

    @Override
    public void setGatewaySSLKeyStoreType(String value2) {
        this.checkGatewaySSLKeyStoreType(value2);
        this.getGatewaySSLProperties().setProperty("javax.net.ssl.keyStoreType", value2);
        this.gatewaySSLKeyStoreType = value2;
    }

    @Override
    public void setGatewaySSLKeyStorePassword(String value2) {
        this.checkGatewaySSLKeyStorePassword(value2);
        this.getGatewaySSLProperties().setProperty("javax.net.ssl.keyStorePassword", value2);
        this.gatewaySSLKeyStorePassword = value2;
    }

    @Override
    public void setGatewaySSLTrustStore(String value2) {
        this.checkGatewaySSLTrustStore(value2);
        this.getGatewaySSLProperties().setProperty("javax.net.ssl.trustStore", value2);
        this.gatewaySSLTrustStore = value2;
    }

    @Override
    public void setGatewaySSLTrustStorePassword(String value2) {
        this.checkGatewaySSLTrustStorePassword(value2);
        this.getGatewaySSLProperties().setProperty("javax.net.ssl.trustStorePassword", value2);
        this.gatewaySSLTrustStorePassword = value2;
    }

    @Override
    public String getGatewaySSLKeyStore() {
        return this.gatewaySSLKeyStore;
    }

    @Override
    public String getGatewaySSLKeyStoreType() {
        return this.gatewaySSLKeyStoreType;
    }

    @Override
    public String getGatewaySSLKeyStorePassword() {
        return this.gatewaySSLKeyStorePassword;
    }

    @Override
    public String getGatewaySSLTrustStore() {
        return this.gatewaySSLTrustStore;
    }

    @Override
    public String getGatewaySSLTrustStorePassword() {
        return this.gatewaySSLTrustStorePassword;
    }

    @Override
    public Properties getGatewaySSLProperties() {
        return this.gatewaySslProperties;
    }

    @Override
    public boolean getHttpServiceSSLEnabled() {
        return this.httpServiceSSLEnabled;
    }

    @Override
    public void setHttpServiceSSLEnabled(boolean httpServiceSSLEnabled) {
        this.httpServiceSSLEnabled = httpServiceSSLEnabled;
    }

    @Override
    public boolean getHttpServiceSSLRequireAuthentication() {
        return this.httpServiceSSLRequireAuthentication;
    }

    @Override
    public void setHttpServiceSSLRequireAuthentication(boolean httpServiceSSLRequireAuthentication) {
        this.httpServiceSSLRequireAuthentication = httpServiceSSLRequireAuthentication;
    }

    @Override
    public String getHttpServiceSSLProtocols() {
        return this.httpServiceSSLProtocols;
    }

    @Override
    public void setHttpServiceSSLProtocols(String httpServiceSSLProtocols) {
        this.httpServiceSSLProtocols = httpServiceSSLProtocols;
    }

    @Override
    public String getHttpServiceSSLCiphers() {
        return this.httpServiceSSLCiphers;
    }

    @Override
    public void setHttpServiceSSLCiphers(String httpServiceSSLCiphers) {
        this.httpServiceSSLCiphers = httpServiceSSLCiphers;
    }

    @Override
    public String getHttpServiceSSLKeyStore() {
        return this.httpServiceSSLKeyStore;
    }

    @Override
    public void setHttpServiceSSLKeyStore(String httpServiceSSLKeyStore) {
        this.checkHttpServiceSSLKeyStore(httpServiceSSLKeyStore);
        this.getHttpServiceSSLProperties().setProperty("javax.net.ssl.keyStore", httpServiceSSLKeyStore);
        this.httpServiceSSLKeyStore = httpServiceSSLKeyStore;
    }

    @Override
    public String getHttpServiceSSLKeyStoreType() {
        return this.httpServiceSSLKeyStoreType;
    }

    @Override
    public void setHttpServiceSSLKeyStoreType(String httpServiceSSLKeyStoreType) {
        this.checkHttpServiceSSLKeyStoreType(httpServiceSSLKeyStoreType);
        this.getHttpServiceSSLProperties().setProperty("javax.net.ssl.keyStoreType", httpServiceSSLKeyStoreType);
        this.httpServiceSSLKeyStoreType = httpServiceSSLKeyStoreType;
    }

    @Override
    public String getHttpServiceSSLKeyStorePassword() {
        return this.httpServiceSSLKeyStorePassword;
    }

    @Override
    public void setHttpServiceSSLKeyStorePassword(String httpServiceSSLKeyStorePassword) {
        this.checkHttpServiceSSLKeyStorePassword(httpServiceSSLKeyStorePassword);
        this.getHttpServiceSSLProperties().setProperty("javax.net.ssl.keyStorePassword", httpServiceSSLKeyStorePassword);
        this.httpServiceSSLKeyStorePassword = httpServiceSSLKeyStorePassword;
    }

    @Override
    public String getHttpServiceSSLTrustStore() {
        return this.httpServiceSSLTrustStore;
    }

    @Override
    public void setHttpServiceSSLTrustStore(String httpServiceSSLTrustStore) {
        this.checkHttpServiceSSLTrustStore(httpServiceSSLTrustStore);
        this.getHttpServiceSSLProperties().setProperty("javax.net.ssl.trustStore", httpServiceSSLTrustStore);
        this.httpServiceSSLTrustStore = httpServiceSSLTrustStore;
    }

    @Override
    public String getHttpServiceSSLTrustStorePassword() {
        return this.httpServiceSSLTrustStorePassword;
    }

    @Override
    public void setHttpServiceSSLTrustStorePassword(String httpServiceSSLTrustStorePassword) {
        this.checkHttpServiceSSLTrustStorePassword(httpServiceSSLTrustStorePassword);
        this.getHttpServiceSSLProperties().setProperty("javax.net.ssl.trustStorePassword", httpServiceSSLTrustStorePassword);
        this.httpServiceSSLTrustStorePassword = httpServiceSSLTrustStorePassword;
    }

    @Override
    public Properties getHttpServiceSSLProperties() {
        return this.httpServiceSSLProperties;
    }

    @Override
    public ConfigSource getConfigSource(String attName) {
        return this.sourceMap.get(attName);
    }
}

