/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.distributed.internal;

import com.gemstone.gemfire.DataSerializable;
import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.internal.HeapDataOutputStream;
import com.gemstone.gemfire.internal.Version;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.IOException;

class DistributedState
implements DataSerializable {
    private static final long serialVersionUID = -4776743091985815549L;
    private String version;
    private long cacheTime;

    public static DistributedState fromBytes(byte[] bytes) throws IOException {
        DistributedState state = new DistributedState();
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        DataInputStream dis = new DataInputStream(bais);
        state.fromData(dis);
        return state;
    }

    public static byte[] toBytes(DistributedState state) throws IOException {
        HeapDataOutputStream hdos = new HeapDataOutputStream(256, Version.CURRENT);
        state.toData(hdos);
        return hdos.toByteArray();
    }

    public void setGemFireVersion(String version) {
        this.version = version;
    }

    public String getGemFireVersion() {
        return this.version;
    }

    public void setCacheTime(long cacheTime) {
        this.cacheTime = cacheTime;
    }

    public long getCacheTime() {
        return this.cacheTime;
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        DataSerializer.writeString(this.version, out);
        out.writeLong(this.cacheTime);
    }

    @Override
    public void fromData(DataInput in) throws IOException {
        this.version = DataSerializer.readString(in);
        this.cacheTime = in.readLong();
    }
}

