/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.distributed;

import com.gemstone.gemfire.SystemFailure;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.partition.PartitionRegionHelper;
import com.gemstone.gemfire.cache.server.CacheServer;
import com.gemstone.gemfire.distributed.AbstractLauncher;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.internal.GemFireVersion;
import com.gemstone.gemfire.internal.SocketCreator;
import com.gemstone.gemfire.internal.cache.CacheConfig;
import com.gemstone.gemfire.internal.cache.CacheServerLauncher;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.lang.ObjectUtils;
import com.gemstone.gemfire.internal.lang.StringUtils;
import com.gemstone.gemfire.internal.lang.SystemUtils;
import com.gemstone.gemfire.internal.process.ClusterConfigurationNotAvailableException;
import com.gemstone.gemfire.internal.process.ConnectionFailedException;
import com.gemstone.gemfire.internal.process.ControlNotificationHandler;
import com.gemstone.gemfire.internal.process.ControllableProcess;
import com.gemstone.gemfire.internal.process.FileAlreadyExistsException;
import com.gemstone.gemfire.internal.process.MBeanInvocationFailedException;
import com.gemstone.gemfire.internal.process.PidUnavailableException;
import com.gemstone.gemfire.internal.process.ProcessController;
import com.gemstone.gemfire.internal.process.ProcessControllerFactory;
import com.gemstone.gemfire.internal.process.ProcessControllerParameters;
import com.gemstone.gemfire.internal.process.ProcessLauncherContext;
import com.gemstone.gemfire.internal.process.ProcessType;
import com.gemstone.gemfire.internal.process.StartupStatusListener;
import com.gemstone.gemfire.internal.process.UnableToControlProcessException;
import com.gemstone.gemfire.internal.util.CollectionUtils;
import com.gemstone.gemfire.internal.util.IOUtils;
import com.gemstone.gemfire.lang.AttachAPINotFoundException;
import com.gemstone.gemfire.management.internal.cli.json.GfJsonArray;
import com.gemstone.gemfire.management.internal.cli.json.GfJsonException;
import com.gemstone.gemfire.management.internal.cli.json.GfJsonObject;
import com.gemstone.gemfire.pdx.PdxSerializer;
import com.gemstone.joptsimple.OptionException;
import com.gemstone.joptsimple.OptionParser;
import com.gemstone.joptsimple.OptionSet;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.springframework.data.gemfire.support.SpringContextBootstrappingInitializer;

public final class ServerLauncher
extends AbstractLauncher<String> {
    protected static final Integer DEFAULT_SERVER_PORT = ServerLauncher.getDefaultServerPort();
    private static final Map<String, String> helpMap = new HashMap<String, String>();
    private static final Map<Command, String> usageMap;
    public static final String DEFAULT_SERVER_PID_FILE = "vf.gf.server.pid";
    private static final String DEFAULT_SERVER_LOG_EXT = ".log";
    private static final String DEFAULT_SERVER_LOG_NAME = "gemfire";
    private static final String SERVER_SERVICE_NAME = "Server";
    private static final AtomicReference<ServerLauncher> INSTANCE;
    private volatile transient boolean debug;
    private final transient ControlNotificationHandler controlHandler;
    private final AtomicBoolean starting = new AtomicBoolean(false);
    private final boolean assignBuckets;
    private final boolean disableDefaultServer;
    private final boolean force;
    private final boolean help;
    private final boolean rebalance;
    private final boolean redirectOutput;
    private volatile transient Cache cache;
    private final transient CacheConfig cacheConfig;
    private final Command command;
    private final InetAddress serverBindAddress;
    private final Integer pid;
    private final Integer serverPort;
    private final Properties distributedSystemProperties;
    private final String memberName;
    private final String springXmlLocation;
    private final String workingDirectory;
    private volatile transient String statusMessage;
    private final Float criticalHeapPercentage;
    private final Float evictionHeapPercentage;
    private final String hostNameForClients;
    private final Integer maxConnections;
    private final Integer maxMessageCount;
    private final Integer messageTimeToLive;
    private final Integer socketBufferSize;
    private final Integer maxThreads;
    private volatile transient ControllableProcess process;
    private final transient ServerControllerParameters controllerParameters;

    private static final Integer getDefaultServerPort() {
        return Integer.getInteger("gemfire.test.CacheServer.OVERRIDE_DEFAULT_PORT", 40404);
    }

    public static void main(String ... args) {
        try {
            new Builder(args).build().run();
        }
        catch (AttachAPINotFoundException e) {
            System.err.println(e.getMessage());
        }
    }

    public static ServerLauncher getInstance() {
        return INSTANCE.get();
    }

    public static ServerState getServerState() {
        return ServerLauncher.getInstance() != null ? ServerLauncher.getInstance().status() : null;
    }

    private ServerLauncher(Builder builder) {
        this.cache = builder.getCache();
        this.cacheConfig = builder.getCacheConfig();
        this.command = builder.getCommand();
        this.assignBuckets = Boolean.TRUE.equals(builder.getAssignBuckets());
        this.setDebug(Boolean.TRUE.equals(builder.getDebug()));
        this.disableDefaultServer = Boolean.TRUE.equals(builder.getDisableDefaultServer());
        CacheServerLauncher.disableDefaultServer.set(this.disableDefaultServer);
        this.distributedSystemProperties = builder.getDistributedSystemProperties();
        this.force = Boolean.TRUE.equals(builder.getForce());
        this.help = Boolean.TRUE.equals(builder.getHelp());
        this.rebalance = Boolean.TRUE.equals(builder.getRebalance());
        this.memberName = builder.getMemberName();
        this.pid = builder.getPid();
        this.redirectOutput = Boolean.TRUE.equals(builder.getRedirectOutput());
        this.serverBindAddress = builder.getServerBindAddress();
        if (builder.isServerBindAddressSetByUser() && this.serverBindAddress != null) {
            CacheServerLauncher.serverBindAddress.set(this.serverBindAddress.getHostAddress());
        }
        this.serverPort = builder.getServerPort();
        if (builder.isServerPortSetByUser() && this.serverPort != null) {
            CacheServerLauncher.serverPort.set(this.serverPort);
        }
        this.springXmlLocation = builder.getSpringXmlLocation();
        this.workingDirectory = builder.getWorkingDirectory();
        this.criticalHeapPercentage = builder.getCriticalHeapPercentage();
        this.evictionHeapPercentage = builder.getEvictionHeapPercentage();
        this.maxThreads = builder.getMaxThreads();
        this.hostNameForClients = builder.getHostNameForClients();
        this.maxConnections = builder.getMaxConnections();
        this.maxMessageCount = builder.getMaxMessageCount();
        this.messageTimeToLive = builder.getMessageTimeToLive();
        this.socketBufferSize = builder.getSocketBufferSize();
        this.controllerParameters = new ServerControllerParameters();
        this.controlHandler = new ControlNotificationHandler(){

            @Override
            public void handleStop() {
                if (ServerLauncher.this.isStoppable()) {
                    ServerLauncher.this.stopInProcess();
                }
            }

            @Override
            public AbstractLauncher.ServiceState<?> handleStatus() {
                return ServerLauncher.this.statusInProcess();
            }
        };
    }

    final Cache getCache() {
        return this.cache;
    }

    final CacheConfig getCacheConfig() {
        CacheConfig copy = new CacheConfig();
        copy.setDeclarativeConfig(this.cacheConfig);
        return copy;
    }

    public final String getId() {
        StringBuilder buffer = new StringBuilder(ServerState.getServerBindAddressAsString(this));
        String serverPort = ServerState.getServerPortAsString(this);
        if (!StringUtils.isBlank(serverPort)) {
            buffer.append("[").append(serverPort).append("]");
        }
        return buffer.toString();
    }

    public Command getCommand() {
        return this.command;
    }

    public boolean isAssignBuckets() {
        return this.assignBuckets;
    }

    public boolean isDisableDefaultServer() {
        return this.disableDefaultServer;
    }

    public boolean isForcing() {
        return this.force;
    }

    public boolean isHelping() {
        return this.help;
    }

    public boolean isRebalancing() {
        return this.rebalance;
    }

    public boolean isRedirectingOutput() {
        return this.redirectOutput;
    }

    @Override
    public String getLogFileName() {
        return StringUtils.defaultIfBlank(this.getMemberName(), DEFAULT_SERVER_LOG_NAME).concat(DEFAULT_SERVER_LOG_EXT);
    }

    @Override
    public String getMemberName() {
        return StringUtils.defaultIfBlank(this.memberName, super.getMemberName());
    }

    @Override
    public Integer getPid() {
        return this.pid;
    }

    public Properties getProperties() {
        return (Properties)this.distributedSystemProperties.clone();
    }

    public InetAddress getServerBindAddress() {
        return this.serverBindAddress;
    }

    public String getServerBindAddressAsString() {
        try {
            if (this.getServerBindAddress() != null) {
                return this.getServerBindAddress().getCanonicalHostName();
            }
            InetAddress localhost = SocketCreator.getLocalHost();
            return localhost.getCanonicalHostName();
        }
        catch (UnknownHostException ignore) {
            return "localhost/127.0.0.1";
        }
    }

    public Integer getServerPort() {
        return this.serverPort;
    }

    public String getServerPortAsString() {
        return ObjectUtils.defaultIfNull(this.getServerPort(), ServerLauncher.getDefaultServerPort()).toString();
    }

    @Override
    public String getServiceName() {
        return SERVER_SERVICE_NAME;
    }

    public String getSpringXmlLocation() {
        return this.springXmlLocation;
    }

    public boolean isSpringXmlLocationSpecified() {
        return !StringUtils.isBlank(this.springXmlLocation);
    }

    @Override
    public String getWorkingDirectory() {
        return this.workingDirectory;
    }

    public Float getCriticalHeapPercentage() {
        return this.criticalHeapPercentage;
    }

    public Float getEvictionHeapPercentage() {
        return this.evictionHeapPercentage;
    }

    public String getHostNameForClients() {
        return this.hostNameForClients;
    }

    public Integer getMaxConnections() {
        return this.maxConnections;
    }

    public Integer getMaxMessageCount() {
        return this.maxMessageCount;
    }

    public Integer getMessageTimeToLive() {
        return this.messageTimeToLive;
    }

    public Integer getMaxThreads() {
        return this.maxThreads;
    }

    public Integer getSocketBufferSize() {
        return this.socketBufferSize;
    }

    public void help(Command command) {
        if (Command.isUnspecified(command)) {
            this.usage();
        } else {
            this.info(StringUtils.wrap(helpMap.get(command.getName()), 80, ""), new Object[0]);
            this.info("\n\nusage: \n\n", new Object[0]);
            this.info(StringUtils.wrap("> java ... " + this.getClass().getName() + " " + usageMap.get((Object)command), 80, "\t\t"), new Object[0]);
            this.info("\n\noptions: \n\n", new Object[0]);
            for (String option : command.getOptions()) {
                this.info(StringUtils.wrap("--" + option + ": " + helpMap.get(option) + "\n", 80, "\t"), new Object[0]);
            }
            this.info("\n\n", new Object[0]);
        }
    }

    public void usage() {
        this.info(StringUtils.wrap(helpMap.get("launcher"), 80, "\t"), new Object[0]);
        this.info("\n\nSTART\n\n", new Object[0]);
        this.help(Command.START);
        this.info("STATUS\n\n", new Object[0]);
        this.help(Command.STATUS);
        this.info("STOP\n\n", new Object[0]);
        this.help(Command.STOP);
    }

    @Override
    public void run() {
        if (!this.isHelping()) {
            switch (this.getCommand()) {
                case START: {
                    this.info(this.start(), new Object[0]);
                    this.waitOnServer();
                    break;
                }
                case STATUS: {
                    this.info(this.status(), new Object[0]);
                    break;
                }
                case STOP: {
                    this.info(this.stop(), new Object[0]);
                    break;
                }
                case VERSION: {
                    this.info(this.version(), new Object[0]);
                    break;
                }
                default: {
                    this.usage();
                    break;
                }
            }
        } else {
            this.help(this.getCommand());
        }
    }

    protected File getServerPidFile() {
        return new File(this.getWorkingDirectory(), ProcessType.SERVER.getPidFileName());
    }

    private boolean isStartable() {
        return !this.isRunning() && this.starting.compareAndSet(false, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServerState start() {
        if (this.isStartable()) {
            INSTANCE.compareAndSet(null, this);
            try {
                Object gemfireProperties;
                this.process = new ControllableProcess(this.controlHandler, new File(this.getWorkingDirectory()), ProcessType.SERVER, this.isForcing());
                if (!this.isDisableDefaultServer()) {
                    ServerLauncher.assertPortAvailable(this.getServerBindAddress(), this.getServerPort());
                }
                SystemFailure.setExitOK(true);
                ProcessLauncherContext.set(this.isRedirectingOutput(), this.getOverriddenDefaults(), new StartupStatusListener(){

                    @Override
                    public void setStatus(String statusMessage) {
                        ServerLauncher.this.debug("Callback setStatus(String) called with message (%1$s)...", statusMessage);
                        ServerLauncher.this.statusMessage = statusMessage;
                    }
                });
                try {
                    gemfireProperties = this.getDistributedSystemProperties(this.getProperties());
                    Cache cache = this.cache = this.isSpringXmlLocationSpecified() ? this.startWithSpring() : this.startWithGemFireApi((Properties)gemfireProperties);
                    if (this.criticalHeapPercentage != null) {
                        this.cache.getResourceManager().setCriticalHeapPercentage(this.getCriticalHeapPercentage().floatValue());
                    }
                    if (this.evictionHeapPercentage != null) {
                        this.cache.getResourceManager().setEvictionHeapPercentage(this.getEvictionHeapPercentage().floatValue());
                    }
                    this.cache.setIsServer(true);
                    this.startCacheServer(this.cache);
                    this.assignBuckets(this.cache);
                    this.rebalance(this.cache);
                }
                finally {
                    ProcessLauncherContext.remove();
                }
                this.debug("Running Server on (%1$s) in (%2$s) as (%2$s)...", this.getId(), this.getWorkingDirectory(), this.getMember());
                this.running.set(true);
                gemfireProperties = new ServerState(this, AbstractLauncher.Status.ONLINE);
                return gemfireProperties;
            }
            catch (IOException e) {
                this.failOnStart(e);
                throw new RuntimeException(LocalizedStrings.Launcher_Command_START_IO_ERROR_MESSAGE.toLocalizedString(this.getServiceName(), this.getWorkingDirectory(), this.getId(), e.getMessage()), e);
            }
            catch (FileAlreadyExistsException e) {
                this.failOnStart(e);
                throw new RuntimeException(LocalizedStrings.Launcher_Command_START_PID_FILE_ALREADY_EXISTS_ERROR_MESSAGE.toLocalizedString(this.getServiceName(), this.getWorkingDirectory(), this.getId()), e);
            }
            catch (PidUnavailableException e) {
                this.failOnStart(e);
                throw new RuntimeException(LocalizedStrings.Launcher_Command_START_PID_UNAVAILABLE_ERROR_MESSAGE.toLocalizedString(this.getServiceName(), this.getId(), this.getWorkingDirectory(), e.getMessage()), e);
            }
            catch (ClusterConfigurationNotAvailableException e) {
                this.failOnStart(e);
                throw e;
            }
            catch (Error e) {
                this.failOnStart(e);
                throw e;
            }
            catch (RuntimeException e) {
                this.failOnStart(e);
                throw e;
            }
            catch (Exception e) {
                this.failOnStart(e);
                throw new RuntimeException(e);
            }
            finally {
                this.starting.set(false);
            }
        }
        throw new IllegalStateException(LocalizedStrings.Launcher_Command_START_SERVICE_ALREADY_RUNNING_ERROR_MESSAGE.toLocalizedString(this.getServiceName(), this.getWorkingDirectory(), this.getId()));
    }

    private Cache startWithSpring() {
        System.setProperty("gemfire.name", this.getMemberName());
        new SpringContextBootstrappingInitializer().init(CollectionUtils.createProperties(Collections.singletonMap("contextConfigLocations", this.getSpringXmlLocation())));
        return (Cache)SpringContextBootstrappingInitializer.getApplicationContext().getBean(Cache.class);
    }

    private Cache startWithGemFireApi(Properties gemfireProperties) {
        CacheConfig cacheConfig = this.getCacheConfig();
        CacheFactory cacheFactory = new CacheFactory(gemfireProperties);
        if (cacheConfig.pdxPersistentUserSet) {
            cacheFactory.setPdxPersistent(cacheConfig.isPdxPersistent());
        }
        if (cacheConfig.pdxDiskStoreUserSet) {
            cacheFactory.setPdxDiskStore(cacheConfig.getPdxDiskStore());
        }
        if (cacheConfig.pdxIgnoreUnreadFieldsUserSet) {
            cacheFactory.setPdxIgnoreUnreadFields(cacheConfig.getPdxIgnoreUnreadFields());
        }
        if (cacheConfig.pdxReadSerializedUserSet) {
            cacheFactory.setPdxReadSerialized(cacheConfig.isPdxReadSerialized());
        }
        if (cacheConfig.pdxSerializerUserSet) {
            cacheFactory.setPdxSerializer(cacheConfig.getPdxSerializer());
        }
        return cacheFactory.create();
    }

    private void failOnStart(Throwable cause) {
        if (this.cache != null) {
            this.cache.close();
            this.cache = null;
        }
        if (this.process != null) {
            this.process.stop();
            this.process = null;
        }
        INSTANCE.compareAndSet(this, null);
        this.running.set(false);
    }

    protected boolean isServing(Cache cache) {
        return !cache.getCacheServers().isEmpty();
    }

    final boolean isWaiting(Cache cache) {
        return this.isRunning() && cache.getDistributedSystem().isConnected();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitOnServer() {
        assert (this.getCache() != null) : "The Cache Server must first be started with a call to start!";
        if (!this.isServing(this.getCache())) {
            RuntimeException cause = null;
            try {
                while (this.isWaiting(this.getCache())) {
                    try {
                        ServerLauncher serverLauncher = this;
                        synchronized (serverLauncher) {
                            this.wait(500L);
                        }
                    }
                    catch (InterruptedException ignore) {
                    }
                }
            }
            catch (RuntimeException e) {
                cause = e;
                throw e;
            }
            finally {
                this.failOnStart(cause);
            }
        }
    }

    protected boolean isDefaultServerEnabled(Cache cache) {
        return cache.getCacheServers().isEmpty() && !this.isDisableDefaultServer();
    }

    final void startCacheServer(Cache cache) throws IOException {
        if (this.isDefaultServerEnabled(cache)) {
            String serverBindAddress = this.getServerBindAddress() == null ? null : this.getServerBindAddress().getHostAddress();
            Integer serverPort = this.getServerPort();
            CacheServerLauncher.serverBindAddress.set(serverBindAddress);
            CacheServerLauncher.serverPort.set(serverPort);
            CacheServer cacheServer = cache.addCacheServer();
            cacheServer.setBindAddress(serverBindAddress);
            cacheServer.setPort(serverPort);
            if (this.getMaxThreads() != null) {
                cacheServer.setMaxThreads(this.getMaxThreads());
            }
            if (this.getMaxConnections() != null) {
                cacheServer.setMaxConnections(this.getMaxConnections());
            }
            if (this.getMaxMessageCount() != null) {
                cacheServer.setMaximumMessageCount(this.getMaxMessageCount());
            }
            if (this.getMessageTimeToLive() != null) {
                cacheServer.setMessageTimeToLive(this.getMessageTimeToLive());
            }
            if (this.getSocketBufferSize() != null) {
                cacheServer.setSocketBufferSize(this.getSocketBufferSize());
            }
            cacheServer.start();
        }
    }

    private final void rebalance(Cache cache) {
        if (this.isRebalancing()) {
            cache.getResourceManager().createRebalanceFactory().start();
        }
    }

    protected boolean isAssignBucketsAllowed(Cache cache) {
        return this.isAssignBuckets() && cache instanceof GemFireCacheImpl;
    }

    final void assignBuckets(Cache cache) {
        if (this.isAssignBucketsAllowed(cache)) {
            for (PartitionedRegion region : ((GemFireCacheImpl)cache).getPartitionedRegions()) {
                PartitionRegionHelper.assignBucketsToPartitions(region);
            }
        }
    }

    protected boolean isStartingOrRunning() {
        return this.starting.get() || this.isRunning();
    }

    public ServerState status() {
        ServerLauncher launcher = ServerLauncher.getInstance();
        if (this.isStartingOrRunning()) {
            this.debug("Getting status from the ServerLauncher instance that actually launched the GemFire Cache Server.%n", new Object[0]);
            return new ServerState(this, this.isRunning() ? AbstractLauncher.Status.ONLINE : AbstractLauncher.Status.STARTING);
        }
        if (this.isPidInProcess() && launcher != null) {
            return launcher.statusInProcess();
        }
        if (this.getPid() != null) {
            this.debug("Getting Server status using process ID (%1$s)%n", this.getPid());
            return this.statusWithPid();
        }
        if (this.getWorkingDirectory() != null) {
            this.debug("Getting Server status using working directory (%1$s)%n", this.getWorkingDirectory());
            return this.statusWithWorkingDirectory();
        }
        this.debug("This ServerLauncher was not the instance used to launch the GemFire Cache Server, and neither PID ".concat("nor working directory were specified; the Server's state is unknown.%n"), new Object[0]);
        return new ServerState(this, AbstractLauncher.Status.NOT_RESPONDING);
    }

    private ServerState statusInProcess() {
        if (this.isStartingOrRunning()) {
            this.debug("Getting status from the ServerLauncher instance that actually launched the GemFire Cache Server.%n", new Object[0]);
            return new ServerState(this, this.isRunning() ? AbstractLauncher.Status.ONLINE : AbstractLauncher.Status.STARTING);
        }
        return new ServerState(this, AbstractLauncher.Status.NOT_RESPONDING);
    }

    private ServerState statusWithPid() {
        try {
            ProcessController controller = new ProcessControllerFactory().createProcessController((ProcessControllerParameters)this.controllerParameters, this.getPid());
            controller.checkPidSupport();
            String statusJson = controller.status();
            return ServerState.fromJson(statusJson);
        }
        catch (ConnectionFailedException e) {
            return this.createNoResponseState(e, "Failed to connect to server with process id " + this.getPid());
        }
        catch (IOException e) {
            return this.createNoResponseState(e, "Failed to communicate with server with process id " + this.getPid());
        }
        catch (MBeanInvocationFailedException e) {
            return this.createNoResponseState(e, "Failed to communicate with server with process id " + this.getPid());
        }
        catch (UnableToControlProcessException e) {
            return this.createNoResponseState(e, "Failed to communicate with server with process id " + this.getPid());
        }
        catch (InterruptedException e) {
            return this.createNoResponseState(e, "Failed to communicate with server with process id " + this.getPid());
        }
        catch (TimeoutException e) {
            return this.createNoResponseState(e, "Failed to communicate with server with process id " + this.getPid());
        }
    }

    private ServerState statusWithWorkingDirectory() {
        int parsedPid = 0;
        try {
            ServerLauncher runningLauncher;
            ProcessController controller = new ProcessControllerFactory().createProcessController(this.controllerParameters, new File(this.getWorkingDirectory()), ProcessType.SERVER.getPidFileName());
            parsedPid = controller.getProcessId();
            if (parsedPid == this.identifyPid() && (runningLauncher = ServerLauncher.getInstance()) != null) {
                return runningLauncher.statusInProcess();
            }
            String statusJson = controller.status();
            return ServerState.fromJson(statusJson);
        }
        catch (ConnectionFailedException e) {
            return this.createNoResponseState(e, "Failed to connect to server with process id " + parsedPid);
        }
        catch (FileNotFoundException e) {
            return this.createNoResponseState(e, "Failed to find process file " + ProcessType.SERVER.getPidFileName() + " in " + this.getWorkingDirectory());
        }
        catch (IOException e) {
            return this.createNoResponseState(e, "Failed to communicate with server with process id " + parsedPid);
        }
        catch (MBeanInvocationFailedException e) {
            return this.createNoResponseState(e, "Failed to communicate with server with process id " + parsedPid);
        }
        catch (PidUnavailableException e) {
            return this.createNoResponseState(e, "Failed to find usable process id within file " + ProcessType.SERVER.getPidFileName() + " in " + this.getWorkingDirectory());
        }
        catch (UnableToControlProcessException e) {
            return this.createNoResponseState(e, "Failed to communicate with server with process id " + parsedPid);
        }
        catch (InterruptedException e) {
            return this.createNoResponseState(e, "Failed to communicate with server with process id " + parsedPid);
        }
        catch (TimeoutException e) {
            return this.createNoResponseState(e, "Failed to communicate with server with process id " + parsedPid);
        }
    }

    private boolean isStoppable() {
        return this.isRunning() && this.getCache() != null;
    }

    public ServerState stop() {
        ServerLauncher launcher = ServerLauncher.getInstance();
        if (this.isStoppable()) {
            return this.stopInProcess();
        }
        if (this.isPidInProcess() && launcher != null) {
            return launcher.stopInProcess();
        }
        if (this.getPid() != null) {
            return this.stopWithPid();
        }
        if (this.getWorkingDirectory() != null) {
            return this.stopWithWorkingDirectory();
        }
        return new ServerState(this, AbstractLauncher.Status.NOT_RESPONDING);
    }

    private ServerState stopInProcess() {
        if (this.isStoppable()) {
            this.cache.close();
            this.cache = null;
            this.process.stop();
            this.process = null;
            INSTANCE.compareAndSet(this, null);
            this.running.set(false);
            return new ServerState(this, AbstractLauncher.Status.STOPPED);
        }
        return new ServerState(this, AbstractLauncher.Status.NOT_RESPONDING);
    }

    private ServerState stopWithPid() {
        try {
            ProcessController controller = new ProcessControllerFactory().createProcessController((ProcessControllerParameters)this.controllerParameters, this.getPid());
            controller.checkPidSupport();
            controller.stop();
            return new ServerState(this, AbstractLauncher.Status.STOPPED);
        }
        catch (ConnectionFailedException e) {
            return this.createNoResponseState(e, "Failed to connect to server with process id " + this.getPid());
        }
        catch (IOException e) {
            return this.createNoResponseState(e, "Failed to communicate with server with process id " + this.getPid());
        }
        catch (MBeanInvocationFailedException e) {
            return this.createNoResponseState(e, "Failed to communicate with server with process id " + this.getPid());
        }
        catch (UnableToControlProcessException e) {
            return this.createNoResponseState(e, "Failed to communicate with server with process id " + this.getPid());
        }
    }

    private ServerState stopWithWorkingDirectory() {
        int parsedPid = 0;
        try {
            ServerLauncher runningLauncher;
            ProcessController controller = new ProcessControllerFactory().createProcessController(this.controllerParameters, new File(this.getWorkingDirectory()), ProcessType.SERVER.getPidFileName());
            parsedPid = controller.getProcessId();
            if (parsedPid == this.identifyPid() && (runningLauncher = ServerLauncher.getInstance()) != null) {
                return runningLauncher.stopInProcess();
            }
            controller.stop();
            return new ServerState(this, AbstractLauncher.Status.STOPPED);
        }
        catch (ConnectionFailedException e) {
            return this.createNoResponseState(e, "Failed to connect to server with process id " + parsedPid);
        }
        catch (FileNotFoundException e) {
            return this.createNoResponseState(e, "Failed to find process file " + ProcessType.SERVER.getPidFileName() + " in " + this.getWorkingDirectory());
        }
        catch (IOException e) {
            return this.createNoResponseState(e, "Failed to communicate with server with process id " + parsedPid);
        }
        catch (MBeanInvocationFailedException e) {
            return this.createNoResponseState(e, "Failed to communicate with server with process id " + parsedPid);
        }
        catch (PidUnavailableException e) {
            return this.createNoResponseState(e, "Failed to find usable process id within file " + ProcessType.SERVER.getPidFileName() + " in " + this.getWorkingDirectory());
        }
        catch (UnableToControlProcessException e) {
            return this.createNoResponseState(e, "Failed to communicate with server with process id " + parsedPid);
        }
    }

    private ServerState createNoResponseState(Exception cause, String errorMessage) {
        this.debug(cause);
        return new ServerState(this, AbstractLauncher.Status.NOT_RESPONDING);
    }

    private Properties getOverriddenDefaults() {
        Properties overriddenDefaults = new Properties();
        overriddenDefaults.put("gemfire.default.".concat("log-file"), this.getLogFileName());
        for (String key2 : System.getProperties().stringPropertyNames()) {
            if (!key2.startsWith("gemfire.default.")) continue;
            overriddenDefaults.put(key2, System.getProperty(key2));
        }
        return overriddenDefaults;
    }

    static {
        helpMap.put("launcher", LocalizedStrings.ServerLauncher_SERVER_LAUNCHER_HELP.toLocalizedString());
        helpMap.put(Command.START.getName(), LocalizedStrings.ServerLauncher_START_SERVER_HELP.toLocalizedString(String.valueOf(ServerLauncher.getDefaultServerPort())));
        helpMap.put(Command.STATUS.getName(), LocalizedStrings.ServerLauncher_STATUS_SERVER_HELP.toLocalizedString());
        helpMap.put(Command.STOP.getName(), LocalizedStrings.ServerLauncher_STOP_SERVER_HELP.toLocalizedString());
        helpMap.put(Command.VERSION.getName(), LocalizedStrings.ServerLauncher_VERSION_SERVER_HELP.toLocalizedString());
        helpMap.put("assign-buckets", LocalizedStrings.ServerLauncher_SERVER_ASSIGN_BUCKETS_HELP.toLocalizedString());
        helpMap.put("debug", LocalizedStrings.ServerLauncher_SERVER_DEBUG_HELP.toLocalizedString());
        helpMap.put("dir", LocalizedStrings.ServerLauncher_SERVER_DIR_HELP.toLocalizedString());
        helpMap.put("disable-default-server", LocalizedStrings.ServerLauncher_SERVER_DISABLE_DEFAULT_SERVER_HELP.toLocalizedString());
        helpMap.put("force", LocalizedStrings.ServerLauncher_SERVER_FORCE_HELP.toLocalizedString());
        helpMap.put("help", LocalizedStrings.SystemAdmin_CAUSES_GEMFIRE_TO_PRINT_OUT_INFORMATION_INSTEAD_OF_PERFORMING_THE_COMMAND_THIS_OPTION_IS_SUPPORTED_BY_ALL_COMMANDS.toLocalizedString());
        helpMap.put("member", LocalizedStrings.ServerLauncher_SERVER_MEMBER_HELP.toLocalizedString());
        helpMap.put("pid", LocalizedStrings.ServerLauncher_SERVER_PID_HELP.toLocalizedString());
        helpMap.put("server-bind-address", LocalizedStrings.ServerLauncher_SERVER_BIND_ADDRESS_HELP.toLocalizedString());
        helpMap.put("server-port", LocalizedStrings.ServerLauncher_SERVER_PORT_HELP.toLocalizedString(String.valueOf(ServerLauncher.getDefaultServerPort())));
        helpMap.put("rebalance", LocalizedStrings.ServerLauncher_SERVER_REBALANCE_HELP.toLocalizedString());
        helpMap.put("redirect-output", LocalizedStrings.ServerLauncher_SERVER_REDIRECT_OUTPUT_HELP.toLocalizedString());
        usageMap = new TreeMap<Command, String>();
        usageMap.put(Command.START, "start <member-name> [--assign-buckets] [--disable-default-server] [--rebalance] [--server-bind-address=<IP-address>] [--server-port=<port>] [--force] [--debug] [--help]");
        usageMap.put(Command.STATUS, "status [--member=<member-ID/Name>] [--pid=<process-ID>] [--dir=<Server-working-directory>] [--debug] [--help]");
        usageMap.put(Command.STOP, "stop [--member=<member-ID/Name>] [--pid=<process-ID>] [--dir=<Server-working-directory>] [--debug] [--help]");
        usageMap.put(Command.VERSION, "version");
        INSTANCE = new AtomicReference();
    }

    public static final class ServerState
    extends AbstractLauncher.ServiceState<String> {
        public static ServerState fromJson(String json) {
            try {
                GfJsonObject gfJsonObject = new GfJsonObject(json);
                AbstractLauncher.Status status = AbstractLauncher.Status.valueOfDescription(gfJsonObject.getString("status"));
                List<String> jvmArguments = Arrays.asList(GfJsonArray.toStringArray(gfJsonObject.getJSONArray("jvmArguments")));
                return new ServerState(status, gfJsonObject.getString("statusMessage"), gfJsonObject.getLong("timestamp"), gfJsonObject.getString("location"), gfJsonObject.getInt("pid"), gfJsonObject.getLong("uptime"), gfJsonObject.getString("workingDirectory"), jvmArguments, gfJsonObject.getString("classpath"), gfJsonObject.getString("gemFireVersion"), gfJsonObject.getString("javaVersion"), gfJsonObject.getString("logFileName"), gfJsonObject.getString("bindAddress"), gfJsonObject.getString("port"), gfJsonObject.getString("memberName"));
            }
            catch (GfJsonException e) {
                throw new IllegalArgumentException("Unable to create ServerStatus from JSON: " + json);
            }
        }

        public ServerState(ServerLauncher launcher, AbstractLauncher.Status status) {
            this(status, launcher.statusMessage, System.currentTimeMillis(), launcher.getId(), ServerState.identifyPid(), ManagementFactory.getRuntimeMXBean().getUptime(), launcher.getWorkingDirectory(), ManagementFactory.getRuntimeMXBean().getInputArguments(), System.getProperty("java.class.path"), GemFireVersion.getGemFireVersion(), System.getProperty("java.version"), ServerState.getServerLogFileCanonicalPath(launcher), ServerState.getServerBindAddressAsString(launcher), ServerState.getServerPortAsString(launcher), launcher.getMemberName());
        }

        protected ServerState(AbstractLauncher.Status status, String statusMessage, long timestamp, String serverLocation, Integer pid, Long uptime, String workingDirectory, List<String> jvmArguments, String classpath, String gemfireVersion, String javaVersion, String logFile, String host, String port, String memberName) {
            super(status, statusMessage, timestamp, serverLocation, pid, uptime, workingDirectory, jvmArguments, classpath, gemfireVersion, javaVersion, logFile, host, port, memberName);
        }

        private static String getServerLogFileCanonicalPath(ServerLauncher launcher) {
            String logFileCanonicalPath;
            File logFile;
            InternalDistributedSystem system = InternalDistributedSystem.getAnyInstance();
            if (system != null && (logFile = system.getConfig().getLogFile()) != null && logFile.isFile() && !StringUtils.isBlank(logFileCanonicalPath = IOUtils.tryGetCanonicalPathElseGetAbsolutePath(logFile))) {
                return logFileCanonicalPath;
            }
            return launcher.getLogFileCanonicalPath();
        }

        private static String getServerBindAddressAsString(ServerLauncher launcher) {
            CacheServer cs;
            String serverBindAddressAsString;
            List csList;
            GemFireCacheImpl gemfireCache = GemFireCacheImpl.getInstance();
            if (gemfireCache != null && (csList = gemfireCache.getCacheServers()) != null && !csList.isEmpty() && !StringUtils.isBlank(serverBindAddressAsString = (cs = (CacheServer)csList.get(0)).getBindAddress())) {
                return serverBindAddressAsString;
            }
            return launcher.getServerBindAddressAsString();
        }

        private static String getServerPortAsString(ServerLauncher launcher) {
            CacheServer cs;
            String portAsString;
            List csList;
            GemFireCacheImpl gemfireCache = GemFireCacheImpl.getInstance();
            if (gemfireCache != null && (csList = gemfireCache.getCacheServers()) != null && !csList.isEmpty() && !StringUtils.isBlank(portAsString = String.valueOf((cs = (CacheServer)csList.get(0)).getPort()))) {
                return portAsString;
            }
            return launcher.isDisableDefaultServer() ? "" : launcher.getServerPortAsString();
        }

        @Override
        protected String getServiceName() {
            return ServerLauncher.SERVER_SERVICE_NAME;
        }
    }

    public static final class Command
    extends Enum<Command> {
        public static final /* enum */ Command START = new Command("start", "assign-buckets", "disable-default-server", "rebalance", "server-bind-address", "server-port", "force", "debug", "help");
        public static final /* enum */ Command STATUS = new Command("status", "member", "pid", "dir", "debug", "help");
        public static final /* enum */ Command STOP = new Command("stop", "member", "pid", "dir", "debug", "help");
        public static final /* enum */ Command UNSPECIFIED = new Command("unspecified", new String[0]);
        public static final /* enum */ Command VERSION = new Command("version", new String[0]);
        private final List<String> options;
        private final String name;
        private static final /* synthetic */ Command[] $VALUES;

        public static Command[] values() {
            return (Command[])$VALUES.clone();
        }

        public static Command valueOf(String name) {
            return Enum.valueOf(Command.class, name);
        }

        private Command(String name, String ... options) {
            assert (!StringUtils.isBlank(name)) : "The name of the command must be specified!";
            this.name = name;
            this.options = options != null ? Collections.unmodifiableList(Arrays.asList(options)) : Collections.emptyList();
        }

        public static boolean isCommand(String name) {
            return Command.valueOfName(name) != null;
        }

        public static boolean isUnspecified(Command command) {
            return command == null || command.isUnspecified();
        }

        public static Command valueOfName(String name) {
            for (Command command : Command.values()) {
                if (!command.getName().equalsIgnoreCase(name)) continue;
                return command;
            }
            return null;
        }

        public String getName() {
            return this.name;
        }

        public List<String> getOptions() {
            return this.options;
        }

        public boolean hasOption(String option) {
            return this.getOptions().contains(StringUtils.toLowerCase(option));
        }

        public boolean isUnspecified() {
            return this == UNSPECIFIED;
        }

        public String toString() {
            return this.getName();
        }

        static {
            $VALUES = new Command[]{START, STATUS, STOP, UNSPECIFIED, VERSION};
        }
    }

    public static class Builder {
        protected static final Command DEFAULT_COMMAND = Command.UNSPECIFIED;
        private boolean serverBindAddressSetByUser;
        private boolean serverPortSetByUser;
        private Boolean assignBuckets;
        private Boolean debug;
        private Boolean disableDefaultServer;
        private Boolean force;
        private Boolean help;
        private Boolean rebalance;
        private Boolean redirectOutput;
        private Cache cache;
        private final CacheConfig cacheConfig = new CacheConfig();
        private Command command;
        private InetAddress serverBindAddress;
        private Integer pid;
        private Integer serverPort;
        private final Properties distributedSystemProperties = new Properties();
        private String memberName;
        private String springXmlLocation;
        private String workingDirectory;
        private Float criticalHeapPercentage;
        private Float evictionHeapPercentage;
        private String hostNameForClients;
        private Integer loadPollInterval;
        private Integer maxConnections;
        private Integer maxMessageCount;
        private Integer messageTimeToLive;
        private Integer socketBufferSize;
        private Integer maxThreads;

        public Builder() {
        }

        public Builder(String ... args) {
            this.parseArguments(args != null ? args : new String[]{});
        }

        private OptionParser getParser() {
            OptionParser parser = new OptionParser(true);
            parser.accepts("assign-buckets");
            parser.accepts("debug");
            parser.accepts("dir").withRequiredArg().ofType(String.class);
            parser.accepts("disable-default-server");
            parser.accepts("force");
            parser.accepts("help");
            parser.accepts("member").withRequiredArg().ofType(String.class);
            parser.accepts("pid").withRequiredArg().ofType(Integer.class);
            parser.accepts("rebalance");
            parser.accepts("redirect-output");
            parser.accepts("server-bind-address").withRequiredArg().ofType(String.class);
            parser.accepts("server-port").withRequiredArg().ofType(Integer.class);
            parser.accepts("spring-xml-location").withRequiredArg().ofType(String.class);
            parser.accepts("version");
            parser.accepts("critical-heap-percentage").withRequiredArg().ofType(Float.class);
            parser.accepts("eviction-heap-percentage").withRequiredArg().ofType(Float.class);
            parser.accepts("max-threads").withRequiredArg().ofType(Integer.class);
            parser.accepts("max-connections").withRequiredArg().ofType(Integer.class);
            parser.accepts("max-message-count").withRequiredArg().ofType(Integer.class);
            parser.accepts("message-time-to-live").withRequiredArg().ofType(Integer.class);
            parser.accepts("socket-buffer-size").withRequiredArg().ofType(Integer.class);
            return parser;
        }

        protected void parseArguments(String ... args) {
            try {
                OptionSet options = this.getParser().parse(args);
                this.parseCommand(args);
                this.parseMemberName(args);
                this.setAssignBuckets(options.has("assign-buckets"));
                this.setDebug(options.has("debug"));
                this.setDisableDefaultServer(options.has("disable-default-server"));
                this.setForce(options.has("force"));
                this.setHelp(options.has("help"));
                this.setRebalance(options.has("rebalance"));
                this.setRedirectOutput(options.has("redirect-output"));
                if (options.hasArgument("critical-heap-percentage")) {
                    this.setCriticalHeapPercentage(Float.valueOf(Float.parseFloat(ObjectUtils.toString(options.valueOf("critical-heap-percentage")))));
                }
                if (options.hasArgument("eviction-heap-percentage")) {
                    this.setCriticalHeapPercentage(Float.valueOf(Float.parseFloat(ObjectUtils.toString(options.valueOf("eviction-heap-percentage")))));
                }
                if (options.hasArgument("max-connections")) {
                    this.setMaxConnections(Integer.parseInt(ObjectUtils.toString(options.valueOf("max-connections"))));
                }
                if (options.hasArgument("max-message-count")) {
                    this.setMaxConnections(Integer.parseInt(ObjectUtils.toString(options.valueOf("max-message-count"))));
                }
                if (options.hasArgument("message-time-to-live")) {
                    this.setMaxConnections(Integer.parseInt(ObjectUtils.toString(options.valueOf("message-time-to-live"))));
                }
                if (options.hasArgument("socket-buffer-size")) {
                    this.setMaxConnections(Integer.parseInt(ObjectUtils.toString(options.valueOf("socket-buffer-size"))));
                }
                if (options.hasArgument("max-threads")) {
                    this.setMaxThreads(Integer.parseInt(ObjectUtils.toString(options.valueOf("max-threads"))));
                }
                if (!this.isHelping()) {
                    if (options.has("dir")) {
                        this.setWorkingDirectory(ObjectUtils.toString(options.valueOf("dir")));
                    }
                    if (options.has("pid")) {
                        this.setPid((Integer)options.valueOf("pid"));
                    }
                    if (options.has("server-bind-address")) {
                        this.setServerBindAddress(ObjectUtils.toString(options.valueOf("server-bind-address")));
                    }
                    if (options.has("server-port")) {
                        this.setServerPort((Integer)options.valueOf("server-port"));
                    }
                    if (options.has("spring-xml-location")) {
                        this.setSpringXmlLocation(ObjectUtils.toString(options.valueOf("spring-xml-location")));
                    }
                    if (options.has("version")) {
                        this.setCommand(Command.VERSION);
                    }
                }
            }
            catch (OptionException e) {
                throw new IllegalArgumentException(LocalizedStrings.Launcher_Builder_PARSE_COMMAND_LINE_ARGUMENT_ERROR_MESSAGE.toLocalizedString(ServerLauncher.SERVER_SERVICE_NAME, e.getMessage()), e);
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }

        protected void parseCommand(String ... args) {
            if (args != null) {
                for (String arg : args) {
                    Command command = Command.valueOfName(arg);
                    if (command == null) continue;
                    this.setCommand(command);
                    break;
                }
            }
        }

        protected void parseMemberName(String ... args) {
            if (args != null) {
                for (String arg : args) {
                    if (arg.startsWith("-") || Command.isCommand(arg)) continue;
                    this.setMemberName(arg);
                    break;
                }
            }
        }

        CacheConfig getCacheConfig() {
            return this.cacheConfig;
        }

        public Command getCommand() {
            return ObjectUtils.defaultIfNull(this.command, DEFAULT_COMMAND);
        }

        public Builder setCommand(Command command) {
            this.command = command;
            return this;
        }

        public Boolean getAssignBuckets() {
            return this.assignBuckets;
        }

        public Builder setAssignBuckets(Boolean assignBuckets) {
            this.assignBuckets = assignBuckets;
            return this;
        }

        Cache getCache() {
            return this.cache;
        }

        Builder setCache(Cache cache) {
            this.cache = cache;
            return this;
        }

        public Boolean getDebug() {
            return this.debug;
        }

        public Builder setDebug(Boolean debug2) {
            this.debug = debug2;
            return this;
        }

        public Boolean getDisableDefaultServer() {
            return this.disableDefaultServer;
        }

        public Builder setDisableDefaultServer(Boolean disableDefaultServer) {
            this.disableDefaultServer = disableDefaultServer;
            return this;
        }

        public Properties getDistributedSystemProperties() {
            return this.distributedSystemProperties;
        }

        public Boolean getForce() {
            return ObjectUtils.defaultIfNull(this.force, AbstractLauncher.DEFAULT_FORCE);
        }

        public Builder setForce(Boolean force) {
            this.force = force;
            return this;
        }

        public Boolean getHelp() {
            return this.help;
        }

        protected final boolean isHelping() {
            return Boolean.TRUE.equals(this.getHelp());
        }

        public Builder setHelp(Boolean help2) {
            this.help = help2;
            return this;
        }

        public Boolean getRebalance() {
            return this.rebalance;
        }

        public Builder setRebalance(Boolean rebalance2) {
            this.rebalance = rebalance2;
            return this;
        }

        public String getMemberName() {
            return this.memberName;
        }

        public Builder setMemberName(String memberName) {
            if (StringUtils.isEmpty(StringUtils.trim(memberName))) {
                throw new IllegalArgumentException(LocalizedStrings.Launcher_Builder_MEMBER_NAME_ERROR_MESSAGE.toLocalizedString(ServerLauncher.SERVER_SERVICE_NAME));
            }
            this.memberName = memberName;
            return this;
        }

        public Integer getPid() {
            return this.pid;
        }

        public Builder setPid(Integer pid) {
            if (pid != null && pid < 0) {
                throw new IllegalArgumentException(LocalizedStrings.Launcher_Builder_PID_ERROR_MESSAGE.toLocalizedString());
            }
            this.pid = pid;
            return this;
        }

        public Boolean getRedirectOutput() {
            return this.redirectOutput;
        }

        private boolean isRedirectingOutput() {
            return Boolean.TRUE.equals(this.getRedirectOutput());
        }

        public Builder setRedirectOutput(Boolean redirectOutput) {
            this.redirectOutput = redirectOutput;
            return this;
        }

        public InetAddress getServerBindAddress() {
            return this.serverBindAddress;
        }

        boolean isServerBindAddressSetByUser() {
            return this.serverBindAddressSetByUser;
        }

        public Builder setServerBindAddress(String serverBindAddress) {
            if (StringUtils.isBlank(serverBindAddress)) {
                this.serverBindAddress = null;
                return this;
            }
            try {
                this.serverBindAddress = InetAddress.getByName(serverBindAddress);
                this.serverBindAddressSetByUser = true;
                return this;
            }
            catch (UnknownHostException e) {
                throw new IllegalArgumentException(LocalizedStrings.Launcher_Builder_UNKNOWN_HOST_ERROR_MESSAGE.toLocalizedString(ServerLauncher.SERVER_SERVICE_NAME), e);
            }
        }

        public Integer getServerPort() {
            return ObjectUtils.defaultIfNull(this.serverPort, ServerLauncher.getDefaultServerPort());
        }

        boolean isServerPortSetByUser() {
            return this.serverPortSetByUser;
        }

        public Builder setServerPort(Integer serverPort) {
            if (serverPort != null && (serverPort < 0 || serverPort > 65535)) {
                throw new IllegalArgumentException(LocalizedStrings.Launcher_Builder_INVALID_PORT_ERROR_MESSAGE.toLocalizedString(ServerLauncher.SERVER_SERVICE_NAME));
            }
            this.serverPort = serverPort;
            this.serverPortSetByUser = true;
            return this;
        }

        public String getSpringXmlLocation() {
            return this.springXmlLocation;
        }

        public Builder setSpringXmlLocation(String springXmlLocation) {
            this.springXmlLocation = springXmlLocation;
            return this;
        }

        public String getWorkingDirectory() {
            return IOUtils.tryGetCanonicalPathElseGetAbsolutePath(new File(StringUtils.defaultIfBlank(this.workingDirectory, AbstractLauncher.DEFAULT_WORKING_DIRECTORY)));
        }

        public Builder setWorkingDirectory(String workingDirectory) {
            if (!new File(StringUtils.defaultIfBlank(workingDirectory, AbstractLauncher.DEFAULT_WORKING_DIRECTORY)).isDirectory()) {
                throw new IllegalArgumentException(LocalizedStrings.Launcher_Builder_WORKING_DIRECTORY_NOT_FOUND_ERROR_MESSAGE.toLocalizedString(ServerLauncher.SERVER_SERVICE_NAME), new FileNotFoundException(workingDirectory));
            }
            this.workingDirectory = workingDirectory;
            return this;
        }

        public Float getCriticalHeapPercentage() {
            return this.criticalHeapPercentage;
        }

        public Builder setCriticalHeapPercentage(Float criticalHeapPercentage) {
            if (criticalHeapPercentage != null && (criticalHeapPercentage.floatValue() < 0.0f || criticalHeapPercentage.floatValue() > 100.0f)) {
                throw new IllegalArgumentException("Critical heap percentage must be between 0 and 100");
            }
            this.criticalHeapPercentage = criticalHeapPercentage;
            return this;
        }

        public Float getEvictionHeapPercentage() {
            return this.evictionHeapPercentage;
        }

        public Builder setEvictionHeapPercentage(Float evictionHeapPercentage) {
            if (evictionHeapPercentage != null && (evictionHeapPercentage.floatValue() < 0.0f || evictionHeapPercentage.floatValue() > 100.0f)) {
                throw new IllegalArgumentException("Eviction heap percentage must be between 0 and 100");
            }
            this.evictionHeapPercentage = evictionHeapPercentage;
            return this;
        }

        public Integer getMaxThreads() {
            return this.maxThreads;
        }

        public Builder setMaxThreads(Integer maxThreads) {
            if (maxThreads != null && maxThreads <= 0) {
                throw new IllegalArgumentException("Max threads must be greate than 0");
            }
            this.maxThreads = maxThreads;
            return this;
        }

        public String getHostNameForClients() {
            return this.hostNameForClients;
        }

        public Builder setHostNameForClients(String hostNameForClients) {
            this.hostNameForClients = hostNameForClients;
            return this;
        }

        public Integer getMaxConnections() {
            return this.maxConnections;
        }

        public Builder setMaxConnections(Integer maxConnections) {
            if (maxConnections != null && (maxConnections <= 0 || maxConnections >= Integer.MAX_VALUE)) {
                throw new IllegalArgumentException("Max number of connections must be between 1 2147483647");
            }
            this.maxConnections = maxConnections;
            return this;
        }

        public Integer getMaxMessageCount() {
            return this.maxMessageCount;
        }

        public Builder setMaxMessageCount(Integer maxMessageCount) {
            if (maxMessageCount != null && (maxMessageCount <= 0 || maxMessageCount >= Integer.MAX_VALUE)) {
                throw new IllegalArgumentException("max-message-count must be between 1 2147483647");
            }
            this.maxMessageCount = maxMessageCount;
            return this;
        }

        public Integer getMessageTimeToLive() {
            return this.messageTimeToLive;
        }

        public Builder setMessageTimeToLive(Integer messageTimeToLive) {
            if (messageTimeToLive != null && (messageTimeToLive <= 0 || messageTimeToLive >= Integer.MAX_VALUE)) {
                throw new IllegalArgumentException("message-time-to-live must be between 1 2147483647");
            }
            this.messageTimeToLive = messageTimeToLive;
            return this;
        }

        public Integer getSocketBufferSize() {
            return this.socketBufferSize;
        }

        public Builder setSocketBufferSize(Integer socketBufferSize) {
            if (socketBufferSize != null && (socketBufferSize <= 0 || socketBufferSize >= Integer.MAX_VALUE)) {
                throw new IllegalArgumentException("socket-buffer-size must be between 1 2147483647");
            }
            this.socketBufferSize = socketBufferSize;
            return this;
        }

        public Builder set(String propertyName, String propertyValue) {
            this.distributedSystemProperties.setProperty(propertyName, propertyValue);
            return this;
        }

        public Builder setPdxPersistent(boolean persistent) {
            this.cacheConfig.setPdxPersistent(persistent);
            return this;
        }

        public Builder setPdxDiskStore(String pdxDiskStore) {
            this.cacheConfig.setPdxDiskStore(pdxDiskStore);
            return this;
        }

        public Builder setPdxIgnoreUnreadFields(boolean ignore) {
            this.cacheConfig.setPdxIgnoreUnreadFields(ignore);
            return this;
        }

        public Builder setPdxReadSerialized(boolean readSerialized) {
            this.cacheConfig.setPdxReadSerialized(readSerialized);
            return this;
        }

        public Builder setPdxSerializer(PdxSerializer pdxSerializer) {
            this.cacheConfig.setPdxSerializer(pdxSerializer);
            return this;
        }

        protected void validate() {
            if (!this.isHelping()) {
                this.validateOnStart();
                this.validateOnStatus();
                this.validateOnStop();
            }
        }

        protected void validateOnStart() {
            if (Command.START.equals((Object)this.getCommand())) {
                if (StringUtils.isBlank(this.getMemberName()) && !AbstractLauncher.isSet(System.getProperties(), "gemfire.name") && !AbstractLauncher.isSet(this.getDistributedSystemProperties(), "name") && !AbstractLauncher.isSet(AbstractLauncher.loadGemFireProperties(DistributedSystem.getPropertyFileURL()), "name")) {
                    throw new IllegalStateException(LocalizedStrings.Launcher_Builder_MEMBER_NAME_VALIDATION_ERROR_MESSAGE.toLocalizedString(ServerLauncher.SERVER_SERVICE_NAME));
                }
                if (!SystemUtils.CURRENT_DIRECTORY.equals(this.getWorkingDirectory())) {
                    throw new IllegalStateException(LocalizedStrings.Launcher_Builder_WORKING_DIRECTORY_OPTION_NOT_VALID_ERROR_MESSAGE.toLocalizedString(ServerLauncher.SERVER_SERVICE_NAME));
                }
            }
        }

        protected void validateOnStatus() {
            if (Command.STATUS.equals((Object)this.getCommand())) {
                // empty if block
            }
        }

        protected void validateOnStop() {
            if (Command.STOP.equals((Object)this.getCommand())) {
                // empty if block
            }
        }

        public ServerLauncher build() {
            this.validate();
            return new ServerLauncher(this);
        }
    }

    private class ServerControllerParameters
    implements ProcessControllerParameters {
        private ServerControllerParameters() {
        }

        @Override
        public File getPidFile() {
            return ServerLauncher.this.getServerPidFile();
        }

        @Override
        public File getWorkingDirectory() {
            return new File(ServerLauncher.this.getWorkingDirectory());
        }

        @Override
        public int getProcessId() {
            return ServerLauncher.this.getPid();
        }

        @Override
        public ProcessType getProcessType() {
            return ProcessType.SERVER;
        }

        @Override
        public ObjectName getNamePattern() {
            try {
                return ObjectName.getInstance("GemFire:type=Member,*");
            }
            catch (MalformedObjectNameException e) {
                return null;
            }
            catch (NullPointerException e) {
                return null;
            }
        }

        @Override
        public String getPidAttribute() {
            return "ProcessId";
        }

        @Override
        public String getStopMethod() {
            return "shutDownMember";
        }

        @Override
        public String getStatusMethod() {
            return "status";
        }

        @Override
        public String[] getAttributes() {
            return new String[]{ServerLauncher.SERVER_SERVICE_NAME};
        }

        @Override
        public Object[] getValues() {
            return new Object[]{Boolean.TRUE};
        }
    }
}

