/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.distributed;

import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.internal.InternalLocator;
import com.gemstone.gemfire.internal.DistributionLocator;
import com.gemstone.gemfire.internal.SocketCreator;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;

public abstract class Locator {
    protected File logFile;
    protected int port;
    protected InetAddress bindAddress;
    protected String hostnameForClients;
    protected static boolean loadSharedConfig = false;

    public static Locator startLocator(int port, File logFile) throws IOException {
        return Locator.startLocator(port, logFile, false, null, null, true, false, null);
    }

    public static Locator startLocatorAndDS(int port, File logFile, Properties distributedSystemProperties) throws IOException {
        return Locator.startLocator(port, logFile, null, distributedSystemProperties, true, true, null);
    }

    public static Locator startLocator(int port, File logFile, InetAddress bindAddress) throws IOException {
        return Locator.startLocator(port, logFile, false, bindAddress, null, true, false, null);
    }

    public static Locator startLocatorAndDS(int port, File logFile, InetAddress bindAddress, Properties dsProperties) throws IOException {
        return Locator.startLocator(port, logFile, bindAddress, dsProperties, true, true, null);
    }

    public static Locator startLocatorAndDS(int port, File logFile, InetAddress bindAddress, Properties dsProperties, boolean peerLocator, boolean serverLocator, String hostnameForClients) throws IOException {
        return Locator.startLocator(port, logFile, bindAddress, dsProperties, peerLocator, serverLocator, hostnameForClients);
    }

    private static Locator startLocator(int port, File logFile, InetAddress bindAddress, Properties dsProperties, boolean peerLocator, boolean serverLocator, String hostnameForClients) throws IOException {
        return InternalLocator.startLocator(port, logFile, null, null, null, bindAddress, dsProperties, peerLocator, serverLocator, hostnameForClients, loadSharedConfig);
    }

    private static Locator startLocator(int port, File logFile, boolean startDistributedSystem, InetAddress bindAddress, Properties dsProperties, boolean peerLocator, boolean serverLocator, String hostnameForClients) throws IOException {
        return InternalLocator.startLocator(port, logFile, null, null, null, bindAddress, startDistributedSystem, dsProperties, peerLocator, serverLocator, hostnameForClients, loadSharedConfig);
    }

    public static List<Locator> getLocators() {
        Locator result = Locator.getLocator();
        if (result == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(result);
    }

    public static Locator getLocator() {
        return InternalLocator.getLocator();
    }

    public static boolean hasLocators() {
        return Locator.hasLocator();
    }

    public static boolean hasLocator() {
        return InternalLocator.hasLocator();
    }

    public int getPort() {
        return this.port;
    }

    public abstract DistributedSystem getDistributedSystem();

    public File getLogFile() {
        return this.logFile;
    }

    public InetAddress getBindAddress() {
        return this.bindAddress;
    }

    public String getHostnameForClients() {
        String result = this.hostnameForClients;
        if (result != null && result.equals("")) {
            result = null;
        }
        return result;
    }

    public abstract ConcurrentMap<Integer, Set<String>> getAllServerLocatorsInfo();

    public abstract Set<String> getRemoteLocatorInfo(int var1);

    public abstract boolean isPeerLocator();

    public abstract boolean isServerLocator();

    public abstract void stop();

    public String toString() {
        return LocalizedStrings.DistributionLocator_DISTRIBUTION_LOCATOR_ON_0.toLocalizedString(this.asString());
    }

    public String asString() {
        Object ba = this.bindAddress;
        if (ba == null) {
            try {
                ba = SocketCreator.getHostName(SocketCreator.getLocalHost());
            }
            catch (UnknownHostException uh) {
                // empty catch block
            }
        }
        StringBuilder locatorString = new StringBuilder(String.valueOf(ba));
        locatorString.append('[').append(this.port).append(']');
        return locatorString.toString();
    }

    public static void main(String[] args) {
        DistributionLocator.main(args);
    }
}

