/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.util;

import com.gemstone.gemfire.admin.AdminDistributedSystem;
import com.gemstone.gemfire.admin.SystemMembershipEvent;
import com.gemstone.gemfire.admin.SystemMembershipListener;
import com.gemstone.gemfire.cache.util.BridgeMembership;
import com.gemstone.gemfire.cache.util.BridgeMembershipEvent;
import com.gemstone.gemfire.cache.util.BridgeMembershipListener;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.internal.Assert;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;

public abstract class UniversalMembershipListenerAdapter
implements SystemMembershipListener {
    public static final int DEFAULT_HISTORY_SIZE = 100;
    protected final int historySize;
    protected final LinkedList<String> eventHistory;
    protected final Map<String, Boolean> eventJoined;
    private final BridgeMembershipListener bridgeMembershipListener = new BridgeMembershipListener(){

        @Override
        public void memberJoined(BridgeMembershipEvent event) {
            UniversalMembershipListenerAdapter.this.systemMembershipListener.memberJoined(new AdaptedMembershipEvent(event));
        }

        @Override
        public void memberLeft(BridgeMembershipEvent event) {
            UniversalMembershipListenerAdapter.this.systemMembershipListener.memberLeft(new AdaptedMembershipEvent(event));
        }

        @Override
        public void memberCrashed(BridgeMembershipEvent event) {
            UniversalMembershipListenerAdapter.this.systemMembershipListener.memberCrashed(new AdaptedMembershipEvent(event));
        }
    };
    protected final SystemMembershipListener systemMembershipListener = new SystemMembershipListener(){

        @Override
        public void memberJoined(SystemMembershipEvent event) {
            if (!this.isDuplicate(event, true)) {
                UniversalMembershipListenerAdapter.this.memberJoined(event);
            }
        }

        @Override
        public void memberLeft(SystemMembershipEvent event) {
            if (!this.isDuplicate(event, false)) {
                UniversalMembershipListenerAdapter.this.memberLeft(event);
            }
        }

        @Override
        public void memberCrashed(SystemMembershipEvent event) {
            if (!this.isDuplicate(event, false)) {
                UniversalMembershipListenerAdapter.this.memberCrashed(event);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean isDuplicate(SystemMembershipEvent event, boolean joined) {
            LinkedList<String> linkedList = UniversalMembershipListenerAdapter.this.eventHistory;
            synchronized (linkedList) {
                boolean duplicate = false;
                String memberId = event.getMemberId();
                int indexOf = UniversalMembershipListenerAdapter.this.eventHistory.indexOf(memberId);
                if (indexOf > -1) {
                    if (UniversalMembershipListenerAdapter.this.eventJoined.get(memberId) == joined) {
                        duplicate = true;
                    } else {
                        Assert.assertTrue(UniversalMembershipListenerAdapter.this.eventHistory.remove(memberId), "Failed to replace entry in eventHistory for " + memberId);
                        Assert.assertTrue(UniversalMembershipListenerAdapter.this.eventJoined.remove(memberId) != null, "Failed to replace entry in eventJoined for " + memberId);
                    }
                }
                if (!duplicate) {
                    if (UniversalMembershipListenerAdapter.this.eventHistory.size() == UniversalMembershipListenerAdapter.this.historySize) {
                        UniversalMembershipListenerAdapter.this.eventHistory.removeFirst();
                    }
                    UniversalMembershipListenerAdapter.this.eventHistory.addLast(memberId);
                    UniversalMembershipListenerAdapter.this.eventJoined.put(memberId, joined);
                    Assert.assertTrue(UniversalMembershipListenerAdapter.this.eventHistory.size() <= UniversalMembershipListenerAdapter.this.historySize, "Attempted to grow eventHistory beyond maximum of " + UniversalMembershipListenerAdapter.this.historySize);
                }
                return duplicate;
            }
        }
    };

    public UniversalMembershipListenerAdapter() {
        this(100);
    }

    public UniversalMembershipListenerAdapter(int historySize) {
        if (historySize < 10) {
            throw new IllegalArgumentException(LocalizedStrings.UniversalMembershipListenerAdapter_ARGUMENT_HISTORYSIZE_MUST_BE_BETWEEN_10_AND_INTEGERMAX_INT_0.toLocalizedString(historySize));
        }
        this.historySize = historySize;
        this.eventHistory = new LinkedList();
        this.eventJoined = new HashMap<String, Boolean>();
        BridgeMembership.registerBridgeMembershipListener(this.bridgeMembershipListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerMembershipListener(AdminDistributedSystem admin) {
        LinkedList<String> linkedList = this.eventHistory;
        synchronized (linkedList) {
            admin.addMembershipListener(this.systemMembershipListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterMembershipListener(AdminDistributedSystem admin) {
        LinkedList<String> linkedList = this.eventHistory;
        synchronized (linkedList) {
            admin.removeMembershipListener(this.systemMembershipListener);
        }
        this.unregisterBridgeMembershipListener();
    }

    public void registerBridgeMembershipListener() {
        BridgeMembership.registerBridgeMembershipListener(this.bridgeMembershipListener);
    }

    public void unregisterBridgeMembershipListener() {
        BridgeMembership.unregisterBridgeMembershipListener(this.bridgeMembershipListener);
    }

    @Override
    public void memberJoined(SystemMembershipEvent event) {
    }

    @Override
    public void memberLeft(SystemMembershipEvent event) {
    }

    @Override
    public void memberCrashed(SystemMembershipEvent event) {
    }

    public static class AdaptedMembershipEvent
    implements SystemMembershipEvent {
        private final BridgeMembershipEvent event;

        protected AdaptedMembershipEvent(BridgeMembershipEvent event) {
            this.event = event;
        }

        public boolean isClient() {
            return this.event.isClient();
        }

        @Override
        public String getMemberId() {
            return this.event.getMemberId();
        }

        @Override
        public DistributedMember getDistributedMember() {
            return this.event.getMember();
        }

        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            if (other == null) {
                return false;
            }
            if (!(other instanceof AdaptedMembershipEvent)) {
                return false;
            }
            AdaptedMembershipEvent that = (AdaptedMembershipEvent)other;
            return this.event == that.event || this.event != null && this.event.equals(that.event);
        }

        public int hashCode() {
            return this.event.hashCode();
        }

        public String toString() {
            StringBuffer sb = new StringBuffer("[AdaptedMembershipEvent: ");
            sb.append(this.event);
            sb.append("]");
            return sb.toString();
        }
    }
}

