/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.query.internal.types;

import com.gemstone.gemfire.InternalGemFireError;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.query.QueryService;
import com.gemstone.gemfire.cache.query.TypeMismatchException;
import com.gemstone.gemfire.cache.query.internal.Support;
import com.gemstone.gemfire.cache.query.internal.parse.OQLLexerTokenTypes;
import com.gemstone.gemfire.cache.query.internal.types.CollectionTypeImpl;
import com.gemstone.gemfire.cache.query.internal.types.ExtendedNumericComparator;
import com.gemstone.gemfire.cache.query.internal.types.MapTypeImpl;
import com.gemstone.gemfire.cache.query.internal.types.NumericComparator;
import com.gemstone.gemfire.cache.query.internal.types.ObjectTypeImpl;
import com.gemstone.gemfire.cache.query.internal.types.TemporalComparator;
import com.gemstone.gemfire.cache.query.types.MapType;
import com.gemstone.gemfire.cache.query.types.ObjectType;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.pdx.internal.PdxInstanceEnum;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class TypeUtils
implements OQLLexerTokenTypes {
    private static List _numericPrimitiveClasses = Arrays.asList(Byte.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE);
    private static List _numericWrapperClasses = Arrays.asList(Byte.class, Short.class, Integer.class, Long.class, Float.class, Double.class);
    public static final ObjectType OBJECT_TYPE = new ObjectTypeImpl(Object.class);

    private TypeUtils() {
    }

    public static Object checkCast(Object castTarget, Class castClass) {
        if (castTarget == null) {
            return null;
        }
        if (!castClass.isInstance(castTarget)) {
            throw new InternalGemFireError(LocalizedStrings.TypeUtils_EXPECTED_INSTANCE_OF_0_BUT_WAS_1.toLocalizedString(castClass.getName(), castTarget.getClass().getName()));
        }
        return castTarget;
    }

    public static Object compare(Object obj1, Object obj2, int compOp) throws TypeMismatchException {
        if (obj1 == QueryService.UNDEFINED || obj2 == QueryService.UNDEFINED) {
            return QueryService.UNDEFINED;
        }
        if (obj1 == null || obj2 == null) {
            Boolean result = TypeUtils.nullCompare(obj1, obj2, compOp);
            if (result == null) {
                return QueryService.UNDEFINED;
            }
            return result;
        }
        try {
            int r;
            if (obj1 instanceof Date && obj2 instanceof Date) {
                r = TypeUtils.getTemporalComparator().compare(obj1, obj2);
            } else if (obj1.getClass() != obj2.getClass() && obj1 instanceof Number && obj2 instanceof Number) {
                r = TypeUtils.getNumericComparator().compare(obj1, obj2);
            } else {
                if (obj1 instanceof Boolean || obj2 instanceof Boolean) {
                    return TypeUtils.booleanCompare(obj1, obj2, compOp);
                }
                if (obj1 instanceof Comparable && obj2 instanceof Comparable) {
                    r = ((Comparable)obj1).compareTo(obj2);
                } else {
                    if (compOp == 13) {
                        return obj1.equals(obj2);
                    }
                    if (compOp == 20) {
                        return !obj1.equals(obj2);
                    }
                    throw new TypeMismatchException(LocalizedStrings.TypeUtils_UNABLE_TO_USE_A_RELATIONAL_COMPARISON_OPERATOR_TO_COMPARE_AN_INSTANCE_OF_CLASS_0_WITH_AN_INSTANCE_OF_1.toLocalizedString(obj1.getClass().getName(), obj2.getClass().getName()));
                }
            }
            switch (compOp) {
                case 13: {
                    return r == 0;
                }
                case 22: {
                    return r < 0;
                }
                case 18: {
                    return r <= 0;
                }
                case 23: {
                    return r > 0;
                }
                case 19: {
                    return r >= 0;
                }
                case 20: {
                    return r != 0;
                }
            }
            throw new IllegalArgumentException(LocalizedStrings.TypeUtils_UNKNOWN_OPERATOR_0.toLocalizedString(compOp));
        }
        catch (ClassCastException e) {
            if (compOp == 13) {
                return Boolean.FALSE;
            }
            if (compOp == 20) {
                return Boolean.TRUE;
            }
            throw new TypeMismatchException(LocalizedStrings.TypeUtils_UNABLE_TO_COMPARE_OBJECT_OF_TYPE_0_WITH_OBJECT_OF_TYPE_1.toLocalizedString(obj1.getClass().getName(), obj2.getClass().getName()), e);
        }
        catch (TypeMismatchException e) {
            if (compOp == 13) {
                return Boolean.FALSE;
            }
            if (compOp == 20) {
                return Boolean.TRUE;
            }
            throw e;
        }
    }

    public static Comparator getTemporalComparator() {
        return new TemporalComparator();
    }

    public static Comparator getNumericComparator() {
        return new NumericComparator();
    }

    public static Comparator getExtendedNumericComparator() {
        return new ExtendedNumericComparator();
    }

    public static Object indexKeyFor(Object obj) throws TypeMismatchException {
        if (obj == null) {
            return null;
        }
        if (obj instanceof Byte) {
            return ((Byte)obj).intValue();
        }
        if (obj instanceof Short) {
            return ((Short)obj).intValue();
        }
        if (obj instanceof Comparable) {
            if (obj instanceof Enum) {
                obj = new PdxInstanceEnum((Enum)obj);
            }
            return obj;
        }
        throw new TypeMismatchException(LocalizedStrings.TypeUtils_INDEXES_ARE_NOT_SUPPORTED_FOR_TYPE_0.toLocalizedString(obj.getClass().getName()));
    }

    public static Comparator comparatorFor(Class pathType) {
        Iterator i = _numericWrapperClasses.iterator();
        while (i.hasNext()) {
            if (!((Class)i.next()).isAssignableFrom(pathType)) continue;
            return TypeUtils.getNumericComparator();
        }
        i = _numericPrimitiveClasses.iterator();
        while (i.hasNext()) {
            if (!((Class)i.next()).isAssignableFrom(pathType)) continue;
            return TypeUtils.getNumericComparator();
        }
        if (Date.class.isAssignableFrom(pathType)) {
            return TypeUtils.getTemporalComparator();
        }
        return null;
    }

    public static Class indexTypeFor(Class pathType) throws TypeMismatchException {
        if (Character.class.isAssignableFrom(pathType) || Character.TYPE == pathType) {
            return pathType;
        }
        if (Byte.class.isAssignableFrom(pathType) || Short.class.isAssignableFrom(pathType) || Byte.TYPE == pathType || Short.TYPE == pathType) {
            return Integer.class;
        }
        for (Class cls : _numericWrapperClasses) {
            if (!cls.isAssignableFrom(pathType)) continue;
            return pathType;
        }
        for (Class cls : _numericPrimitiveClasses) {
            if (cls != pathType) continue;
            return pathType;
        }
        if (Date.class.isAssignableFrom(pathType) || pathType == String.class) {
            return pathType;
        }
        throw new TypeMismatchException(LocalizedStrings.TypeUtils_INDEXES_ARE_NOT_SUPPORTED_ON_PATHS_OF_TYPE_0.toLocalizedString(pathType.getName()));
    }

    public static boolean areTypesConvertible(Class[] srcTypes, Class[] destTypes) {
        Support.assertArg(srcTypes.length == destTypes.length, "Arguments 'srcTypes' and 'destTypes' must be of same length");
        for (int i = 0; i < srcTypes.length; ++i) {
            if (TypeUtils.isTypeConvertible(srcTypes[i], destTypes[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean isTypeConvertible(Class srcType, Class destType) {
        if (srcType == null) {
            return Object.class.isAssignableFrom(destType);
        }
        if (destType.isAssignableFrom(srcType)) {
            return true;
        }
        if (!(srcType != Boolean.TYPE && srcType != Boolean.class || destType != Boolean.TYPE && destType != Boolean.class)) {
            return true;
        }
        int i = _numericPrimitiveClasses.indexOf(srcType);
        if (i < 0) {
            i = _numericWrapperClasses.indexOf(srcType);
        }
        int destP = _numericPrimitiveClasses.indexOf(destType);
        int destW = -1;
        if (destP < 0) {
            destW = _numericWrapperClasses.indexOf(destType);
        }
        if (i >= 0 && destW == i) {
            return true;
        }
        if (i >= 0 && destP >= i) {
            return true;
        }
        return !(srcType != Character.class && srcType != Character.TYPE || destType != Character.class && destType != Character.TYPE);
    }

    private static boolean booleanCompare(Object obj1, Object obj2, int compOp) throws TypeMismatchException {
        if (!(obj1 instanceof Boolean) || !(obj2 instanceof Boolean)) {
            throw new TypeMismatchException(LocalizedStrings.TypeUtils_BOOLEANS_CAN_ONLY_BE_COMPARED_WITH_BOOLEANS.toLocalizedString());
        }
        if (compOp == 13) {
            return obj1.equals(obj2);
        }
        if (compOp == 20) {
            return !obj1.equals(obj2);
        }
        throw new TypeMismatchException(LocalizedStrings.TypeUtils_BOOLEAN_VALUES_CAN_ONLY_BE_COMPARED_WITH_OR.toLocalizedString());
    }

    private static Boolean nullCompare(Object obj1, Object obj2, int compOp) {
        switch (compOp) {
            case 13: {
                if (obj1 == null) {
                    return obj2 == null;
                }
                return Boolean.FALSE;
            }
            case 20: {
                if (obj1 == null) {
                    return obj2 != null;
                }
                return Boolean.TRUE;
            }
        }
        return null;
    }

    public static boolean isMap(ObjectType objType) {
        return objType instanceof MapType;
    }

    public static ObjectType getObjectType(Class cls) {
        if (cls == Object.class) {
            return OBJECT_TYPE;
        }
        if (Collection.class.isAssignableFrom(cls)) {
            return new CollectionTypeImpl(cls, OBJECT_TYPE);
        }
        if (cls.isArray()) {
            return new CollectionTypeImpl(cls, TypeUtils.getObjectType(cls.getComponentType()));
        }
        if (Region.class.isAssignableFrom(cls)) {
            return new CollectionTypeImpl(cls, OBJECT_TYPE);
        }
        if (Map.class.isAssignableFrom(cls)) {
            return new MapTypeImpl(cls, OBJECT_TYPE, OBJECT_TYPE);
        }
        return new ObjectTypeImpl(cls);
    }

    public static ObjectType getRegionEntryType(Region rgn) {
        return new ObjectTypeImpl(Region.Entry.class);
    }
}

