/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.query.internal.types;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.query.internal.types.ObjectTypeImpl;
import com.gemstone.gemfire.cache.query.types.CollectionType;
import com.gemstone.gemfire.cache.query.types.ObjectType;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;

public class CollectionTypeImpl
extends ObjectTypeImpl
implements CollectionType {
    private static final long serialVersionUID = 892402666471396897L;
    private ObjectType elementType;

    public CollectionTypeImpl() {
    }

    public CollectionTypeImpl(Class clazz, ObjectType elementType) {
        super(clazz);
        this.elementType = elementType;
    }

    public CollectionTypeImpl(String className, ObjectType elementType) throws ClassNotFoundException {
        super(className);
        this.elementType = elementType;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && obj instanceof CollectionTypeImpl && this.elementType.equals(((CollectionTypeImpl)obj).elementType);
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ this.elementType.hashCode();
    }

    @Override
    public String toString() {
        return this.resolveClass().getName() + "<" + this.elementType.resolveClass().getName() + ">";
    }

    @Override
    public boolean allowsDuplicates() {
        Class cls = this.resolveClass();
        return !Set.class.isAssignableFrom(cls) && !Map.class.isAssignableFrom(cls) && !Region.class.isAssignableFrom(cls);
    }

    @Override
    public ObjectType getElementType() {
        return this.elementType;
    }

    @Override
    public boolean isOrdered() {
        Class cls = this.resolveClass();
        return List.class.isAssignableFrom(cls) || SortedSet.class.isAssignableFrom(cls) || cls.isArray() || LinkedHashSet.class.isAssignableFrom(cls);
    }

    @Override
    public boolean isCollectionType() {
        return true;
    }

    @Override
    public boolean isMapType() {
        return false;
    }

    @Override
    public boolean isStructType() {
        return false;
    }

    @Override
    public int getDSFID() {
        return -59;
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.elementType = (ObjectType)DataSerializer.readObject(in);
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        DataSerializer.writeObject(this.elementType, out);
    }
}

