/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.query.internal.index;

import com.gemstone.gemfire.cache.query.internal.index.IndexManager;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;

public class IndexElemArray
implements Iterable,
Collection {
    private Object[] elementData;
    private volatile byte size;

    public IndexElemArray(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Illegal Capacity: " + initialCapacity);
        }
        this.elementData = new Object[initialCapacity];
    }

    public IndexElemArray() {
        this(IndexManager.INDEX_ELEMARRAY_SIZE);
    }

    private void ensureCapacity(int minCapacity) {
        int oldCapacity = this.elementData.length;
        if (minCapacity > oldCapacity) {
            int newCapacity = oldCapacity + 5;
            if (newCapacity < minCapacity) {
                newCapacity = minCapacity;
            }
            Object[] newElementData = new Object[newCapacity];
            System.arraycopy(this.elementData, 0, newElementData, 0, this.elementData.length);
            this.elementData = newElementData;
        }
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public boolean contains(Object o) {
        return this.indexOf(o) >= 0;
    }

    public int indexOf(Object o) {
        if (o == null) {
            for (int i = 0; i < this.size; ++i) {
                if (this.elementData[i] != null) continue;
                return i;
            }
        } else {
            for (int i = 0; i < this.size; ++i) {
                if (!o.equals(this.elementData[i])) continue;
                return i;
            }
        }
        return -1;
    }

    public Object get(int index2) {
        this.RangeCheck(index2);
        return this.elementData[index2];
    }

    public Object set(int index2, Object element) {
        this.RangeCheck(index2);
        Object oldValue = this.elementData[index2];
        this.elementData[index2] = element;
        return oldValue;
    }

    public synchronized boolean add(Object e) {
        this.ensureCapacity(this.size + 1);
        this.elementData[this.size] = e;
        this.size = (byte)(this.size + 1);
        return true;
    }

    @Override
    public synchronized boolean remove(Object o) {
        if (o == null) {
            for (int index2 = 0; index2 < this.size; ++index2) {
                if (this.elementData[index2] != null) continue;
                this.fastRemove(index2);
                return true;
            }
        } else {
            for (int index3 = 0; index3 < this.size; ++index3) {
                if (!o.equals(this.elementData[index3])) continue;
                this.fastRemove(index3);
                return true;
            }
        }
        return false;
    }

    private void fastRemove(int index2) {
        int len = this.elementData.length;
        Object[] newArray = new Object[len - 1];
        System.arraycopy(this.elementData, 0, newArray, 0, index2);
        int numMoved = len - index2 - 1;
        if (numMoved > 0) {
            System.arraycopy(this.elementData, index2 + 1, newArray, index2, numMoved);
        }
        this.elementData = newArray;
        this.size = (byte)(this.size - 1);
    }

    @Override
    public void clear() {
        for (int i = 0; i < this.size; ++i) {
            this.elementData[i] = null;
        }
        this.size = 0;
    }

    private void RangeCheck(int index2) {
        if (index2 >= this.size) {
            throw new IndexOutOfBoundsException("Index: " + index2 + ", Size: " + this.size);
        }
    }

    public synchronized boolean addAll(Collection c) {
        Object[] a = c.toArray();
        int numNew = a.length;
        this.ensureCapacity(this.size + numNew);
        System.arraycopy(a, 0, this.elementData, this.size, numNew);
        this.size = (byte)(this.size + numNew);
        return numNew != 0;
    }

    @Override
    public Object[] toArray() {
        return Arrays.copyOf(this.elementData, (int)this.size);
    }

    @Override
    public Iterator iterator() {
        return new IndexArrayListIterator();
    }

    public Object[] toArray(Object[] a) {
        throw new UnsupportedOperationException("toArray(Object[] a) method is not supported");
    }

    public boolean containsAll(Collection c) {
        throw new UnsupportedOperationException("containsAll() method is not supported");
    }

    public boolean removeAll(Collection c) {
        throw new UnsupportedOperationException("removeAll() method is not supported");
    }

    public boolean retainAll(Collection c) {
        throw new UnsupportedOperationException("retainAll() method is not supported");
    }

    public Object[] getElementData() {
        return this.elementData;
    }

    private class IndexArrayListIterator
    implements Iterator {
        private byte current;
        private Object currentEntry;

        private IndexArrayListIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.current < IndexElemArray.this.size;
        }

        public Object next() {
            try {
                byte by = this.current;
                this.current = (byte)(by + 1);
                this.currentEntry = IndexElemArray.this.elementData[by];
            }
            catch (IndexOutOfBoundsException e) {
                return null;
            }
            return this.currentEntry;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove() method is not supported");
        }
    }
}

