/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.query.internal.index;

import com.gemstone.gemfire.cache.query.TypeMismatchException;
import com.gemstone.gemfire.cache.query.internal.AttributeDescriptor;
import com.gemstone.gemfire.cache.query.internal.index.AbstractIndex;
import com.gemstone.gemfire.cache.query.internal.index.HashIndexStrategy;
import com.gemstone.gemfire.cache.query.internal.index.IndexConcurrentHashSet;
import com.gemstone.gemfire.cache.query.internal.index.IndexElemArray;
import com.gemstone.gemfire.cache.query.internal.index.IndexManager;
import com.gemstone.gemfire.cache.query.internal.types.TypeUtils;
import com.gemstone.gemfire.internal.cache.CachePerfStats;
import com.gemstone.gemfire.internal.cache.CachedDeserializable;
import com.gemstone.gemfire.internal.cache.RegionEntry;
import com.gemstone.gnu.trove.PrimeFinder;
import com.gemstone.gnu.trove.THashMap;
import com.gemstone.gnu.trove.TObjectProcedure;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;

public class HashIndexSet
implements Set {
    private transient CachePerfStats cacheStats;
    protected transient int _size;
    protected transient int _free;
    protected transient int _removedTokens;
    protected static final float DEFAULT_LOAD_FACTOR = 0.5f;
    protected static final int DEFAULT_INITIAL_CAPACITY = 100;
    protected float _loadFactor;
    protected int _maxSize;
    protected static final int CONDITIONAL_COMPACT_FACTOR = 2;
    protected static final float CONDITIONAL_REMOVED_TOKEN_REHASH_FACTOR = 0.7f;
    protected transient Object[] _set;
    protected HashIndexStrategy _hashingStrategy;
    protected static final Object REMOVED = new Object();
    static boolean TEST_ALWAYS_REHASH = false;
    private ConcurrentMap<Object, Object> entryToValuesMap;
    protected ThreadLocal<THashMap> entryToOldKeysMap;
    protected AbstractIndex.InternalIndexStatistics internalIndexStats;
    private AttributeDescriptor attDesc;

    public HashIndexSet() {
        this(100, 0.5f);
    }

    public HashIndexSet(ConcurrentMap reverseMap, ThreadLocal<THashMap> entryToOldKeysMap, AbstractIndex.InternalIndexStatistics internalIndexStats) {
        this(100, 0.5f);
        this.entryToValuesMap = reverseMap;
        this.entryToOldKeysMap = entryToOldKeysMap;
        this.internalIndexStats = internalIndexStats;
    }

    public HashIndexSet(HashIndexStrategy strategy) {
        this(100, 0.5f);
        this._hashingStrategy = strategy;
    }

    public HashIndexSet(int initialCapacity) {
        this(initialCapacity, 0.5f);
    }

    public HashIndexSet(int initialCapacity, HashIndexStrategy strategy) {
        this(initialCapacity, 0.5f);
        this._hashingStrategy = strategy;
    }

    public HashIndexSet(int initialCapacity, float loadFactor) {
        this._loadFactor = loadFactor;
        this.setUp((int)Math.ceil((float)initialCapacity / loadFactor));
    }

    public HashIndexSet(int initialCapacity, float loadFactor, HashIndexStrategy strategy) {
        this(initialCapacity, loadFactor);
        this._hashingStrategy = strategy;
    }

    public HashIndexSet(Collection collection) {
        this(collection.size());
        this.addAll(collection);
    }

    public HashIndexSet(Collection collection, HashIndexStrategy strategy) {
        this(collection.size(), strategy);
        this.addAll(collection);
    }

    public void setHashIndexStrategy(HashIndexStrategy hashingStrategy) {
        this._hashingStrategy = hashingStrategy;
    }

    public void setCachePerfStats(CachePerfStats stats) {
        this.cacheStats = stats;
    }

    @Override
    public boolean contains(Object obj) {
        return this.index(obj) >= 0;
    }

    private int computeHash(Object object, boolean recomputeKey) {
        return this._hashingStrategy.computeHashCode(object, recomputeKey) & Integer.MAX_VALUE;
    }

    protected int index(Object obj) {
        return this.index(this._hashingStrategy.computeKey(obj), obj);
    }

    protected int index(Object key2, Object obj) {
        return this.index(key2, obj, -1);
    }

    protected int index(Object key2, Object obj, int ignoreThisSlot) {
        Object[] set = this._set;
        int length = set.length;
        int hash = this.computeHash(key2, false);
        int index2 = hash % length;
        Object cur = set[index2];
        long start = -1L;
        if (this.cacheStats != null) {
            HashIndexSet hashIndexSet = this;
            start = hashIndexSet.cacheStats.getStatTime();
        }
        while (cur != null) {
            if (cur != REMOVED && index2 != ignoreThisSlot && cur instanceof RegionEntry && this._hashingStrategy.equalsOnAdd(obj, cur)) {
                return index2;
            }
            int probe = 1 + hash % (length - 2);
            if ((index2 -= probe) < 0) {
                index2 += length;
            }
            cur = set[index2];
        }
        return -1;
    }

    public Iterator getAll() {
        return this.getAllNotMatching(Collections.EMPTY_LIST);
    }

    public Iterator getAllNotMatching(Collection keysToRemove) {
        return new HashIndexSetIterator(keysToRemove, this._set);
    }

    public Iterator get(Object indexKey) {
        return new HashIndexSetIterator(indexKey, this._set);
    }

    private boolean addObjectToSet(Object[] set, int index2, Object newObject) {
        Object oldObject;
        boolean added = true;
        if (index2 < 0) {
            this.throwObjectContractViolation(set[-index2 - 1], newObject);
        }
        if ((oldObject = set[index2]) == null || oldObject == REMOVED) {
            set[index2] = newObject;
        } else if (oldObject instanceof RegionEntry) {
            IndexElemArray elemArray = new IndexElemArray();
            elemArray.add(oldObject);
            elemArray.add(newObject);
            set[index2] = elemArray;
        } else if (oldObject instanceof IndexConcurrentHashSet) {
            added = ((IndexConcurrentHashSet)oldObject).add(newObject);
        } else if (oldObject instanceof IndexElemArray) {
            IndexElemArray elemArray = (IndexElemArray)oldObject;
            if (elemArray.size() >= IndexManager.INDEX_ELEMARRAY_THRESHOLD) {
                IndexConcurrentHashSet<Object> newSet = new IndexConcurrentHashSet<Object>(IndexManager.INDEX_ELEMARRAY_THRESHOLD + 20, 0.75f, 1);
                newSet.addAll(elemArray);
                newSet.add(newObject);
                set[index2] = newSet;
            } else {
                elemArray.add(newObject);
            }
        }
        return added;
    }

    @Override
    public synchronized boolean add(Object obj) {
        throw new UnsupportedOperationException("add(Object) not supported, try add(Object key, Object obj) instead");
    }

    public synchronized boolean add(Object indexKey, Object obj) throws TypeMismatchException {
        Map oldKeyMap;
        Object oldKey = null;
        if (IndexManager.isObjectModificationInplace() && this.entryToValuesMap.containsKey(obj)) {
            oldKey = this.entryToValuesMap.get(obj);
        } else if (!IndexManager.isObjectModificationInplace() && this.entryToOldKeysMap != null && (oldKeyMap = (Map)this.entryToOldKeysMap.get()) != null) {
            oldKey = TypeUtils.indexKeyFor(oldKeyMap.get(obj));
        }
        this.preInsertHook();
        int indexSlot = this.insertionIndex(indexKey, obj, this._set);
        if (indexSlot < 0) {
            return false;
        }
        Object old = this._set[indexSlot];
        boolean added = this.addObjectToSet(this._set, indexSlot, obj);
        if (added) {
            if (IndexManager.isObjectModificationInplace()) {
                this.entryToValuesMap.put(obj, indexKey);
            }
            if (indexKey != null && oldKey != null) {
                this.remove(oldKey, obj, false, indexSlot);
            }
            this.internalIndexStats.incNumValues(1);
        }
        if (old == null) {
            this.postInsertHook(true);
        } else {
            this.postInsertHook(false);
        }
        return added;
    }

    protected int insertionIndex(Object obj) {
        return this.insertionIndex(this._hashingStrategy.computeKey(obj), obj, this._set);
    }

    protected int insertionIndex(Object obj, Object[] set) {
        return this.insertionIndex(this._hashingStrategy.computeKey(obj), obj, set);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int insertionIndex(Object indexKey, Object obj, Object[] set) {
        int length = set.length;
        int hash = this.computeHash(indexKey, false);
        int indexSlot = hash % length;
        Object cur = set[indexSlot];
        if (cur == null) {
            return indexSlot;
        }
        long start = -1L;
        if (this.cacheStats != null) {
            HashIndexSet hashIndexSet = this;
            start = hashIndexSet.cacheStats.getStatTime();
            this.cacheStats.incQueryResultsHashCollisions();
        }
        try {
            int probe = 1 + hash % (length - 2);
            if (cur != REMOVED) {
                do {
                    if ((indexSlot -= probe) >= 0) continue;
                    indexSlot += length;
                } while ((cur = set[indexSlot]) != null && cur != REMOVED);
            }
            int n = indexSlot;
            return n;
        }
        finally {
            if (this.cacheStats != null) {
                this.cacheStats.endQueryResultsHashCollisionProbe(start);
            }
        }
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof Set)) {
            return false;
        }
        Set that = (Set)other;
        if (that.size() != this.size()) {
            return false;
        }
        return this.containsAll((Collection)that);
    }

    @Override
    public int hashCode() {
        HashProcedure p = new HashProcedure();
        this.forEach(p);
        return p.getHashCode();
    }

    public boolean forEach(TObjectProcedure procedure) {
        Object[] set = this._set;
        int i = set.length;
        while (i-- > 0) {
            if (set[i] == null || set[i] == REMOVED || procedure.execute(set[i])) continue;
            return false;
        }
        return true;
    }

    protected void rehash(int newCapacity) {
        if (TEST_ALWAYS_REHASH) {
            Thread.yield();
        }
        int oldCapacity = this._set.length;
        Object[] oldSet = this._set;
        Object[] newSet = new Object[newCapacity];
        this._removedTokens = 0;
        if (IndexManager.isObjectModificationInplace()) {
            this.entryToValuesMap.clear();
        }
        int i = oldCapacity;
        while (i-- > 0) {
            int index2;
            Object o;
            if (oldSet[i] == null || oldSet[i] == REMOVED || !((o = oldSet[i]) instanceof RegionEntry)) continue;
            Object key2 = this._hashingStrategy.computeKey(o);
            if (key2 == null) {
                key2 = IndexManager.NULL;
            }
            if ((index2 = this.insertionIndex(key2, o, newSet)) < 0 || !this.addObjectToSet(newSet, index2, o)) continue;
            this.updateReverseMap(o, key2);
        }
        this._set = newSet;
    }

    private void updateReverseMap(Object regionEntry, Object key2) {
        if (IndexManager.isObjectModificationInplace()) {
            this.entryToValuesMap.put(regionEntry, key2);
        }
    }

    protected final void throwObjectContractViolation(Object o1, Object o2) throws IllegalArgumentException {
        throw new IllegalArgumentException("Equal objects must have equal hashcodes. During rehashing, Trove discovered that the following two objects claim to be equal (as in java.lang.Object.equals()) but their hashCodes (or those calculated by your HashIndexStrategy) are not equal.This violates the general contract of java.lang.Object.hashCode().  See bullet point two in that method's documentation. object #1 =" + HashIndexSet.objToString(o1) + "; object #2 =" + HashIndexSet.objToString(o2));
    }

    private static String objToString(Object o) {
        if (o instanceof Object[]) {
            return Arrays.toString((Object[])o);
        }
        return String.valueOf(o);
    }

    @Override
    public Object[] toArray() {
        throw new UnsupportedOperationException("toArray not yet supported");
    }

    @Override
    public Object[] toArray(Object[] a) {
        throw new UnsupportedOperationException("toArray(Object[] a) not yet supported");
    }

    @Override
    public void clear() {
        this._size = 0;
        this._free = this.capacity();
        this._removedTokens = 0;
        if (IndexManager.isObjectModificationInplace()) {
            this.entryToValuesMap.clear();
        }
        Object[] set = this._set;
        int i = set.length;
        while (i-- > 0) {
            set[i] = null;
        }
    }

    protected int capacity() {
        return this._set.length;
    }

    @Override
    public boolean remove(Object obj) {
        throw new UnsupportedOperationException("remove(Object) not supported, try remove(Object key, Object obj) instead");
    }

    public synchronized boolean remove(Object key2, Object obj, boolean updateReverseMap) {
        return this.remove(key2, obj, updateReverseMap, -1);
    }

    public synchronized boolean remove(Object key2, Object obj, boolean updateReverseMap, int newIndexSlot) {
        int indexSlot = this.index(key2, obj, newIndexSlot);
        boolean removed = false;
        if (indexSlot >= 0 && indexSlot != newIndexSlot) {
            removed = this.removeAt(indexSlot);
            if (removed) {
                if (updateReverseMap && IndexManager.isObjectModificationInplace()) {
                    this.entryToValuesMap.remove(obj);
                }
                this.internalIndexStats.incNumValues(-1);
            }
            return removed;
        }
        if (!IndexManager.isObjectModificationInplace()) {
            HashIndexSetIterator iterator = (HashIndexSetIterator)this.getAll();
            while (iterator.hasNext()) {
                Object indexedObject = iterator.next();
                if (!this._hashingStrategy.equalsOnAdd(indexedObject, obj) || iterator.currentObjectIndex() == newIndexSlot) continue;
                iterator.remove();
                this.internalIndexStats.incNumValues(-1);
                return true;
            }
        }
        return false;
    }

    @Override
    public Iterator iterator() {
        return this.getAll();
    }

    @Override
    public boolean containsAll(Collection collection) {
        Iterator i = collection.iterator();
        while (i.hasNext()) {
            if (this.contains(i.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection collection) {
        boolean changed = false;
        int size2 = collection.size();
        this.ensureCapacity(size2);
        Iterator it = collection.iterator();
        while (size2-- > 0) {
            Object obj = it.next();
            if (obj == null || !this.add(obj)) continue;
            changed = true;
        }
        return changed;
    }

    @Override
    public boolean removeAll(Collection collection) {
        boolean changed = false;
        int size2 = collection.size();
        Iterator it = collection.iterator();
        while (size2-- > 0) {
            if (!this.remove(it.next())) continue;
            changed = true;
        }
        return changed;
    }

    @Override
    public boolean retainAll(Collection collection) {
        boolean changed = false;
        int size2 = this.size();
        Iterator it = this.iterator();
        while (size2-- > 0) {
            if (collection.contains(it.next())) continue;
            it.remove();
            changed = true;
        }
        return changed;
    }

    @Override
    public boolean isEmpty() {
        return 0 == this._size;
    }

    @Override
    public int size() {
        return this._size;
    }

    public int size(Object indexKey) {
        int size2 = 0;
        Object[] set = this._set;
        int length = set.length;
        int hash = this.computeHash(indexKey, false);
        int index2 = hash % length;
        Object cur = set[index2];
        if (cur == null) {
            return 0;
        }
        while (cur != null) {
            if (cur != REMOVED) {
                if (!(cur instanceof RegionEntry) || !this._hashingStrategy.equalsOnGet(indexKey, cur)) break;
                ++size2;
                break;
            }
            int probe = 1 + hash % (length - 2);
            if ((index2 -= probe) < 0) {
                index2 += length;
            }
            cur = set[index2];
        }
        return size2;
    }

    public void ensureCapacity(int desiredCapacity) {
        if (desiredCapacity > this._maxSize - this.size()) {
            this.rehash(PrimeFinder.nextPrime((int)Math.ceil((float)desiredCapacity + (float)this.size() / this._loadFactor) + 1));
            this.computeMaxSize(this.capacity());
        }
    }

    public void compact() {
        this.rehash(PrimeFinder.nextPrime((int)Math.ceil((float)this.size() / this._loadFactor) + 1));
        this.computeMaxSize(this.capacity());
    }

    public void conditionalCompact() {
        if ((float)this._size < (float)this.capacity() * (this._loadFactor / 2.0f)) {
            this.compact();
        }
    }

    public final void trimToSize() {
        this.compact();
    }

    protected boolean removeAt(int index2) {
        Object cur = this._set[index2];
        if (cur == null || cur == REMOVED) {
            return false;
        }
        this._set[index2] = REMOVED;
        --this._size;
        ++this._removedTokens;
        return true;
    }

    protected int setUp(int initialCapacity) {
        int capacity = PrimeFinder.nextPrime(initialCapacity);
        this.computeMaxSize(capacity);
        this._set = new Object[capacity];
        return capacity;
    }

    private final void computeMaxSize(int capacity) {
        this._maxSize = Math.min(capacity - 1, (int)Math.floor((float)capacity * this._loadFactor));
        this._free = capacity - this._size;
    }

    protected final void postInsertHook(boolean usedFreeSlot) {
        if (usedFreeSlot) {
            --this._free;
        } else {
            --this._removedTokens;
        }
        ++this._size;
    }

    protected final void preInsertHook() {
        if (this._size > this._maxSize || this._free == 0 || TEST_ALWAYS_REHASH) {
            int newCapacity = this._size > this._maxSize ? PrimeFinder.nextPrime(this.capacity() << 1) : this.capacity();
            this.rehash(newCapacity);
            this.computeMaxSize(this.capacity());
        } else if ((float)this._removedTokens > (float)this._maxSize * 0.7f) {
            this.compact();
        }
    }

    public String printAll() {
        StringBuffer s = new StringBuffer();
        for (int i = 0; i < this._set.length; ++i) {
            Object object = this._set[i];
            if (object == null || object == REMOVED) continue;
            s.append("\n slot[" + i + "]:");
            if (object instanceof Collection) {
                for (Object o : (Collection)object) {
                    if (o == null) continue;
                    RegionEntry re = (RegionEntry)o;
                    Object val = re._getValue();
                    if (val instanceof CachedDeserializable) {
                        val = ((CachedDeserializable)val).getDeserializedForReading();
                    }
                    s.append(re.getKey() + " =>  " + val + " # ");
                }
                continue;
            }
            RegionEntry re = (RegionEntry)object;
            Object val = re._getValue();
            if (val instanceof CachedDeserializable) {
                val = ((CachedDeserializable)val).getDeserializedForReading();
            }
            s.append(re.getKey() + " =>  " + val);
        }
        return s.toString();
    }

    private class HashIndexSetIterator
    implements Iterator {
        private Object keyToMatch;
        private final Object[] objects;
        private int indexSlot;
        private Collection keysToRemove;
        private Object current;
        private int hash;
        private int length;
        private int probe;

        private HashIndexSetIterator(Collection keysToRemove, Object[] objects) {
            this.keysToRemove = keysToRemove;
            this.indexSlot = 0;
            this.objects = objects;
            this.current = objects[this.indexSlot];
        }

        private HashIndexSetIterator(Object keyToMatch, Object[] objects) {
            this.keyToMatch = keyToMatch;
            this.objects = objects;
            this.length = objects.length;
            this.hash = HashIndexSet.this.computeHash(keyToMatch, false);
            this.probe = 1 + this.hash % (this.length - 2);
            this.indexSlot = this.hash % this.length;
            this.current = objects[this.indexSlot];
        }

        @Override
        public boolean hasNext() {
            if (this.keysToRemove != null) {
                while (this.indexSlot < this.objects.length) {
                    this.current = this.objects[this.indexSlot];
                    if (this.current != null && !this.current.equals(REMOVED) && this.notMatchingAnyKeyToRemove(this.keysToRemove, this.current)) {
                        return true;
                    }
                    ++this.indexSlot;
                }
                return false;
            }
            this.current = this.objects[this.indexSlot];
            while (this.current != null) {
                if (this.current != REMOVED && HashIndexSet.this._hashingStrategy.equalsOnGet(this.keyToMatch, this.current)) {
                    return true;
                }
                this.indexSlot -= this.probe;
                if (this.indexSlot < 0) {
                    this.indexSlot += this.length;
                }
                this.current = this.objects[this.indexSlot];
            }
            return false;
        }

        private boolean notMatchingAnyKeyToRemove(Collection keysToRemove, Object current) {
            for (Object keyToMatch : keysToRemove) {
                if (!HashIndexSet.this._hashingStrategy.equalsOnGet(keyToMatch, current)) continue;
                return false;
            }
            return true;
        }

        public Object next() throws NoSuchElementException {
            Object obj = this.current;
            if (this.keysToRemove != null) {
                ++this.indexSlot;
            } else {
                this.indexSlot -= this.probe;
                if (this.indexSlot < 0) {
                    this.indexSlot += this.length;
                }
            }
            return obj;
        }

        int currentObjectIndex() {
            int indexToRemove = 0;
            if (this.keysToRemove != null) {
                indexToRemove = this.indexSlot - 1;
            } else {
                indexToRemove = this.indexSlot + this.probe;
                if (this.indexSlot >= this.objects.length) {
                    indexToRemove = this.indexSlot - this.length;
                }
            }
            return indexToRemove;
        }

        @Override
        public void remove() {
            HashIndexSet.this.removeAt(this.currentObjectIndex());
        }
    }

    final class ToObjectArrayProcedure
    implements TObjectProcedure {
        private final Object[] target;
        private int pos = 0;

        public ToObjectArrayProcedure(Object[] target) {
            this.target = target;
        }

        @Override
        public final boolean execute(Object value2) {
            this.target[this.pos++] = value2;
            return true;
        }
    }

    protected final class HashProcedure
    implements TObjectProcedure {
        private int h = 0;

        protected HashProcedure() {
        }

        public int getHashCode() {
            return this.h;
        }

        @Override
        public final boolean execute(Object key2) {
            this.h += HashIndexSet.this._hashingStrategy.computeHashCode(key2);
            return true;
        }
    }
}

