/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.query.internal.index;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.query.AmbiguousNameException;
import com.gemstone.gemfire.cache.query.IndexInvalidException;
import com.gemstone.gemfire.cache.query.NameResolutionException;
import com.gemstone.gemfire.cache.query.TypeMismatchException;
import com.gemstone.gemfire.cache.query.internal.AbstractCompiledValue;
import com.gemstone.gemfire.cache.query.internal.CompiledBindArgument;
import com.gemstone.gemfire.cache.query.internal.CompiledComparison;
import com.gemstone.gemfire.cache.query.internal.CompiledFunction;
import com.gemstone.gemfire.cache.query.internal.CompiledID;
import com.gemstone.gemfire.cache.query.internal.CompiledIndexOperation;
import com.gemstone.gemfire.cache.query.internal.CompiledIteratorDef;
import com.gemstone.gemfire.cache.query.internal.CompiledLiteral;
import com.gemstone.gemfire.cache.query.internal.CompiledNegation;
import com.gemstone.gemfire.cache.query.internal.CompiledOperation;
import com.gemstone.gemfire.cache.query.internal.CompiledPath;
import com.gemstone.gemfire.cache.query.internal.CompiledRegion;
import com.gemstone.gemfire.cache.query.internal.CompiledUndefined;
import com.gemstone.gemfire.cache.query.internal.CompiledValue;
import com.gemstone.gemfire.cache.query.internal.ExecutionContext;
import com.gemstone.gemfire.cache.query.internal.MapIndexable;
import com.gemstone.gemfire.cache.query.internal.QRegion;
import com.gemstone.gemfire.cache.query.internal.RuntimeIterator;
import com.gemstone.gemfire.cache.query.internal.index.IndexCreationHelper;
import com.gemstone.gemfire.cache.query.internal.index.IndexManager;
import com.gemstone.gemfire.cache.query.types.ObjectType;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import java.util.ArrayList;
import java.util.List;

class FunctionalIndexCreationHelper
extends IndexCreationHelper {
    private boolean isMapTypeIndex;
    private boolean isAllKeys = false;
    ExecutionContext context = null;
    CompiledValue indexedExpr;
    List fromClauseIterators;
    QRegion region;
    String[] multiIndexKeysPattern;
    Object[] mapKeys;
    List indexInitIterators = null;
    CompiledValue missingLink = null;
    CompiledValue additionalProj = null;
    ObjectType addnlProjType = null;
    CompiledValue modifiedIndexExpr = null;
    boolean isFirstIteratorRegionEntry = false;
    boolean isFirstIteratorRegionKey = false;
    final String imports;

    FunctionalIndexCreationHelper(String fromClause, String indexedExpression, String projectionAttributes, String imports, Cache cache, ExecutionContext externalContext, IndexManager imgr) throws IndexInvalidException {
        super(fromClause, projectionAttributes, cache);
        this.context = externalContext == null ? new ExecutionContext(null, cache) : externalContext;
        this.context.newScope(1);
        this.imports = imports;
        this.prepareFromClause(imgr);
        this.prepareIndexExpression(indexedExpression);
        this.prepareProjectionAttributes(projectionAttributes);
        Object[] data = this.modfiyIterDefToSuiteIMQ((CompiledIteratorDef)this.fromClauseIterators.get(0));
        if (data[0] == null || data[1] == null) {
            throw new IndexInvalidException(LocalizedStrings.FunctionalIndexCreationHelper_INVALID_FROM_CLAUSE_0.toLocalizedString(fromClause));
        }
        this.fromClauseIterators.remove(0);
        this.fromClauseIterators.add(0, data[1]);
        this.region = (QRegion)data[0];
    }

    @Override
    public List getIterators() {
        return this.fromClauseIterators;
    }

    @Override
    public CompiledValue getCompiledIndexedExpression() {
        return this.indexedExpr;
    }

    @Override
    public Region getRegion() {
        return this.region.getRegion();
    }

    @Override
    boolean isMapTypeIndex() {
        return this.isMapTypeIndex;
    }

    boolean isAllKeys() {
        return this.isAllKeys;
    }

    private void prepareFromClause(IndexManager imgr) throws IndexInvalidException {
        List list;
        if (this.imports != null) {
            this.compiler.compileImports(this.imports);
        }
        if ((list = this.compiler.compileFromClause(this.fromClause)) == null) {
            throw new IndexInvalidException(LocalizedStrings.FunctionalIndexCreationHelper_INVALID_FROM_CLAUSE_0.toLocalizedString(this.fromClause));
        }
        boolean isFromClauseNull = true;
        int size2 = list.size();
        this.canonicalizedIteratorNames = new String[size2];
        this.canonicalizedIteratorDefinitions = new String[size2];
        CompiledIteratorDef newItr = null;
        StringBuffer tempBuff = new StringBuffer();
        try {
            PartitionedRegion pr2 = this.context.getPartitionedRegion();
            for (int i = 0; i < size2; ++i) {
                String definition;
                CompiledIteratorDef iterDef = (CompiledIteratorDef)list.get(i);
                iterDef.computeDependencies(this.context);
                RuntimeIterator rIter = iterDef.getRuntimeIterator(this.context);
                this.context.addToIndependentRuntimeItrMapForIndexCreation(iterDef);
                this.context.bindIterator(rIter);
                if (i != 0 && !iterDef.isDependentOnCurrentScope(this.context)) {
                    throw new IndexInvalidException(LocalizedStrings.FunctionalIndexCreationHelper_INVALID_FROM_CLAUSE_0_SUBSEQUENT_ITERATOR_EXPRESSIONS_IN_FROM_CLAUSE_MUST_BE_DEPENDENT_ON_PREVIOUS_ITERATORS.toLocalizedString(this.fromClause));
                }
                this.canonicalizedIteratorDefinitions[i] = definition = rIter.getDefinition();
                this.canonicalizedIteratorNames[i] = imgr.putCanonicalizedIteratorNameIfAbsent(definition);
                this.canonicalizedIteratorNames[i] = pr2 != null ? pr2.getIndexManager().putCanonicalizedIteratorNameIfAbsent(definition) : imgr.putCanonicalizedIteratorNameIfAbsent(definition);
                rIter.setIndexInternalID(this.canonicalizedIteratorNames[i]);
                tempBuff.append(definition).append(' ').append(this.canonicalizedIteratorNames[i]).append(", ");
                isFromClauseNull = false;
                if (i == 0) {
                    CompiledValue cv = iterDef.getCollectionExpr();
                    this.addnlProjType = rIter.getElementType();
                    String name = null;
                    name = iterDef.getName();
                    if (name == null || name.equals("")) {
                        name = this.canonicalizedIteratorNames[i];
                    }
                    AbstractCompiledValue newCollExpr = new CompiledPath(new CompiledBindArgument(1), "entries");
                    if (cv instanceof CompiledRegion) {
                        this.additionalProj = this.missingLink = new CompiledPath(new CompiledID(name), "value");
                    } else if (cv instanceof CompiledOperation || cv instanceof CompiledPath || cv instanceof CompiledIndexOperation) {
                        int secondTokenType;
                        CompiledValue prevCV = null;
                        ArrayList<Object> reconstruct = new ArrayList<Object>();
                        while (!(cv instanceof CompiledRegion)) {
                            prevCV = cv;
                            if (cv instanceof CompiledOperation) {
                                reconstruct.add(0, ((CompiledOperation)cv).getArguments());
                                reconstruct.add(0, ((CompiledOperation)cv).getMethodName());
                                cv = ((CompiledOperation)cv).getReceiver(this.context);
                            } else if (cv instanceof CompiledPath) {
                                reconstruct.add(0, ((CompiledPath)cv).getTailID());
                                cv = ((CompiledPath)cv).getReceiver();
                            } else if (cv instanceof CompiledIndexOperation) {
                                reconstruct.add(0, ((CompiledIndexOperation)cv).getExpression());
                                cv = ((CompiledIndexOperation)cv).getReceiver();
                            } else {
                                throw new IndexInvalidException(LocalizedStrings.FunctionalIndexCreationHelper_FUNCTIONALINDEXCREATIONHELPERPREPAREFROMCLAUSEFROM_CLAUSE_IS_NEITHER_A_COMPILEDPATH_NOR_COMPILEDOPERATION.toLocalizedString());
                            }
                            reconstruct.add(0, prevCV.getType());
                        }
                        int firstTokenType = (Integer)reconstruct.get(0);
                        if (firstTokenType == -5) {
                            String secTokName;
                            String tailID = (String)reconstruct.get(1);
                            if (tailID.equals("asList") || tailID.equals("asSet") || tailID.equals("values") || tailID.equals("toArray") || tailID.equals("getValues")) {
                                this.missingLink = new CompiledPath(new CompiledID(name), "value");
                            } else if (tailID.equals("keys") || tailID.equals("getKeys") || tailID.equals("keySet")) {
                                this.missingLink = new CompiledPath(new CompiledID(name), "key");
                                this.isFirstIteratorRegionKey = true;
                            } else if (tailID.equals("entries") || tailID.equals("getEntries") || tailID.equals("entrySet")) {
                                this.isFirstIteratorRegionEntry = true;
                            } else {
                                throw new IndexInvalidException(LocalizedStrings.FunctionalIndexCreationHelper_FUNCTIONALINDEXCREATIONHELPERPREPAREFROMCLAUSEFROM_CLAUSE_DOES_NOT_EVALUATE_TO_VALID_COLLECTION.toLocalizedString());
                            }
                            this.remove(reconstruct, 2, 0);
                            int n = secondTokenType = reconstruct.size() > 1 ? (Integer)reconstruct.get(0) : -1;
                            if (!this.isFirstIteratorRegionEntry && secondTokenType == 24) {
                                if (!tailID.equals("values") && !tailID.equals("getValues")) {
                                    if (tailID.equals("toList") || tailID.equals("toArray")) {
                                        throw new IndexInvalidException(LocalizedStrings.FunctionalIndexCreationHelper_FUNCTIONALINDEXCREATIONHELPERPREPAREFROMCLAUSETOLIST_TOARRAY_NOT_SUPPORTED.toLocalizedString());
                                    }
                                    throw new IndexInvalidException(LocalizedStrings.FunctionalIndexCreationHelper_FUNCTIONALINDEXCREATIONHELPERPREPAREFROMCLAUSETOLIST_TOARRAY_NOT_SUPPORTED.toLocalizedString());
                                }
                                boolean returnEntryForRegionCollection = true;
                                this.additionalProj = new CompiledIndexOperation(new CompiledBindArgument(1), (CompiledValue)reconstruct.get(1), returnEntryForRegionCollection);
                                this.isFirstIteratorRegionEntry = true;
                                this.remove(reconstruct, 2, 0);
                            } else if (!this.isFirstIteratorRegionEntry && (secondTokenType == 53 || secondTokenType == -5) && (tailID.equals("values") || tailID.equals("getValues") || tailID.equals("keySet") || tailID.equals("keys") || tailID.equals("getKeys")) && ((secTokName = (String)reconstruct.get(1)).equals("asList") || secTokName.equals("asSet") || secTokName.equals("toArray"))) {
                                this.remove(reconstruct, secondTokenType == 53 ? 3 : 2, 0);
                            }
                        } else if (firstTokenType == 24) {
                            boolean returnEntryForRegionCollection = true;
                            this.additionalProj = new CompiledIndexOperation(new CompiledBindArgument(1), (CompiledValue)reconstruct.get(1), returnEntryForRegionCollection);
                            this.isFirstIteratorRegionEntry = true;
                        } else if (firstTokenType == 53) {
                            String secTokName;
                            String methodName = (String)reconstruct.get(1);
                            if (methodName.equals("asList") || methodName.equals("asSet") || methodName.equals("values") || methodName.equals("toArray") || methodName.equals("getValues")) {
                                this.missingLink = new CompiledPath(new CompiledID(name), "value");
                            } else if (methodName.equals("keys") || methodName.equals("getKeys") || methodName.equals("keySet")) {
                                this.missingLink = new CompiledPath(new CompiledID(name), "key");
                                this.isFirstIteratorRegionKey = true;
                            } else if (methodName.equals("entries") || methodName.equals("getEntries") || methodName.equals("entrySet")) {
                                Object obj;
                                this.isFirstIteratorRegionEntry = true;
                                List args = (List)reconstruct.get(2);
                                if (args != null && args.size() == 1 && (obj = args.get(0)) instanceof CompiledBindArgument) {
                                    throw new IndexInvalidException(LocalizedStrings.FunctionalIndexCreationHelper_FUNCTIONALINDEXCREATIONHELPERPREPAREFROMCLAUSEENTRIES_METHOD_CALLED_WITH_COMPILEDBINDARGUMENT.toLocalizedString());
                                }
                            }
                            this.remove(reconstruct, 3, 0);
                            int n = secondTokenType = reconstruct.size() > 1 ? (Integer)reconstruct.get(0) : -1;
                            if (!this.isFirstIteratorRegionEntry && secondTokenType == 24) {
                                if (!methodName.equals("values") && !methodName.equals("getValues")) {
                                    if (methodName.equals("toList") || methodName.equals("toArray")) {
                                        throw new IndexInvalidException(LocalizedStrings.FunctionalIndexCreationHelper_FUNCTIONALINDEXCREATIONHELPERPREPAREFROMCLAUSETOLIST_TOARRAY_NOT_SUPPORTED_YET.toLocalizedString());
                                    }
                                    throw new IndexInvalidException(LocalizedStrings.FunctionalIndexCreationHelper_FUNCTIONALINDEXCREATIONHELPERPREPAREFROMCLAUSETOLIST_TOARRAY_NOT_SUPPORTED_YET.toLocalizedString());
                                }
                                boolean returnEntryForRegionCollection = true;
                                newCollExpr = new CompiledIndexOperation(new CompiledBindArgument(1), (CompiledValue)reconstruct.get(1), returnEntryForRegionCollection);
                                this.remove(reconstruct, 2, 0);
                            } else if (!this.isFirstIteratorRegionEntry && (secondTokenType == 53 || secondTokenType == -5) && (methodName.equals("values") || methodName.equals("getValues") || methodName.equals("keys") || methodName.equals("getKeys") || methodName.equals("keySet")) && ((secTokName = (String)reconstruct.get(1)).equals("asList") || secTokName.equals("asSet") || secTokName.equals("toArray"))) {
                                this.remove(reconstruct, secondTokenType == 53 ? 3 : 2, 0);
                            }
                        }
                        if (!this.isFirstIteratorRegionEntry) {
                            this.additionalProj = this.missingLink;
                            int len = reconstruct.size();
                            for (int j = 0; j < len; ++j) {
                                Object obj = reconstruct.get(j);
                                if (!(obj instanceof Integer)) continue;
                                int tokenType = (Integer)obj;
                                if (tokenType == -5) {
                                    this.additionalProj = new CompiledPath(this.additionalProj, (String)reconstruct.get(++j));
                                    continue;
                                }
                                if (tokenType == 24) {
                                    this.additionalProj = new CompiledIndexOperation(this.additionalProj, (CompiledValue)reconstruct.get(++j));
                                    continue;
                                }
                                if (tokenType != 53) continue;
                                this.additionalProj = new CompiledOperation(this.additionalProj, (String)reconstruct.get(++j), (List)reconstruct.get(++j));
                            }
                        }
                    } else {
                        throw new IndexInvalidException(LocalizedStrings.FunctionalIndexCreationHelper_FUNCTIONALINDEXCREATIONHELPERPREPAREFROMCLAUSEFROM_CLAUSE_IS_NEITHER_A_COMPILEDPATH_NOR_COMPILEDOPERATION.toLocalizedString());
                    }
                    if (this.isFirstIteratorRegionEntry) continue;
                    newItr = new CompiledIteratorDef(name, null, newCollExpr);
                    this.indexInitIterators = new ArrayList();
                    this.indexInitIterators.add(newItr);
                    continue;
                }
                if (this.isFirstIteratorRegionEntry) continue;
                newItr = iterDef;
                if (rIter.getDefinition().indexOf(this.canonicalizedIteratorNames[0]) != -1) {
                    newItr = (CompiledIteratorDef)this.getModifiedDependentCompiledValue(this.context, i, iterDef, true);
                }
                this.indexInitIterators.add(newItr);
            }
        }
        catch (Exception e) {
            if (e instanceof IndexInvalidException) {
                throw (IndexInvalidException)e;
            }
            throw new IndexInvalidException(e);
        }
        if (isFromClauseNull) {
            throw new IndexInvalidException(LocalizedStrings.FunctionalIndexCreationHelper_INVALID_FROM_CLAUSE_0.toLocalizedString(this.fromClause));
        }
        this.fromClause = tempBuff.substring(0, tempBuff.length() - 2);
        this.fromClauseIterators = list;
    }

    private void prepareIndexExpression(String indexedExpression) throws IndexInvalidException {
        CompiledValue expr = this.compiler.compileQuery(indexedExpression);
        if (expr == null) {
            throw new IndexInvalidException(LocalizedStrings.FunctionalIndexCreationHelper_INVALID_INDEXED_EXPRESSION_0.toLocalizedString(indexedExpression));
        }
        if (expr instanceof CompiledUndefined || expr instanceof CompiledLiteral || expr instanceof CompiledComparison || expr instanceof CompiledBindArgument || expr instanceof CompiledNegation) {
            throw new IndexInvalidException(LocalizedStrings.FunctionalIndexCreationHelper_INVALID_INDEXED_EXPRESSION_0.toLocalizedString(indexedExpression));
        }
        try {
            StringBuffer sb = new StringBuffer();
            if (expr instanceof MapIndexable) {
                MapIndexable mi = (MapIndexable)((Object)expr);
                List<CompiledValue> indexingKeys = mi.getIndexingKeys();
                if (indexingKeys.size() == 1 && indexingKeys.get(0) == CompiledValue.MAP_INDEX_ALL_KEYS) {
                    this.isMapTypeIndex = true;
                    this.isAllKeys = true;
                    expr = mi.getRecieverSansIndexArgs();
                    expr.generateCanonicalizedExpression(sb, this.context);
                    sb.append('[').append('*').append(']');
                } else if (indexingKeys.size() == 1) {
                    expr.generateCanonicalizedExpression(sb, this.context);
                } else {
                    this.isMapTypeIndex = true;
                    this.multiIndexKeysPattern = new String[indexingKeys.size()];
                    this.mapKeys = new Object[indexingKeys.size()];
                    expr = mi.getRecieverSansIndexArgs();
                    expr.generateCanonicalizedExpression(sb, this.context);
                    sb.append('[');
                    String prefixStr = sb.toString();
                    StringBuffer buff2 = new StringBuffer();
                    int size2 = indexingKeys.size();
                    for (int j = 0; j < size2; ++j) {
                        CompiledValue cv = indexingKeys.get(size2 - j - 1);
                        this.mapKeys[size2 - j - 1] = cv.evaluate(this.context);
                        StringBuffer sbuff = new StringBuffer();
                        cv.generateCanonicalizedExpression(sbuff, this.context);
                        sbuff.insert(0, prefixStr);
                        sbuff.append(']');
                        this.multiIndexKeysPattern[j] = sbuff.toString();
                        cv.generateCanonicalizedExpression(buff2, this.context);
                        buff2.insert(0, ',');
                    }
                    buff2.deleteCharAt(0);
                    sb.append(buff2.toString());
                    sb.append(']');
                }
            } else {
                expr.generateCanonicalizedExpression(sb, this.context);
            }
            this.indexedExpression = sb.toString();
            this.modifiedIndexExpr = expr;
            if (!this.isFirstIteratorRegionEntry && this.indexedExpression.indexOf(this.canonicalizedIteratorNames[0]) >= 0) {
                this.modifiedIndexExpr = this.getModifiedDependentCompiledValue(this.context, -1, expr, true);
            }
        }
        catch (Exception e) {
            throw new IndexInvalidException(LocalizedStrings.FunctionalIndexCreationHelper_INVALID_INDEXED_EXPRESSION_0.toLocalizedString(indexedExpression), e);
        }
        this.indexedExpr = expr;
    }

    private void prepareProjectionAttributes(String projectionAttributes) throws IndexInvalidException {
        if (projectionAttributes != null && !projectionAttributes.equals("*")) {
            throw new IndexInvalidException(LocalizedStrings.FunctionalIndexCreationHelper_INVALID_PROJECTION_ATTRIBUTES_0.toLocalizedString(projectionAttributes));
        }
        this.projectionAttributes = projectionAttributes;
    }

    private Object[] modfiyIterDefToSuiteIMQ(CompiledIteratorDef iterDef) throws IndexInvalidException {
        Object[] retValues = new Object[]{null, null};
        try {
            CompiledValue def = iterDef.getCollectionExpr();
            if (def instanceof CompiledRegion) {
                CompiledBindArgument bindArg = new CompiledBindArgument(1);
                CompiledIteratorDef newDef = new CompiledIteratorDef(iterDef.getName(), null, bindArg);
                retValues[0] = def.evaluate(this.context);
                retValues[1] = newDef;
                return retValues;
            }
            if (def instanceof CompiledPath || def instanceof CompiledOperation || def instanceof CompiledIndexOperation) {
                CompiledValue cv = def;
                CompiledValue prevCV = null;
                ArrayList<Object> reconstruct = new ArrayList<Object>();
                while (!(cv instanceof CompiledRegion)) {
                    prevCV = cv;
                    if (cv instanceof CompiledOperation) {
                        reconstruct.add(0, ((CompiledOperation)cv).getArguments());
                        reconstruct.add(0, ((CompiledOperation)cv).getMethodName());
                        cv = ((CompiledOperation)cv).getReceiver(this.context);
                    } else if (cv instanceof CompiledPath) {
                        reconstruct.add(0, ((CompiledPath)cv).getTailID());
                        cv = ((CompiledPath)cv).getReceiver();
                    } else if (cv instanceof CompiledIndexOperation) {
                        reconstruct.add(0, ((CompiledIndexOperation)cv).getExpression());
                        cv = ((CompiledIndexOperation)cv).getReceiver();
                    } else {
                        throw new IndexInvalidException(LocalizedStrings.FunctionalIndexCreationHelper_FUNCTIONALINDEXCREATIONHELPERPREPAREFROMCLAUSEFROM_CLAUSE_IS_NEITHER_A_COMPILEDPATH_NOR_COMPILEDOPERATION.toLocalizedString());
                    }
                    reconstruct.add(0, prevCV.getType());
                }
                CompiledValue v = cv;
                cv = new CompiledBindArgument(1);
                int len = reconstruct.size();
                for (int j = 0; j < len; ++j) {
                    Object obj = reconstruct.get(j);
                    if (!(obj instanceof Integer)) continue;
                    int tokenType = (Integer)obj;
                    if (tokenType == -5) {
                        cv = new CompiledPath(cv, (String)reconstruct.get(++j));
                        continue;
                    }
                    if (tokenType == 24) {
                        cv = new CompiledIndexOperation(cv, (CompiledValue)reconstruct.get(++j));
                        continue;
                    }
                    if (tokenType != 53) continue;
                    cv = new CompiledOperation(cv, (String)reconstruct.get(++j), (List)reconstruct.get(++j));
                }
                CompiledIteratorDef newDef = new CompiledIteratorDef(iterDef.getName(), null, cv);
                retValues[0] = v.evaluate(this.context);
                retValues[1] = newDef;
                return retValues;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IndexInvalidException(e);
        }
        return retValues;
    }

    private CompiledValue getModifiedDependentCompiledValue(ExecutionContext context, int currItrID, CompiledValue cv, boolean isDependent) throws AmbiguousNameException, TypeMismatchException, NameResolutionException {
        if (cv instanceof CompiledIteratorDef) {
            CompiledIteratorDef iterDef = (CompiledIteratorDef)cv;
            RuntimeIterator rItr = (RuntimeIterator)context.getCurrentIterators().get(currItrID);
            String canonFrmClause = rItr.getDefinition();
            isDependent = canonFrmClause.startsWith(this.canonicalizedIteratorNames[0]);
            return new CompiledIteratorDef(iterDef.getName(), rItr.getElementType(), this.getModifiedDependentCompiledValue(context, currItrID, iterDef.getCollectionExpr(), isDependent));
        }
        if (cv instanceof CompiledPath) {
            CompiledPath path = (CompiledPath)cv;
            return new CompiledPath(this.getModifiedDependentCompiledValue(context, currItrID, path.getReceiver(), isDependent), path.getTailID());
        }
        if (cv instanceof CompiledOperation) {
            CompiledOperation oper = (CompiledOperation)cv;
            List list = oper.getArguments();
            int len = list.size();
            ArrayList<CompiledValue> newList = new ArrayList<CompiledValue>();
            for (int i = 0; i < len; ++i) {
                CompiledValue cv1 = (CompiledValue)list.get(i);
                StringBuffer sbuff = new StringBuffer();
                cv1.generateCanonicalizedExpression(sbuff, context);
                if (sbuff.toString().startsWith(this.canonicalizedIteratorNames[0])) {
                    newList.add(this.getModifiedDependentCompiledValue(context, currItrID, cv1, true));
                    continue;
                }
                newList.add(this.getModifiedDependentCompiledValue(context, currItrID, cv1, false));
            }
            CompiledValue rec = oper.getReceiver(context);
            if (rec == null) {
                if (isDependent) {
                    rec = this.missingLink;
                }
                return new CompiledOperation(rec, oper.getMethodName(), newList);
            }
            return new CompiledOperation(this.getModifiedDependentCompiledValue(context, currItrID, rec, isDependent), oper.getMethodName(), newList);
        }
        if (cv instanceof CompiledFunction) {
            CompiledFunction cf = (CompiledFunction)cv;
            CompiledValue[] cvArray = cf.getArguments();
            int function = cf.getFunction();
            int len = cvArray.length;
            CompiledValue[] newCvArray = new CompiledValue[len];
            for (int i = 0; i < len; ++i) {
                CompiledValue cv1 = cvArray[i];
                StringBuffer sbuff = new StringBuffer();
                cv1.generateCanonicalizedExpression(sbuff, context);
                newCvArray[i] = sbuff.toString().startsWith(this.canonicalizedIteratorNames[0]) ? this.getModifiedDependentCompiledValue(context, currItrID, cv1, true) : this.getModifiedDependentCompiledValue(context, currItrID, cv1, false);
            }
            return new CompiledFunction(newCvArray, function);
        }
        if (cv instanceof CompiledID) {
            CompiledID id = (CompiledID)cv;
            RuntimeIterator rItr0 = (RuntimeIterator)context.getCurrentIterators().get(0);
            if (isDependent) {
                String name = null;
                name = rItr0.getName();
                if (name != null && name.equals(id.getId())) {
                    return this.missingLink;
                }
                return new CompiledPath(this.missingLink, id.getId());
            }
            return cv;
        }
        if (cv instanceof CompiledIndexOperation) {
            CompiledIndexOperation co = (CompiledIndexOperation)cv;
            CompiledValue cv1 = co.getExpression();
            StringBuffer sbuff = new StringBuffer();
            cv1.generateCanonicalizedExpression(sbuff, context);
            cv1 = sbuff.toString().startsWith(this.canonicalizedIteratorNames[0]) ? this.getModifiedDependentCompiledValue(context, currItrID, cv1, true) : this.getModifiedDependentCompiledValue(context, currItrID, cv1, false);
            return new CompiledIndexOperation(this.getModifiedDependentCompiledValue(context, currItrID, co.getReceiver(), isDependent), cv1);
        }
        return cv;
    }

    private void remove(List list, int count, int index2) {
        for (int j = 0; j < count; ++j) {
            list.remove(index2);
        }
    }
}

