/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.query.internal.index;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.query.AmbiguousNameException;
import com.gemstone.gemfire.cache.query.FunctionDomainException;
import com.gemstone.gemfire.cache.query.Index;
import com.gemstone.gemfire.cache.query.IndexStatistics;
import com.gemstone.gemfire.cache.query.NameResolutionException;
import com.gemstone.gemfire.cache.query.QueryInvocationTargetException;
import com.gemstone.gemfire.cache.query.QueryService;
import com.gemstone.gemfire.cache.query.SelectResults;
import com.gemstone.gemfire.cache.query.Struct;
import com.gemstone.gemfire.cache.query.TypeMismatchException;
import com.gemstone.gemfire.cache.query.internal.CompiledID;
import com.gemstone.gemfire.cache.query.internal.CompiledIndexOperation;
import com.gemstone.gemfire.cache.query.internal.CompiledIteratorDef;
import com.gemstone.gemfire.cache.query.internal.CompiledPath;
import com.gemstone.gemfire.cache.query.internal.CompiledValue;
import com.gemstone.gemfire.cache.query.internal.CqEntry;
import com.gemstone.gemfire.cache.query.internal.DefaultQuery;
import com.gemstone.gemfire.cache.query.internal.ExecutionContext;
import com.gemstone.gemfire.cache.query.internal.IndexInfo;
import com.gemstone.gemfire.cache.query.internal.LinkedStructSet;
import com.gemstone.gemfire.cache.query.internal.QRegion;
import com.gemstone.gemfire.cache.query.internal.QueryMonitor;
import com.gemstone.gemfire.cache.query.internal.QueryUtils;
import com.gemstone.gemfire.cache.query.internal.ResultsBag;
import com.gemstone.gemfire.cache.query.internal.RuntimeIterator;
import com.gemstone.gemfire.cache.query.internal.StructBag;
import com.gemstone.gemfire.cache.query.internal.StructImpl;
import com.gemstone.gemfire.cache.query.internal.Support;
import com.gemstone.gemfire.cache.query.internal.index.CompactRangeIndex;
import com.gemstone.gemfire.cache.query.internal.index.DummyQRegion;
import com.gemstone.gemfire.cache.query.internal.index.FunctionalIndexCreationHelper;
import com.gemstone.gemfire.cache.query.internal.index.IMQException;
import com.gemstone.gemfire.cache.query.internal.index.IndexConcurrentHashSet;
import com.gemstone.gemfire.cache.query.internal.index.IndexCreationHelper;
import com.gemstone.gemfire.cache.query.internal.index.IndexManager;
import com.gemstone.gemfire.cache.query.internal.index.IndexProtocol;
import com.gemstone.gemfire.cache.query.internal.index.IndexStore;
import com.gemstone.gemfire.cache.query.internal.index.IndexedExpressionEvaluator;
import com.gemstone.gemfire.cache.query.internal.index.PartitionedIndex;
import com.gemstone.gemfire.cache.query.internal.index.RangeIndex;
import com.gemstone.gemfire.cache.query.internal.types.StructTypeImpl;
import com.gemstone.gemfire.cache.query.internal.types.TypeUtils;
import com.gemstone.gemfire.cache.query.types.ObjectType;
import com.gemstone.gemfire.internal.Assert;
import com.gemstone.gemfire.internal.cache.BucketRegion;
import com.gemstone.gemfire.internal.cache.CachedDeserializable;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.RegionEntry;
import com.gemstone.gemfire.internal.cache.persistence.query.CloseableIterator;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.pdx.PdxInstance;
import com.gemstone.gemfire.pdx.internal.PdxString;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.logging.log4j.Logger;

public abstract class AbstractIndex
implements IndexProtocol {
    private static final Logger logger = LogService.getLogger();
    final String indexName;
    final Region region;
    final String indexedExpression;
    final String fromClause;
    final String projectionAttributes;
    final String originalIndexedExpression;
    final String originalFromClause;
    final String originalProjectionAttributes;
    final String[] canonicalizedDefinitions;
    private boolean isValid;
    protected IndexedExpressionEvaluator evaluator;
    protected InternalIndexStatistics internalIndexStats;
    protected Index prIndex;
    protected Boolean isIndexedPdxKeys = false;
    protected Boolean isIndexedPdxKeysFlagSet = false;
    protected boolean indexOnRegionKeys = false;
    protected boolean indexOnValues = false;
    private final ReadWriteLock removeIndexLock = new ReentrantReadWriteLock();
    protected volatile boolean isPopulated = false;

    AbstractIndex(String indexName, Region region, String fromClause, String indexedExpression, String projectionAttributes, String origFromClause, String origIndxExpr, String[] defintions, IndexStatistics stats) {
        this.indexName = indexName;
        this.region = region;
        this.indexedExpression = indexedExpression;
        this.fromClause = fromClause;
        this.originalIndexedExpression = origIndxExpr;
        this.originalFromClause = origFromClause;
        this.canonicalizedDefinitions = defintions;
        if (projectionAttributes == null || projectionAttributes.length() == 0) {
            projectionAttributes = "*";
        }
        this.projectionAttributes = projectionAttributes;
        this.originalProjectionAttributes = projectionAttributes;
        this.internalIndexStats = stats != null ? (InternalIndexStatistics)stats : this.createStats(indexName);
    }

    public Map getValueToEntriesMap() {
        return null;
    }

    @Override
    public IndexStatistics getStatistics() {
        return this.internalIndexStats;
    }

    @Override
    public void destroy() {
        this.markValid(false);
        if (this.internalIndexStats != null) {
            this.internalIndexStats.updateNumKeys(0L);
            this.internalIndexStats.close();
        }
    }

    long updateIndexUpdateStats() {
        long result = System.nanoTime();
        this.internalIndexStats.incUpdatesInProgress(1);
        return result;
    }

    void updateIndexUpdateStats(long start) {
        long end = System.nanoTime();
        this.internalIndexStats.incUpdatesInProgress(-1);
        this.internalIndexStats.incUpdateTime(end - start);
    }

    long updateIndexUseStats() {
        return this.updateIndexUseStats(true);
    }

    long updateIndexUseStats(boolean updateStats) {
        long result = 0L;
        if (updateStats) {
            this.internalIndexStats.incUsesInProgress(1);
            result = System.nanoTime();
        }
        return result;
    }

    void updateIndexUseEndStats(long start) {
        this.updateIndexUseEndStats(start, true);
    }

    void updateIndexUseEndStats(long start, boolean updateStats) {
        if (updateStats) {
            long end = System.nanoTime();
            this.internalIndexStats.incUsesInProgress(-1);
            this.internalIndexStats.incNumUses();
            this.internalIndexStats.incUseTime(end - start);
        }
    }

    public IndexedExpressionEvaluator getEvaluator() {
        return this.evaluator;
    }

    public Region getRegion() {
        return this.region;
    }

    @Override
    public String getName() {
        return this.indexName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void query(Object key2, int operator, Collection results, ExecutionContext context) throws TypeMismatchException, FunctionDomainException, NameResolutionException, QueryInvocationTargetException {
        if (context.getBucketList() != null && this.region instanceof BucketRegion) {
            PartitionedRegion pr2 = ((BucketRegion)this.region).getPartitionedRegion();
            long start = this.updateIndexUseStats();
            try {
                for (Object b : context.getBucketList()) {
                    AbstractIndex i = PartitionedIndex.getBucketIndex(pr2, this.indexName, (Integer)b);
                    if (i == null) continue;
                    i.lockedQuery(key2, operator, results, null, context);
                }
            }
            finally {
                this.updateIndexUseEndStats(start);
            }
        } else {
            long start = this.updateIndexUseStats();
            try {
                this.lockedQuery(key2, operator, results, null, context);
                return;
            }
            finally {
                this.updateIndexUseEndStats(start);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void query(Object key2, int operator, Collection results, CompiledValue iterOp, RuntimeIterator indpndntIr, ExecutionContext context, List projAttrib, SelectResults intermediateResults, boolean isIntersection) throws TypeMismatchException, FunctionDomainException, NameResolutionException, QueryInvocationTargetException {
        if (context.getBucketList() != null && this.region instanceof BucketRegion) {
            PartitionedRegion pr2 = ((BucketRegion)this.region).getPartitionedRegion();
            long start = this.updateIndexUseStats();
            try {
                for (Object b : context.getBucketList()) {
                    AbstractIndex i = PartitionedIndex.getBucketIndex(pr2, this.indexName, (Integer)b);
                    if (i == null) continue;
                    i.lockedQuery(key2, operator, results, iterOp, indpndntIr, context, projAttrib, intermediateResults, isIntersection);
                }
            }
            finally {
                this.updateIndexUseEndStats(start);
            }
        }
        long start = this.updateIndexUseStats();
        try {
            this.lockedQuery(key2, operator, results, iterOp, indpndntIr, context, projAttrib, intermediateResults, isIntersection);
        }
        finally {
            this.updateIndexUseEndStats(start);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void query(Object key2, int operator, Collection results, Set keysToRemove, ExecutionContext context) throws TypeMismatchException, FunctionDomainException, NameResolutionException, QueryInvocationTargetException {
        if (context.getBucketList() != null && this.region instanceof BucketRegion) {
            PartitionedRegion pr2 = ((BucketRegion)this.region).getPartitionedRegion();
            long start = this.updateIndexUseStats();
            try {
                for (Object b : context.getBucketList()) {
                    AbstractIndex i = PartitionedIndex.getBucketIndex(pr2, this.indexName, (Integer)b);
                    if (i == null) continue;
                    i.lockedQuery(key2, operator, results, keysToRemove, context);
                }
            }
            finally {
                this.updateIndexUseEndStats(start);
            }
        }
        long start = this.updateIndexUseStats();
        try {
            this.lockedQuery(key2, operator, results, keysToRemove, context);
        }
        finally {
            this.updateIndexUseEndStats(start);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void query(Collection results, Set keysToRemove, ExecutionContext context) throws TypeMismatchException, FunctionDomainException, NameResolutionException, QueryInvocationTargetException {
        Iterator itr = keysToRemove.iterator();
        Object temp = itr.next();
        itr.remove();
        if (context.getBucketList() != null && this.region instanceof BucketRegion) {
            long start = this.updateIndexUseStats();
            try {
                PartitionedRegion pr2 = ((BucketRegion)this.region).getPartitionedRegion();
                for (Object b : context.getBucketList()) {
                    AbstractIndex i = PartitionedIndex.getBucketIndex(pr2, this.indexName, (Integer)b);
                    if (i == null) continue;
                    i.lockedQuery(temp, 20, results, itr.hasNext() ? keysToRemove : null, context);
                }
            }
            finally {
                this.updateIndexUseEndStats(start);
            }
        }
        long start = this.updateIndexUseStats();
        try {
            this.lockedQuery(temp, 20, results, itr.hasNext() ? keysToRemove : null, context);
        }
        finally {
            this.updateIndexUseEndStats(start);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void query(Object lowerBoundKey, int lowerBoundOperator, Object upperBoundKey, int upperBoundOperator, Collection results, Set keysToRemove, ExecutionContext context) throws TypeMismatchException, FunctionDomainException, NameResolutionException, QueryInvocationTargetException {
        if (context.getBucketList() != null) {
            if (this.region instanceof BucketRegion) {
                PartitionedRegion pr2 = ((BucketRegion)this.region).getPartitionedRegion();
                long start = this.updateIndexUseStats();
                try {
                    for (Object b : context.getBucketList()) {
                        AbstractIndex i = PartitionedIndex.getBucketIndex(pr2, this.indexName, (Integer)b);
                        if (i == null) continue;
                        i.lockedQuery(lowerBoundKey, lowerBoundOperator, upperBoundKey, upperBoundOperator, results, keysToRemove, context);
                    }
                }
                finally {
                    this.updateIndexUseEndStats(start);
                }
            }
        } else {
            long start = this.updateIndexUseStats();
            try {
                this.lockedQuery(lowerBoundKey, lowerBoundOperator, upperBoundKey, upperBoundOperator, results, keysToRemove, context);
            }
            finally {
                this.updateIndexUseEndStats(start);
            }
        }
    }

    @Override
    public List queryEquijoinCondition(IndexProtocol index2, ExecutionContext context) throws TypeMismatchException, FunctionDomainException, NameResolutionException, QueryInvocationTargetException {
        Support.assertionFailed(" This function should have never got invoked as its meaningful implementation is present only in RangeIndex class");
        return null;
    }

    @Override
    public String getProjectionAttributes() {
        return this.originalProjectionAttributes;
    }

    @Override
    public String getCanonicalizedProjectionAttributes() {
        return this.projectionAttributes;
    }

    @Override
    public String getIndexedExpression() {
        return this.originalIndexedExpression;
    }

    @Override
    public String getCanonicalizedIndexedExpression() {
        return this.indexedExpression;
    }

    @Override
    public String getFromClause() {
        return this.originalFromClause;
    }

    @Override
    public String getCanonicalizedFromClause() {
        return this.fromClause;
    }

    public boolean isMapType() {
        return false;
    }

    @Override
    public boolean addIndexMapping(RegionEntry entry) throws IMQException {
        this.addMapping(entry);
        return true;
    }

    @Override
    public boolean addAllIndexMappings(Collection c) throws IMQException {
        Iterator iterator = c.iterator();
        while (iterator.hasNext()) {
            this.addMapping((RegionEntry)iterator.next());
        }
        return true;
    }

    @Override
    public boolean removeIndexMapping(RegionEntry entry, int opCode) throws IMQException {
        this.removeMapping(entry, opCode);
        return true;
    }

    @Override
    public boolean removeAllIndexMappings(Collection c) throws IMQException {
        Iterator iterator = c.iterator();
        while (iterator.hasNext()) {
            this.removeMapping((RegionEntry)iterator.next(), 0);
        }
        return true;
    }

    @Override
    public boolean isValid() {
        return this.isValid;
    }

    @Override
    public void markValid(boolean b) {
        this.isValid = b;
    }

    @Override
    public boolean isMatchingWithIndexExpression(CompiledValue indexExpr, String conditionExprStr, ExecutionContext context) throws AmbiguousNameException, TypeMismatchException, NameResolutionException {
        return this.indexedExpression.equals(conditionExprStr);
    }

    private Object verifyAndGetPdxDomainObject(Object value2) {
        if (value2 instanceof StructImpl) {
            if (((StructImpl)value2).isHasPdx() && !((GemFireCacheImpl)this.region.getCache()).getPdxReadSerializedByAnyGemFireServices()) {
                StructImpl v = (StructImpl)value2;
                Object[] fieldValues = v.getPdxFieldValues();
                return new StructImpl((StructTypeImpl)v.getStructType(), fieldValues);
            }
        } else if (value2 instanceof PdxInstance && !((GemFireCacheImpl)this.region.getCache()).getPdxReadSerializedByAnyGemFireServices()) {
            return ((PdxInstance)value2).getObject();
        }
        return value2;
    }

    private void addToResultsBagWithUnionOrIntersection(Collection results, SelectResults intermediateResults, boolean isIntersection, Object value2) {
        value2 = this.verifyAndGetPdxDomainObject(value2);
        if (intermediateResults == null) {
            results.add(value2);
        } else if (isIntersection) {
            int numOcc = intermediateResults.occurrences(value2);
            if (numOcc > 0) {
                results.add(value2);
                intermediateResults.remove(value2);
            }
        } else {
            results.add(value2);
        }
    }

    private void addToStructBagWithUnionOrIntersection(Collection results, SelectResults intermediateResults, boolean isIntersection, Object[] values) {
        for (int i = 0; i < values.length; ++i) {
            values[i] = this.verifyAndGetPdxDomainObject(values[i]);
        }
        if (intermediateResults == null) {
            if (results instanceof StructBag) {
                ((StructBag)results).addFieldValues(values);
            } else {
                LinkedStructSet lss = (LinkedStructSet)results;
                StructImpl structImpl = new StructImpl((StructTypeImpl)lss.getCollectionType().getElementType(), values);
                lss.add(structImpl);
            }
        } else if (isIntersection) {
            if (results instanceof StructBag) {
                int numOcc = ((StructBag)intermediateResults).occurrences(values);
                if (numOcc > 0) {
                    ((StructBag)results).addFieldValues(values);
                    ((StructBag)intermediateResults).removeFieldValues(values);
                }
            } else {
                LinkedStructSet lss = (LinkedStructSet)results;
                StructImpl structImpl = new StructImpl((StructTypeImpl)lss.getCollectionType().getElementType(), values);
                if (((LinkedStructSet)intermediateResults).remove(structImpl)) {
                    lss.add(structImpl);
                }
            }
        } else if (results instanceof StructBag) {
            ((StructBag)results).addFieldValues(values);
        } else {
            LinkedStructSet lss = (LinkedStructSet)results;
            StructImpl structImpl = new StructImpl((StructTypeImpl)lss.getCollectionType().getElementType(), values);
            if (((LinkedStructSet)intermediateResults).remove(structImpl)) {
                lss.add(structImpl);
            }
        }
    }

    void applyProjection(List projAttrib, ExecutionContext context, Collection result, Object iterValue, SelectResults intermediateResults, boolean isIntersection) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
        if (projAttrib == null) {
            iterValue = this.deserializePdxForLocalDistinctQuery(context, iterValue);
            this.addToResultsBagWithUnionOrIntersection(result, intermediateResults, isIntersection, iterValue);
        } else if (result instanceof StructBag || result instanceof LinkedStructSet) {
            int projCount = projAttrib.size();
            Object[] values = new Object[projCount];
            Iterator projIter = projAttrib.iterator();
            int i = 0;
            while (projIter.hasNext()) {
                Object[] projDef = (Object[])projIter.next();
                values[i] = this.deserializePdxForLocalDistinctQuery(context, ((CompiledValue)projDef[1]).evaluate(context));
                ++i;
            }
            this.addToStructBagWithUnionOrIntersection(result, intermediateResults, isIntersection, values);
        } else {
            Object[] temp = (Object[])projAttrib.get(0);
            Object val = this.deserializePdxForLocalDistinctQuery(context, ((CompiledValue)temp[1]).evaluate(context));
            this.addToResultsBagWithUnionOrIntersection(result, intermediateResults, isIntersection, val);
        }
    }

    private Object deserializePdxForLocalDistinctQuery(ExecutionContext context, Object val) throws QueryInvocationTargetException {
        if (!((DefaultQuery)context.getQuery()).isRemoteQuery()) {
            if (context.isDistinct() && val instanceof PdxInstance && !this.region.getCache().getPdxReadSerialized()) {
                try {
                    val = ((PdxInstance)val).getObject();
                }
                catch (Exception ex) {
                    throw new QueryInvocationTargetException("Unable to retrieve domain object from PdxInstance while building the ResultSet. " + ex.getMessage());
                }
            } else if (val instanceof PdxString) {
                val = ((PdxString)val).toString();
            }
        }
        return val;
    }

    private void removeFromResultsBagWithUnionOrIntersection(Collection results, SelectResults intermediateResults, boolean isIntersection, Object value2) {
        if (intermediateResults == null) {
            results.remove(value2);
        } else if (isIntersection) {
            int numOcc = ((ResultsBag)results).occurrences(value2);
            if (numOcc > 0) {
                results.remove(value2);
                intermediateResults.add(value2);
            }
        } else {
            results.remove(value2);
        }
    }

    private void removeFromStructBagWithUnionOrIntersection(Collection results, SelectResults intermediateResults, boolean isIntersection, Object[] values) {
        if (intermediateResults == null) {
            ((StructBag)results).removeFieldValues(values);
        } else if (isIntersection) {
            int numOcc = ((StructBag)results).occurrences(values);
            if (numOcc > 0) {
                ((StructBag)results).removeFieldValues(values);
                ((StructBag)intermediateResults).addFieldValues(values);
            }
        } else {
            ((StructBag)results).removeFieldValues(values);
        }
    }

    void removeProjection(List projAttrib, ExecutionContext context, Collection result, Object iterValue, SelectResults intermediateResults, boolean isIntersection) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
        if (projAttrib == null) {
            this.removeFromResultsBagWithUnionOrIntersection(result, intermediateResults, isIntersection, iterValue);
        } else if (result instanceof StructBag) {
            int projCount = projAttrib.size();
            Object[] values = new Object[projCount];
            Iterator projIter = projAttrib.iterator();
            int i = 0;
            while (projIter.hasNext()) {
                Object[] projDef = (Object[])projIter.next();
                values[i++] = ((CompiledValue)projDef[1]).evaluate(context);
            }
            this.removeFromStructBagWithUnionOrIntersection(result, intermediateResults, isIntersection, values);
        } else {
            Object[] temp = (Object[])projAttrib.get(0);
            Object val = ((CompiledValue)temp[1]).evaluate(context);
            this.removeFromResultsBagWithUnionOrIntersection(result, intermediateResults, isIntersection, val);
        }
    }

    @Override
    public String[] getCanonicalizedIteratorDefinitions() {
        return this.canonicalizedDefinitions;
    }

    @Override
    public boolean containsEntry(RegionEntry entry) {
        return false;
    }

    void instantiateEvaluator(IndexCreationHelper ich) {
    }

    @Override
    public void initializeIndex(boolean loadEntries) throws IMQException {
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Index [");
        sb.append(" Name=").append(this.getName());
        sb.append(" Type =").append(this.getType());
        sb.append(" IdxExp=").append(this.getIndexedExpression());
        sb.append(" From=").append(this.getFromClause());
        sb.append(" Proj=").append(this.getProjectionAttributes());
        sb.append("]");
        return sb.toString();
    }

    public abstract boolean isEmpty();

    protected abstract boolean isCompactRangeIndex();

    protected abstract InternalIndexStatistics createStats(String var1);

    @Override
    public abstract ObjectType getResultSetType();

    abstract void recreateIndexData() throws IMQException;

    abstract void addMapping(RegionEntry var1) throws IMQException;

    abstract void removeMapping(RegionEntry var1, int var2) throws IMQException;

    abstract void addMapping(Object var1, Object var2, RegionEntry var3) throws IMQException;

    abstract void saveMapping(Object var1, Object var2, RegionEntry var3) throws IMQException;

    abstract void lockedQuery(Object var1, int var2, Collection var3, CompiledValue var4, RuntimeIterator var5, ExecutionContext var6, List var7, SelectResults var8, boolean var9) throws TypeMismatchException, FunctionDomainException, NameResolutionException, QueryInvocationTargetException;

    abstract void lockedQuery(Object var1, int var2, Object var3, int var4, Collection var5, Set var6, ExecutionContext var7) throws TypeMismatchException, FunctionDomainException, NameResolutionException, QueryInvocationTargetException;

    abstract void lockedQuery(Object var1, int var2, Collection var3, Set var4, ExecutionContext var5) throws TypeMismatchException, FunctionDomainException, NameResolutionException, QueryInvocationTargetException;

    public Index getPRIndex() {
        return this.prIndex;
    }

    public void setPRIndex(Index parIndex) {
        this.prIndex = parIndex;
    }

    protected boolean verifyLimit(Collection result, int limit, ExecutionContext context) {
        if (limit > 0) {
            if (((DefaultQuery)context.getQuery()).getSimpleSelect().isDistinct()) {
                if (result instanceof ResultsBag) {
                    return ((ResultsBag)result).distinctElementsSize() == limit;
                }
                if (result instanceof StructBag) {
                    return ((StructBag)result).distinctElementsSize() == limit;
                }
            } else if (result.size() == limit) {
                return true;
            }
        }
        return false;
    }

    protected boolean verifyEntryAndIndexVaue(RegionEntry re, Object value2, ExecutionContext context) {
        Object valueInIndex;
        List valuesInRegion;
        block8: {
            IMQEvaluator evaluator = (IMQEvaluator)this.getEvaluator();
            valuesInRegion = null;
            valueInIndex = null;
            try {
                if (evaluator.isFirstItrOnKey()) {
                    return true;
                }
                if (evaluator.isFirstItrOnEntry()) {
                    valuesInRegion = this.evaluateIndexIteratorsFromRE(re, context);
                    valueInIndex = this.verifyAndGetPdxDomainObject(value2);
                } else {
                    Object val = re.getValueInVM(context.getPartitionedRegion());
                    if (val instanceof CachedDeserializable) {
                        val = ((CachedDeserializable)val).getDeserializedValue(this.getRegion(), re);
                    }
                    val = this.verifyAndGetPdxDomainObject(val);
                    valueInIndex = this.verifyAndGetPdxDomainObject(value2);
                    valuesInRegion = this.evaluateIndexIteratorsFromRE(val, context);
                }
            }
            catch (Exception e) {
                if (!logger.isDebugEnabled()) break block8;
                logger.debug("Exception occured while verifying a Region Entry value during a Query when the Region Entry is under update operation", (Throwable)e);
            }
        }
        if (!valuesInRegion.isEmpty()) {
            for (Object valueInRegion : valuesInRegion) {
                if (!this.compareStructWithNonStruct(valueInRegion, valueInIndex)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    private boolean compareStructWithNonStruct(Object valueInRegion, Object valueInIndex) {
        if (valueInRegion instanceof Struct && valueInIndex instanceof Struct) {
            Object[] regFields = ((StructImpl)valueInRegion).getFieldValues();
            List<Object> indFields = Arrays.asList(((StructImpl)valueInIndex).getFieldValues());
            for (Object regField : regFields) {
                if (indFields.contains(regField)) continue;
                return false;
            }
            return true;
        }
        if (valueInRegion instanceof Struct && !(valueInIndex instanceof Struct)) {
            Object[] fields;
            for (Object field : fields = ((StructImpl)valueInRegion).getFieldValues()) {
                if (!field.equals(valueInIndex)) continue;
                return true;
            }
        } else if (!(valueInRegion instanceof Struct) && valueInIndex instanceof Struct) {
            Object[] fields;
            for (Object field : fields = ((StructImpl)valueInIndex).getFieldValues()) {
                if (!field.equals(valueInRegion)) continue;
                return true;
            }
        } else {
            return valueInRegion.equals(valueInIndex);
        }
        return false;
    }

    protected List evaluateIndexIteratorsFromRE(Object value2, ExecutionContext context) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
        if (value2 instanceof RegionEntry) {
            LocalRegion localRegion = (LocalRegion)this.getRegion();
            localRegion.getClass();
            value2 = new LocalRegion.NonTXEntry(localRegion, (RegionEntry)value2);
        }
        List itrs = this.getAllDependentRuntimeIterators(context);
        List values = this.evaluateLastColl(value2, context, itrs, 0);
        return values;
    }

    private List evaluateLastColl(Object value2, ExecutionContext context, List itrs, int level) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
        ArrayList<Object> tuples = new ArrayList<Object>(1);
        RuntimeIterator currItrator = (RuntimeIterator)itrs.get(level);
        currItrator.setCurrent(value2);
        if (itrs.size() - 1 == level) {
            if (itrs.size() > 1) {
                Object[] tuple = new Object[itrs.size()];
                for (int i = 0; i < itrs.size(); ++i) {
                    RuntimeIterator iter = (RuntimeIterator)itrs.get(i);
                    tuple[i] = iter.evaluate(context);
                }
                tuples.add(new StructImpl(new StructTypeImpl(), tuple));
            } else {
                tuples.add(currItrator.evaluate(context));
            }
        } else {
            RuntimeIterator nextItr = (RuntimeIterator)itrs.get(level + 1);
            SelectResults nextLevelValues = nextItr.evaluateCollection(context);
            if (nextLevelValues != null) {
                for (Object nextLevelValue : nextLevelValues) {
                    tuples.addAll(this.evaluateLastColl(nextLevelValue, context, itrs, level + 1));
                }
            }
        }
        return tuples;
    }

    public RuntimeIterator getRuntimeIteratorForThisIndex(ExecutionContext context) {
        List indItrs = context.getCurrentIterators();
        Region rgn = this.getRegion();
        if (rgn instanceof BucketRegion) {
            rgn = ((BucketRegion)rgn).getPartitionedRegion();
        }
        String regionPath = rgn.getFullPath();
        String definition = this.getCanonicalizedIteratorDefinitions()[0];
        for (RuntimeIterator itr : indItrs) {
            if (!itr.getDefinition().equals(regionPath) && !itr.getDefinition().equals(definition)) continue;
            return itr;
        }
        return null;
    }

    public RuntimeIterator getRuntimeIteratorForThisIndex(ExecutionContext context, IndexInfo info) {
        List indItrs = context.getCurrentIterators();
        Region rgn = this.getRegion();
        if (rgn instanceof BucketRegion) {
            rgn = ((BucketRegion)rgn).getPartitionedRegion();
        }
        String regionPath = rgn.getFullPath();
        String definition = this.getCanonicalizedIteratorDefinitions()[0];
        for (RuntimeIterator itr : indItrs) {
            if (!itr.getDefinition().equals(regionPath) && !itr.getDefinition().equals(definition)) continue;
            if (itr.getName() != null) {
                CompiledValue path = info._path();
                String pathName = this.getReceiverNameFromPath(path);
                if (path.getType() != 34 && !itr.getName().equals(pathName)) continue;
                return itr;
            }
            return itr;
        }
        return null;
    }

    private String getReceiverNameFromPath(CompiledValue path) {
        if (path instanceof CompiledID) {
            return ((CompiledID)path).getId();
        }
        if (path instanceof CompiledPath) {
            return this.getReceiverNameFromPath(path.getReceiver());
        }
        if (path instanceof CompiledIndexOperation) {
            return this.getReceiverNameFromPath(((CompiledIndexOperation)path).getReceiver());
        }
        return "";
    }

    public List getAllDependentRuntimeIterators(ExecutionContext context) {
        List indItrs = context.getCurrScopeDpndntItrsBasedOnSingleIndpndntItr(this.getRuntimeIteratorForThisIndex(context));
        List<String> definitions = Arrays.asList(this.getCanonicalizedIteratorDefinitions());
        ArrayList<RuntimeIterator> itrs = new ArrayList<RuntimeIterator>();
        for (RuntimeIterator itr : indItrs) {
            if (!definitions.contains(itr.getDefinition())) continue;
            itrs.add(itr);
        }
        return itrs;
    }

    protected void populateListForEquiJoin(List list, Object outerEntries, Object innerEntries, ExecutionContext context, Object key2) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
        Assert.assertTrue(outerEntries != null && innerEntries != null, "OuterEntries or InnerEntries must not be null");
        Object[][] values = new Object[2][];
        Iterator itr = null;
        int j = 0;
        while (j < 2) {
            boolean isRangeIndex = false;
            if (j == 0) {
                if (outerEntries instanceof RegionEntryToValuesMap) {
                    itr = ((RegionEntryToValuesMap)outerEntries).map.entrySet().iterator();
                    isRangeIndex = true;
                } else if (outerEntries instanceof CloseableIterator) {
                    itr = (Iterator)outerEntries;
                }
            } else if (innerEntries instanceof RegionEntryToValuesMap) {
                itr = ((RegionEntryToValuesMap)innerEntries).map.entrySet().iterator();
                isRangeIndex = true;
            } else if (innerEntries instanceof CloseableIterator) {
                itr = (Iterator)innerEntries;
            }
            ArrayList<Object> dummy = new ArrayList<Object>();
            RegionEntry re = null;
            IndexStore.IndexStoreEntry ie = null;
            Object val = null;
            Object entryVal = null;
            IndexInfo[] indexInfo = (IndexInfo[])context.cacheGet("index_info");
            IndexInfo indInfo = indexInfo[j];
            while (itr.hasNext()) {
                if (isRangeIndex) {
                    Map.Entry entry = (Map.Entry)itr.next();
                    val = entry.getValue();
                    entryVal = val instanceof Collection ? (Object)((Collection)val).iterator().next() : val;
                    re = (RegionEntry)entry.getKey();
                } else {
                    ie = (IndexStore.IndexStoreEntry)itr.next();
                }
                boolean ok = true;
                if (isRangeIndex) {
                    if (re.isUpdateInProgress()) {
                        ok = ((RangeIndex)indInfo._getIndex()).verifyEntryAndIndexVaue(re, entryVal, context);
                    }
                } else if (ie.isUpdateInProgress()) {
                    ok = ((CompactRangeIndex)indInfo._getIndex()).verifyInnerAndOuterEntryValues(ie, context, indInfo, key2);
                }
                if (!ok) continue;
                if (isRangeIndex) {
                    if (val instanceof Collection) {
                        dummy.addAll((Collection)val);
                        continue;
                    }
                    dummy.add(val);
                    continue;
                }
                if (IndexManager.IS_TEST_EXPANSION) {
                    dummy.addAll(((CompactRangeIndex)indInfo._getIndex()).expandValue(context, key2, null, 13, -1, ie.getDeserializedValue()));
                    continue;
                }
                dummy.add(ie.getDeserializedValue());
            }
            Object[] newValues = new Object[dummy.size()];
            dummy.toArray(newValues);
            values[j++] = newValues;
        }
        list.add(values);
    }

    public synchronized void setPdxStringFlag(Object key2) {
        if (key2 == null || key2 == IndexManager.NULL || key2 == QueryService.UNDEFINED) {
            return;
        }
        if (!this.isIndexedPdxKeys.booleanValue() && key2 instanceof PdxString) {
            this.isIndexedPdxKeys = true;
        }
        this.isIndexedPdxKeysFlagSet = true;
    }

    public Object getPdxStringForIndexedPdxKeys(Object key2) {
        if (this.isIndexedPdxKeys.booleanValue()) {
            if (key2 instanceof String) {
                return new PdxString((String)key2);
            }
        } else if (key2 instanceof PdxString) {
            return ((PdxString)key2).toString();
        }
        return key2;
    }

    public boolean removeFromKeysToRemove(Collection keysToRemove, Object key2) {
        Iterator iterator = keysToRemove.iterator();
        while (iterator.hasNext()) {
            try {
                if (!TypeUtils.compare(key2, iterator.next(), 13).equals(Boolean.TRUE)) continue;
                iterator.remove();
                return true;
            }
            catch (TypeMismatchException e) {
            }
        }
        return false;
    }

    public boolean acquireIndexReadLockForRemove() {
        boolean success = this.removeIndexLock.readLock().tryLock();
        if (success) {
            this.internalIndexStats.incReadLockCount(1);
            if (logger.isDebugEnabled()) {
                logger.debug("Acquired read lock on index {}", this.getName());
            }
        }
        return success;
    }

    public void releaseIndexReadLockForRemove() {
        this.removeIndexLock.readLock().unlock();
        this.internalIndexStats.incReadLockCount(-1);
        if (logger.isDebugEnabled()) {
            logger.debug("Released read lock on index {}", this.getName());
        }
    }

    public void acquireIndexWriteLockForRemove() {
        boolean isDebugEnabled = logger.isDebugEnabled();
        if (logger.isDebugEnabled()) {
            logger.debug("Acquiring write lock on Index {}", this.getName());
        }
        this.removeIndexLock.writeLock().lock();
        if (logger.isDebugEnabled()) {
            logger.debug("Acquired write lock on index {}", this.getName());
        }
    }

    public void releaseIndexWriteLockForRemove() {
        boolean isDebugEnabled = logger.isDebugEnabled();
        if (isDebugEnabled) {
            logger.debug("Releasing write lock on Index {}", this.getName());
        }
        this.removeIndexLock.writeLock().unlock();
        if (isDebugEnabled) {
            logger.debug("Released write lock on Index {}", this.getName());
        }
    }

    public boolean isPopulated() {
        return this.isPopulated;
    }

    public void setPopulated(boolean isPopulated) {
        this.isPopulated = isPopulated;
    }

    class RegionEntryToValuesMap {
        protected Map map;
        private boolean useList;
        private volatile int numValues = 0;

        RegionEntryToValuesMap(boolean useList) {
            this.map = new ConcurrentHashMap(2, 0.75f, 1);
            this.useList = useList;
        }

        RegionEntryToValuesMap(Map map, boolean useList) {
            this.map = map;
            this.useList = useList;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void add(RegionEntry entry, Object value2) {
            assert (value2 != null);
            if (value2 == null) {
                return;
            }
            Object object = this.map.get(entry);
            if (object == null) {
                this.map.put(entry, value2);
            } else if (object instanceof Collection) {
                Collection coll = (Collection)object;
                if (this.useList) {
                    Collection collection = coll;
                    synchronized (collection) {
                        coll.add(value2);
                    }
                } else {
                    coll.add(value2);
                }
            } else {
                AbstractCollection coll = this.useList ? new ArrayList(2) : new IndexConcurrentHashSet(2, 0.75f, 1);
                coll.add(object);
                coll.add(value2);
                this.map.put(entry, coll);
            }
            ++this.numValues;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addAll(RegionEntry entry, Collection values) {
            Object object = this.map.get(entry);
            if (object == null) {
                AbstractCollection coll = this.useList ? new ArrayList(values.size()) : new IndexConcurrentHashSet(values.size(), 0.75f, 1);
                coll.addAll(values);
                this.map.put(entry, coll);
                this.numValues += values.size();
            } else if (object instanceof Collection) {
                Collection coll = (Collection)object;
                if (this.useList) {
                    Collection collection = coll;
                    synchronized (collection) {
                        coll.addAll(values);
                    }
                } else {
                    coll.addAll(values);
                }
            } else {
                AbstractCollection coll = this.useList ? new ArrayList(values.size() + 1) : new IndexConcurrentHashSet(values.size() + 1, 0.75f, 1);
                coll.addAll(values);
                coll.add(object);
                this.map.put(entry, coll);
            }
            this.numValues += values.size();
        }

        public Object get(RegionEntry entry) {
            return this.map.get(entry);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void remove(RegionEntry entry, Object value2) {
            Object object = this.map.get(entry);
            if (object == null) {
                return;
            }
            if (object instanceof Collection) {
                Collection coll = (Collection)object;
                boolean removed = false;
                if (this.useList) {
                    Collection collection = coll;
                    synchronized (collection) {
                        removed = coll.remove(value2);
                    }
                } else {
                    removed = coll.remove(value2);
                }
                if (removed) {
                    if (coll.size() == 0) {
                        this.map.remove(entry);
                    }
                    --this.numValues;
                }
            } else {
                if (object.equals(value2)) {
                    this.map.remove(entry);
                }
                --this.numValues;
            }
        }

        public Object remove(RegionEntry entry) {
            Object retVal = this.map.remove(entry);
            if (retVal != null) {
                this.numValues = retVal instanceof Collection ? this.numValues - ((Collection)retVal).size() : this.numValues - 1;
            }
            return retVal;
        }

        public int getNumValues(RegionEntry entry) {
            Object object = this.map.get(entry);
            if (object == null) {
                return 0;
            }
            if (object instanceof Collection) {
                Collection coll = (Collection)object;
                return coll.size();
            }
            return 1;
        }

        public int getNumValues() {
            return this.numValues;
        }

        public int getNumEntries() {
            return this.map.keySet().size();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addValuesToCollection(Collection result, int limit, ExecutionContext context) {
            Iterator entriesIter = this.map.entrySet().iterator();
            while (entriesIter.hasNext()) {
                QueryMonitor.isQueryExecutionCanceled();
                if (this.verifylimit(result, limit, context)) {
                    return;
                }
                Map.Entry e = entriesIter.next();
                Object value2 = e.getValue();
                assert (value2 != null);
                RegionEntry re = (RegionEntry)e.getKey();
                boolean reUpdateInProgress = re.isUpdateInProgress();
                if (value2 instanceof Collection) {
                    if (this.useList) {
                        Object v = value2;
                        synchronized (v) {
                            for (Object val : (Collection)value2) {
                                if (!reUpdateInProgress || AbstractIndex.this.verifyEntryAndIndexVaue(re, val, context)) {
                                    result.add(val);
                                }
                                if (limit == -1 || result.size() != limit) continue;
                                return;
                            }
                            continue;
                        }
                    }
                    for (Object val : (Collection)value2) {
                        if (!reUpdateInProgress || AbstractIndex.this.verifyEntryAndIndexVaue(re, val, context)) {
                            result.add(val);
                        }
                        if (limit == -1 || !this.verifylimit(result, limit, context)) continue;
                        return;
                    }
                    continue;
                }
                if (reUpdateInProgress && !AbstractIndex.this.verifyEntryAndIndexVaue(re, value2, context)) continue;
                if (context.isCqQueryContext()) {
                    result.add(new CqEntry(((RegionEntry)e.getKey()).getKey(), value2));
                    continue;
                }
                result.add(AbstractIndex.this.verifyAndGetPdxDomainObject(value2));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addValuesToCollection(Collection result, CompiledValue iterOp, RuntimeIterator runtimeItr, ExecutionContext context, List projAttrib, SelectResults intermediateResults, boolean isIntersection, int limit) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
            if (this.verifylimit(result, limit, context)) {
                return;
            }
            Iterator entries = this.map.entrySet().iterator();
            while (entries.hasNext()) {
                QueryMonitor.isQueryExecutionCanceled();
                Map.Entry e = entries.next();
                Object value2 = e.getValue();
                RegionEntry entry = (RegionEntry)e.getKey();
                boolean reUpdateInProgress = false;
                if (value2 == null) continue;
                if (entry.isUpdateInProgress()) {
                    reUpdateInProgress = true;
                }
                if (value2 instanceof Collection) {
                    if (this.useList) {
                        Object v = value2;
                        synchronized (v) {
                            Iterator itr = ((Collection)value2).iterator();
                            while (itr.hasNext()) {
                                boolean ok = true;
                                Object val = itr.next();
                                if (reUpdateInProgress) {
                                    ok = AbstractIndex.this.verifyEntryAndIndexVaue(entry, val, context);
                                }
                                if (ok && runtimeItr != null) {
                                    runtimeItr.setCurrent(val);
                                    ok = QueryUtils.applyCondition(iterOp, context);
                                }
                                if (!ok) continue;
                                AbstractIndex.this.applyProjection(projAttrib, context, result, value2, intermediateResults, isIntersection);
                                if (limit == -1 || result.size() != limit) continue;
                                return;
                            }
                            continue;
                        }
                    }
                    Iterator itr = ((Collection)value2).iterator();
                    while (itr.hasNext()) {
                        boolean ok = true;
                        Object val = itr.next();
                        if (reUpdateInProgress) {
                            ok = AbstractIndex.this.verifyEntryAndIndexVaue(entry, val, context);
                        }
                        if (ok && runtimeItr != null) {
                            runtimeItr.setCurrent(val);
                            ok = QueryUtils.applyCondition(iterOp, context);
                        }
                        if (!ok) continue;
                        AbstractIndex.this.applyProjection(projAttrib, context, result, value2, intermediateResults, isIntersection);
                        if (!this.verifylimit(result, limit, context)) continue;
                        return;
                    }
                    continue;
                }
                boolean ok = true;
                if (reUpdateInProgress) {
                    ok = AbstractIndex.this.verifyEntryAndIndexVaue(entry, value2, context);
                }
                if (ok && runtimeItr != null) {
                    runtimeItr.setCurrent(value2);
                    ok = QueryUtils.applyCondition(iterOp, context);
                }
                if (!ok) continue;
                if (context.isCqQueryContext()) {
                    result.add(new CqEntry(((RegionEntry)e.getKey()).getKey(), value2));
                    continue;
                }
                AbstractIndex.this.applyProjection(projAttrib, context, result, value2, intermediateResults, isIntersection);
            }
        }

        public void removeValuesFromCollection(Collection result, CompiledValue iterOps, RuntimeIterator runtimeItr, ExecutionContext context, List projAttrib, SelectResults intermediateResults, boolean isIntersection) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
            for (Map.Entry e : this.map.entrySet()) {
                Object value2 = e.getValue();
                if (value2 instanceof Collection) {
                    Iterator itr = ((Collection)value2).iterator();
                    while (itr.hasNext()) {
                        boolean ok = true;
                        Object val = itr.next();
                        if (runtimeItr != null) {
                            runtimeItr.setCurrent(val);
                            ok = QueryUtils.applyCondition(iterOps, context);
                        }
                        if (!ok) continue;
                        AbstractIndex.this.removeProjection(projAttrib, context, result, val, intermediateResults, isIntersection);
                    }
                    continue;
                }
                boolean ok = true;
                if (runtimeItr != null) {
                    runtimeItr.setCurrent(value2);
                    ok = QueryUtils.applyCondition(iterOps, context);
                }
                if (!ok) continue;
                if (context.isCqQueryContext()) {
                    result.remove(new CqEntry(((RegionEntry)e.getKey()).getKey(), value2));
                    continue;
                }
                AbstractIndex.this.removeProjection(projAttrib, context, result, value2, intermediateResults, isIntersection);
            }
        }

        public void removeValuesFromCollection(Collection result) {
            for (Object value2 : this.map.values()) {
                if (value2 instanceof Collection) {
                    result.removeAll((Collection)value2);
                    continue;
                }
                result.remove(value2);
            }
        }

        private boolean verifylimit(Collection result, int limit, ExecutionContext context) {
            if (limit > 0) {
                if (((DefaultQuery)context.getQuery()).getSimpleSelect().isDistinct()) {
                    if (result instanceof ResultsBag) {
                        return ((ResultsBag)result).distinctElementsSize() == limit;
                    }
                    if (result instanceof StructBag) {
                        return ((StructBag)result).distinctElementsSize() == limit;
                    }
                } else if (result.size() == limit) {
                    return true;
                }
            }
            return false;
        }

        public boolean containsEntry(RegionEntry entry) {
            return this.map.containsKey(entry);
        }

        public boolean containsValue(Object value2) {
            throw new RuntimeException(LocalizedStrings.RangeIndex_NOT_YET_IMPLEMENTED.toLocalizedString());
        }

        public void clear() {
            this.map.clear();
            this.numValues = 0;
        }

        public Set entrySet() {
            return this.map.entrySet();
        }

        public void replace(RegionEntry entry, Object values) {
            int numOldValues = this.getNumValues(entry);
            this.map.put(entry, values);
            this.numValues += (values instanceof Collection ? ((Collection)values).size() : 1) - numOldValues;
        }
    }

    class IMQEvaluator
    implements IndexedExpressionEvaluator {
        private Cache cache;
        private List fromIterators = null;
        private CompiledValue indexedExpr = null;
        private final String[] canonicalIterNames;
        private ObjectType indexResultSetType = null;
        private Map dependencyGraph = null;
        private boolean isFirstItrOnEntry = false;
        private boolean isFirstItrOnKey = false;
        private List indexInitIterators = null;
        private CompiledValue additionalProj = null;
        private CompiledValue modifiedIndexExpr = null;
        private ObjectType addnlProjType = null;
        private int initEntriesUpdated = 0;
        private boolean hasInitOccuredOnce = false;
        private ExecutionContext initContext = null;
        private int iteratorSize = -1;
        private Region rgn = null;

        IMQEvaluator(IndexCreationHelper helper) {
            this.cache = helper.getCache();
            this.fromIterators = helper.getIterators();
            this.indexedExpr = helper.getCompiledIndexedExpression();
            this.rgn = helper.getRegion();
            this.isFirstItrOnEntry = ((FunctionalIndexCreationHelper)helper).isFirstIteratorRegionEntry;
            this.isFirstItrOnKey = ((FunctionalIndexCreationHelper)helper).isFirstIteratorRegionKey;
            this.additionalProj = ((FunctionalIndexCreationHelper)helper).additionalProj;
            Object[] params1 = new Object[]{new QRegion(this.rgn, false)};
            this.initContext = new ExecutionContext(params1, this.cache);
            this.canonicalIterNames = ((FunctionalIndexCreationHelper)helper).canonicalizedIteratorNames;
            if (this.isFirstItrOnEntry) {
                this.indexInitIterators = this.fromIterators;
            } else {
                this.indexInitIterators = ((FunctionalIndexCreationHelper)helper).indexInitIterators;
                this.modifiedIndexExpr = ((FunctionalIndexCreationHelper)helper).modifiedIndexExpr;
                this.addnlProjType = ((FunctionalIndexCreationHelper)helper).addnlProjType;
            }
            this.iteratorSize = this.indexInitIterators.size();
        }

        @Override
        public String getIndexedExpression() {
            return AbstractIndex.this.getCanonicalizedIndexedExpression();
        }

        @Override
        public String getProjectionAttributes() {
            return AbstractIndex.this.getCanonicalizedProjectionAttributes();
        }

        @Override
        public String getFromClause() {
            return AbstractIndex.this.getCanonicalizedFromClause();
        }

        @Override
        public void expansion(List expandedResults, Object lowerBoundKey, Object upperBoundKey, int lowerBoundOperator, int upperBoundOperator, Object value2) throws IMQException {
        }

        @Override
        public void evaluate(RegionEntry target, boolean add) throws IMQException {
            assert (add);
            DummyQRegion dQRegion = new DummyQRegion(this.rgn);
            dQRegion.setEntry(target);
            Object[] params = new Object[]{dQRegion};
            ExecutionContext context = new ExecutionContext(params, this.cache);
            context.newScope(IndexCreationHelper.INDEX_QUERY_SCOPE_ID);
            try {
                boolean computeDependency = true;
                if (this.dependencyGraph != null) {
                    context.setDependencyGraph(this.dependencyGraph);
                    computeDependency = false;
                }
                for (int i = 0; i < this.iteratorSize; ++i) {
                    CompiledIteratorDef iterDef = (CompiledIteratorDef)this.fromIterators.get(i);
                    if (computeDependency) {
                        iterDef.computeDependencies(context);
                    }
                    RuntimeIterator rIter = iterDef.getRuntimeIterator(context);
                    context.addToIndependentRuntimeItrMapForIndexCreation(iterDef);
                    context.bindIterator(rIter);
                }
                if (this.dependencyGraph == null) {
                    this.dependencyGraph = context.getDependencyGraph();
                }
                Support.Assert(this.indexResultSetType != null, "IMQEvaluator::evaluate:The StrcutType should have been initialized during index creation");
                this.doNestedIterations(0, context);
            }
            catch (IMQException imqe) {
                throw imqe;
            }
            catch (Exception e) {
                throw new IMQException(e);
            }
            finally {
                context.popScope();
            }
        }

        @Override
        public void initializeIndex(boolean loadEntries) throws IMQException {
            this.initEntriesUpdated = 0;
            try {
                this.initContext.newScope(1);
                for (int i = 0; i < this.iteratorSize; ++i) {
                    CompiledIteratorDef iterDef = (CompiledIteratorDef)this.indexInitIterators.get(i);
                    RuntimeIterator rIter = null;
                    if (!this.hasInitOccuredOnce) {
                        iterDef.computeDependencies(this.initContext);
                        rIter = iterDef.getRuntimeIterator(this.initContext);
                        this.initContext.addToIndependentRuntimeItrMapForIndexCreation(iterDef);
                    }
                    if (rIter == null) {
                        rIter = iterDef.getRuntimeIterator(this.initContext);
                    }
                    this.initContext.bindIterator(rIter);
                }
                this.hasInitOccuredOnce = true;
                if (this.indexResultSetType == null) {
                    this.indexResultSetType = this.createIndexResultSetType();
                }
                if (loadEntries) {
                    this.doNestedIterationsForIndexInit(0, this.initContext.getCurrentIterators());
                }
            }
            catch (IMQException imqe) {
                throw imqe;
            }
            catch (Exception e) {
                throw new IMQException(e);
            }
            finally {
                this.initContext.popScope();
            }
        }

        private void doNestedIterationsForIndexInit(int level, List runtimeIterators) throws TypeMismatchException, AmbiguousNameException, FunctionDomainException, NameResolutionException, QueryInvocationTargetException, IMQException {
            if (level == 1) {
                ++this.initEntriesUpdated;
            }
            if (level == this.iteratorSize) {
                this.applyProjectionForIndexInit(runtimeIterators);
            } else {
                RuntimeIterator rIter = (RuntimeIterator)runtimeIterators.get(level);
                SelectResults c = rIter.evaluateCollection(this.initContext);
                if (c == null) {
                    return;
                }
                Iterator cIter = c.iterator();
                while (cIter.hasNext()) {
                    rIter.setCurrent(cIter.next());
                    this.doNestedIterationsForIndexInit(level + 1, runtimeIterators);
                }
            }
        }

        private void applyProjectionForIndexInit(List currrentRuntimeIters) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException, IMQException {
            Object indexKey;
            if (QueryMonitor.isLowMemory()) {
                throw new IMQException(LocalizedStrings.IndexCreationMsg_CANCELED_DUE_TO_LOW_MEMORY.toLocalizedString());
            }
            LocalRegion.NonTXEntry temp = null;
            temp = this.isFirstItrOnEntry && this.additionalProj != null ? (LocalRegion.NonTXEntry)this.additionalProj.evaluate(this.initContext) : (LocalRegion.NonTXEntry)((RuntimeIterator)currrentRuntimeIters.get(0)).evaluate(this.initContext);
            RegionEntry re = temp.getRegionEntry();
            Object indxResultSet = null;
            if (this.iteratorSize == 1) {
                indxResultSet = this.isFirstItrOnEntry ? (this.additionalProj == null ? temp : ((RuntimeIterator)currrentRuntimeIters.get(0)).evaluate(this.initContext)) : this.additionalProj.evaluate(this.initContext);
            } else {
                int i;
                Object[] tuple = new Object[this.iteratorSize];
                int n = i = this.isFirstItrOnEntry ? 0 : 1;
                while (i < this.iteratorSize) {
                    RuntimeIterator iter = (RuntimeIterator)currrentRuntimeIters.get(i);
                    tuple[i] = iter.evaluate(this.initContext);
                    ++i;
                }
                if (!this.isFirstItrOnEntry) {
                    tuple[0] = this.additionalProj.evaluate(this.initContext);
                }
                Support.Assert(this.indexResultSetType instanceof StructTypeImpl, "The Index ResultType should have been an instance of StructTypeImpl rather than ObjectTypeImpl. The indxeResultType is " + this.indexResultSetType);
                indxResultSet = new StructImpl((StructTypeImpl)this.indexResultSetType, tuple);
            }
            Object object = indexKey = this.isFirstItrOnEntry ? this.indexedExpr.evaluate(this.initContext) : this.modifiedIndexExpr.evaluate(this.initContext);
            if (!AbstractIndex.this.isIndexedPdxKeysFlagSet.booleanValue()) {
                AbstractIndex.this.setPdxStringFlag(indexKey);
            }
            indexKey = AbstractIndex.this.getPdxStringForIndexedPdxKeys(indexKey);
            AbstractIndex.this.addMapping(indexKey, indxResultSet, re);
        }

        private void doNestedIterations(int level, ExecutionContext context) throws TypeMismatchException, AmbiguousNameException, FunctionDomainException, NameResolutionException, QueryInvocationTargetException, IMQException {
            List iterList = context.getCurrentIterators();
            if (level == this.iteratorSize) {
                this.applyProjection(context);
            } else {
                RuntimeIterator rIter = (RuntimeIterator)iterList.get(level);
                SelectResults c = rIter.evaluateCollection(context);
                if (c == null) {
                    return;
                }
                Iterator cIter = c.iterator();
                while (cIter.hasNext()) {
                    rIter.setCurrent(cIter.next());
                    this.doNestedIterations(level + 1, context);
                }
            }
        }

        private void applyProjection(ExecutionContext context) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException, IMQException {
            List currrentRuntimeIters = context.getCurrentIterators();
            Object indxResultSet = null;
            Object indexKey = this.indexedExpr.evaluate(context);
            if (!AbstractIndex.this.isIndexedPdxKeysFlagSet.booleanValue()) {
                AbstractIndex.this.setPdxStringFlag(indexKey);
            }
            indexKey = AbstractIndex.this.getPdxStringForIndexedPdxKeys(indexKey);
            if (this.iteratorSize == 1) {
                RuntimeIterator iter = (RuntimeIterator)currrentRuntimeIters.get(0);
                indxResultSet = iter.evaluate(context);
            } else {
                Object[] tuple = new Object[this.iteratorSize];
                for (int i = 0; i < this.iteratorSize; ++i) {
                    RuntimeIterator iter = (RuntimeIterator)currrentRuntimeIters.get(i);
                    tuple[i] = iter.evaluate(context);
                }
                Support.Assert(this.indexResultSetType instanceof StructTypeImpl, "The Index ResultType should have been an instance of StructTypeImpl rather than ObjectTypeImpl. The indxeResultType is " + this.indexResultSetType);
                indxResultSet = new StructImpl((StructTypeImpl)this.indexResultSetType, tuple);
            }
            RegionEntry entry = ((DummyQRegion)context.getBindArgument(1)).getEntry();
            AbstractIndex.this.saveMapping(indexKey, indxResultSet, entry);
        }

        private ObjectType createIndexResultSetType() {
            int start;
            List currentIterators = this.initContext.getCurrentIterators();
            int len = currentIterators.size();
            ObjectType type = null;
            ObjectType[] fieldTypes = new ObjectType[len];
            int n = start = this.isFirstItrOnEntry ? 0 : 1;
            while (start < len) {
                RuntimeIterator iter = (RuntimeIterator)currentIterators.get(start);
                fieldTypes[start] = iter.getElementType();
                ++start;
            }
            if (!this.isFirstItrOnEntry) {
                fieldTypes[0] = this.addnlProjType;
            }
            type = len == 1 ? fieldTypes[0] : new StructTypeImpl(this.canonicalIterNames, fieldTypes);
            return type;
        }

        private void printList(List list) {
            System.out.println("results.size = " + list.size());
            for (int i = 0; i < list.size(); ++i) {
                Object[] arr = (Object[])list.get(i);
                System.out.println("Key = " + arr[0]);
                System.out.println("Value =" + arr[1]);
            }
        }

        int getTotalEntriesUpdated() {
            return this.initEntriesUpdated;
        }

        @Override
        public ObjectType getIndexResultSetType() {
            return this.indexResultSetType;
        }

        public boolean isFirstItrOnEntry() {
            return this.isFirstItrOnEntry;
        }

        public boolean isFirstItrOnKey() {
            return this.isFirstItrOnKey;
        }

        @Override
        public List getAllDependentIterators() {
            return this.fromIterators;
        }
    }

    protected static abstract class InternalIndexStatistics
    implements IndexStatistics {
        protected InternalIndexStatistics() {
        }

        @Override
        public long getNumUpdates() {
            return 0L;
        }

        @Override
        public long getTotalUpdateTime() {
            return 0L;
        }

        @Override
        public long getTotalUses() {
            return 0L;
        }

        @Override
        public long getNumberOfKeys() {
            return 0L;
        }

        @Override
        public long getNumberOfValues() {
            return 0L;
        }

        @Override
        public long getNumberOfValues(Object key2) {
            return 0L;
        }

        public long getUpdateTime() {
            return 0L;
        }

        public long getUseTime() {
            return 0L;
        }

        @Override
        public int getReadLockCount() {
            return 0;
        }

        @Override
        public long getNumberOfMapIndexKeys() {
            return 0L;
        }

        @Override
        public int getNumberOfBucketIndexes() {
            return 0;
        }

        public void close() {
        }

        public void incNumValues(int delta) {
        }

        public void incNumUpdates() {
        }

        public void incNumUpdates(int delta) {
        }

        public void incUpdatesInProgress(int delta) {
        }

        public void incUsesInProgress(int delta) {
        }

        public void updateNumKeys(long count) {
        }

        public void incNumKeys(long count) {
        }

        public void incNumMapIndexKeys(long numKeys) {
        }

        public void incUpdateTime(long delta) {
        }

        public void incNumUses() {
        }

        public void incUseTime(long delta) {
        }

        public void incReadLockCount(int delta) {
        }

        public void incNumBucketIndexes(int delta) {
        }
    }
}

