/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.query.internal;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.cache.query.SelectResults;
import com.gemstone.gemfire.cache.query.Struct;
import com.gemstone.gemfire.cache.query.internal.StructImpl;
import com.gemstone.gemfire.cache.query.internal.StructSet;
import com.gemstone.gemfire.cache.query.internal.types.CollectionTypeImpl;
import com.gemstone.gemfire.cache.query.internal.types.StructTypeImpl;
import com.gemstone.gemfire.cache.query.types.CollectionType;
import com.gemstone.gemfire.cache.query.types.ObjectType;
import com.gemstone.gemfire.internal.DataSerializableFixedID;
import com.gemstone.gemfire.internal.Version;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

public final class SortedStructSet
extends TreeSet
implements SelectResults,
DataSerializableFixedID {
    private static final long serialVersionUID = -1687142950781718159L;
    protected StructTypeImpl structType;
    private boolean modifiable = true;

    public SortedStructSet() {
    }

    private SortedStructSet(Comparator c) {
        super(c);
    }

    public SortedStructSet(Comparator c, StructTypeImpl structType) {
        this(c);
        if (structType == null) {
            throw new IllegalArgumentException(LocalizedStrings.SortedStructSet_STRUCTTYPE_MUST_NOT_BE_NULL.toLocalizedString());
        }
        this.structType = structType;
    }

    public SortedStructSet(StructTypeImpl structType) {
        if (structType == null) {
            throw new IllegalArgumentException(LocalizedStrings.SortedStructSet_STRUCTTYPE_MUST_NOT_BE_NULL.toLocalizedString());
        }
        this.structType = structType;
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof SortedStructSet)) {
            return false;
        }
        if (!this.structType.equals(((SortedStructSet)other).structType)) {
            return false;
        }
        return super.equals(other);
    }

    @Override
    public boolean add(Object obj) {
        if (!(obj instanceof StructImpl)) {
            throw new IllegalArgumentException(LocalizedStrings.SortedStructSet_THIS_SET_ONLY_ACCEPTS_STRUCTIMPL.toLocalizedString());
        }
        StructImpl s = (StructImpl)obj;
        if (!s.getStructType().equals(this.structType)) {
            throw new IllegalArgumentException(LocalizedStrings.SortedStructSet_OBJ_DOES_NOT_HAVE_THE_SAME_STRUCTTYPE.toLocalizedString());
        }
        return this.addFieldValues(s.getFieldValues());
    }

    public boolean addFieldValues(Object[] fieldValues) {
        return super.add(fieldValues);
    }

    @Override
    public boolean contains(Object obj) {
        if (!(obj instanceof Struct)) {
            return false;
        }
        Struct s = (Struct)obj;
        if (!this.structType.equals(StructTypeImpl.typeFromStruct(s))) {
            return false;
        }
        return this.containsFieldValues(s.getFieldValues());
    }

    public boolean containsFieldValues(Object[] fieldValues) {
        return super.contains(fieldValues);
    }

    @Override
    public boolean remove(Object o) {
        if (!(o instanceof Struct)) {
            return false;
        }
        Struct s = (Struct)o;
        if (!this.structType.equals(StructTypeImpl.typeFromStruct(s))) {
            return false;
        }
        return this.removeFieldValues(s.getFieldValues());
    }

    public boolean removeFieldValues(Object[] fieldValues) {
        return super.remove(fieldValues);
    }

    @Override
    public boolean addAll(Collection c) {
        if (c instanceof StructSet) {
            return this.addAll((StructSet)c);
        }
        return super.addAll(c);
    }

    @Override
    public boolean removeAll(Collection c) {
        if (c instanceof StructSet) {
            return this.removeAll((StructSet)c);
        }
        return super.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection c) {
        if (c instanceof StructSet) {
            return this.retainAll((StructSet)c);
        }
        return super.retainAll(c);
    }

    public boolean addAll(StructSet ss) {
        boolean modified = false;
        if (!this.structType.equals(ss.structType)) {
            throw new IllegalArgumentException(LocalizedStrings.SortedStructSet_TYPES_DONT_MATCH.toLocalizedString());
        }
        Iterator itr = ss.fieldValuesIterator();
        while (itr.hasNext()) {
            if (!this.addFieldValues((Object[])itr.next())) continue;
            modified = true;
        }
        return modified;
    }

    public boolean removeAll(StructSet ss) {
        boolean modified = false;
        if (!this.structType.equals(ss.structType)) {
            return false;
        }
        Iterator itr = ss.fieldValuesIterator();
        while (itr.hasNext()) {
            Object[] fieldValues = (Object[])itr.next();
            if (!this.removeFieldValues(fieldValues)) continue;
            modified = true;
        }
        return modified;
    }

    public boolean retainAll(StructSet ss) {
        if (!this.structType.equals(ss.structType)) {
            if (this.isEmpty()) {
                return false;
            }
            this.clear();
            return true;
        }
        boolean changed = false;
        int size2 = this.size();
        Iterator it = this.fieldValuesIterator();
        while (size2-- > 0) {
            Object[] val = (Object[])it.next();
            if (ss.containsFieldValues(val)) continue;
            it.remove();
            changed = true;
        }
        return changed;
    }

    @Override
    public Iterator iterator() {
        return new StructIterator(this.fieldValuesIterator());
    }

    public Iterator fieldValuesIterator() {
        return super.iterator();
    }

    @Override
    public CollectionType getCollectionType() {
        return new CollectionTypeImpl(TreeSet.class, (ObjectType)this.structType);
    }

    @Override
    public void setElementType(ObjectType elementType) {
        if (!(elementType instanceof StructTypeImpl)) {
            throw new IllegalArgumentException(LocalizedStrings.SortedStructSet_ELEMENT_TYPE_MUST_BE_STRUCT.toLocalizedString());
        }
        this.structType = (StructTypeImpl)elementType;
    }

    public List asList() {
        return new ArrayList(this);
    }

    public Set asSet() {
        return this;
    }

    @Override
    public boolean isModifiable() {
        return this.modifiable;
    }

    public int occurrences(Object element) {
        return this.contains(element) ? 1 : 0;
    }

    public void setModifiable(boolean modifiable) {
        this.modifiable = modifiable;
    }

    @Override
    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("[");
        Iterator i = this.iterator();
        boolean hasNext = i.hasNext();
        while (hasNext) {
            Object o = i.next();
            buf.append(o == this ? "(this Collection)" : String.valueOf(o));
            hasNext = i.hasNext();
            if (!hasNext) continue;
            buf.append(",\n ");
        }
        buf.append("]");
        return buf.toString();
    }

    @Override
    public int getDSFID() {
        return 30;
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        this.modifiable = in.readBoolean();
        int size2 = in.readInt();
        this.structType = (StructTypeImpl)DataSerializer.readObject(in);
        for (int j = size2; j > 0; --j) {
            Object[] fieldValues = (Object[])DataSerializer.readObject(in);
            this.addFieldValues(fieldValues);
        }
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        out.writeBoolean(this.modifiable);
        out.writeInt(this.size());
        DataSerializer.writeObject(this.structType, out);
        Iterator i = this.fieldValuesIterator();
        while (i.hasNext()) {
            Object[] fieldValues = (Object[])i.next();
            DataSerializer.writeObjectArray(fieldValues, out);
        }
    }

    @Override
    public Version[] getSerializationVersions() {
        return null;
    }

    private class StructIterator
    implements Iterator {
        private final Iterator itr;

        StructIterator(Iterator itr) {
            this.itr = itr;
        }

        @Override
        public boolean hasNext() {
            return this.itr.hasNext();
        }

        public Object next() {
            return new StructImpl(SortedStructSet.this.structType, (Object[])this.itr.next());
        }

        @Override
        public void remove() {
            this.itr.remove();
        }
    }
}

