/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.query.internal;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.cache.query.CqResults;
import com.gemstone.gemfire.cache.query.SelectResults;
import com.gemstone.gemfire.cache.query.internal.HashingStrategy;
import com.gemstone.gemfire.cache.query.internal.ObjectIntHashMap;
import com.gemstone.gemfire.cache.query.internal.types.CollectionTypeImpl;
import com.gemstone.gemfire.cache.query.types.CollectionType;
import com.gemstone.gemfire.cache.query.types.ObjectType;
import com.gemstone.gemfire.cache.query.types.StructType;
import com.gemstone.gemfire.internal.DataSerializableFixedID;
import com.gemstone.gemfire.internal.Version;
import com.gemstone.gemfire.internal.cache.CachePerfStats;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;

public class ResultsBag
extends AbstractCollection
implements CqResults,
DataSerializableFixedID {
    protected ObjectType elementType;
    protected ObjectIntHashMap map;
    protected int size = 0;
    protected int numNulls = 0;
    private int limit = -1;
    boolean hasLimitIterator = false;
    final Object limitLock = new Object();

    public ResultsBag() {
        this.map = new ObjectIntHashMap();
    }

    public ResultsBag(boolean ignored) {
    }

    public ResultsBag(CachePerfStats stats) {
        this.map = new ObjectIntHashMap();
    }

    protected ResultsBag(HashingStrategy strategy, CachePerfStats stats) {
        this.map = new ObjectIntHashMap(strategy);
    }

    ResultsBag(Collection c, CachePerfStats stats) {
        this(stats);
        Iterator itr = c.iterator();
        while (itr.hasNext()) {
            this.add(itr.next());
        }
    }

    protected ResultsBag(Collection c, HashingStrategy strategy, CachePerfStats stats) {
        this(strategy, stats);
        Iterator itr = c.iterator();
        while (itr.hasNext()) {
            this.add(itr.next());
        }
    }

    ResultsBag(SelectResults sr, CachePerfStats stats) {
        this((Collection)sr, stats);
        this.setElementType(sr.getCollectionType().getElementType());
    }

    ResultsBag(ObjectType elementType, CachePerfStats stats) {
        this(stats);
        this.setElementType(elementType);
    }

    ResultsBag(ObjectType elementType, int initialCapacity, CachePerfStats stats) {
        this(initialCapacity, stats);
        this.setElementType(elementType);
    }

    ResultsBag(int initialCapacity, float loadFactor, CachePerfStats stats) {
        this.map = new ObjectIntHashMap(initialCapacity, loadFactor);
    }

    protected ResultsBag(int initialCapacity, float loadFactor, HashingStrategy strategy, CachePerfStats stats) {
        this.map = new ObjectIntHashMap(initialCapacity, loadFactor, strategy);
    }

    ResultsBag(int initialCapacity, CachePerfStats stats) {
        this.map = new ObjectIntHashMap(initialCapacity);
    }

    protected ResultsBag(int initialCapacity, HashingStrategy strategy, CachePerfStats stats) {
        this.map = new ObjectIntHashMap(initialCapacity, strategy);
    }

    @Override
    public void setElementType(ObjectType elementType) {
        if (elementType instanceof StructType) {
            throw new IllegalArgumentException(LocalizedStrings.ResultsBag_THIS_COLLECTION_DOES_NOT_SUPPORT_STRUCT_ELEMENTS.toLocalizedString());
        }
        this.elementType = elementType;
    }

    @Override
    public List asList() {
        return new ArrayList(this);
    }

    @Override
    public Set asSet() {
        return new SetView();
    }

    @Override
    public CollectionType getCollectionType() {
        return new CollectionTypeImpl(Collection.class, this.elementType);
    }

    @Override
    public boolean isModifiable() {
        return true;
    }

    @Override
    public int occurrences(Object element) {
        if (this.hasLimitIterator) {
            int count = 0;
            boolean encounteredObject = false;
            for (Object v : this) {
                if (element == null ? v == null : element.equals(v)) {
                    ++count;
                    encounteredObject = true;
                    continue;
                }
                if (!encounteredObject) continue;
                break;
            }
            return count;
        }
        if (element == null) {
            return this.numNulls;
        }
        return this.map.get(element);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator iterator() {
        if (this.hasLimitIterator) {
            Object object = this.limitLock;
            synchronized (object) {
                return new LimitResultsBagIterator();
            }
        }
        return new ResultsBagIterator();
    }

    @Override
    public boolean contains(Object element) {
        if (this.hasLimitIterator) {
            return super.contains(element);
        }
        if (element == null) {
            return this.numNulls > 0;
        }
        return this.map.containsKey(element);
    }

    @Override
    public boolean add(Object element) {
        if (this.limit > -1) {
            throw new UnsupportedOperationException("Addition to the SelectResults not allowed as the query result is constrained by LIMIT");
        }
        if (element == null) {
            ++this.numNulls;
        } else {
            int count = this.map.get(element);
            this.map.put(element, count + 1);
        }
        ++this.size;
        assert (this.size >= 0) : this.size;
        return true;
    }

    public int addAndGetOccurence(Object element) {
        int occurence;
        if (element == null) {
            ++this.numNulls;
            occurence = this.numNulls;
        } else {
            occurence = this.map.get(element);
            this.map.put(element, ++occurence);
        }
        ++this.size;
        assert (this.size >= 0) : this.size;
        return occurence;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        if (this.hasLimitIterator) {
            Object object = this.limitLock;
            synchronized (object) {
                return this.limit;
            }
        }
        return this.size;
    }

    public int distinctElementsSize() {
        return this.map.size();
    }

    @Override
    public boolean remove(Object element) {
        if (this.hasLimitIterator) {
            return super.remove(element);
        }
        if (element == null) {
            if (this.numNulls > 0) {
                --this.numNulls;
                --this.size;
                assert (this.size >= 0) : this.size;
                return true;
            }
            return false;
        }
        int count = this.map.get(element);
        if (count == 0) {
            return false;
        }
        if (count == 1) {
            this.map.remove(element);
        } else {
            this.map.put(element, --count);
        }
        --this.size;
        assert (this.size >= 0) : this.size;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        this.map.clear();
        this.numNulls = 0;
        this.size = 0;
        if (this.hasLimitIterator) {
            Object object = this.limitLock;
            synchronized (object) {
                this.limit = 0;
            }
        }
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof ResultsBag)) {
            return false;
        }
        ResultsBag otherBag = (ResultsBag)o;
        return this.size == otherBag.size && this.elementType.equals(otherBag.elementType) && this.map.equals(otherBag.map) && this.numNulls == otherBag.numNulls;
    }

    @Override
    public int hashCode() {
        return this.map.hashCode();
    }

    @Override
    public boolean addAll(Collection coll) {
        if (this.limit > -1) {
            throw new UnsupportedOperationException("Addition to the SelectResults not allowed as the query result is constrained by LIMIT");
        }
        return super.addAll(coll);
    }

    protected ObjectIntHashMap createMapForFromData() {
        return new ObjectIntHashMap(this.size);
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        int occurence;
        this.elementType = (ObjectType)DataSerializer.readObject(in);
        this.size = in.readInt();
        assert (this.size >= 0) : this.size;
        this.map = this.createMapForFromData();
        this.readNumNulls(in);
        for (int numLeft = this.size - this.numNulls; numLeft > 0; numLeft -= occurence) {
            Object key2 = DataSerializer.readObject(in);
            occurence = in.readInt();
            this.map.put(key2, occurence);
        }
    }

    @Override
    public int getDSFID() {
        return 15;
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        int occurence;
        DataSerializer.writeObject(this.elementType, out);
        out.writeInt(this.size());
        this.writeNumNulls(out);
        Iterator<ObjectIntHashMap.Entry> itr = this.map.entrySet().iterator();
        for (int numLeft = this.size() - this.numNulls; itr.hasNext() && numLeft > 0; numLeft -= occurence) {
            ObjectIntHashMap.Entry entry = itr.next();
            Object key2 = entry.getKey();
            DataSerializer.writeObject(key2, out);
            occurence = entry.getValue();
            if (numLeft < occurence) {
                occurence = numLeft;
            }
            out.writeInt(occurence);
        }
    }

    void writeNumNulls(DataOutput out) throws IOException {
        out.writeInt(this.numNulls);
    }

    void readNumNulls(DataInput in) throws IOException {
        this.numNulls = in.readInt();
    }

    void createIntHashMap() {
        this.map = new ObjectIntHashMap(this.size - this.numNulls);
    }

    void applyLimit(int limit) {
        this.limit = limit;
        if (this.limit > -1 && this.size > this.limit) {
            this.hasLimitIterator = true;
        }
    }

    @Override
    public Version[] getSerializationVersions() {
        return null;
    }

    protected class LimitResultsBagIterator
    extends ResultsBagIterator {
        private final int localLimit;
        private int currPos;

        public LimitResultsBagIterator() {
            this.currPos = 0;
            this.localLimit = ResultsBag.this.limit;
        }

        @Override
        public boolean hasNext() {
            return this.currPos < this.localLimit;
        }

        @Override
        public Object next() {
            if (this.currPos == this.localLimit) {
                throw new NoSuchElementException();
            }
            Object next2 = super.next();
            ++this.currPos;
            return next2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void remove() {
            if (this.currPos == 0) {
                throw new IllegalStateException("next() must be called before remove()");
            }
            Object object = ResultsBag.this.limitLock;
            synchronized (object) {
                super.remove();
                --ResultsBag.this.limit;
            }
        }
    }

    class SetView
    extends AbstractSet {
        private int localLimit;

        SetView() {
            this.localLimit = ResultsBag.this.limit;
        }

        @Override
        public Iterator iterator() {
            if (this.localLimit > -1) {
                return new LimitSetViewIterator();
            }
            return new SetViewIterator();
        }

        @Override
        public boolean add(Object o) {
            if (this.contains(o)) {
                return false;
            }
            return ResultsBag.this.add(o);
        }

        @Override
        public void clear() {
            ResultsBag.this.clear();
        }

        @Override
        public int size() {
            int calculatedSize = ResultsBag.this.map.size() + (ResultsBag.this.numNulls > 0 ? 1 : 0);
            if (this.localLimit > -1) {
                return Math.min(this.localLimit, calculatedSize);
            }
            return calculatedSize;
        }

        @Override
        public boolean contains(Object o) {
            if (o == null) {
                return ResultsBag.this.numNulls > 0;
            }
            return ResultsBag.this.map.containsKey(o);
        }

        @Override
        public boolean isEmpty() {
            if (this.localLimit == 0) {
                return true;
            }
            if (ResultsBag.this.numNulls > 0) {
                return false;
            }
            return ResultsBag.this.map.isEmpty();
        }

        class LimitSetViewIterator
        extends SetViewIterator {
            private int currPos;
            private Object currentKey;

            LimitSetViewIterator() {
                this.currPos = 0;
            }

            @Override
            public Object next() {
                if (this.currPos == SetView.this.localLimit) {
                    throw new NoSuchElementException();
                }
                this.currentKey = super.next();
                ++this.currPos;
                return this.currentKey;
            }

            @Override
            public boolean hasNext() {
                return this.currPos < SetView.this.localLimit && super.hasNext();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void remove() {
                if (this.currPos == 0) {
                    throw new IllegalStateException("next() must be called before remove()");
                }
                Object object = ResultsBag.this.limitLock;
                synchronized (object) {
                    if (this.currentIsNull) {
                        ResultsBag.this.limit -= ResultsBag.this.numNulls;
                        ResultsBag.this.numNulls = 0;
                        SetView.this.localLimit--;
                    } else {
                        int count = ResultsBag.this.map.remove(this.currentKey);
                        assert (count != 0) : "Attempted to remove an element that was not in the map.";
                        ResultsBag.this.limit -= count;
                        SetView.this.localLimit--;
                    }
                }
            }
        }

        public class SetViewIterator
        implements Iterator {
            boolean emitNull;
            final Iterator it;
            boolean currentIsNull;

            public SetViewIterator() {
                this.emitNull = ResultsBag.this.numNulls > 0;
                this.it = ResultsBag.this.map.keySet().iterator();
                this.currentIsNull = false;
            }

            public Object next() {
                if (this.emitNull) {
                    this.emitNull = false;
                    this.currentIsNull = true;
                    return null;
                }
                Object key2 = this.it.next();
                this.currentIsNull = false;
                return key2;
            }

            @Override
            public boolean hasNext() {
                if (this.emitNull) {
                    return true;
                }
                return this.it.hasNext();
            }

            @Override
            public void remove() {
                if (this.currentIsNull) {
                    ResultsBag.this.numNulls = 0;
                } else {
                    this.it.remove();
                }
            }
        }
    }

    protected class ResultsBagIterator
    implements Iterator {
        final Iterator<ObjectIntHashMap.Entry> mapIterator;
        ObjectIntHashMap.Entry currentEntry;
        int currentDup;
        int dupLimit;

        protected ResultsBagIterator() {
            this.mapIterator = ResultsBag.this.map.entrySet().iterator();
            this.currentEntry = null;
            this.currentDup = 0;
            this.dupLimit = ResultsBag.this.numNulls;
        }

        @Override
        public boolean hasNext() {
            return this.mapIterator.hasNext() || this.currentDup < this.dupLimit;
        }

        public Object next() {
            if (this.currentDup < this.dupLimit) {
                ++this.currentDup;
                return this.currentEntry == null ? null : this.currentEntry.getKey();
            }
            this.currentEntry = this.mapIterator.next();
            this.dupLimit = this.currentEntry.getValue();
            this.currentDup = 1;
            return this.currentEntry.getKey();
        }

        @Override
        public void remove() {
            if (this.currentDup == 0) {
                throw new IllegalStateException(LocalizedStrings.ResultsBag_NEXT_MUST_BE_CALLED_BEFORE_REMOVE.toLocalizedString());
            }
            --this.dupLimit;
            assert (this.dupLimit >= 0) : this.dupLimit;
            if (this.currentEntry == null) {
                ResultsBag.this.numNulls = this.dupLimit;
                assert (ResultsBag.this.numNulls >= 0) : ResultsBag.this.numNulls;
            } else if (this.dupLimit > 0) {
                ResultsBag.this.map.put(this.currentEntry.getKey(), this.dupLimit);
            } else {
                this.mapIterator.remove();
            }
            --ResultsBag.this.size;
            --this.currentDup;
            assert (ResultsBag.this.size >= 0) : ResultsBag.this.size;
            assert (this.currentDup >= 0) : this.currentDup;
        }
    }
}

