/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.query.internal;

import com.gemstone.gemfire.cache.query.Query;
import com.gemstone.gemfire.cache.query.QueryExecutionLowMemoryException;
import com.gemstone.gemfire.cache.query.QueryExecutionTimeoutException;
import com.gemstone.gemfire.cache.query.internal.DefaultQuery;
import com.gemstone.gemfire.cache.query.internal.QueryExecutionCanceledException;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.internal.logging.log4j.LocalizedMessage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.logging.log4j.Logger;

public class QueryMonitor
implements Runnable {
    private static final Logger logger = LogService.getLogger();
    private static ThreadLocal<AtomicBoolean> queryExecutionStatus = new ThreadLocal<AtomicBoolean>(){

        @Override
        protected AtomicBoolean initialValue() {
            return new AtomicBoolean(Boolean.FALSE);
        }
    };
    private final long maxQueryExecutionTime;
    private static final ConcurrentLinkedQueue queryThreads = new ConcurrentLinkedQueue();
    private Thread monitoringThread;
    private final AtomicBoolean stopped = new AtomicBoolean(Boolean.FALSE);
    private ConcurrentMap queryMonitorTasks = null;
    private static volatile Boolean LOW_MEMORY = Boolean.FALSE;
    private static volatile long LOW_MEMORY_USED_BYTES = 0L;

    public QueryMonitor(long maxQueryExecutionTime) {
        this.maxQueryExecutionTime = maxQueryExecutionTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void monitorQueryThread(Thread queryThread, Query query) {
        if (LOW_MEMORY.booleanValue()) {
            String reason = LocalizedStrings.QueryMonitor_LOW_MEMORY_CANCELED_QUERY.toLocalizedString(LOW_MEMORY_USED_BYTES);
            ((DefaultQuery)query).setCanceled(true, new QueryExecutionLowMemoryException(reason));
            throw new QueryExecutionLowMemoryException(reason);
        }
        QueryThreadTask queryTask = new QueryThreadTask(queryThread, query, queryExecutionStatus.get());
        ConcurrentLinkedQueue concurrentLinkedQueue = queryThreads;
        synchronized (concurrentLinkedQueue) {
            queryThreads.add(queryTask);
            queryThreads.notify();
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Adding thread to QueryMonitor. QueryMonitor size is:{}, Thread (id): {} query: {} thread is : {}", queryThreads.size(), queryThread.getId(), query.getQueryString(), queryThread);
        }
        if (GemFireCacheImpl.getInstance() != null && GemFireCacheImpl.getInstance().TEST_MAX_QUERY_EXECUTION_TIME > 0) {
            if (this.queryMonitorTasks == null) {
                this.queryMonitorTasks = new ConcurrentHashMap();
            }
            this.queryMonitorTasks.put(queryThread, queryTask);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopMonitoringQueryThread(Thread queryThread, Query query) {
        boolean[] queryCompleted;
        QueryExecutionTimeoutException testException = null;
        DefaultQuery q = (DefaultQuery)query;
        boolean[] blArray = queryCompleted = q.getQueryCompletedForMonitoring();
        synchronized (queryCompleted) {
            queryExecutionStatus.get().getAndSet(Boolean.FALSE);
            if (GemFireCacheImpl.getInstance() != null && GemFireCacheImpl.getInstance().TEST_MAX_QUERY_EXECUTION_TIME > 0) {
                long maxTimeSet = GemFireCacheImpl.getInstance().TEST_MAX_QUERY_EXECUTION_TIME;
                QueryThreadTask queryTask = (QueryThreadTask)queryThreads.peek();
                if (queryTask != null && System.currentTimeMillis() - queryTask.StartTime > maxTimeSet) {
                    testException = new QueryExecutionTimeoutException("The QueryMonitor thread may be sleeping longer than the set sleep time. This will happen as the sleep is based on OS thread scheduling, verify the time spent by the executor thread.");
                }
                if ((queryTask = (QueryThreadTask)this.queryMonitorTasks.get(queryThread)) != null) {
                    this.queryMonitorTasks.remove(queryThread);
                    if (!GemFireCacheImpl.getInstance().TEST_MAX_QUERY_EXECUTION_TIME_OVERRIDE_EXCEPTION && testException == null && System.currentTimeMillis() - queryTask.StartTime < maxTimeSet + 10L) {
                        testException = new QueryExecutionTimeoutException("The Query completed sucessfully before it got canceled.");
                    }
                }
            }
            q.setQueryCompletedForMonitoring(true);
            queryThreads.remove(new QueryThreadTask(queryThread, null, null));
            // ** MonitorExit[var6_6] (shouldn't be in output)
            if (logger.isDebugEnabled()) {
                logger.debug("Removed thread from QueryMonitor. QueryMonitor size is:{}, Thread (id): thread is : {}", queryThreads.size(), queryThread.getId(), queryThread);
            }
            if (testException != null) {
                throw testException;
            }
            return;
        }
    }

    public static void isQueryExecutionCanceled() {
        if (queryExecutionStatus.get() != null && queryExecutionStatus.get().get()) {
            throw new QueryExecutionCanceledException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopMonitoring() {
        AtomicBoolean atomicBoolean = this.stopped;
        synchronized (atomicBoolean) {
            if (this.monitoringThread != null) {
                this.monitoringThread.interrupt();
            }
            this.stopped.set(Boolean.TRUE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        AtomicBoolean atomicBoolean = this.stopped;
        // MONITORENTER : atomicBoolean
        if (this.stopped.get()) {
            queryThreads.clear();
            // MONITOREXIT : atomicBoolean
            return;
        }
        this.monitoringThread = Thread.currentThread();
        // MONITOREXIT : atomicBoolean
        try {
            try {
                QueryThreadTask queryTask = null;
                long sleepTime = 0L;
                while (true) {
                    boolean[] queryCompleted;
                    long currentTime;
                    if ((queryTask = (QueryThreadTask)queryThreads.peek()) == null) {
                        ConcurrentLinkedQueue concurrentLinkedQueue = queryThreads;
                        // MONITORENTER : concurrentLinkedQueue
                        queryThreads.wait();
                        // MONITOREXIT : concurrentLinkedQueue
                        continue;
                    }
                    if (DefaultQuery.testHook != null) {
                        DefaultQuery.testHook.doTestHook(6);
                    }
                    if ((currentTime = System.currentTimeMillis()) - queryTask.StartTime < this.maxQueryExecutionTime) {
                        sleepTime = this.maxQueryExecutionTime - (currentTime - queryTask.StartTime);
                        Thread.sleep(sleepTime);
                        continue;
                    }
                    boolean[] blArray = queryCompleted = ((DefaultQuery)queryTask.query).getQueryCompletedForMonitoring();
                    // MONITORENTER : queryCompleted
                    if (!queryCompleted[0]) {
                        ((DefaultQuery)queryTask.query).setCanceled(true, new QueryExecutionTimeoutException(LocalizedStrings.QueryMonitor_LONG_RUNNING_QUERY_CANCELED.toLocalizedString(GemFireCacheImpl.MAX_QUERY_EXECUTION_TIME)));
                        queryTask.queryExecutionStatus.set(Boolean.TRUE);
                        queryThreads.poll();
                    }
                    // MONITOREXIT : blArray
                    logger.info(LocalizedMessage.create(LocalizedStrings.GemFireCache_LONG_RUNNING_QUERY_EXECUTION_CANCELED, new Object[]{queryTask.query.getQueryString(), queryTask.queryThread.getId()}));
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug("Query Execution for the thread {} got canceled.", queryTask.queryThread);
                }
            }
            catch (InterruptedException ex) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Query Monitoring thread got interrupted.");
                }
                queryThreads.clear();
                return;
            }
        }
        catch (Throwable throwable) {
            queryThreads.clear();
            throw throwable;
        }
    }

    public static boolean isLowMemory() {
        return LOW_MEMORY;
    }

    public static long getMemoryUsedDuringLowMemory() {
        return LOW_MEMORY_USED_BYTES;
    }

    public static void setLowMemory(boolean lowMemory, long usedBytes) {
        if (GemFireCacheImpl.getInstance() != null && !GemFireCacheImpl.getInstance().isQueryMonitorDisabledForLowMemory()) {
            LOW_MEMORY_USED_BYTES = usedBytes;
            LOW_MEMORY = lowMemory;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelAllQueriesDueToMemory() {
        ConcurrentLinkedQueue concurrentLinkedQueue = queryThreads;
        synchronized (concurrentLinkedQueue) {
            QueryThreadTask queryTask = (QueryThreadTask)queryThreads.poll();
            while (queryTask != null) {
                this.cancelQueryDueToLowMemory(queryTask, LOW_MEMORY_USED_BYTES);
                queryTask = (QueryThreadTask)queryThreads.poll();
            }
            queryThreads.clear();
            queryThreads.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelQueryDueToLowMemory(QueryThreadTask queryTask, long memoryThreshold) {
        boolean[] queryCompleted;
        boolean[] blArray = queryCompleted = ((DefaultQuery)queryTask.query).getQueryCompletedForMonitoring();
        synchronized (queryCompleted) {
            if (!queryCompleted[0]) {
                String reason = LocalizedStrings.QueryMonitor_LOW_MEMORY_CANCELED_QUERY.toLocalizedString(memoryThreshold);
                ((DefaultQuery)queryTask.query).setCanceled(true, new QueryExecutionLowMemoryException(reason));
                queryTask.queryExecutionStatus.set(Boolean.TRUE);
            }
            // ** MonitorExit[var5_4] (shouldn't be in output)
            return;
        }
    }

    public int getQueryMonitorThreadCount() {
        return queryThreads.size();
    }

    private class QueryThreadTask {
        private final long StartTime = System.currentTimeMillis();
        private final Thread queryThread;
        private final Query query;
        private final AtomicBoolean queryExecutionStatus;

        QueryThreadTask(Thread queryThread, Query query, AtomicBoolean queryExecutionStatus) {
            this.queryThread = queryThread;
            this.query = query;
            this.queryExecutionStatus = queryExecutionStatus;
        }

        public int hashCode() {
            assert (this.queryThread != null);
            return this.queryThread.hashCode();
        }

        public boolean equals(Object other) {
            if (!(other instanceof QueryThreadTask)) {
                return false;
            }
            QueryThreadTask o = (QueryThreadTask)other;
            return this.queryThread.equals(o.queryThread);
        }

        public String toString() {
            return new StringBuffer().append("QueryThreadTask[StartTime:").append(this.StartTime).append(", queryThread:").append(this.queryThread).append(", threadId:").append(this.queryThread.getId()).append(", query:").append(this.query.getQueryString()).append(", queryExecutionStatus:").append(this.queryExecutionStatus).append("]").toString();
        }
    }
}

