/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.query.internal;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.query.Query;
import com.gemstone.gemfire.cache.query.SelectResults;
import com.gemstone.gemfire.cache.query.internal.ExecutionContext;
import com.gemstone.gemfire.pdx.internal.PdxString;
import com.gemstone.gnu.trove.TIntHashSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;

public class QueryExecutionContext
extends ExecutionContext {
    private int nextFieldNum = 0;
    private Query query;
    private TIntHashSet successfulBuckets;
    private boolean cqQueryContext = false;
    private SelectResults results;
    private List bucketList;
    private boolean indexUsed = false;
    private final Stack execCacheStack = new Stack();
    private final Map execCaches = new HashMap();
    private Map<Integer, PdxString> bindArgumentToPdxStringMap;
    private ArrayList<String> hints = null;

    public QueryExecutionContext(Object[] bindArguments, Cache cache) {
        super(bindArguments, cache);
    }

    public QueryExecutionContext(Object[] bindArguments, Cache cache, SelectResults results, Query query) {
        super(bindArguments, cache);
        this.results = results;
        this.query = query;
    }

    public QueryExecutionContext(Object[] bindArguments, Cache cache, Query query) {
        super(bindArguments, cache);
        this.query = query;
    }

    @Override
    void cachePut(Object key2, Object value2) {
        HashMap<Object, Object> execCache;
        if (key2.equals("query_index_hints")) {
            this.setHints((ArrayList)value2);
            return;
        }
        int scopeId = -1;
        if (!this.execCacheStack.isEmpty()) {
            scopeId = (Integer)this.execCacheStack.peek();
        }
        if ((execCache = (HashMap<Object, Object>)this.execCaches.get(scopeId)) == null) {
            execCache = new HashMap<Object, Object>();
            this.execCaches.put(scopeId, execCache);
        }
        execCache.put(key2, value2);
    }

    @Override
    public Object cacheGet(Object key2) {
        Map execCache;
        int scopeId = -1;
        if (!this.execCacheStack.isEmpty()) {
            scopeId = (Integer)this.execCacheStack.peek();
        }
        return (execCache = (Map)this.execCaches.get(scopeId)) != null ? execCache.get(key2) : null;
    }

    @Override
    public void pushExecCache(int scopeNum) {
        this.execCacheStack.push(scopeNum);
    }

    @Override
    public void popExecCache() {
        this.execCacheStack.pop();
    }

    @Override
    public void reset() {
        super.reset();
        this.execCacheStack.clear();
    }

    @Override
    int nextFieldNum() {
        return this.nextFieldNum++;
    }

    @Override
    public void setCqQueryContext(boolean cqQuery) {
        this.cqQueryContext = cqQuery;
    }

    @Override
    public boolean isCqQueryContext() {
        return this.cqQueryContext;
    }

    @Override
    public SelectResults getResults() {
        return this.results;
    }

    @Override
    public Query getQuery() {
        return this.query;
    }

    @Override
    public void setBucketList(List list) {
        this.bucketList = list;
        this.successfulBuckets = new TIntHashSet();
    }

    @Override
    public List getBucketList() {
        return this.bucketList;
    }

    @Override
    public void addToSuccessfulBuckets(int bId) {
        this.successfulBuckets.add(bId);
    }

    @Override
    public int[] getSuccessfulBuckets() {
        return this.successfulBuckets.toArray();
    }

    @Override
    public PdxString getSavedPdxString(int index2) {
        PdxString pdxString;
        if (this.bindArgumentToPdxStringMap == null) {
            this.bindArgumentToPdxStringMap = new HashMap<Integer, PdxString>();
        }
        if ((pdxString = this.bindArgumentToPdxStringMap.get(index2 - 1)) == null) {
            pdxString = new PdxString((String)this.bindArguments[index2 - 1]);
            this.bindArgumentToPdxStringMap.put(index2 - 1, pdxString);
        }
        return pdxString;
    }

    public boolean isIndexUsed() {
        return this.indexUsed;
    }

    void setIndexUsed(boolean indexUsed) {
        this.indexUsed = indexUsed;
    }

    public void setHints(ArrayList<String> hints) {
        this.hints = new ArrayList();
        this.hints.addAll(hints);
    }

    public boolean isHinted(String indexName) {
        return this.hints != null ? this.hints.contains(indexName) : false;
    }

    public int getHintSize(String indexName) {
        return -(this.hints.size() - this.hints.indexOf(indexName));
    }

    public boolean hasHints() {
        return this.hints != null;
    }

    public boolean hasMultiHints() {
        return this.hints != null && this.hints.size() > 1;
    }
}

