/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.query.internal;

import com.gemstone.gemfire.cache.CacheClosedException;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.client.internal.ProxyCache;
import com.gemstone.gemfire.cache.client.internal.UserAttributes;
import com.gemstone.gemfire.cache.query.CqAttributes;
import com.gemstone.gemfire.cache.query.CqException;
import com.gemstone.gemfire.cache.query.CqExistsException;
import com.gemstone.gemfire.cache.query.CqQuery;
import com.gemstone.gemfire.cache.query.CqServiceStatistics;
import com.gemstone.gemfire.cache.query.Index;
import com.gemstone.gemfire.cache.query.IndexExistsException;
import com.gemstone.gemfire.cache.query.IndexInvalidException;
import com.gemstone.gemfire.cache.query.IndexNameConflictException;
import com.gemstone.gemfire.cache.query.IndexType;
import com.gemstone.gemfire.cache.query.MultiIndexCreationException;
import com.gemstone.gemfire.cache.query.Query;
import com.gemstone.gemfire.cache.query.QueryInvalidException;
import com.gemstone.gemfire.cache.query.QueryService;
import com.gemstone.gemfire.cache.query.RegionNotFoundException;
import com.gemstone.gemfire.cache.query.internal.CqQueryImpl;
import com.gemstone.gemfire.cache.query.internal.DefaultQueryService;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.LogService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.logging.log4j.Logger;

public class ProxyQueryService
implements QueryService {
    private static final Logger logger = LogService.getLogger();
    ProxyCache proxyCache;
    QueryService realQueryService;
    List<String> cqNames = new ArrayList<String>();

    public ProxyQueryService(ProxyCache proxyCache, QueryService realQueryService) {
        this.proxyCache = proxyCache;
        this.realQueryService = realQueryService;
    }

    @Override
    public void closeCqs() {
        this.closeCqs(false);
    }

    public void closeCqs(boolean keepAlive) {
        block2: {
            this.preOp();
            try {
                ((DefaultQueryService)this.realQueryService).getCqService().closeAllCqs(!keepAlive, this.getCqs(), keepAlive);
                this.cqNames.clear();
            }
            catch (CqException cqe) {
                if (!logger.isDebugEnabled()) break block2;
                logger.debug("Unable to closeAll Cqs. Error: {}", cqe.getMessage(), cqe);
            }
        }
    }

    @Override
    public Index createHashIndex(String indexName, String indexedExpression, String fromClause) throws IndexInvalidException, IndexNameConflictException, IndexExistsException, RegionNotFoundException, UnsupportedOperationException {
        throw new UnsupportedOperationException("Index creation on the server is not supported from the client.");
    }

    @Override
    public Index createHashIndex(String indexName, String indexedExpression, String fromClause, String imports) throws IndexInvalidException, IndexNameConflictException, IndexExistsException, RegionNotFoundException, UnsupportedOperationException {
        throw new UnsupportedOperationException("Index creation on the server is not supported from the client.");
    }

    @Override
    public Index createIndex(String indexName, IndexType indexType, String indexedExpression, String fromClause) throws IndexInvalidException, IndexNameConflictException, IndexExistsException, RegionNotFoundException, UnsupportedOperationException {
        throw new UnsupportedOperationException("Index creation on the server is not supported from the client.");
    }

    @Override
    public Index createIndex(String indexName, IndexType indexType, String indexedExpression, String fromClause, String imports) throws IndexInvalidException, IndexNameConflictException, IndexExistsException, RegionNotFoundException, UnsupportedOperationException {
        throw new UnsupportedOperationException("Index creation on the server is not supported from the client.");
    }

    @Override
    public Index createIndex(String indexName, String indexedExpression, String fromClause) throws IndexInvalidException, IndexNameConflictException, IndexExistsException, RegionNotFoundException, UnsupportedOperationException {
        throw new UnsupportedOperationException("Index creation on the server is not supported from the client.");
    }

    @Override
    public Index createIndex(String indexName, String indexedExpression, String fromClause, String imports) throws IndexInvalidException, IndexNameConflictException, IndexExistsException, RegionNotFoundException, UnsupportedOperationException {
        throw new UnsupportedOperationException("Index creation on the server is not supported from the client.");
    }

    @Override
    public Index createKeyIndex(String indexName, String indexedExpression, String fromClause) throws IndexInvalidException, IndexNameConflictException, IndexExistsException, RegionNotFoundException, UnsupportedOperationException {
        throw new UnsupportedOperationException("Index creation on the server is not supported from the client.");
    }

    @Override
    public void defineKeyIndex(String indexName, String indexedExpression, String fromClause) throws RegionNotFoundException {
        throw new UnsupportedOperationException("Index creation on the server is not supported from the client.");
    }

    @Override
    public void defineHashIndex(String indexName, String indexedExpression, String regionPath) throws RegionNotFoundException {
        throw new UnsupportedOperationException("Index creation on the server is not supported from the client.");
    }

    @Override
    public void defineHashIndex(String indexName, String indexedExpression, String regionPath, String imports) throws RegionNotFoundException {
        throw new UnsupportedOperationException("Index creation on the server is not supported from the client.");
    }

    @Override
    public void defineIndex(String indexName, String indexedExpression, String regionPath) throws RegionNotFoundException {
        throw new UnsupportedOperationException("Index creation on the server is not supported from the client.");
    }

    @Override
    public void defineIndex(String indexName, String indexedExpression, String regionPath, String imports) throws RegionNotFoundException {
        throw new UnsupportedOperationException("Index creation on the server is not supported from the client.");
    }

    @Override
    public List<Index> createDefinedIndexes() throws MultiIndexCreationException {
        throw new UnsupportedOperationException("Index creation on the server is not supported from the client.");
    }

    @Override
    public boolean clearDefinedIndexes() {
        throw new UnsupportedOperationException("Index creation on the server is not supported from the client.");
    }

    @Override
    public void executeCqs() throws CqException {
        block2: {
            this.preOp();
            try {
                ((DefaultQueryService)this.realQueryService).getCqService().executeCqs(this.getCqs());
            }
            catch (CqException cqe) {
                if (!logger.isDebugEnabled()) break block2;
                logger.debug("Unable to execute cqs. Error: {}", cqe.getMessage(), cqe);
            }
        }
    }

    @Override
    public void executeCqs(String regionName) throws CqException {
        block2: {
            this.preOp();
            try {
                ((DefaultQueryService)this.realQueryService).getCqService().executeCqs(this.getCqs(regionName));
            }
            catch (CqException cqe) {
                if (!logger.isDebugEnabled()) break block2;
                logger.debug("Unable to execute cqs on the specified region. Error: {}", cqe.getMessage(), cqe);
            }
        }
    }

    @Override
    public CqQuery getCq(String cqName) {
        this.preOp();
        if (this.cqNames.contains(cqName)) {
            return this.realQueryService.getCq(cqName);
        }
        return null;
    }

    @Override
    public CqServiceStatistics getCqStatistics() {
        throw new UnsupportedOperationException();
    }

    @Override
    public CqQuery[] getCqs() {
        CqQuery[] cqs;
        block3: {
            this.preOp();
            cqs = null;
            try {
                ArrayList<CqQuery> cqList = new ArrayList<CqQuery>();
                for (String name : this.cqNames) {
                    cqList.add(((DefaultQueryService)this.realQueryService).getCqService().getCq(name));
                }
                cqs = new CqQuery[cqList.size()];
                cqList.toArray(cqs);
            }
            catch (CqException cqe) {
                if (!logger.isDebugEnabled()) break block3;
                logger.debug("Unable to get Cqs. Error: {}", cqe.getMessage(), cqe);
            }
        }
        return cqs;
    }

    @Override
    public CqQuery[] getCqs(String regionName) throws CqException {
        CqQuery[] cqs;
        block3: {
            this.preOp();
            cqs = null;
            try {
                ArrayList<CqQuery> cqList = new ArrayList<CqQuery>();
                cqs = ((DefaultQueryService)this.realQueryService).getCqService().getAllCqs(regionName);
                for (int i = 0; i < cqs.length; ++i) {
                    if (!this.cqNames.contains(cqs[i].getName())) continue;
                    cqList.add(cqs[i]);
                }
                cqs = new CqQuery[cqList.size()];
                cqList.toArray(cqs);
            }
            catch (CqException cqe) {
                if (!logger.isDebugEnabled()) break block3;
                logger.debug("Unable to get Cqs. Error: {}", cqe.getMessage(), cqe);
            }
        }
        return cqs;
    }

    @Override
    public Index getIndex(Region<?, ?> region, String indexName) {
        throw new UnsupportedOperationException("Index operation on the server is not supported from the client.");
    }

    @Override
    public Collection<Index> getIndexes() {
        throw new UnsupportedOperationException("Index operation on the server is not supported from the client.");
    }

    @Override
    public Collection<Index> getIndexes(Region<?, ?> region) {
        throw new UnsupportedOperationException("Index operation on the server is not supported from the client.");
    }

    @Override
    public Collection<Index> getIndexes(Region<?, ?> region, IndexType indexType) {
        throw new UnsupportedOperationException("Index operation on the server is not supported from the client.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CqQuery newCq(String queryString, CqAttributes cqAttributes) throws QueryInvalidException, CqException {
        this.preOp(true);
        CqQueryImpl cq = null;
        try {
            cq = (CqQueryImpl)((DefaultQueryService)this.realQueryService).getCqService().newCq(null, queryString, cqAttributes, ((DefaultQueryService)this.realQueryService).getServerProxy(), false);
            cq.setProxyCache(this.proxyCache);
            this.cqNames.add(cq.getName());
        }
        catch (CqExistsException cqe) {
            if (logger.isDebugEnabled()) {
                logger.debug("Unable to createCq. Error: {}", cqe.getMessage(), cqe);
            }
        }
        finally {
            this.postOp();
        }
        return cq;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CqQuery newCq(String queryString, CqAttributes cqAttributes, boolean isDurable) throws QueryInvalidException, CqException {
        this.preOp(true);
        CqQueryImpl cq = null;
        try {
            cq = (CqQueryImpl)((DefaultQueryService)this.realQueryService).getCqService().newCq(null, queryString, cqAttributes, ((DefaultQueryService)this.realQueryService).getServerProxy(), isDurable);
            cq.setProxyCache(this.proxyCache);
            this.cqNames.add(cq.getName());
        }
        catch (CqExistsException cqe) {
            if (logger.isDebugEnabled()) {
                logger.debug("Unable to createCq. Error: {}", cqe.getMessage(), cqe);
            }
        }
        finally {
            this.postOp();
        }
        return cq;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CqQuery newCq(String cqName, String queryString, CqAttributes cqAttributes) throws QueryInvalidException, CqExistsException, CqException {
        this.preOp(true);
        try {
            if (cqName == null) {
                throw new IllegalArgumentException(LocalizedStrings.DefaultQueryService_CQNAME_MUST_NOT_BE_NULL.toLocalizedString());
            }
            CqQueryImpl cq = (CqQueryImpl)((DefaultQueryService)this.realQueryService).getCqService().newCq(cqName, queryString, cqAttributes, ((DefaultQueryService)this.realQueryService).getServerProxy(), false);
            cq.setProxyCache(this.proxyCache);
            this.cqNames.add(cq.getName());
            CqQueryImpl cqQueryImpl = cq;
            return cqQueryImpl;
        }
        finally {
            this.postOp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CqQuery newCq(String cqName, String queryString, CqAttributes cqAttributes, boolean isDurable) throws QueryInvalidException, CqExistsException, CqException {
        this.preOp(true);
        try {
            if (cqName == null) {
                throw new IllegalArgumentException(LocalizedStrings.DefaultQueryService_CQNAME_MUST_NOT_BE_NULL.toLocalizedString());
            }
            CqQueryImpl cq = (CqQueryImpl)((DefaultQueryService)this.realQueryService).getCqService().newCq(cqName, queryString, cqAttributes, ((DefaultQueryService)this.realQueryService).getServerProxy(), isDurable);
            cq.setProxyCache(this.proxyCache);
            this.cqNames.add(cq.getName());
            CqQueryImpl cqQueryImpl = cq;
            return cqQueryImpl;
        }
        finally {
            this.postOp();
        }
    }

    @Override
    public Query newQuery(String queryString) {
        this.preOp();
        return ((DefaultQueryService)this.realQueryService).newQuery(queryString, this.proxyCache);
    }

    @Override
    public void removeIndex(Index index2) {
        throw new UnsupportedOperationException("Index operation on the server is not supported from the client.");
    }

    @Override
    public void removeIndexes() {
        throw new UnsupportedOperationException("Index operation on the server is not supported from the client.");
    }

    @Override
    public void removeIndexes(Region<?, ?> region) {
        throw new UnsupportedOperationException("Index operation on the server is not supported from the client.");
    }

    @Override
    public void stopCqs() throws CqException {
        block2: {
            this.preOp();
            try {
                ((DefaultQueryService)this.realQueryService).getCqService().stopCqs(this.getCqs());
            }
            catch (CqException cqe) {
                if (!logger.isDebugEnabled()) break block2;
                logger.debug("Unable to stop all CQs. Error: {}", cqe.getMessage(), cqe);
            }
        }
    }

    @Override
    public void stopCqs(String regionName) throws CqException {
        block2: {
            this.preOp();
            try {
                ((DefaultQueryService)this.realQueryService).getCqService().stopCqs(this.getCqs(regionName));
            }
            catch (CqException cqe) {
                if (!logger.isDebugEnabled()) break block2;
                logger.debug("Unable to stop cqs on the specified region. Error: {}", cqe.getMessage(), cqe);
            }
        }
    }

    @Override
    public List<String> getAllDurableCqsFromServer() throws CqException {
        block2: {
            this.preOp();
            try {
                ((DefaultQueryService)this.realQueryService).getAllDurableCqsFromServer();
            }
            catch (CqException cqe) {
                if (!logger.isDebugEnabled()) break block2;
                logger.debug("Unable to get all durablec client cqs on the specified region. Error: {}", cqe.getMessage(), cqe);
            }
        }
        return Collections.EMPTY_LIST;
    }

    private void preOp() {
        this.preOp(false);
    }

    private void preOp(boolean setTL) {
        if (this.proxyCache.isClosed()) {
            throw new CacheClosedException("Cache is closed for this user.");
        }
        if (setTL) {
            UserAttributes.userAttributes.set(this.proxyCache.getUserAttributes());
        }
    }

    private void postOp() {
        UserAttributes.userAttributes.set(null);
    }
}

