/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.query.internal;

import com.gemstone.gemfire.cache.query.AmbiguousNameException;
import com.gemstone.gemfire.cache.query.NameNotFoundException;
import com.gemstone.gemfire.cache.query.NameResolutionException;
import com.gemstone.gemfire.cache.query.QueryInvocationTargetException;
import com.gemstone.gemfire.cache.query.QueryService;
import com.gemstone.gemfire.cache.query.Struct;
import com.gemstone.gemfire.cache.query.TypeMismatchException;
import com.gemstone.gemfire.cache.query.internal.AttributeDescriptor;
import com.gemstone.gemfire.cache.query.internal.CompiledID;
import com.gemstone.gemfire.cache.query.internal.CompiledOperation;
import com.gemstone.gemfire.cache.query.internal.CompiledPath;
import com.gemstone.gemfire.cache.query.internal.CompiledRegion;
import com.gemstone.gemfire.cache.query.internal.CompiledValue;
import com.gemstone.gemfire.cache.query.internal.DefaultQueryService;
import com.gemstone.gemfire.cache.query.internal.ExecutionContext;
import com.gemstone.gemfire.cache.query.internal.QRegion;
import com.gemstone.gemfire.cache.query.internal.RuntimeIterator;
import com.gemstone.gemfire.cache.query.internal.Support;
import com.gemstone.gemfire.cache.query.internal.types.TypeUtils;
import com.gemstone.gemfire.cache.query.types.ObjectType;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class PathUtils {
    public static String[] tokenizePath(String path) {
        ArrayList<String> alist = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(path, ".");
        while (tokenizer.hasMoreTokens()) {
            alist.add(tokenizer.nextToken());
        }
        return alist.toArray(new String[alist.size()]);
    }

    public static String buildPathString(String[] path) {
        Support.assertArg(path != null && path.length > 0, "path should not be null or empty");
        StringBuffer buf = new StringBuffer();
        buf.append(path[0]);
        for (int i = 1; i < path.length; ++i) {
            buf.append('.');
            buf.append(path[i]);
        }
        return buf.toString();
    }

    public static Object evaluateAttribute(Object target, String attribute) throws NameNotFoundException, QueryInvocationTargetException {
        if (target instanceof Struct) {
            Struct struct = (Struct)target;
            try {
                return struct.get(attribute);
            }
            catch (Exception e) {
                throw new NameNotFoundException(attribute);
            }
        }
        try {
            return new AttributeDescriptor(attribute).read(target);
        }
        catch (NameNotFoundException nfe) {
            if (DefaultQueryService.QUERY_HETEROGENEOUS_OBJECTS || DefaultQueryService.TEST_QUERY_HETEROGENEOUS_OBJECTS) {
                return QueryService.UNDEFINED;
            }
            throw nfe;
        }
    }

    public static ObjectType[] calculateTypesAlongPath(ObjectType initialType, String[] pathArray) throws NameNotFoundException {
        ObjectType[] types = new ObjectType[pathArray.length + 1];
        types[0] = initialType;
        for (int i = 1; i < types.length; ++i) {
            ObjectType currentType = types[i - 1];
            Member member = new AttributeDescriptor(pathArray[i - 1]).getReadMember(currentType);
            if (member instanceof Field) {
                types[i] = TypeUtils.getObjectType(((Field)member).getType());
                continue;
            }
            if (!(member instanceof Method)) continue;
            types[i] = TypeUtils.getObjectType(((Method)member).getReturnType());
        }
        return types;
    }

    public static ObjectType computeElementTypeOfExpression(ExecutionContext context, CompiledValue expr) throws AmbiguousNameException {
        try {
            ObjectType type = TypeUtils.OBJECT_TYPE;
            ArrayList<String> exprSteps = new ArrayList<String>();
            while (true) {
                if (expr instanceof CompiledPath) {
                    CompiledPath path = (CompiledPath)expr;
                    exprSteps.add(0, path.getTailID());
                    expr = path.getReceiver();
                    continue;
                }
                if (expr instanceof CompiledOperation) {
                    CompiledOperation operation = (CompiledOperation)expr;
                    if (operation.getArguments().size() > 0) {
                        return TypeUtils.OBJECT_TYPE;
                    }
                    exprSteps.add(0, operation.getMethodName() + "()");
                    expr = operation.getReceiver(context);
                    if (expr != null) continue;
                    expr = context.resolveImplicitOperationName(operation.getMethodName(), operation.getArguments().size(), true);
                    continue;
                }
                if (!(expr instanceof CompiledID)) break;
                expr = context.resolve(((CompiledID)expr).getId());
            }
            if (expr instanceof CompiledRegion) {
                QRegion qrgn = (QRegion)((CompiledRegion)expr).evaluate(context);
                type = qrgn.getCollectionType();
            } else if (expr instanceof RuntimeIterator) {
                type = ((RuntimeIterator)expr).getElementType();
            } else {
                return TypeUtils.OBJECT_TYPE;
            }
            if (!TypeUtils.OBJECT_TYPE.equals(type)) {
                Class<?> clazz = type.resolveClass();
                for (int i = 0; i < exprSteps.size(); ++i) {
                    Member member;
                    String stepStr = (String)exprSteps.get(i);
                    if (stepStr.endsWith("()")) {
                        stepStr = stepStr.substring(0, stepStr.length() - 2);
                        member = clazz.getMethod(stepStr, null);
                    } else {
                        member = new AttributeDescriptor(stepStr).getReadMember(clazz);
                    }
                    if (member instanceof Field) {
                        clazz = ((Field)member).getType();
                    } else if (member instanceof Method) {
                        clazz = ((Method)member).getReturnType();
                    }
                    type = TypeUtils.getObjectType(clazz);
                }
                return type;
            }
        }
        catch (NoSuchMethodException e) {
        }
        catch (NameResolutionException e) {
        }
        catch (TypeMismatchException typeMismatchException) {
            // empty catch block
        }
        return TypeUtils.OBJECT_TYPE;
    }
}

