/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.query.internal;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.DataSerializableFixedID;
import com.gemstone.gemfire.internal.Version;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;

public class PRQueryTraceInfo
implements DataSerializableFixedID {
    public String indexesUsed = "";
    private InternalDistributedMember sender;
    private float timeInMillis;
    private int numResults;

    @Override
    public void toData(DataOutput out) throws IOException {
        out.writeFloat(this.timeInMillis);
        out.writeInt(this.numResults);
        DataSerializer.writeString(this.indexesUsed, out);
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        this.timeInMillis = in.readFloat();
        this.numResults = in.readInt();
        this.indexesUsed = DataSerializer.readString(in);
    }

    @Override
    public Version[] getSerializationVersions() {
        return null;
    }

    @Override
    public int getDSFID() {
        return 2162;
    }

    public int calculateNumberOfResults(Collection resultCollector) {
        int traceSize = 0;
        for (Collection collection : resultCollector) {
            traceSize += collection.size();
        }
        return traceSize;
    }

    public String createLogLine(DistributedMember me) {
        if (this.sender.equals(me)) {
            return LocalizedStrings.PartitionedRegion_QUERY_TRACE_LOCAL_NODE_LOG.toLocalizedString(this.sender, Float.valueOf(this.timeInMillis), this.numResults, this.indexesUsed);
        }
        return LocalizedStrings.PartitionedRegion_QUERY_TRACE_REMOTE_NODE_LOG.toLocalizedString(this.sender, Float.valueOf(this.timeInMillis), this.numResults, this.indexesUsed);
    }

    public float getTimeInMillis() {
        return this.timeInMillis;
    }

    public void setTimeInMillis(float timeInMillis) {
        this.timeInMillis = timeInMillis;
    }

    public void setSender(InternalDistributedMember sender) {
        this.sender = sender;
    }

    public void setNumResults(int numResults) {
        this.numResults = numResults;
    }

    public void setIndexesUsed(String indexesUsed) {
        this.indexesUsed = indexesUsed;
    }
}

