/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.query.internal;

import com.gemstone.gemfire.cache.query.QueryService;
import com.gemstone.gemfire.cache.query.internal.StructBag;
import com.gemstone.gemfire.cache.query.internal.Support;
import com.gemstone.gemfire.cache.query.types.ObjectType;
import com.gemstone.gemfire.pdx.internal.PdxString;
import com.gemstone.gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;

class OrderByComparator
implements Comparator {
    final Map orderByMap;
    private final ObjectType objType;

    public OrderByComparator(ObjectType objType) {
        this.objType = objType;
        this.orderByMap = objType.isStructType() ? new THashMap(new StructBag.ObjectArrayTHashingStrategy()) : new HashMap();
    }

    public int compare(Object obj1, Object obj2) {
        int result = -1;
        if (obj1 == null && obj2 == null) {
            return 0;
        }
        if (this.objType.isStructType() && obj1 instanceof Object[] && obj2 instanceof Object[] || !this.objType.isStructType()) {
            ArrayList list1 = (ArrayList)this.orderByMap.get(obj1);
            ArrayList list2 = (ArrayList)this.orderByMap.get(obj2);
            if (list1.size() != list2.size()) {
                Support.assertionFailed("Error Occured due to improper sort criteria evaluation ");
            } else {
                int i;
                for (i = 0; i < list1.size(); ++i) {
                    Object[] arr1 = (Object[])list1.get(i);
                    Object[] arr2 = (Object[])list2.get(i);
                    if (arr1[0] == null || arr2[0] == null) {
                        result = arr1[0] == null ? (arr2[0] == null ? 0 : -1) : 1;
                    } else if (arr1[0] == QueryService.UNDEFINED || arr2[0] == QueryService.UNDEFINED) {
                        result = arr1[0] == QueryService.UNDEFINED ? (arr2[0] == QueryService.UNDEFINED ? 0 : -1) : 1;
                    } else {
                        if (arr1[0] instanceof PdxString && arr2[0] instanceof String) {
                            arr2[0] = new PdxString((String)arr2[0]);
                        } else if (arr2[0] instanceof PdxString && arr1[0] instanceof String) {
                            arr1[0] = new PdxString((String)arr1[0]);
                        }
                        result = ((Comparable)arr1[0]).compareTo(arr2[0]);
                    }
                    if (result == 0) continue;
                    if (((Boolean)arr1[1]).booleanValue()) {
                        result *= -1;
                    }
                    return result;
                }
                if (this.objType.isStructType()) {
                    i = 0;
                    for (Object o1 : (Object[])obj1) {
                        Object o2 = ((Object[])obj2)[i++];
                        if (o1 == null || o2 == null) {
                            if (o1 == null) {
                                if (o2 == null) continue;
                                return -1;
                            }
                            return 1;
                        }
                        if (o1 == QueryService.UNDEFINED || o2 == QueryService.UNDEFINED) {
                            if (o1 == QueryService.UNDEFINED) {
                                if (o2 == QueryService.UNDEFINED) continue;
                                return -1;
                            }
                            return 1;
                        }
                        if (o1 instanceof Comparable) {
                            if (o1 instanceof PdxString && o2 instanceof String) {
                                o2 = new PdxString((String)o2);
                            } else if (o2 instanceof PdxString && o1 instanceof String) {
                                o1 = new PdxString((String)o1);
                            }
                            int rslt = ((Comparable)o1).compareTo(o2);
                            if (rslt == 0) continue;
                            return rslt;
                        }
                        if (o1.equals(o2)) continue;
                        return -1;
                    }
                    return 0;
                }
                if (obj1 instanceof PdxString && obj2 instanceof String) {
                    obj2 = new PdxString((String)obj2);
                } else if (obj2 instanceof PdxString && obj1 instanceof String) {
                    obj1 = new PdxString((String)obj1);
                }
                if (obj1 instanceof Comparable) {
                    return ((Comparable)obj1).compareTo(obj2);
                }
                return obj1.equals(obj2) ? 0 : -1;
            }
        }
        return -1;
    }
}

