/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.query.internal;

import com.gemstone.gemfire.cache.query.Index;
import com.gemstone.gemfire.cache.query.internal.QueryObserverAdapter;
import com.gemstone.gemfire.cache.query.internal.index.CompactMapRangeIndex;
import com.gemstone.gemfire.cache.query.internal.index.MapRangeIndex;
import com.gemstone.gemfire.internal.cache.PartitionedRegionQueryEvaluator;
import com.gemstone.gnu.trove.THashMap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class IndexTrackingQueryObserver
extends QueryObserverAdapter {
    private static final ThreadLocal indexInfo = new ThreadLocal();
    private static final ThreadLocal lastIndexUsed = new ThreadLocal();
    private volatile PartitionedRegionQueryEvaluator.TestHook th;

    @Override
    public void beforeIndexLookup(Index index2, int oper, Object key2) {
        HashMap<String, IndexInfo> indexMap = (HashMap<String, IndexInfo>)indexInfo.get();
        if (indexMap == null) {
            indexMap = new HashMap<String, IndexInfo>();
            indexInfo.set(indexMap);
        }
        String indexName = index2 instanceof MapRangeIndex || index2 instanceof CompactMapRangeIndex ? index2.getName() + "-" + ((Object[])key2)[1] : index2.getName();
        IndexInfo iInfo = indexMap.containsKey(indexName) ? (IndexInfo)indexMap.get(indexName) : new IndexInfo();
        iInfo.addRegionId(index2.getRegion().getFullPath());
        indexMap.put(indexName, iInfo);
        lastIndexUsed.set(index2);
        if (this.th != null) {
            this.th.hook(1);
        }
    }

    @Override
    public void beforeIndexLookup(Index index2, int lowerBoundOperator, Object lowerBoundKey, int upperBoundOperator, Object upperBoundKey, Set NotEqualKeys) {
        HashMap<String, IndexInfo> indexMap = (HashMap<String, IndexInfo>)indexInfo.get();
        if (indexMap == null) {
            indexMap = new HashMap<String, IndexInfo>();
            indexInfo.set(indexMap);
        }
        IndexInfo iInfo = indexMap.containsKey(index2.getName()) ? (IndexInfo)indexMap.get(index2.getName()) : new IndexInfo();
        iInfo.addRegionId(index2.getRegion().getFullPath());
        indexMap.put(index2.getName(), iInfo);
        lastIndexUsed.set(index2);
        if (this.th != null) {
            this.th.hook(2);
        }
    }

    @Override
    public void afterIndexLookup(Collection results) {
        if (results == null) {
            return;
        }
        Map indexMap = (Map)indexInfo.get();
        if (lastIndexUsed.get() != null) {
            IndexInfo indexInfo = (IndexInfo)indexMap.get(((Index)lastIndexUsed.get()).getName());
            if (indexInfo != null) {
                indexInfo.getResults().put(((Index)lastIndexUsed.get()).getRegion().getFullPath(), new Integer(results.size()));
            }
        }
        lastIndexUsed.set(null);
        if (this.th != null) {
            this.th.hook(3);
        }
    }

    public void reset() {
        if (this.th != null) {
            this.th.hook(4);
        }
        indexInfo.set(null);
    }

    public void setIndexInfo(Map indexInfoMap) {
        indexInfo.set(indexInfoMap);
    }

    public Map getUsedIndexes() {
        Map map = (Map)indexInfo.get();
        if (map == null) {
            return Collections.EMPTY_MAP;
        }
        return map;
    }

    public void setTestHook(PartitionedRegionQueryEvaluator.TestHook testHook) {
        this.th = testHook;
    }

    public Map getUsedIndexes(String fullPath) {
        Map map = (Map)indexInfo.get();
        if (map == null) {
            return Collections.EMPTY_MAP;
        }
        HashMap newMap = new HashMap();
        for (Map.Entry obj : map.entrySet()) {
            Map.Entry entry = obj;
            if (entry == null || !((IndexInfo)entry.getValue()).getRegionIds().contains(fullPath)) continue;
            newMap.put(entry.getKey(), ((IndexInfo)entry.getValue()).getResults().get(fullPath));
        }
        return newMap;
    }

    public PartitionedRegionQueryEvaluator.TestHook getTestHook() {
        return this.th;
    }

    public class IndexInfo {
        private Map<String, Integer> results = new THashMap();

        public Map getResults() {
            return this.results;
        }

        public void addResults(Map rslts) {
            Iterator i$ = rslts.entrySet().iterator();
            while (i$.hasNext()) {
                Map.Entry obj;
                Map.Entry ent = obj = i$.next();
                this.results.put((String)ent.getKey(), (Integer)ent.getValue());
            }
        }

        public Set getRegionIds() {
            return this.results.keySet();
        }

        public void addRegionId(String regionId) {
            this.results.put(regionId, 0);
        }

        public String toString() {
            int total = 0;
            for (Integer i : this.results.values()) {
                total += i.intValue();
            }
            return "(Results: " + total + ")";
        }

        public void merge(IndexInfo src) {
            this.addResults(src.getResults());
        }
    }
}

