/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.query.internal;

import com.gemstone.gemfire.cache.query.FunctionDomainException;
import com.gemstone.gemfire.cache.query.NameResolutionException;
import com.gemstone.gemfire.cache.query.QueryInvocationTargetException;
import com.gemstone.gemfire.cache.query.TypeMismatchException;
import com.gemstone.gemfire.cache.query.internal.AbstractGroupOrRangeJunction;
import com.gemstone.gemfire.cache.query.internal.CompiledValue;
import com.gemstone.gemfire.cache.query.internal.ExecutionContext;
import com.gemstone.gemfire.cache.query.internal.Filter;
import com.gemstone.gemfire.cache.query.internal.OrganizedOperands;
import com.gemstone.gemfire.cache.query.internal.PlanInfo;
import com.gemstone.gemfire.cache.query.internal.QueryExecutionContext;
import com.gemstone.gemfire.cache.query.internal.RuntimeIterator;
import com.gemstone.gemfire.cache.query.internal.Support;
import java.util.ArrayList;
import java.util.List;

public class GroupJunction
extends AbstractGroupOrRangeJunction {
    private List unevaluatedFilterOperands = null;

    GroupJunction(int operator, RuntimeIterator[] indpndntItr, boolean isCompleteExpansion, CompiledValue[] operands) {
        super(operator, indpndntItr, isCompleteExpansion, operands);
    }

    @Override
    void addUnevaluatedFilterOperands(List unevaluatedFilterOps) {
        this.unevaluatedFilterOperands = unevaluatedFilterOps;
    }

    List getUnevaluatedFilterOperands() {
        return this.unevaluatedFilterOperands;
    }

    private GroupJunction(AbstractGroupOrRangeJunction oldGJ, boolean completeExpansion, RuntimeIterator[] indpnds, CompiledValue iterOp) {
        super(oldGJ, completeExpansion, indpnds, iterOp);
    }

    @Override
    AbstractGroupOrRangeJunction recreateFromOld(boolean completeExpansion, RuntimeIterator[] indpnds, CompiledValue iterOp) {
        return new GroupJunction(this, completeExpansion, indpnds, iterOp);
    }

    @Override
    AbstractGroupOrRangeJunction createNewOfSameType(int operator, RuntimeIterator[] indpndntItr, boolean isCompleteExpansion, CompiledValue[] operands) {
        return new GroupJunction(operator, indpndntItr, isCompleteExpansion, operands);
    }

    @Override
    OrganizedOperands organizeOperands(ExecutionContext context) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
        ArrayList<Object> evalOperands = new ArrayList<Object>(this._operands.length);
        int indexCount = 0;
        boolean foundPreferredCondition = false;
        if (this.getOperator() == 84) {
            if (context instanceof QueryExecutionContext && ((QueryExecutionContext)context).hasHints() && ((QueryExecutionContext)context).hasMultiHints()) {
                for (int i = 0; i < this._operands.length; ++i) {
                    if (this._operands[i].getPlanInfo((ExecutionContext)context).evalAsFilter) {
                        ++indexCount;
                        evalOperands.add(0, this._operands[i]);
                        continue;
                    }
                    evalOperands.add(this._operands[i]);
                }
            } else {
                Filter currentBestFilter = null;
                int currentBestFilterSize = -1;
                indexCount = 1;
                for (int i = 0; i < this._operands.length; ++i) {
                    PlanInfo pi = this._operands[i].getPlanInfo(context);
                    if (pi.evalAsFilter) {
                        if (pi.isPreferred) {
                            if (currentBestFilter != null) {
                                evalOperands.add(currentBestFilter);
                            }
                            currentBestFilter = (Filter)((Object)this._operands[i]);
                            currentBestFilterSize = ((Filter)((Object)this._operands[i])).getSizeEstimate(context);
                            foundPreferredCondition = true;
                            continue;
                        }
                        if (currentBestFilter == null) {
                            currentBestFilter = (Filter)((Object)this._operands[i]);
                            currentBestFilterSize = ((Filter)((Object)this._operands[i])).getSizeEstimate(context);
                            continue;
                        }
                        if (foundPreferredCondition || currentBestFilter.isBetterFilter((Filter)((Object)this._operands[i]), context, currentBestFilterSize)) {
                            evalOperands.add(this._operands[i]);
                            continue;
                        }
                        evalOperands.add(currentBestFilter);
                        currentBestFilter = (Filter)((Object)this._operands[i]);
                        currentBestFilterSize = ((Filter)((Object)this._operands[i])).getSizeEstimate(context);
                        continue;
                    }
                    if (!this._operands[i].isDependentOnCurrentScope(context)) {
                        Support.assertionFailed("An independentoperand should not ever be present as operand inside a GroupJunction as it should always be present only in CompiledJunction");
                        continue;
                    }
                    evalOperands.add(this._operands[i]);
                }
                evalOperands.add(0, currentBestFilter);
            }
        } else {
            indexCount = this._operands.length;
            for (int i = 0; i < indexCount; ++i) {
                evalOperands.add(this._operands[i]);
            }
        }
        if (this.getIterOperands() != null) {
            evalOperands.add(this.getIterOperands());
        }
        return this.createOrganizedOperandsObject(indexCount, evalOperands);
    }

    @Override
    public int getSizeEstimate(ExecutionContext context) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
        return 1;
    }
}

