/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.query.internal;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.LowMemoryException;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.client.Pool;
import com.gemstone.gemfire.cache.client.internal.ExecutablePool;
import com.gemstone.gemfire.cache.client.internal.GetDurableCQsOp;
import com.gemstone.gemfire.cache.client.internal.InternalPool;
import com.gemstone.gemfire.cache.client.internal.ProxyCache;
import com.gemstone.gemfire.cache.client.internal.ServerCQProxy;
import com.gemstone.gemfire.cache.client.internal.UserAttributes;
import com.gemstone.gemfire.cache.query.AmbiguousNameException;
import com.gemstone.gemfire.cache.query.CqAttributes;
import com.gemstone.gemfire.cache.query.CqException;
import com.gemstone.gemfire.cache.query.CqExistsException;
import com.gemstone.gemfire.cache.query.CqQuery;
import com.gemstone.gemfire.cache.query.CqServiceStatistics;
import com.gemstone.gemfire.cache.query.Index;
import com.gemstone.gemfire.cache.query.IndexCreationException;
import com.gemstone.gemfire.cache.query.IndexExistsException;
import com.gemstone.gemfire.cache.query.IndexNameConflictException;
import com.gemstone.gemfire.cache.query.IndexType;
import com.gemstone.gemfire.cache.query.MultiIndexCreationException;
import com.gemstone.gemfire.cache.query.NameResolutionException;
import com.gemstone.gemfire.cache.query.Query;
import com.gemstone.gemfire.cache.query.QueryExecutionLowMemoryException;
import com.gemstone.gemfire.cache.query.QueryInvalidException;
import com.gemstone.gemfire.cache.query.QueryService;
import com.gemstone.gemfire.cache.query.RegionNotFoundException;
import com.gemstone.gemfire.cache.query.TypeMismatchException;
import com.gemstone.gemfire.cache.query.internal.CompiledIteratorDef;
import com.gemstone.gemfire.cache.query.internal.CompiledRegion;
import com.gemstone.gemfire.cache.query.internal.CompiledValue;
import com.gemstone.gemfire.cache.query.internal.CqQueryImpl;
import com.gemstone.gemfire.cache.query.internal.CqService;
import com.gemstone.gemfire.cache.query.internal.DefaultQuery;
import com.gemstone.gemfire.cache.query.internal.ExecutionContext;
import com.gemstone.gemfire.cache.query.internal.QCompiler;
import com.gemstone.gemfire.cache.query.internal.QueryMonitor;
import com.gemstone.gemfire.cache.query.internal.QueryUtils;
import com.gemstone.gemfire.cache.query.internal.index.AbstractIndex;
import com.gemstone.gemfire.cache.query.internal.index.IndexCreationData;
import com.gemstone.gemfire.cache.query.internal.index.IndexData;
import com.gemstone.gemfire.cache.query.internal.index.IndexManager;
import com.gemstone.gemfire.cache.query.internal.index.IndexUtils;
import com.gemstone.gemfire.cache.query.internal.index.PartitionedIndex;
import com.gemstone.gemfire.internal.cache.ForceReattemptException;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.control.InternalResourceManager;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.internal.logging.log4j.LocalizedMessage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.Logger;

public class DefaultQueryService
implements QueryService {
    private static final Logger logger = LogService.getLogger();
    public static final boolean QUERY_HETEROGENEOUS_OBJECTS = Boolean.valueOf(System.getProperty("gemfire.QueryService.QueryHeterogeneousObjects", "true"));
    public static boolean COPY_ON_READ_AT_ENTRY_LEVEL = Boolean.valueOf(System.getProperty("gemfire.QueryService.CopyOnReadAtEntryLevel", "false"));
    public static boolean TEST_QUERY_HETEROGENEOUS_OBJECTS = false;
    private final Cache cache;
    private Pool pool;
    private ServerCQProxy serverProxy;
    private Map<Region, HashSet<IndexCreationData>> indexDefinitions = Collections.synchronizedMap(new HashMap());

    public DefaultQueryService(Cache cache) {
        if (cache == null) {
            throw new IllegalArgumentException(LocalizedStrings.DefaultQueryService_CACHE_MUST_NOT_BE_NULL.toLocalizedString());
        }
        this.cache = cache;
    }

    @Override
    public Query newQuery(String queryString) {
        if (QueryMonitor.isLowMemory()) {
            String reason = LocalizedStrings.QueryMonitor_LOW_MEMORY_CANCELED_QUERY.toLocalizedString(QueryMonitor.getMemoryUsedDuringLowMemory());
            throw new QueryExecutionLowMemoryException(reason);
        }
        if (queryString == null) {
            throw new QueryInvalidException(LocalizedStrings.DefaultQueryService_THE_QUERY_STRING_MUST_NOT_BE_NULL.toLocalizedString());
        }
        if (queryString.length() == 0) {
            throw new QueryInvalidException(LocalizedStrings.DefaultQueryService_THE_QUERY_STRING_MUST_NOT_BE_EMPTY.toLocalizedString());
        }
        DefaultQuery query = new DefaultQuery(queryString, this.cache);
        query.setServerProxy(this.serverProxy);
        return query;
    }

    public Query newQuery(String queryString, ProxyCache proxyCache) {
        Query query = this.newQuery(queryString);
        ((DefaultQuery)query).setProxyCache(proxyCache);
        return query;
    }

    @Override
    public Index createHashIndex(String indexName, String indexedExpression, String fromClause) throws IndexNameConflictException, IndexExistsException, RegionNotFoundException {
        return this.createHashIndex(indexName, indexedExpression, fromClause, null);
    }

    @Override
    public Index createHashIndex(String indexName, String indexedExpression, String fromClause, String imports) throws IndexNameConflictException, IndexExistsException, RegionNotFoundException {
        return this.createIndex(indexName, IndexType.HASH, indexedExpression, fromClause, imports);
    }

    @Override
    public Index createIndex(String indexName, String indexedExpression, String fromClause) throws IndexNameConflictException, IndexExistsException, RegionNotFoundException {
        return this.createIndex(indexName, IndexType.FUNCTIONAL, indexedExpression, fromClause, null);
    }

    @Override
    public Index createIndex(String indexName, String indexedExpression, String fromClause, String imports) throws IndexNameConflictException, IndexExistsException, RegionNotFoundException {
        return this.createIndex(indexName, IndexType.FUNCTIONAL, indexedExpression, fromClause, imports);
    }

    @Override
    public Index createKeyIndex(String indexName, String indexedExpression, String fromClause) throws IndexNameConflictException, IndexExistsException, RegionNotFoundException {
        return this.createIndex(indexName, IndexType.PRIMARY_KEY, indexedExpression, fromClause, null);
    }

    @Override
    public Index createIndex(String indexName, IndexType indexType, String indexedExpression, String fromClause) throws IndexNameConflictException, IndexExistsException, RegionNotFoundException {
        return this.createIndex(indexName, indexType, indexedExpression, fromClause, null);
    }

    public Index createIndex(String indexName, IndexType indexType, String indexedExpression, String fromClause, String imports, boolean loadEntries) throws IndexNameConflictException, IndexExistsException, RegionNotFoundException {
        return this.createIndex(indexName, indexType, indexedExpression, fromClause, imports, loadEntries, null);
    }

    public Index createIndex(String indexName, IndexType indexType, String indexedExpression, String fromClause, String imports, boolean loadEntries, Region region) throws IndexNameConflictException, IndexExistsException, RegionNotFoundException {
        if (this.pool != null) {
            throw new UnsupportedOperationException("Index creation on the server is not supported from the client.");
        }
        PartitionedIndex parIndex = null;
        if (region == null) {
            region = this.getRegionFromPath(imports, fromClause);
        }
        RegionAttributes ra = region.getAttributes();
        if (((LocalRegion)region).heapThresholdReached.get() && !InternalResourceManager.isLowMemoryExceptionDisabled()) {
            LocalRegion lr = (LocalRegion)region;
            throw new LowMemoryException(LocalizedStrings.ResourceManager_LOW_MEMORY_FOR_INDEX.toLocalizedString(region.getName()), lr.getHeapThresholdReachedMembers());
        }
        if (region instanceof PartitionedRegion) {
            try {
                parIndex = (PartitionedIndex)((PartitionedRegion)region).createIndex(false, indexType, indexName, indexedExpression, fromClause, imports, loadEntries);
            }
            catch (ForceReattemptException ex) {
                region.getCache().getLoggerI18n().info(LocalizedStrings.DefaultQueryService_EXCEPTION_WHILE_CREATING_INDEX_ON_PR_DEFAULT_QUERY_PROCESSOR, ex);
            }
            catch (IndexCreationException exx) {
                region.getCache().getLoggerI18n().info(LocalizedStrings.DefaultQueryService_EXCEPTION_WHILE_CREATING_INDEX_ON_PR_DEFAULT_QUERY_PROCESSOR, exx);
            }
            return parIndex;
        }
        IndexManager indexManager = IndexUtils.getIndexManager(region, true);
        Index index2 = indexManager.createIndex(indexName, indexType, indexedExpression, fromClause, imports, null, null, loadEntries);
        return index2;
    }

    @Override
    public Index createIndex(String indexName, IndexType indexType, String indexedExpression, String fromClause, String imports) throws IndexNameConflictException, IndexExistsException, RegionNotFoundException {
        return this.createIndex(indexName, indexType, indexedExpression, fromClause, imports, true);
    }

    private Region getRegionFromPath(String imports, String fromClause) throws RegionNotFoundException {
        QCompiler compiler = new QCompiler();
        if (imports != null) {
            compiler.compileImports(imports);
        }
        List list = compiler.compileFromClause(fromClause);
        CompiledValue cv = QueryUtils.obtainTheBottomMostCompiledValue(((CompiledIteratorDef)list.get(0)).getCollectionExpr());
        String regionPath = null;
        if (cv.getType() != 35) {
            throw new RegionNotFoundException(LocalizedStrings.DefaultQueryService_DEFAULTQUERYSERVICECREATEINDEXFIRST_ITERATOR_OF_INDEX_FROM_CLAUSE_DOES_NOT_EVALUATE_TO_A_REGION_PATH_THE_FROM_CLAUSE_USED_FOR_INDEX_CREATION_IS_0.toLocalizedString(fromClause));
        }
        regionPath = ((CompiledRegion)cv).getRegionPath();
        Region region = this.cache.getRegion(regionPath);
        if (region == null) {
            throw new RegionNotFoundException(LocalizedStrings.DefaultQueryService_REGION_0_NOT_FOUND_FROM_1.toLocalizedString(regionPath, fromClause));
        }
        return region;
    }

    public IndexData getIndex(String regionPath, String[] definitions, IndexType indexType, CompiledValue indexedExpression, ExecutionContext context) throws AmbiguousNameException, TypeMismatchException, NameResolutionException {
        Region region = this.cache.getRegion(regionPath);
        if (region == null) {
            return null;
        }
        IndexManager indexManager = IndexUtils.getIndexManager(region, true);
        IndexData indexData = indexManager.getIndex(indexType, definitions, indexedExpression, context);
        return indexData;
    }

    public Index getIndex(Region region, String indexName) {
        if (this.pool != null) {
            throw new UnsupportedOperationException("Index Operation is not supported on the Server Region.");
        }
        if (region instanceof PartitionedRegion) {
            return (Index)((PartitionedRegion)region).getIndex().get(indexName);
        }
        IndexManager indexManager = IndexUtils.getIndexManager(region, false);
        if (indexManager == null) {
            return null;
        }
        return indexManager.getIndex(indexName);
    }

    public IndexData getBestMatchIndex(String regionPath, String[] definitions, IndexType indexType, CompiledValue indexedExpression, ExecutionContext context) throws AmbiguousNameException, TypeMismatchException, NameResolutionException {
        Region region = this.cache.getRegion(regionPath);
        if (region == null) {
            return null;
        }
        IndexManager indexManager = IndexUtils.getIndexManager(region, false);
        if (indexManager == null) {
            return null;
        }
        return indexManager.getBestMatchIndex(indexType, definitions, indexedExpression, context);
    }

    public Collection getIndexes() {
        ArrayList allIndexes = new ArrayList();
        for (Region<?, ?> region : this.cache.rootRegions()) {
            Collection indexes = this.getIndexes((Region)region);
            if (indexes != null) {
                allIndexes.addAll(indexes);
            }
            Iterator<Region<?, ?>> subRegions = region.subregions(true).iterator();
            while (subRegions.hasNext()) {
                indexes = this.getIndexes((Region)subRegions.next());
                if (indexes == null) continue;
                allIndexes.addAll(indexes);
            }
        }
        return allIndexes;
    }

    public Collection getIndexes(Region region) {
        if (this.pool != null) {
            throw new UnsupportedOperationException("Index Operation is not supported on the Server Region.");
        }
        if (region instanceof PartitionedRegion) {
            return ((PartitionedRegion)region).getIndexes();
        }
        IndexManager indexManager = IndexUtils.getIndexManager(region, false);
        if (indexManager == null) {
            return null;
        }
        return indexManager.getIndexes();
    }

    public Collection getIndexes(Region region, IndexType indexType) {
        if (this.pool != null) {
            throw new UnsupportedOperationException("Index Operation is not supported on the Server Region.");
        }
        IndexManager indexManager = IndexUtils.getIndexManager(region, false);
        if (indexManager == null) {
            return null;
        }
        return indexManager.getIndexes(indexType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeIndex(Index index2) {
        if (this.pool != null) {
            throw new UnsupportedOperationException("Index Operation is not supported on the Server Region.");
        }
        Region<?, ?> region = index2.getRegion();
        if (region instanceof PartitionedRegion) {
            try {
                ((PartitionedRegion)region).removeIndex(index2, false);
            }
            catch (ForceReattemptException ex) {
                logger.info(LocalizedMessage.create(LocalizedStrings.DefaultQueryService_EXCEPTION_REMOVING_INDEX___0), (Throwable)ex);
            }
            return;
        }
        ((AbstractIndex)index2).acquireIndexWriteLockForRemove();
        try {
            IndexManager indexManager = ((LocalRegion)index2.getRegion()).getIndexManager();
            indexManager.removeIndex(index2);
        }
        finally {
            ((AbstractIndex)index2).releaseIndexWriteLockForRemove();
        }
    }

    @Override
    public void removeIndexes() {
        if (this.pool != null) {
            throw new UnsupportedOperationException("Index Operation is not supported on the Server Region.");
        }
        for (Region<?, ?> region : this.cache.rootRegions()) {
            Iterator<Region<?, ?>> subRegions = region.subregions(true).iterator();
            while (subRegions.hasNext()) {
                this.removeIndexes((Region)subRegions.next());
            }
            this.removeIndexes((Region)region);
        }
    }

    public void removeIndexes(Region region) {
        IndexManager indexManager;
        if (this.pool != null) {
            throw new UnsupportedOperationException("Index Operation is not supported on the Server Region.");
        }
        if (region instanceof PartitionedRegion) {
            try {
                ((PartitionedRegion)region).removeIndexes(false);
            }
            catch (ForceReattemptException ex) {
                logger.info(LocalizedMessage.create(LocalizedStrings.DefaultQueryService_EXCEPTION_REMOVING_INDEX___0), (Throwable)ex);
            }
        }
        if ((indexManager = IndexUtils.getIndexManager(region, false)) == null) {
            return;
        }
        indexManager.removeIndexes();
    }

    @Override
    public CqQuery newCq(String queryString, CqAttributes cqAttributes) throws QueryInvalidException, CqException {
        CqQueryImpl cq;
        block2: {
            cq = null;
            try {
                cq = (CqQueryImpl)this.getCqService().newCq(null, queryString, cqAttributes, this.serverProxy, false);
            }
            catch (CqExistsException cqe) {
                if (!logger.isDebugEnabled()) break block2;
                logger.debug("Unable to createCq. Error :{}", cqe.getMessage(), cqe);
            }
        }
        return cq;
    }

    @Override
    public CqQuery newCq(String queryString, CqAttributes cqAttributes, boolean isDurable) throws QueryInvalidException, CqException {
        CqQueryImpl cq;
        block2: {
            cq = null;
            try {
                cq = (CqQueryImpl)this.getCqService().newCq(null, queryString, cqAttributes, this.serverProxy, isDurable);
            }
            catch (CqExistsException cqe) {
                if (!logger.isDebugEnabled()) break block2;
                logger.debug("Unable to createCq. Error :{}", cqe.getMessage(), cqe);
            }
        }
        return cq;
    }

    @Override
    public CqQuery newCq(String cqName, String queryString, CqAttributes cqAttributes) throws QueryInvalidException, CqExistsException, CqException {
        if (cqName == null) {
            throw new IllegalArgumentException(LocalizedStrings.DefaultQueryService_CQNAME_MUST_NOT_BE_NULL.toLocalizedString());
        }
        CqQueryImpl cq = (CqQueryImpl)this.getCqService().newCq(cqName, queryString, cqAttributes, this.serverProxy, false);
        return cq;
    }

    @Override
    public CqQuery newCq(String cqName, String queryString, CqAttributes cqAttributes, boolean isDurable) throws QueryInvalidException, CqExistsException, CqException {
        if (cqName == null) {
            throw new IllegalArgumentException(LocalizedStrings.DefaultQueryService_CQNAME_MUST_NOT_BE_NULL.toLocalizedString());
        }
        CqQueryImpl cq = (CqQueryImpl)this.getCqService().newCq(cqName, queryString, cqAttributes, this.serverProxy, isDurable);
        return cq;
    }

    @Override
    public void closeCqs() {
        block2: {
            try {
                this.getCqService().closeAllCqs(true);
            }
            catch (CqException cqe) {
                if (!logger.isDebugEnabled()) break block2;
                logger.debug("Unable to closeAll Cqs. Error :{}", cqe.getMessage(), cqe);
            }
        }
    }

    @Override
    public CqQuery getCq(String cqName) {
        CqQuery cq;
        block2: {
            cq = null;
            try {
                cq = this.getCqService().getCq(cqName);
            }
            catch (CqException cqe) {
                if (!logger.isDebugEnabled()) break block2;
                logger.debug("Unable to getCq. Error :{}", cqe.getMessage(), cqe);
            }
        }
        return cq;
    }

    @Override
    public CqQuery[] getCqs() {
        CqQuery[] cqs;
        block2: {
            cqs = null;
            try {
                cqs = this.getCqService().getAllCqs();
            }
            catch (CqException cqe) {
                if (!logger.isDebugEnabled()) break block2;
                logger.debug("Unable to getAllCqs. Error :{}", cqe.getMessage(), cqe);
            }
        }
        return cqs;
    }

    @Override
    public CqQuery[] getCqs(String regionName) throws CqException {
        return this.getCqService().getAllCqs(regionName);
    }

    @Override
    public void executeCqs() throws CqException {
        block2: {
            try {
                this.getCqService().executeAllClientCqs();
            }
            catch (CqException cqe) {
                if (!logger.isDebugEnabled()) break block2;
                logger.debug("Unable to execute all cqs. Error :{}", cqe.getMessage(), cqe);
            }
        }
    }

    @Override
    public void stopCqs() throws CqException {
        block2: {
            try {
                this.getCqService().stopAllClientCqs();
            }
            catch (CqException cqe) {
                if (!logger.isDebugEnabled()) break block2;
                logger.debug("Unable to stop all CQs. Error :{}", cqe.getMessage(), cqe);
            }
        }
    }

    @Override
    public void executeCqs(String regionName) throws CqException {
        block2: {
            try {
                this.getCqService().executeAllRegionCqs(regionName);
            }
            catch (CqException cqe) {
                if (!logger.isDebugEnabled()) break block2;
                logger.debug("Unable to execute cqs on the specified region. Error :{}", cqe.getMessage(), cqe);
            }
        }
    }

    @Override
    public void stopCqs(String regionName) throws CqException {
        block2: {
            try {
                this.getCqService().stopAllRegionCqs(regionName);
            }
            catch (CqException cqe) {
                if (!logger.isDebugEnabled()) break block2;
                logger.debug("Unable to stop cqs on the specified region. Error :{}", cqe.getMessage(), cqe);
            }
        }
    }

    @Override
    public CqServiceStatistics getCqStatistics() {
        CqServiceStatistics stats;
        block2: {
            stats = null;
            try {
                stats = this.getCqService().getCqStatistics();
            }
            catch (CqException cqe) {
                if (!logger.isDebugEnabled()) break block2;
                logger.debug("Unable get CQ Statistics. Error :{}", cqe.getMessage(), cqe);
            }
        }
        return stats;
    }

    public boolean isServer() {
        boolean isServer;
        block2: {
            isServer = false;
            try {
                isServer = this.getCqService().isServer();
            }
            catch (CqException cqe) {
                if (!logger.isDebugEnabled()) break block2;
                logger.debug("Unable get Server Status. Error :{}", cqe.getMessage(), cqe);
            }
        }
        return isServer;
    }

    public void closeCqService() {
        CqService.closeCqService();
    }

    public CqService getCqService() throws CqException {
        return CqService.getCqService(this.cache);
    }

    public void setPool(Pool pool) {
        this.pool = pool;
        this.serverProxy = new ServerCQProxy((InternalPool)this.pool);
        if (logger.isDebugEnabled()) {
            logger.debug("Setting ServerProxy with the Query Service using the pool :{} And ServerProxy is: {}", pool.getName(), this.serverProxy);
        }
    }

    public Pool getPool() {
        return this.pool;
    }

    ServerCQProxy getServerProxy() {
        return this.serverProxy;
    }

    @Override
    public List<String> getAllDurableCqsFromServer() throws CqException {
        if (!this.isServer()) {
            if (this.serverProxy != null) {
                return this.serverProxy.getAllDurableCqsFromServer();
            }
            if (this.pool != null) {
                return GetDurableCQsOp.execute((ExecutablePool)((Object)this.pool));
            }
            throw new UnsupportedOperationException("GetAllDurableCQsFromServer requires a pool to be configured.");
        }
        return Collections.EMPTY_LIST;
    }

    public UserAttributes getUserAttributes(String cqName) {
        try {
            return this.getCqService().getUserAttributes(cqName);
        }
        catch (CqException ce) {
            return null;
        }
    }

    @Override
    public void defineKeyIndex(String indexName, String indexedExpression, String fromClause) throws RegionNotFoundException {
        this.defineIndex(indexName, IndexType.PRIMARY_KEY, indexedExpression, fromClause, null);
    }

    @Override
    public void defineHashIndex(String indexName, String indexedExpression, String fromClause) throws RegionNotFoundException {
        this.defineIndex(indexName, IndexType.HASH, indexedExpression, fromClause, null);
    }

    @Override
    public void defineHashIndex(String indexName, String indexedExpression, String fromClause, String imports) throws RegionNotFoundException {
        this.defineIndex(indexName, IndexType.HASH, indexedExpression, fromClause, imports);
    }

    @Override
    public void defineIndex(String indexName, String indexedExpression, String fromClause) throws RegionNotFoundException {
        this.defineIndex(indexName, IndexType.FUNCTIONAL, indexedExpression, fromClause, null);
    }

    @Override
    public void defineIndex(String indexName, String indexedExpression, String fromClause, String imports) throws RegionNotFoundException {
        this.defineIndex(indexName, IndexType.FUNCTIONAL, indexedExpression, fromClause, imports);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void defineIndex(String indexName, IndexType indexType, String indexedExpression, String fromClause, String imports) throws RegionNotFoundException {
        IndexCreationData indexData = new IndexCreationData(indexName);
        indexData.setIndexData(indexType, fromClause, indexedExpression, imports);
        Region r = this.getRegionFromPath(imports, fromClause);
        Map<Region, HashSet<IndexCreationData>> map = this.indexDefinitions;
        synchronized (map) {
            HashSet<IndexCreationData> s = this.indexDefinitions.get(r);
            if (s == null) {
                s = new HashSet();
            }
            s.add(indexData);
            this.indexDefinitions.put(r, s);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Index> createDefinedIndexes() throws MultiIndexCreationException {
        HashSet<Index> indexes = new HashSet<Index>();
        boolean throwException = false;
        HashMap<String, Exception> exceptionsMap = new HashMap<String, Exception>();
        Map<Region, HashSet<IndexCreationData>> map = this.indexDefinitions;
        synchronized (map) {
            for (Map.Entry<Region, HashSet<IndexCreationData>> e : this.indexDefinitions.entrySet()) {
                Region region = e.getKey();
                HashSet<IndexCreationData> icds = e.getValue();
                if (region instanceof PartitionedRegion) {
                    throwException = this.createDefinedIndexesForPR(indexes, (PartitionedRegion)region, icds, exceptionsMap);
                    continue;
                }
                throwException = this.createDefinedIndexesForReplicatedRegion(indexes, region, icds, exceptionsMap);
            }
        }
        if (throwException) {
            throw new MultiIndexCreationException(exceptionsMap);
        }
        return new ArrayList<Index>(indexes);
    }

    private boolean createDefinedIndexesForPR(HashSet<Index> indexes, PartitionedRegion region, HashSet<IndexCreationData> icds, HashMap<String, Exception> exceptionsMap) {
        try {
            indexes.addAll(region.createIndexes(false, icds));
        }
        catch (IndexCreationException e1) {
            logger.info(LocalizedMessage.create(LocalizedStrings.DefaultQueryService_EXCEPTION_WHILE_CREATING_INDEX_ON_PR_DEFAULT_QUERY_PROCESSOR), (Throwable)e1);
        }
        catch (CacheException e1) {
            logger.info(LocalizedMessage.create(LocalizedStrings.DefaultQueryService_EXCEPTION_WHILE_CREATING_INDEX_ON_PR_DEFAULT_QUERY_PROCESSOR), (Throwable)e1);
            return true;
        }
        catch (ForceReattemptException e1) {
            logger.info(LocalizedMessage.create(LocalizedStrings.DefaultQueryService_EXCEPTION_WHILE_CREATING_INDEX_ON_PR_DEFAULT_QUERY_PROCESSOR), (Throwable)e1);
            return true;
        }
        catch (MultiIndexCreationException e) {
            exceptionsMap.putAll(e.getExceptionsMap());
            return true;
        }
        return false;
    }

    private boolean createDefinedIndexesForReplicatedRegion(HashSet<Index> indexes, Region region, Set<IndexCreationData> icds, HashMap<String, Exception> exceptionsMap) {
        IndexManager indexManager;
        boolean throwException = false;
        for (IndexCreationData icd : icds) {
            try {
                indexes.add(this.createIndex(icd.getIndexName(), icd.getIndexType(), icd.getIndexExpression(), icd.getIndexFromClause(), icd.getIndexImportString(), false, region));
            }
            catch (Exception ex) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Index creation failed, {}, {}", icd.getIndexName(), ex.getMessage(), ex);
                }
                exceptionsMap.put(icd.getIndexName(), ex);
                throwException = true;
            }
        }
        if (IndexManager.testHook != null) {
            IndexManager.testHook.hook(13);
        }
        if ((indexManager = IndexUtils.getIndexManager(region, false)) == null) {
            for (IndexCreationData icd : icds) {
                exceptionsMap.put(icd.getIndexName(), new IndexCreationException("Index Creation Failed due to region destroy"));
            }
            return true;
        }
        if (indexes.size() > 0) {
            try {
                indexManager.populateIndexes(indexes);
            }
            catch (MultiIndexCreationException ex) {
                exceptionsMap.putAll(ex.getExceptionsMap());
                throwException = true;
            }
        }
        return throwException;
    }

    @Override
    public boolean clearDefinedIndexes() {
        this.indexDefinitions.clear();
        return true;
    }
}

