/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.query.internal;

import com.gemstone.gemfire.InvalidDeltaException;
import com.gemstone.gemfire.SystemFailure;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheEvent;
import com.gemstone.gemfire.cache.CacheLoaderException;
import com.gemstone.gemfire.cache.EntryEvent;
import com.gemstone.gemfire.cache.Operation;
import com.gemstone.gemfire.cache.RegionEvent;
import com.gemstone.gemfire.cache.TimeoutException;
import com.gemstone.gemfire.cache.client.Pool;
import com.gemstone.gemfire.cache.client.internal.GetEventValueOp;
import com.gemstone.gemfire.cache.client.internal.InternalPool;
import com.gemstone.gemfire.cache.client.internal.QueueManager;
import com.gemstone.gemfire.cache.client.internal.ServerCQProxy;
import com.gemstone.gemfire.cache.client.internal.UserAttributes;
import com.gemstone.gemfire.cache.query.CqAttributes;
import com.gemstone.gemfire.cache.query.CqClosedException;
import com.gemstone.gemfire.cache.query.CqException;
import com.gemstone.gemfire.cache.query.CqExistsException;
import com.gemstone.gemfire.cache.query.CqListener;
import com.gemstone.gemfire.cache.query.CqQuery;
import com.gemstone.gemfire.cache.query.CqServiceStatistics;
import com.gemstone.gemfire.cache.query.CqStatusListener;
import com.gemstone.gemfire.cache.query.QueryException;
import com.gemstone.gemfire.cache.query.QueryInvalidException;
import com.gemstone.gemfire.cache.query.RegionNotFoundException;
import com.gemstone.gemfire.cache.query.SelectResults;
import com.gemstone.gemfire.cache.query.internal.CompiledSelect;
import com.gemstone.gemfire.cache.query.internal.CqEventImpl;
import com.gemstone.gemfire.cache.query.internal.CqQueryImpl;
import com.gemstone.gemfire.cache.query.internal.CqQueryVsdStats;
import com.gemstone.gemfire.cache.query.internal.CqServiceStatisticsImpl;
import com.gemstone.gemfire.cache.query.internal.CqServiceVsdStats;
import com.gemstone.gemfire.cache.query.internal.CqStateImpl;
import com.gemstone.gemfire.cache.query.internal.DefaultQuery;
import com.gemstone.gemfire.cache.query.internal.ExecutionContext;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.internal.DistributionAdvisor;
import com.gemstone.gemfire.i18n.StringId;
import com.gemstone.gemfire.internal.cache.CacheDistributionAdvisor;
import com.gemstone.gemfire.internal.cache.EntryEventImpl;
import com.gemstone.gemfire.internal.cache.EventID;
import com.gemstone.gemfire.internal.cache.FilterProfile;
import com.gemstone.gemfire.internal.cache.FilterRoutingInfo;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.tier.sockets.CacheClientNotifier;
import com.gemstone.gemfire.internal.cache.tier.sockets.ClientProxyMembershipID;
import com.gemstone.gemfire.internal.cache.tier.sockets.Part;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.internal.logging.log4j.LocalizedMessage;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.logging.log4j.Logger;

public final class CqService {
    private static final Logger logger = LogService.getLogger();
    public static boolean MAINTAIN_KEYS = Boolean.valueOf(System.getProperty("gemfire.cq.MAINTAIN_KEYS", "true"));
    public static boolean EXECUTE_QUERY_DURING_INIT = Boolean.valueOf(System.getProperty("gemfire.cq.EXECUTE_QUERY_DURING_INIT", "true"));
    private static final String CQ_NAME_PREFIX = "GfCq";
    private final Cache cache;
    private static volatile CqService cqServiceSingleton;
    private static HashMap cqPoolsConnected;
    private volatile HashMap cqQueryMap = new HashMap();
    private final Object cqQueryMapLock = new Object();
    private final HashMap<String, UserAttributes> cqNameToUserAttributesMap = new HashMap();
    private HashMap matchingCqMap = null;
    public CqServiceStatisticsImpl cqServiceStats;
    public CqServiceVsdStats stats;
    private volatile long cqId = 1L;
    final Object cqSync = new Object();
    private HashMap baseRegionToCqNameMap = new HashMap();

    private CqService(Cache c) {
        if (c == null) {
            throw new IllegalStateException(LocalizedStrings.CqService_CACHE_IS_NULL.toLocalizedString());
        }
        GemFireCacheImpl gfc = (GemFireCacheImpl)c;
        gfc.getCancelCriterion().checkCancelInProgress(null);
        this.cache = gfc;
    }

    private void initCqService() {
        this.matchingCqMap = new HashMap();
        DistributedSystem factory = this.cache.getDistributedSystem();
        this.stats = new CqServiceVsdStats(factory);
        this.cqServiceStats = new CqServiceStatisticsImpl(this);
        if (logger.isDebugEnabled()) {
            logger.debug("Initialized CqService Successfully.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized CqService getCqService(Cache cache) {
        if (cqServiceSingleton == null) {
            cqServiceSingleton = new CqService(cache);
            boolean initSuccessful = false;
            try {
                cqServiceSingleton.initCqService();
                initSuccessful = true;
            }
            finally {
                if (!initSuccessful) {
                    cqServiceSingleton = null;
                }
            }
        }
        return cqServiceSingleton;
    }

    public static synchronized CqService getRunningCqService() {
        return cqServiceSingleton;
    }

    public static boolean isRunning() {
        return cqServiceSingleton != null;
    }

    public Cache getCache() {
        return this.cache;
    }

    public synchronized CqQuery newCq(String cqName, String queryString, CqAttributes cqAttributes, ServerCQProxy serverProxy, boolean isDurable) throws QueryInvalidException, CqExistsException, CqException {
        CqQueryImpl cQuery;
        block8: {
            if (queryString == null) {
                throw new IllegalArgumentException(LocalizedStrings.CqService_NULL_ARGUMENT_0.toLocalizedString("queryString"));
            }
            if (cqAttributes == null) {
                throw new IllegalArgumentException(LocalizedStrings.CqService_NULL_ARGUMENT_0.toLocalizedString("cqAttribute"));
            }
            if (this.isServer()) {
                throw new IllegalStateException(LocalizedStrings.CqService_CLIENT_SIDE_NEWCQ_METHOD_INVOCATION_ON_SERVER.toLocalizedString());
            }
            if (cqName != null && this.isCqExists(cqName)) {
                throw new CqExistsException(LocalizedStrings.CqService_CQ_WITH_THE_GIVEN_NAME_ALREADY_EXISTS_CQNAME_0.toLocalizedString(cqName));
            }
            cQuery = new CqQueryImpl(this, cqName, queryString, cqAttributes, serverProxy, isDurable);
            cQuery.updateCqCreateStats();
            cQuery.validateCq();
            if (cqName == null) {
                while (true) {
                    cQuery.setName(this.generateCqName());
                    try {
                        this.addToCqMap(cQuery);
                        break block8;
                    }
                    catch (CqExistsException ex) {
                        if (!logger.isDebugEnabled()) continue;
                        logger.debug("Got CqExistsException while intializing cq : {} Error : {}", cQuery.getName(), ex.getMessage());
                        continue;
                    }
                    break;
                }
            }
            this.addToCqMap(cQuery);
        }
        this.addToBaseRegionToCqNameMap(cQuery.getBaseRegionName(), cQuery.getServerCqName());
        return cQuery;
    }

    /*
     * Unable to fully structure code
     */
    public synchronized CqQuery executeCq(String cqName, String queryString, int cqState, ClientProxyMembershipID clientProxyId, CacheClientNotifier ccn, boolean isDurable, boolean manageEmptyRegions, int regionDataPolicy, Map emptyRegionsMap) throws CqException, RegionNotFoundException, CqClosedException {
        if (!this.isServer()) {
            throw new IllegalStateException(LocalizedStrings.CqService_SERVER_SIDE_EXECUTECQ_METHOD_IS_CALLED_ON_CLIENT_CQNAME_0.toLocalizedString(new Object[]{cqName}));
        }
        serverCqName = this.constructServerCqName(cqName, clientProxyId);
        cQuery = null;
        if (!this.isCqExists(serverCqName)) {
            cQuery = new CqQueryImpl(this, cqName, queryString, null, null, isDurable);
            cQuery.setServerCqName(this.constructServerCqName(cqName, clientProxyId));
            try {
                cQuery.registerCq(clientProxyId, ccn, cqState);
                if (!manageEmptyRegions) ** GOTO lbl25
                if (emptyRegionsMap != null && emptyRegionsMap.containsKey(cQuery.getBaseRegionName())) {
                    regionDataPolicy = 0;
                }
                ccn.updateMapOfEmptyRegions(ccn.getClientProxy(clientProxyId, true).getRegionsWithEmptyDataPolicy(), cQuery.getBaseRegionName(), regionDataPolicy);
            }
            catch (CqException cqe) {
                CqService.logger.info(LocalizedMessage.create(LocalizedStrings.CqService_EXCEPTION_WHILE_REGISTERING_CQ_ON_SERVER_CQNAME___0, cQuery.getName()));
                cQuery = null;
                throw cqe;
            }
        } else {
            cQuery = (CqQueryImpl)this.getCq(serverCqName);
            if (((CqStateImpl)cQuery.getState()).getState() != cqState) {
                cQuery.setCqState(cqState);
                cQuery.getCqBaseRegion().getFilterProfile().setCqState(cQuery);
            }
            if (cqState == 1) {
                this.addToMatchingCqMap(cQuery);
            }
        }
lbl25:
        // 5 sources

        if (CqService.logger.isDebugEnabled()) {
            CqService.logger.debug("Successfully created CQ on the server. CqName : {}", new Object[]{cQuery.getName()});
        }
        return cQuery;
    }

    public boolean hasCq() {
        HashMap cqMap = this.cqQueryMap;
        return cqMap.size() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addToCqMap(CqQueryImpl cq) throws CqExistsException, CqException {
        HashMap cqMap;
        String sCqName = cq.getServerCqName();
        if (logger.isDebugEnabled()) {
            logger.debug("Adding to CQ Repository. CqName : {} ServerCqName : {}", cq.getName(), sCqName);
        }
        if ((cqMap = this.cqQueryMap).containsKey(sCqName)) {
            throw new CqExistsException(LocalizedStrings.CqService_A_CQ_WITH_THE_GIVEN_NAME_0_ALREADY_EXISTS.toLocalizedString(sCqName));
        }
        Object object = this.cqQueryMapLock;
        synchronized (object) {
            HashMap<String, CqQueryImpl> tmpCqQueryMap = new HashMap<String, CqQueryImpl>(this.cqQueryMap);
            try {
                tmpCqQueryMap.put(sCqName, cq);
            }
            catch (Exception ex) {
                StringId errMsg = LocalizedStrings.CqQueryImpl_FAILED_TO_STORE_CONTINUOUS_QUERY_IN_THE_REPOSITORY_CQNAME_0_1;
                Object[] errMsgArgs = new Object[]{sCqName, ex.getLocalizedMessage()};
                String s = errMsg.toLocalizedString(errMsgArgs);
                logger.error(s);
                throw new CqException(s, ex);
            }
            UserAttributes attributes = UserAttributes.userAttributes.get();
            if (attributes != null) {
                this.cqNameToUserAttributesMap.put(cq.getName(), attributes);
            }
            this.cqQueryMap = tmpCqQueryMap;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCq(String cqName) {
        Object object = this.cqQueryMapLock;
        synchronized (object) {
            HashMap tmpCqQueryMap = new HashMap(this.cqQueryMap);
            tmpCqQueryMap.remove(cqName);
            this.cqNameToUserAttributesMap.remove(cqName);
            this.cqQueryMap = tmpCqQueryMap;
        }
    }

    public CqQuery getClientCqFromServer(ClientProxyMembershipID clientProxyId, String clientCqName) {
        HashMap cqMap = this.cqQueryMap;
        return (CqQuery)cqMap.get(this.constructServerCqName(clientCqName, clientProxyId));
    }

    public CqQuery getCq(String cqName) {
        HashMap cqMap = this.cqQueryMap;
        return (CqQuery)this.cqQueryMap.get(cqName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCqQueryMap() {
        HashMap oldMap = null;
        Object object = this.cqQueryMapLock;
        synchronized (object) {
            oldMap = this.cqQueryMap;
            this.cqQueryMap = new HashMap();
        }
    }

    public CqQuery[] getAllCqs() {
        CqQuery[] cQuerys = new CqQuery[]{};
        HashMap cqMap = this.cqQueryMap;
        if (cqMap.size() > 0) {
            Collection cqs = cqMap.values();
            cQuerys = new CqQuery[cqs.size()];
            cqs.toArray(cQuerys);
        }
        return cQuerys;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CqQuery[] getAllCqs(String regionName) throws CqException {
        if (regionName == null) {
            throw new IllegalArgumentException(LocalizedStrings.CqService_NULL_ARGUMENT_0.toLocalizedString("regionName"));
        }
        String[] cqNames = null;
        CqQuery[] cQuerys = null;
        HashMap hashMap = this.baseRegionToCqNameMap;
        synchronized (hashMap) {
            ArrayList cqs = (ArrayList)this.baseRegionToCqNameMap.get(regionName);
            if (cqs == null) {
                return cQuerys;
            }
            cqNames = new String[cqs.size()];
            cqs.toArray(cqNames);
        }
        ArrayList<CqQuery> cQueryList = new ArrayList<CqQuery>();
        for (int cqCnt = 0; cqCnt < cqNames.length; ++cqCnt) {
            CqQuery cq = this.getCq(cqNames[cqCnt]);
            if (cq == null) continue;
            cQueryList.add(cq);
        }
        if (!cQueryList.isEmpty()) {
            cQuerys = cQueryList.toArray(new CqQueryImpl[0]);
        }
        return cQuerys;
    }

    public synchronized void executeAllClientCqs() throws CqException {
        this.executeCqs(this.getAllCqs());
    }

    public synchronized void executeAllRegionCqs(String regionName) throws CqException {
        this.executeCqs(this.getAllCqs(regionName));
    }

    public synchronized void executeCqs(CqQuery[] cqs) throws CqException {
        if (cqs == null) {
            return;
        }
        String cqName = null;
        for (int cqCnt = 0; cqCnt < cqs.length; ++cqCnt) {
            CqQuery cq = cqs[cqCnt];
            if (cq.isClosed() || !cq.isStopped()) continue;
            try {
                cqName = cq.getName();
                cq.execute();
                continue;
            }
            catch (QueryException qe) {
                if (!logger.isDebugEnabled()) continue;
                logger.debug("Failed to execute the CQ, CqName : {} Error : {}", cqName, qe.getMessage());
                continue;
            }
            catch (CqClosedException cce) {
                if (!logger.isDebugEnabled()) continue;
                logger.debug("Failed to execute the CQ, CqName : {} Error : {}", cqName, cce.getMessage());
            }
        }
    }

    public synchronized void stopAllClientCqs() throws CqException {
        this.stopCqs(this.getAllCqs());
    }

    public synchronized void stopAllRegionCqs(String regionName) throws CqException {
        this.stopCqs(this.getAllCqs(regionName));
    }

    public synchronized void stopCqs(CqQuery[] cqs) throws CqException {
        boolean isDebugEnabled = logger.isDebugEnabled();
        if (isDebugEnabled) {
            if (cqs == null) {
                logger.debug("CqService.stopCqs cqs : null");
            } else {
                logger.debug("CqService.stopCqs cqs : ({} queries)", cqs.length);
            }
        }
        if (cqs == null) {
            return;
        }
        String cqName = null;
        for (int cqCnt = 0; cqCnt < cqs.length; ++cqCnt) {
            CqQuery cq = cqs[cqCnt];
            if (cq.isClosed() || !cq.isRunning()) continue;
            try {
                cqName = cq.getName();
                cq.stop();
                continue;
            }
            catch (QueryException qe) {
                if (!isDebugEnabled) continue;
                logger.debug("Failed to stop the CQ, CqName : {} Error : {}", cqName, qe.getMessage());
                continue;
            }
            catch (CqClosedException cce) {
                if (!isDebugEnabled) continue;
                logger.debug("Failed to stop the CQ, CqName : {} Error : {}", cqName, cce.getMessage());
            }
        }
    }

    public void closeCqs(String regionName) throws CqException {
        CqQueryImpl[] cqs = (CqQueryImpl[])this.getAllCqs(regionName);
        if (cqs != null) {
            String cqName = null;
            for (int cqCnt = 0; cqCnt < cqs.length; ++cqCnt) {
                try {
                    CqQueryImpl cq = cqs[cqCnt];
                    cqName = cq.getName();
                    if (this.isServer()) {
                        cq.close(false);
                        continue;
                    }
                    boolean keepAlive = ((GemFireCacheImpl)this.cache).keepDurableSubscriptionsAlive();
                    if (cq.isDurable() && keepAlive) {
                        logger.warn(LocalizedMessage.create(LocalizedStrings.CqService_NOT_SENDING_CQ_CLOSE_TO_THE_SERVER_AS_IT_IS_A_DURABLE_CQ));
                        cq.close(false);
                        continue;
                    }
                    cq.close(true);
                    continue;
                }
                catch (QueryException qe) {
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug("Failed to close the CQ, CqName : {} Error : {}", cqName, qe.getMessage());
                    continue;
                }
                catch (CqClosedException cce) {
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug("Failed to close the CQ, CqName : {} Error : {}", cqName, cce.getMessage());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public void stopCq(String cqName, ClientProxyMembershipID clientId) throws CqException {
        block23: {
            block24: {
                serverCqName = cqName;
                if (clientId != null) {
                    serverCqName = this.constructServerCqName(cqName, clientId);
                }
                cQuery = null;
                errMsg = null;
                ex /* !! */  = null;
                cqMap = this.cqQueryMap;
                if (cqMap.containsKey(serverCqName)) break block23;
                if (ex /* !! */  == null) break block24;
                s = errMsg.toLocalizedString(new Object[]{cqName});
                if (CqService.logger.isDebugEnabled()) {
                    CqService.logger.debug(s);
                }
                throw new CqException(s, ex /* !! */ );
            }
            return;
        }
        try {
            cQuery = (CqQueryImpl)this.getCq(serverCqName);
            ** if (ex /* !! */  == null) goto lbl-1000
        }
        catch (CacheLoaderException e1) {
            errMsg = LocalizedStrings.CqService_CQ_NOT_FOUND_IN_THE_CQ_META_REGION_CQNAME_0;
            ex /* !! */  = e1;
            ** if (ex /* !! */  == null) goto lbl-1000
lbl-1000:
            // 1 sources

            {
                s = errMsg.toLocalizedString(new Object[]{cqName});
                if (CqService.logger.isDebugEnabled()) {
                    CqService.logger.debug(s);
                }
                throw new CqException(s, ex /* !! */ );
            }
lbl-1000:
            // 1 sources

            {
            }
        }
        catch (TimeoutException e2) {
            errMsg = LocalizedStrings.CqService_TIMEOUT_WHILE_TRYING_TO_GET_CQ_FROM_META_REGION_CQNAME_0;
            ex /* !! */  = e2;
            ** if (ex /* !! */  == null) goto lbl-1000
lbl-1000:
            // 1 sources

            {
                s = errMsg.toLocalizedString(new Object[]{cqName});
                if (CqService.logger.isDebugEnabled()) {
                    CqService.logger.debug(s);
                }
                throw new CqException(s, ex /* !! */ );
            }
lbl-1000:
            // 1 sources

            {
            }
            {
                catch (Throwable var9_14) {
                    if (ex /* !! */  != null) {
                        s = errMsg.toLocalizedString(new Object[]{cqName});
                        if (CqService.logger.isDebugEnabled()) {
                            CqService.logger.debug(s);
                        }
                        throw new CqException(s, ex /* !! */ );
                    }
                    throw var9_14;
                }
            }
        }
lbl-1000:
        // 1 sources

        {
            s = errMsg.toLocalizedString(new Object[]{cqName});
            if (CqService.logger.isDebugEnabled()) {
                CqService.logger.debug(s);
            }
            throw new CqException(s, ex /* !! */ );
        }
lbl-1000:
        // 1 sources

        {
        }
        try {
            if (!cQuery.isStopped()) {
                cQuery.stop();
            }
        }
        catch (CqClosedException cce) {
            throw new CqException(cce.getMessage());
        }
        finally {
            this.removeFromMatchingCqMap(cQuery);
        }
        cQuery.getCqBaseRegion().getFilterProfile().stopCq(cQuery);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public void closeCq(String cqName, ClientProxyMembershipID clientProxyId) throws CqException {
        block29: {
            block30: {
                serverCqName = cqName;
                if (clientProxyId != null) {
                    serverCqName = this.constructServerCqName(cqName, clientProxyId);
                }
                cQuery = null;
                errMsg = null;
                ex /* !! */  = null;
                cqMap = this.cqQueryMap;
                if (cqMap.containsKey(serverCqName)) break block29;
                if (ex /* !! */  == null) break block30;
                s = errMsg.toLocalizedString(new Object[]{cqName});
                if (CqService.logger.isDebugEnabled()) {
                    CqService.logger.debug(s);
                }
                throw new CqException(s, ex /* !! */ );
            }
            return;
        }
        try {
            cQuery = (CqQueryImpl)cqMap.get(serverCqName);
            ** if (ex /* !! */  == null) goto lbl-1000
        }
        catch (CacheLoaderException e1) {
            errMsg = LocalizedStrings.CqService_CQ_NOT_FOUND_IN_THE_CQ_META_REGION_CQNAME_0;
            ex /* !! */  = e1;
            ** if (ex /* !! */  == null) goto lbl-1000
lbl-1000:
            // 1 sources

            {
                s = errMsg.toLocalizedString(new Object[]{cqName});
                if (CqService.logger.isDebugEnabled()) {
                    CqService.logger.debug(s);
                }
                throw new CqException(s, ex /* !! */ );
            }
lbl-1000:
            // 1 sources

            {
            }
        }
        catch (TimeoutException e2) {
            errMsg = LocalizedStrings.CqService_TIMEOUT_WHILE_TRYING_TO_GET_CQ_FROM_META_REGION_CQNAME_0;
            ex /* !! */  = e2;
            ** if (ex /* !! */  == null) goto lbl-1000
lbl-1000:
            // 1 sources

            {
                s = errMsg.toLocalizedString(new Object[]{cqName});
                if (CqService.logger.isDebugEnabled()) {
                    CqService.logger.debug(s);
                }
                throw new CqException(s, ex /* !! */ );
            }
lbl-1000:
            // 1 sources

            {
            }
            {
                catch (Throwable var9_16) {
                    if (ex /* !! */  != null) {
                        s = errMsg.toLocalizedString(new Object[]{cqName});
                        if (CqService.logger.isDebugEnabled()) {
                            CqService.logger.debug(s);
                        }
                        throw new CqException(s, ex /* !! */ );
                    }
                    throw var9_16;
                }
            }
        }
lbl-1000:
        // 1 sources

        {
            s = errMsg.toLocalizedString(new Object[]{cqName});
            if (CqService.logger.isDebugEnabled()) {
                CqService.logger.debug(s);
            }
            throw new CqException(s, ex /* !! */ );
        }
lbl-1000:
        // 1 sources

        {
        }
        try {
            block31: {
                cQuery.close(false);
                try {
                    baseRegion = cQuery.getCqBaseRegion();
                    if (baseRegion != null && !baseRegion.isDestroyed() && this.isServer()) {
                        fp = baseRegion.getFilterProfile();
                        if (fp != null) {
                            fp.closeCq(cQuery);
                        }
                        clientProxy = cQuery.getCacheClientNotifier().getClientProxy(clientProxyId);
                        clientProxy.decCqCount();
                        if (clientProxy.hasNoCq()) {
                            this.stats.decClientsWithCqs();
                        }
                    }
                }
                catch (Exception e) {
                    if (!CqService.logger.isDebugEnabled()) break block31;
                    CqService.logger.debug("Failed to remove CQ from the base region. CqName : {}", new Object[]{cqName});
                }
            }
            if (this.isServer()) {
                this.removeFromBaseRegionToCqNameMap(cQuery.getRegionName(), serverCqName);
            }
            if ((baseRegion = cQuery.getCqBaseRegion()).getFilterProfile().getCqCount() <= 0 && CqService.logger.isDebugEnabled()) {
                CqService.logger.debug("Should update the profile for this partitioned region {} for not requiring old value", new Object[]{baseRegion});
            }
        }
        catch (CqClosedException cce) {
            throw new CqException(cce.getMessage());
        }
        finally {
            this.removeFromMatchingCqMap(cQuery);
        }
    }

    public void closeAllCqs(boolean clientInitiated) {
        this.closeAllCqs(clientInitiated, this.getAllCqs());
    }

    public void closeAllCqs(boolean clientInitiated, CqQuery[] cqs) {
        this.closeAllCqs(clientInitiated, cqs, ((GemFireCacheImpl)this.cache).keepDurableSubscriptionsAlive());
    }

    public void closeAllCqs(boolean clientInitiated, CqQuery[] cqs, boolean keepAlive) {
        CqQueryImpl cQuery = null;
        if (cqs != null) {
            String cqName = null;
            if (logger.isDebugEnabled()) {
                logger.debug("Closing all CQs, number of CQ to be closed : {}", cqs.length);
            }
            for (int cqCnt = 0; cqCnt < cqs.length; ++cqCnt) {
                try {
                    cQuery = (CqQueryImpl)cqs[cqCnt];
                    cqName = cQuery.getName();
                    if (this.isServer()) {
                        cQuery.close(false);
                        continue;
                    }
                    if (clientInitiated) {
                        cQuery.close(true);
                        continue;
                    }
                    if (!this.isServer() && cQuery.isDurable() && keepAlive) {
                        logger.warn(LocalizedMessage.create(LocalizedStrings.CqService_NOT_SENDING_CQ_CLOSE_TO_THE_SERVER_AS_IT_IS_A_DURABLE_CQ));
                        cQuery.close(false);
                        continue;
                    }
                    cQuery.close(true);
                    continue;
                }
                catch (QueryException cqe) {
                    if (!CqService.isRunning()) {
                        logger.warn(LocalizedMessage.create(LocalizedStrings.CqService_FAILED_TO_CLOSE_CQ__0___1, new Object[]{cqName, cqe.getMessage()}));
                    }
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug(cqe.getMessage(), (Throwable)cqe);
                    continue;
                }
                catch (CqClosedException cqe) {
                    if (!CqService.isRunning()) {
                        logger.warn(LocalizedMessage.create(LocalizedStrings.CqService_FAILED_TO_CLOSE_CQ__0___1, new Object[]{cqName, cqe.getMessage()}));
                    }
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug(cqe.getMessage(), (Throwable)cqe);
                }
            }
        }
    }

    public void handleCqMonitorOp(int op, String regionName) throws CqException {
        throw new CqException(LocalizedStrings.CqService_INVALID_CQ_MONITOR_REQUEST_RECEIVED.toLocalizedString());
    }

    public CqServiceStatistics getCqStatistics() {
        return this.cqServiceStats;
    }

    public void closeClientCqs(ClientProxyMembershipID clientProxyId) throws CqException {
        boolean isDebugEnabled = logger.isDebugEnabled();
        if (isDebugEnabled) {
            logger.debug("Closing Client CQs for the client: {}", clientProxyId);
        }
        List<CqQueryImpl> cqs = this.getAllClientCqs(clientProxyId);
        for (CqQuery cqQuery : cqs) {
            CqQueryImpl cQuery = (CqQueryImpl)cqQuery;
            try {
                cQuery.close(false);
            }
            catch (QueryException qe) {
                if (!isDebugEnabled) continue;
                logger.debug("Failed to close the CQ, CqName : {} Error : {}", cQuery.getName(), qe.getMessage());
            }
            catch (CqClosedException cce) {
                if (!isDebugEnabled) continue;
                logger.debug("Failed to close the CQ, CqName : {} Error : {}", cQuery.getName(), cce.getMessage());
            }
        }
    }

    public List<CqQueryImpl> getAllClientCqs(ClientProxyMembershipID clientProxyId) {
        CqQuery[] cqs = this.getAllCqs();
        ArrayList<CqQueryImpl> clientCqs = new ArrayList<CqQueryImpl>();
        for (int cnt = 0; cnt < cqs.length; ++cnt) {
            CqQueryImpl cQuery = (CqQueryImpl)cqs[cnt];
            ClientProxyMembershipID id = cQuery.getClientProxyId();
            if (id == null || !id.equals(clientProxyId)) continue;
            clientCqs.add(cQuery);
        }
        return clientCqs;
    }

    public List<String> getAllDurableClientCqs(ClientProxyMembershipID clientProxyId) throws CqException {
        if (clientProxyId == null) {
            throw new CqException(LocalizedStrings.CqService_UNABLE_TO_RETRIEVE_DURABLE_CQS_FOR_CLIENT_PROXY_ID.toLocalizedString(clientProxyId));
        }
        List<CqQueryImpl> cqs = this.getAllClientCqs(clientProxyId);
        ArrayList<String> durableClientCqs = new ArrayList<String>();
        for (CqQueryImpl cQuery : cqs) {
            ClientProxyMembershipID id;
            if (cQuery == null || !cQuery.isDurable() || (id = cQuery.getClientProxyId()) == null || !id.equals(clientProxyId)) continue;
            durableClientCqs.add(cQuery.getName());
        }
        return durableClientCqs;
    }

    public void closeNonDurableClientCqs(ClientProxyMembershipID clientProxyId) throws CqException {
        boolean isDebugEnabled = logger.isDebugEnabled();
        if (isDebugEnabled) {
            logger.debug("Closing Client CQs for the client: {}", clientProxyId);
        }
        List<CqQueryImpl> cqs = this.getAllClientCqs(clientProxyId);
        for (CqQuery cqQuery : cqs) {
            CqQueryImpl cQuery = (CqQueryImpl)cqQuery;
            try {
                if (cQuery.isDurable()) continue;
                cQuery.close(false);
            }
            catch (QueryException qe) {
                if (!isDebugEnabled) continue;
                logger.debug("Failed to close the CQ, CqName : {} Error : {}", cQuery.getName(), qe.getMessage());
            }
            catch (CqClosedException cce) {
                if (!isDebugEnabled) continue;
                logger.debug("Failed to close the CQ, CqName : {} Error : {}", cQuery.getName(), cce.getMessage());
            }
        }
    }

    public boolean isServer() {
        return !this.cache.getCacheServers().isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void closeCqService() {
        if (cqServiceSingleton != null) {
            block5: {
                boolean isDebugEnabled = logger.isDebugEnabled();
                if (isDebugEnabled) {
                    logger.debug("Closing CqService. {}", cqServiceSingleton);
                }
                try {
                    cqServiceSingleton.cleanup();
                    if (!isDebugEnabled) break block5;
                }
                catch (Throwable throwable) {
                    if (isDebugEnabled) {
                        logger.debug("Closed CqService. {}", cqServiceSingleton);
                    }
                    cqServiceSingleton = null;
                    throw throwable;
                }
                logger.debug("Closed CqService. {}", cqServiceSingleton);
            }
            cqServiceSingleton = null;
        }
    }

    private void cleanup() {
        if (logger.isDebugEnabled()) {
            logger.debug("Cleaning up CqService.");
        }
        this.closeAllCqs(false);
    }

    public String constructServerCqName(String cqName, ClientProxyMembershipID clientProxyId) {
        String cName = null;
        cName = clientProxyId.isDurable() ? cqName + "__" + clientProxyId.getDurableId() : cqName + "__" + clientProxyId.getDSMembership();
        return cName;
    }

    private synchronized boolean isCqExists(String cqName) {
        boolean status = false;
        HashMap cqMap = this.cqQueryMap;
        status = cqMap.containsKey(cqName);
        return status;
    }

    public synchronized String generateCqName() {
        String cqName;
        while (this.isCqExists(cqName = CQ_NAME_PREFIX + this.cqId++)) {
        }
        return cqName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispatchCqListeners(HashMap cqs, int messageType, Object key2, Object value2, byte[] delta, QueueManager qManager, EventID eventId) {
        CqQueryImpl cQuery = null;
        Object[] fullValue = new Object[1];
        Iterator iter = cqs.entrySet().iterator();
        String cqName = null;
        boolean isDebugEnabled = logger.isDebugEnabled();
        while (iter.hasNext()) {
            try {
                Map.Entry entry = iter.next();
                cqName = (String)entry.getKey();
                cQuery = (CqQueryImpl)this.getCq(cqName);
                if (cQuery == null || !cQuery.isRunning() && cQuery.getQueuedEvents() == null) {
                    if (!isDebugEnabled) continue;
                    logger.debug("Unable to invoke CqListener, {}, CqName : {}", cQuery == null ? "CQ not found" : " CQ is Not running", cqName);
                    continue;
                }
                Integer cqOp = (Integer)entry.getValue();
                if (cqOp == 11) {
                    try {
                        cQuery.close(false);
                    }
                    catch (Exception ex) {}
                    continue;
                }
                CqEventImpl cqEvent = null;
                cqEvent = new CqEventImpl(cQuery, this.getOperation(messageType), this.getOperation(cqOp), key2, value2, delta, qManager, eventId);
                cQuery.updateStats(cqEvent);
                if (cQuery.getQueuedEvents() != null) {
                    Object object = cQuery.queuedEventsSynchObject;
                    synchronized (object) {
                        ConcurrentLinkedQueue queuedEvents = cQuery.getQueuedEvents();
                        if (queuedEvents != null) {
                            if (isDebugEnabled) {
                                logger.debug("Queueing event for key: {}", key2);
                            }
                            cQuery.getVsdStats().incQueuedCqListenerEvents();
                            queuedEvents.add(cqEvent);
                            continue;
                        }
                    }
                }
                this.invokeListeners(cqName, cQuery, cqEvent, fullValue);
                if (value2 != null) continue;
                value2 = fullValue[0];
            }
            catch (Throwable t) {
                logger.warn(LocalizedMessage.create(LocalizedStrings.CqService_ERROR_PROCESSING_CQLISTENER_FOR_CQ_0, cqName), t);
                if (!(t instanceof VirtualMachineError)) continue;
                logger.warn(LocalizedMessage.create(LocalizedStrings.CqService_VIRTUALMACHINEERROR_PROCESSING_CQLISTENER_FOR_CQ_0, cqName), t);
                return;
            }
        }
    }

    public void invokeListeners(String cqName, CqQueryImpl cQuery, CqEventImpl cqEvent) {
        this.invokeListeners(cqName, cQuery, cqEvent, null);
    }

    public void invokeListeners(String cqName, CqQueryImpl cQuery, CqEventImpl cqEvent, Object[] fullValue) {
        if (!cQuery.isRunning() || cQuery.getCqAttributes() == null) {
            return;
        }
        CqListener[] cqListeners = cQuery.getCqAttributes().getCqListeners();
        boolean isDebugEnabled = logger.isDebugEnabled();
        if (isDebugEnabled) {
            logger.debug("Invoking CQ listeners for {}, number of listeners : {} cqEvent : {}", cqName, cqListeners.length, cqEvent);
        }
        for (int lCnt = 0; lCnt < cqListeners.length; ++lCnt) {
            try {
                if (cqListeners[lCnt] == null) continue;
                cQuery.getVsdStats().incNumCqListenerInvocations();
                try {
                    if (cqEvent.getThrowable() != null) {
                        cqListeners[lCnt].onError(cqEvent);
                        continue;
                    }
                    cqListeners[lCnt].onEvent(cqEvent);
                }
                catch (InvalidDeltaException ide) {
                    if (isDebugEnabled) {
                        logger.debug("CqService.dispatchCqListeners(): Requesting full value...");
                    }
                    Part result = (Part)GetEventValueOp.executeOnPrimary(cqEvent.getQueueManager().getPool(), cqEvent.getEventID(), null);
                    Object newVal = null;
                    if (result == null || (newVal = result.getObject()) == null) {
                        if (this.cache.getCancelCriterion().cancelInProgress() != null) continue;
                        Exception ex = new Exception("Failed to retrieve full value from server for eventID " + cqEvent.getEventID());
                        logger.warn(LocalizedMessage.create(LocalizedStrings.CqService_EXCEPTION_IN_THE_CQLISTENER_OF_THE_CQ_CQNAME_0_ERROR__1, new Object[]{cqName, ex.getMessage()}));
                        if (!isDebugEnabled) continue;
                        logger.debug(ex.getMessage(), (Throwable)ex);
                        continue;
                    }
                    ((GemFireCacheImpl)this.cache).getCachePerfStats().incDeltaFullValuesRequested();
                    cqEvent = new CqEventImpl(cQuery, cqEvent.getBaseOperation(), cqEvent.getQueryOperation(), cqEvent.getKey(), newVal, cqEvent.getDeltaValue(), cqEvent.getQueueManager(), cqEvent.getEventID());
                    if (cqEvent.getThrowable() != null) {
                        cqListeners[lCnt].onError(cqEvent);
                    } else {
                        cqListeners[lCnt].onEvent(cqEvent);
                    }
                    if (fullValue == null) continue;
                    fullValue[0] = newVal;
                }
                continue;
            }
            catch (Exception ex) {
                if (this.cache.getCancelCriterion().cancelInProgress() != null) continue;
                logger.warn(LocalizedMessage.create(LocalizedStrings.CqService_EXCEPTION_IN_THE_CQLISTENER_OF_THE_CQ_CQNAME_0_ERROR__1, new Object[]{cqName, ex.getMessage()}));
                if (!isDebugEnabled) continue;
                logger.debug(ex.getMessage(), (Throwable)ex);
                continue;
            }
            catch (VirtualMachineError err) {
                SystemFailure.initiateFailure(err);
                throw err;
            }
            catch (Throwable t) {
                SystemFailure.checkFailure();
                logger.warn(LocalizedMessage.create(LocalizedStrings.CqService_RUNTIME_EXCEPTION_IN_THE_CQLISTENER_OF_THE_CQ_CQNAME_0_ERROR__1, new Object[]{cqName, t.getLocalizedMessage()}));
                if (!isDebugEnabled) continue;
                logger.debug(t.getMessage(), t);
            }
        }
    }

    public void invokeCqConnectedListeners(String cqName, CqQueryImpl cQuery, boolean connected) {
        if (!cQuery.isRunning() || cQuery.getCqAttributes() == null) {
            return;
        }
        cQuery.setConnected(connected);
        CqListener[] cqListeners = cQuery.getCqAttributes().getCqListeners();
        if (logger.isDebugEnabled()) {
            logger.debug("Invoking CQ status listeners for {}, number of listeners : {}", cqName, cqListeners.length);
        }
        for (int lCnt = 0; lCnt < cqListeners.length; ++lCnt) {
            try {
                if (cqListeners[lCnt] == null || !(cqListeners[lCnt] instanceof CqStatusListener)) continue;
                CqStatusListener listener = (CqStatusListener)cqListeners[lCnt];
                if (connected) {
                    listener.onCqConnected();
                    continue;
                }
                listener.onCqDisconnected();
                continue;
            }
            catch (Exception ex) {
                if (this.cache.getCancelCriterion().cancelInProgress() != null) continue;
                logger.warn(LocalizedMessage.create(LocalizedStrings.CqService_EXCEPTION_IN_THE_CQLISTENER_OF_THE_CQ_CQNAME_0_ERROR__1, new Object[]{cqName, ex.getMessage()}));
                if (!logger.isDebugEnabled()) continue;
                logger.debug(ex.getMessage(), (Throwable)ex);
                continue;
            }
            catch (VirtualMachineError err) {
                SystemFailure.initiateFailure(err);
                throw err;
            }
            catch (Throwable t) {
                SystemFailure.checkFailure();
                logger.warn(LocalizedMessage.create(LocalizedStrings.CqService_RUNTIME_EXCEPTION_IN_THE_CQLISTENER_OF_THE_CQ_CQNAME_0_ERROR__1, new Object[]{cqName, t.getLocalizedMessage()}));
                if (!logger.isDebugEnabled()) continue;
                logger.debug(t.getMessage(), t);
            }
        }
    }

    private Operation getOperation(int eventType) {
        Operation op = null;
        switch (eventType) {
            case 27: {
                op = Operation.CREATE;
                break;
            }
            case 28: {
                op = Operation.UPDATE;
                break;
            }
            case 16: {
                op = Operation.DESTROY;
                break;
            }
            case 15: {
                op = Operation.INVALIDATE;
                break;
            }
            case 36: {
                op = Operation.REGION_CLEAR;
                break;
            }
            case 55: {
                op = Operation.REGION_INVALIDATE;
            }
        }
        return op;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processEvents(CacheEvent event, DistributionAdvisor.Profile localProfile, DistributionAdvisor.Profile[] profiles, FilterRoutingInfo frInfo) throws CqException {
        if (event instanceof RegionEvent) {
            this.processRegionEvent(event, localProfile, profiles, frInfo);
        } else {
            DefaultQuery.setPdxReadSerialized(this.cache, true);
            try {
                this.processEntryEvent(event, localProfile, profiles, frInfo);
            }
            finally {
                DefaultQuery.setPdxReadSerialized(this.cache, false);
            }
        }
    }

    private void processRegionEvent(CacheEvent event, DistributionAdvisor.Profile localProfile, DistributionAdvisor.Profile[] profiles, FilterRoutingInfo frInfo) throws CqException {
        boolean isDebugEnabled = logger.isDebugEnabled();
        if (isDebugEnabled) {
            logger.debug("CQ service processing region event {}", event);
        }
        Integer cqRegionEvent = this.generateCqRegionEvent(event);
        for (int i = -1; i < profiles.length; ++i) {
            FilterProfile pf;
            CacheDistributionAdvisor.CacheProfile cf;
            if (i < 0) {
                cf = (CacheDistributionAdvisor.CacheProfile)localProfile;
                if (cf == null) {
                    continue;
                }
            } else {
                cf = (CacheDistributionAdvisor.CacheProfile)profiles[i];
            }
            if ((pf = cf.filterProfile) == null || pf.getCqMap().isEmpty()) continue;
            Map cqs = pf.getCqMap();
            HashMap<Long, Integer> cqInfo = new HashMap<Long, Integer>();
            for (Map.Entry cqEntry : cqs.entrySet()) {
                CqQueryImpl cQuery;
                block11: {
                    cQuery = (CqQueryImpl)cqEntry.getValue();
                    if (!event.isOriginRemote() && event.getOperation().isRegionDestroy() && !((LocalRegion)event.getRegion()).isUsedForPartitionedRegionBucket()) {
                        try {
                            if (isDebugEnabled) {
                                logger.debug("Closing CQ on region destroy event. CqName : {}", cQuery.getName());
                            }
                            cQuery.close(false);
                        }
                        catch (Exception ex) {
                            if (!isDebugEnabled) break block11;
                            logger.debug("Failed to Close CQ on region destroy. CqName : {}", cQuery.getName(), ex);
                        }
                    }
                }
                cqInfo.put(cQuery.getFilterID(), cqRegionEvent);
                cQuery.getVsdStats().updateStats(cqRegionEvent);
            }
            if (pf.isLocalProfile()) {
                frInfo.setLocalCqInfo(cqInfo);
                continue;
            }
            frInfo.setCqRoutingInfo(cf.getDistributedMember(), cqInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processEntryEvent(CacheEvent event, DistributionAdvisor.Profile localProfile, DistributionAdvisor.Profile[] profiles, FilterRoutingInfo frInfo) throws CqException {
        boolean isDebugEnabled = logger.isDebugEnabled();
        HashSet cqUnfilteredEventsSet_newValue = new HashSet();
        HashSet cqUnfilteredEventsSet_oldValue = new HashSet();
        boolean b_cqResults_newValue = false;
        boolean b_cqResults_oldValue = false;
        EntryEvent entryEvent = (EntryEvent)event;
        Object eventKey = entryEvent.getKey();
        boolean isDupEvent = ((EntryEventImpl)event).isPossibleDuplicate();
        boolean opRequiringQueryOnOldValue = event.getOperation().isUpdate() || event.getOperation().isDestroy() || event.getOperation().isInvalidate() || event.getOperation().isCreate() && isDupEvent;
        HashMap<String, Integer> matchedCqs = new HashMap<String, Integer>();
        long executionStartTime = 0L;
        for (int i = -1; i < profiles.length; ++i) {
            Object newValue;
            FilterProfile pf;
            CacheDistributionAdvisor.CacheProfile cf;
            if (i < 0) {
                cf = (CacheDistributionAdvisor.CacheProfile)localProfile;
                if (cf == null) {
                    continue;
                }
            } else {
                cf = (CacheDistributionAdvisor.CacheProfile)profiles[i];
            }
            if ((pf = cf.filterProfile) == null || pf.getCqMap().isEmpty()) continue;
            Map cqs = pf.getCqMap();
            if (isDebugEnabled) {
                logger.debug("Profile for {} processing {} CQs", cf.peerMemberId, cqs.size());
            }
            if (cqs.isEmpty()) continue;
            if (cqUnfilteredEventsSet_newValue.isEmpty() && (event.getOperation().isCreate() || event.getOperation().isUpdate()) && (newValue = entryEvent.getNewValue()) != null) {
                cqUnfilteredEventsSet_newValue.add(newValue);
            }
            HashMap<Long, Integer> cqInfo = new HashMap<Long, Integer>();
            for (Map.Entry cqEntry : cqs.entrySet()) {
                CqQueryImpl cQuery = (CqQueryImpl)cqEntry.getValue();
                b_cqResults_newValue = false;
                b_cqResults_oldValue = false;
                boolean queryOldValue = false;
                if (cQuery == null) continue;
                String cqName = cQuery.getServerCqName();
                Long filterID = cQuery.getFilterID();
                if (isDebugEnabled) {
                    logger.debug("Processing CQ : {} Key: {}", cqName, eventKey);
                }
                Integer cqEvent = null;
                if (matchedCqs.containsKey(cqName)) {
                    cqEvent = (Integer)matchedCqs.get(cqName);
                    if (isDebugEnabled) {
                        logger.debug("query {} has already been processed and returned {}", cqName, cqEvent);
                    }
                    if (cqEvent == null) continue;
                    if (cqEvent == 27 || cqEvent == 28) {
                        cQuery.addToCqResultKeys(eventKey);
                    } else if (cqEvent == 16) {
                        cQuery.markAsDestroyedInCqResultKeys(eventKey);
                    }
                } else {
                    boolean error = false;
                    Serializable serializable = cQuery;
                    synchronized (serializable) {
                        try {
                            if (!cqUnfilteredEventsSet_newValue.isEmpty()) {
                                executionStartTime = this.stats.startCqQueryExecution();
                                b_cqResults_newValue = this.evaluateQuery(cQuery, new Object[]{cqUnfilteredEventsSet_newValue});
                                this.stats.endCqQueryExecution(executionStartTime);
                            }
                            if (opRequiringQueryOnOldValue) {
                                if (cQuery.cqResultKeysInitialized) {
                                    b_cqResults_oldValue = cQuery.isPartOfCqResult(eventKey);
                                    if (!(!cQuery.isPR && EXECUTE_QUERY_DURING_INIT || b_cqResults_oldValue)) {
                                        queryOldValue = true;
                                    }
                                    if (isDebugEnabled && !cQuery.isPR && !b_cqResults_oldValue) {
                                        logger.debug("Event Key not found in the CQ Result Queue. EventKey : {} CQ Name : {}", eventKey, cqName);
                                    }
                                } else {
                                    queryOldValue = true;
                                }
                                if (queryOldValue) {
                                    Object oldValue;
                                    if (cqUnfilteredEventsSet_oldValue.isEmpty() && (oldValue = entryEvent.getOldValue()) != null) {
                                        cqUnfilteredEventsSet_oldValue.add(oldValue);
                                    }
                                    if (!cqUnfilteredEventsSet_oldValue.isEmpty()) {
                                        executionStartTime = this.stats.startCqQueryExecution();
                                        b_cqResults_oldValue = this.evaluateQuery(cQuery, new Object[]{cqUnfilteredEventsSet_oldValue});
                                        this.stats.endCqQueryExecution(executionStartTime);
                                    } else if (isDebugEnabled) {
                                        logger.debug("old value for event with key {} is null - query execution not performed", eventKey);
                                    }
                                }
                            }
                        }
                        catch (Exception ex) {
                            error = true;
                            logger.info(LocalizedMessage.create(LocalizedStrings.CqService_ERROR_WHILE_PROCESSING_CQ_ON_THE_EVENT_KEY_0_CQNAME_1_ERROR_2, new Object[]{((EntryEvent)event).getKey(), cQuery.getName(), ex.getLocalizedMessage()}));
                        }
                        if (error) {
                            cqEvent = 2;
                        } else if (b_cqResults_newValue) {
                            cqEvent = b_cqResults_oldValue ? Integer.valueOf(28) : Integer.valueOf(27);
                            cQuery.addToCqResultKeys(eventKey);
                        } else if (b_cqResults_oldValue) {
                            cqEvent = 16;
                            cQuery.markAsDestroyedInCqResultKeys(eventKey);
                        }
                    }
                    serializable = this.matchingCqMap;
                    synchronized (serializable) {
                        String query = cQuery.getQueryString();
                        HashSet matchingCqs = (HashSet)this.matchingCqMap.get(query);
                        if (matchingCqs != null) {
                            for (String matchingCqName : matchingCqs) {
                                if (matchingCqName.equals(cqName)) continue;
                                matchedCqs.put(matchingCqName, cqEvent);
                                if (!isDebugEnabled) continue;
                                logger.debug("Adding CQ into Matching CQ Map: {} Event is: {}", matchingCqName, cqEvent);
                            }
                        }
                    }
                }
                if (cqEvent == null || !cQuery.isRunning()) continue;
                if (isDebugEnabled) {
                    logger.debug("Added event to CQ with client-side name: {} key: {} operation : {}", cQuery.cqName, eventKey, cqEvent);
                }
                cqInfo.put(filterID, cqEvent);
                CqQueryVsdStats stats = cQuery.getVsdStats();
                if (stats == null) continue;
                stats.updateStats(cqEvent);
            }
            if (cqInfo.size() <= 0) continue;
            if (pf.isLocalProfile()) {
                if (isDebugEnabled) {
                    logger.debug("Setting local CQ matches to {}", cqInfo);
                }
                frInfo.setLocalCqInfo(cqInfo);
                continue;
            }
            if (isDebugEnabled) {
                logger.debug("Setting CQ matches for {} to {}", cf.getDistributedMember(), cqInfo);
            }
            frInfo.setCqRoutingInfo(cf.getDistributedMember(), cqInfo);
        }
    }

    private Integer generateCqRegionEvent(CacheEvent event) {
        Integer cqEvent = null;
        if (event.getOperation().isRegionDestroy()) {
            cqEvent = 11;
        } else if (event.getOperation().isRegionInvalidate()) {
            cqEvent = 55;
        } else if (event.getOperation().isClear()) {
            cqEvent = 36;
        }
        return cqEvent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addToBaseRegionToCqNameMap(String regionName, String cqName) {
        HashMap hashMap = this.baseRegionToCqNameMap;
        synchronized (hashMap) {
            ArrayList<String> cqs = (ArrayList<String>)this.baseRegionToCqNameMap.get(regionName);
            if (cqs == null) {
                cqs = new ArrayList<String>();
            }
            cqs.add(cqName);
            this.baseRegionToCqNameMap.put(regionName, cqs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFromBaseRegionToCqNameMap(String regionName, String cqName) {
        HashMap hashMap = this.baseRegionToCqNameMap;
        synchronized (hashMap) {
            ArrayList cqs = (ArrayList)this.baseRegionToCqNameMap.get(regionName);
            if (cqs != null) {
                cqs.remove(cqName);
                if (cqs.isEmpty()) {
                    this.baseRegionToCqNameMap.remove(regionName);
                } else {
                    this.baseRegionToCqNameMap.put(regionName, cqs);
                }
            }
        }
    }

    public CqServiceVsdStats getCqServiceVsdStats() {
        return this.stats;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addToMatchingCqMap(CqQueryImpl cq) {
        HashMap hashMap = this.matchingCqMap;
        synchronized (hashMap) {
            String cqQuery = cq.getQueryString();
            HashSet matchingCQs = null;
            if (!this.matchingCqMap.containsKey(cqQuery)) {
                matchingCQs = new HashSet();
                this.matchingCqMap.put(cqQuery, matchingCQs);
                this.stats.incUniqueCqQuery();
            } else {
                matchingCQs = (HashSet)this.matchingCqMap.get(cqQuery);
            }
            matchingCQs.add(cq.getServerCqName());
            if (logger.isDebugEnabled()) {
                logger.debug("Adding CQ into MatchingCQ map, CQName: {} Number of matched querys are: {}", cq.getServerCqName(), matchingCQs.size());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFromMatchingCqMap(CqQueryImpl cq) {
        HashMap hashMap = this.matchingCqMap;
        synchronized (hashMap) {
            String cqQuery = cq.getQueryString();
            if (this.matchingCqMap.containsKey(cqQuery)) {
                HashSet matchingCQs = (HashSet)this.matchingCqMap.get(cqQuery);
                matchingCQs.remove(cq.getServerCqName());
                if (logger.isDebugEnabled()) {
                    logger.debug("Removing CQ from MatchingCQ map, CQName: {} Number of matched querys are: {}", cq.getServerCqName(), matchingCQs.size());
                }
                if (matchingCQs.isEmpty()) {
                    this.matchingCqMap.remove(cqQuery);
                    this.stats.decUniqueCqQuery();
                }
            }
        }
    }

    public HashMap getMatchingCqMap() {
        return this.matchingCqMap;
    }

    private boolean evaluateQuery(CqQueryImpl cQuery, Object[] event) throws Exception {
        ExecutionContext execContext = cQuery.getQueryExecutionContext();
        execContext.reset();
        execContext.setBindArguments(event);
        boolean status = false;
        if (execContext.getScopeNum() <= 0) {
            SelectResults results = (SelectResults)((DefaultQuery)cQuery.getQuery()).executeUsingContext(execContext);
            if (results != null && results.size() > 0) {
                status = true;
            }
        } else {
            CompiledSelect cs = ((DefaultQuery)cQuery.getQuery()).getSelect();
            status = cs.evaluateCq(execContext);
        }
        return status;
    }

    UserAttributes getUserAttributes(String cqName) {
        return this.cqNameToUserAttributesMap.get(cqName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cqsDisconnected(Pool pool) {
        HashMap hashMap = cqPoolsConnected;
        synchronized (hashMap) {
            if (cqServiceSingleton != null && !cqServiceSingleton.isServer()) {
                cqServiceSingleton.invokeCqsConnected(pool, false);
            }
        }
    }

    public static void cqsConnected(Pool pool) {
        if (cqServiceSingleton != null && !cqServiceSingleton.isServer()) {
            cqServiceSingleton.invokeCqsConnected(pool, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invokeCqsConnected(Pool pool, boolean connected) {
        String poolName = pool.getName();
        HashMap hashMap = cqPoolsConnected;
        synchronized (hashMap) {
            if (cqPoolsConnected.containsKey(poolName) && connected == (Boolean)cqPoolsConnected.get(poolName)) {
                return;
            }
            cqPoolsConnected.put(poolName, connected);
            CqQuery[] cqs = this.getAllCqs();
            int numCqs = cqs.length;
            String cqName = null;
            boolean isDebugEnabled = logger.isDebugEnabled();
            for (int i = 0; i < numCqs; ++i) {
                try {
                    CqQueryImpl cQuery;
                    CqQuery query = cqs[i];
                    if (query == null || (cQuery = (CqQueryImpl)this.getCq(cqName = query.getName())) == null) continue;
                    InternalPool cqPool = cQuery.getCQProxy().getPool();
                    if (cQuery.isConnected() == connected || !cqPool.getName().equals(poolName)) continue;
                    if (!cQuery.isRunning() && cQuery.getQueuedEvents() == null) {
                        if (!isDebugEnabled) continue;
                        logger.debug("Unable to invoke CqListener, {}, CqName : {}", cQuery == null ? "CQ not found" : " CQ is Not running", cqName);
                        continue;
                    }
                    this.invokeCqConnectedListeners(cqName, cQuery, connected);
                    continue;
                }
                catch (VirtualMachineError e) {
                    SystemFailure.initiateFailure(e);
                    throw e;
                }
                catch (Throwable t) {
                    SystemFailure.checkFailure();
                    logger.warn(LocalizedMessage.create(LocalizedStrings.CqService_ERROR_SENDING_CQ_CONNECTION_STATUS, cqName), t);
                    if (!(t instanceof VirtualMachineError)) continue;
                    logger.warn(LocalizedMessage.create(LocalizedStrings.CqService_VIRTUALMACHINEERROR_PROCESSING_CQLISTENER_FOR_CQ_0, cqName), t);
                    return;
                }
            }
        }
    }

    static {
        cqPoolsConnected = new HashMap();
    }
}

