/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.query.internal;

import com.gemstone.gemfire.CancelException;
import com.gemstone.gemfire.DataSerializable;
import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.SystemFailure;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheClosedException;
import com.gemstone.gemfire.cache.EvictionAction;
import com.gemstone.gemfire.cache.client.internal.ProxyCache;
import com.gemstone.gemfire.cache.client.internal.ServerCQProxy;
import com.gemstone.gemfire.cache.client.internal.ServerRegionProxy;
import com.gemstone.gemfire.cache.client.internal.UserAttributes;
import com.gemstone.gemfire.cache.query.CqAttributes;
import com.gemstone.gemfire.cache.query.CqAttributesMutator;
import com.gemstone.gemfire.cache.query.CqClosedException;
import com.gemstone.gemfire.cache.query.CqEvent;
import com.gemstone.gemfire.cache.query.CqException;
import com.gemstone.gemfire.cache.query.CqExistsException;
import com.gemstone.gemfire.cache.query.CqListener;
import com.gemstone.gemfire.cache.query.CqQuery;
import com.gemstone.gemfire.cache.query.CqResults;
import com.gemstone.gemfire.cache.query.CqState;
import com.gemstone.gemfire.cache.query.CqStatistics;
import com.gemstone.gemfire.cache.query.CqStatusListener;
import com.gemstone.gemfire.cache.query.Query;
import com.gemstone.gemfire.cache.query.QueryException;
import com.gemstone.gemfire.cache.query.RegionNotFoundException;
import com.gemstone.gemfire.cache.query.SelectResults;
import com.gemstone.gemfire.cache.query.internal.CompiledBindArgument;
import com.gemstone.gemfire.cache.query.internal.CompiledIteratorDef;
import com.gemstone.gemfire.cache.query.internal.CompiledRegion;
import com.gemstone.gemfire.cache.query.internal.CompiledSelect;
import com.gemstone.gemfire.cache.query.internal.CompiledValue;
import com.gemstone.gemfire.cache.query.internal.CqEventImpl;
import com.gemstone.gemfire.cache.query.internal.CqQueryVsdStats;
import com.gemstone.gemfire.cache.query.internal.CqService;
import com.gemstone.gemfire.cache.query.internal.CqStateImpl;
import com.gemstone.gemfire.cache.query.internal.CqStatisticsImpl;
import com.gemstone.gemfire.cache.query.internal.DefaultQuery;
import com.gemstone.gemfire.cache.query.internal.ExecutionContext;
import com.gemstone.gemfire.cache.query.internal.QueryExecutionContext;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.i18n.StringId;
import com.gemstone.gemfire.internal.cache.EnumListenerEvent;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.Token;
import com.gemstone.gemfire.internal.cache.tier.sockets.CacheClientNotifier;
import com.gemstone.gemfire.internal.cache.tier.sockets.CacheClientProxy;
import com.gemstone.gemfire.internal.cache.tier.sockets.ClientProxyMembershipID;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.InternalLogWriter;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.internal.logging.LoggingThreadGroup;
import com.gemstone.gemfire.internal.logging.log4j.LocalizedMessage;
import com.gemstone.gemfire.security.GemFireSecurityException;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.logging.log4j.Logger;

public class CqQueryImpl
implements CqQuery,
DataSerializable {
    private static final Logger logger = LogService.getLogger();
    protected String cqName;
    protected String queryString;
    private volatile HashMap<Object, Object> cqResultKeys;
    private static final Object TOKEN = new Object();
    private HashSet<Object> destroysWhileCqResultsInProgress;
    public volatile boolean cqResultKeysInitialized = false;
    protected LocalRegion cqBaseRegion;
    public volatile boolean isPR = false;
    private Query query = null;
    private ClientProxyMembershipID clientProxyId = null;
    private CacheClientNotifier ccn = null;
    private CqAttributes cqAttributes = null;
    private InternalLogWriter securityLogWriter;
    private CqService cqService;
    private String regionName;
    private String serverCqName;
    private boolean isDurable = false;
    private volatile ServerCQProxy cqProxy;
    private CqStatisticsImpl cqStats;
    private CqQueryVsdStats stats;
    private final CqStateImpl cqState = new CqStateImpl();
    private EnumListenerEvent cqOperation;
    private ExecutionContext queryExecutionContext = null;
    private ProxyCache proxyCache = null;
    private Long filterID;
    private volatile ConcurrentLinkedQueue queuedEvents = null;
    public final Object queuedEventsSynchObject = new Object();
    public static TestHook testHook = null;
    private boolean connected = false;

    public Long getFilterID() {
        return this.filterID;
    }

    public void setFilterID(Long filterID) {
        this.filterID = filterID;
    }

    public CqQueryImpl() {
    }

    public CqQueryImpl(CqService cqService, String cqName, String queryString, CqAttributes cqAttributes, ServerCQProxy serverProxy, boolean isDurable) {
        this.cqName = cqName;
        this.cqAttributes = cqAttributes;
        this.queryString = queryString;
        this.securityLogWriter = (InternalLogWriter)cqService.getCache().getSecurityLoggerI18n();
        this.cqService = cqService;
        this.cqProxy = serverProxy;
        this.isDurable = isDurable;
        this.serverCqName = cqName;
    }

    @Override
    public String getName() {
        return this.cqName;
    }

    public void setName(String cqName) {
        this.cqName = this.serverCqName = cqName;
    }

    public void setCqService(CqService cqService) {
        this.cqService = cqService;
    }

    public String getRegionName() {
        return this.regionName;
    }

    public void initCq() throws CqException, CqExistsException {
        block4: {
            this.validateCq();
            if (this.cqName == null) {
                while (true) {
                    this.setName(this.cqService.generateCqName());
                    try {
                        this.cqService.addToCqMap(this);
                        break block4;
                    }
                    catch (CqExistsException ex) {
                        if (!logger.isDebugEnabled()) continue;
                        logger.debug("Got CqExistsException while intializing cq: {} Error: {}", this.cqName, ex.getMessage());
                        continue;
                    }
                    break;
                }
            }
            this.cqService.addToCqMap(this);
        }
        DistributedSystem factory = this.cqService.getCache().getDistributedSystem();
        this.stats = new CqQueryVsdStats(factory, this.serverCqName);
        this.cqStats = new CqStatisticsImpl(this);
        this.cqService.stats.incCqsStopped();
        this.cqService.stats.incCqsCreated();
        this.cqService.stats.incCqsOnClient();
    }

    public void updateCqCreateStats() {
        DistributedSystem factory = this.cqService.getCache().getDistributedSystem();
        this.stats = new CqQueryVsdStats(factory, this.serverCqName);
        this.cqStats = new CqStatisticsImpl(this);
        this.cqService.stats.incCqsStopped();
        this.cqService.stats.incCqsCreated();
        this.cqService.stats.incCqsOnClient();
    }

    public void validateCq() {
        List fromClause;
        Cache cache = this.cqService.getCache();
        DefaultQuery locQuery = (DefaultQuery)((GemFireCacheImpl)cache).getLocalQueryService().newQuery(this.queryString);
        this.query = locQuery;
        Object[] parameters = new Object[]{};
        CompiledSelect select2 = locQuery.getSimpleSelect();
        if (select2 == null) {
            throw new UnsupportedOperationException(LocalizedStrings.CqQueryImpl_CQ_QUERIES_MUST_BE_A_SELECT_STATEMENT_ONLY.toLocalizedString());
        }
        if (select2.isDistinct()) {
            throw new UnsupportedOperationException(LocalizedStrings.CqQueryImpl_SELECT_DISTINCT_QUERIES_NOT_SUPPORTED_IN_CQ.toLocalizedString());
        }
        Set regionsInQuery = locQuery.getRegionsInQuery(parameters);
        if (regionsInQuery.size() > 1 || regionsInQuery.size() < 1) {
            throw new UnsupportedOperationException(LocalizedStrings.CqQueryImpl_CQ_QUERIES_MUST_REFERENCE_ONE_AND_ONLY_ONE_REGION.toLocalizedString());
        }
        this.regionName = (String)regionsInQuery.iterator().next();
        HashSet regions = new HashSet();
        CompiledValue whereClause = select2.getWhereClause();
        if (whereClause != null) {
            whereClause.getRegionsInQuery(regions, parameters);
            if (!regions.isEmpty()) {
                throw new UnsupportedOperationException(LocalizedStrings.CqQueryImpl_THE_WHERE_CLAUSE_IN_CQ_QUERIES_CANNOT_REFER_TO_A_REGION.toLocalizedString());
            }
        }
        if ((fromClause = select2.getIterators()).size() > 1) {
            throw new UnsupportedOperationException(LocalizedStrings.CqQueryImpl_CQ_QUERIES_CANNOT_HAVE_MORE_THAN_ONE_ITERATOR_IN_THE_FROM_CLAUSE.toLocalizedString());
        }
        CompiledIteratorDef itrDef = (CompiledIteratorDef)fromClause.get(0);
        if (!(itrDef.getCollectionExpr() instanceof CompiledRegion)) {
            throw new UnsupportedOperationException(LocalizedStrings.CqQueryImpl_CQ_QUERIES_MUST_HAVE_A_REGION_PATH_ONLY_AS_THE_FIRST_ITERATOR_IN_THE_FROM_CLAUSE.toLocalizedString());
        }
        List projs = select2.getProjectionAttributes();
        if (projs != null) {
            throw new UnsupportedOperationException(LocalizedStrings.CqQueryImpl_CQ_QUERIES_DO_NOT_SUPPORT_PROJECTIONS.toLocalizedString());
        }
        List orderBys = select2.getOrderByAttrs();
        if (orderBys != null) {
            throw new UnsupportedOperationException(LocalizedStrings.CqQueryImpl_CQ_QUERIES_DO_NOT_SUPPORT_ORDER_BY.toLocalizedString());
        }
        this.setQueryExecutionContext(new QueryExecutionContext(null, this.cqService.getCache()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void registerCq(ClientProxyMembershipID p_clientProxyId, CacheClientNotifier p_ccn, int p_cqState) throws CqException, RegionNotFoundException {
        clientProxy = null;
        this.clientProxyId = p_clientProxyId;
        if (p_ccn != null) {
            this.ccn = p_ccn;
            clientProxy = p_ccn.getClientProxy(p_clientProxyId, true);
        }
        this.validateCq();
        isDebugEnabled = CqQueryImpl.logger.isDebugEnabled();
        msg = LocalizedStrings.ONE_ARG;
        t = null;
        try {
            this.query = this.constructServerSideQuery();
            if (isDebugEnabled) {
                CqQueryImpl.logger.debug("Server side query for the cq: {} is: {}", new Object[]{this.cqName, this.query.getQueryString()});
            }
            ** if (t == null) goto lbl-1000
        }
        catch (Exception ex) {
            try {
                t = ex;
                msg = ex instanceof ClassNotFoundException != false ? LocalizedStrings.CqQueryImpl_CLASS_NOT_FOUND_EXCEPTION_THE_ANTLRJAR_OR_THE_SPCIFIED_CLASS_MAY_BE_MISSING_FROM_SERVER_SIDE_CLASSPATH_ERROR_0 : LocalizedStrings.CqQueryImpl_ERROR_WHILE_PARSING_THE_QUERY_ERROR_0;
                ** if (t == null) goto lbl-1000
            }
            catch (Throwable var9_12) {
                if (t != null) {
                    s = msg.toLocalizedString(new Object[]{t});
                    if (isDebugEnabled) {
                        CqQueryImpl.logger.debug(s, (Throwable)t);
                    }
                    throw new CqException(s);
                }
                throw var9_12;
            }
lbl-1000:
            // 1 sources

            {
                s = msg.toLocalizedString(new Object[]{t});
                if (isDebugEnabled) {
                    CqQueryImpl.logger.debug(s, (Throwable)t);
                }
                throw new CqException(s);
            }
lbl-1000:
            // 1 sources

            {
            }
        }
lbl-1000:
        // 1 sources

        {
            s = msg.toLocalizedString(new Object[]{t});
            if (isDebugEnabled) {
                CqQueryImpl.logger.debug(s, (Throwable)t);
            }
            throw new CqException(s);
        }
lbl-1000:
        // 1 sources

        {
        }
        this.cqBaseRegion = (LocalRegion)this.cqService.getCache().getRegion(this.regionName);
        if (this.cqBaseRegion == null) {
            throw new RegionNotFoundException(LocalizedStrings.CqQueryImpl_REGION__0_SPECIFIED_WITH_CQ_NOT_FOUND_CQNAME_1.toLocalizedString(new Object[]{this.regionName, this.cqName}));
        }
        dp = this.cqBaseRegion.getDataPolicy();
        this.isPR = dp.withPartitioning();
        if (!this.isPR && !dp.withReplication()) {
            errMsg = null;
            errMsg = dp.withPreloaded() != false && this.cqBaseRegion.getAttributes().getEvictionAttributes() != null && this.cqBaseRegion.getAttributes().getEvictionAttributes().getAction().equals(EvictionAction.LOCAL_DESTROY) != false ? LocalizedStrings.CqQueryImpl_CQ_NOT_SUPPORTED_FOR_REPLICATE_WITH_LOCAL_DESTROY.toString(new Object[]{this.regionName, this.cqBaseRegion.getAttributes().getEvictionAttributes().getAction()}) : "The region " + this.regionName + "  specified in CQ creation is neither replicated nor partitioned; " + "only replicated or partitioned regions are allowed in CQ creation.";
            if (isDebugEnabled) {
                CqQueryImpl.logger.debug(errMsg);
            }
            throw new CqException(errMsg);
        }
        if (dp.withReplication() && !this.cqBaseRegion.getAttributes().getScope().isDistributedAck() && !this.cqBaseRegion.getAttributes().getScope().isGlobal()) {
            errMsg = "The replicated region " + this.regionName + " specified in CQ creation does not have scope supported by CQ." + " The CQ supported scopes are DISTRIBUTED_ACK and GLOBAL.";
            if (isDebugEnabled) {
                CqQueryImpl.logger.debug(errMsg);
            }
            throw new CqException(errMsg);
        }
        if (clientProxy != null) {
            clientProxy.incCqCount();
            if (clientProxy.hasOneCq()) {
                this.cqService.stats.incClientsWithCqs();
            }
            if (isDebugEnabled) {
                CqQueryImpl.logger.debug("Added CQ to the base region: {} With key as: {}", new Object[]{this.cqBaseRegion.getFullPath(), this.serverCqName});
            }
        }
        this.updateCqCreateStats();
        if (this.cqState.getState() != p_cqState) {
            this.setCqState(p_cqState);
        }
        if (p_cqState == 1) {
            this.cqService.addToMatchingCqMap(this);
        }
        if (CqService.MAINTAIN_KEYS) {
            this.cqResultKeys = new HashMap<K, V>();
            if (this.isPR) {
                this.setCqResultsCacheInitialized();
            } else {
                this.destroysWhileCqResultsInProgress = new HashSet<E>();
            }
        }
        if (p_ccn != null) {
            try {
                this.cqService.addToCqMap(this);
            }
            catch (CqExistsException cqe) {
                throw new CqException(LocalizedStrings.CqQueryImpl_UNABLE_TO_CREATE_CQ_0_ERROR__1.toLocalizedString(new Object[]{this.cqName, cqe.getMessage()}));
            }
            this.cqBaseRegion.getFilterProfile().registerCq(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Object> getCqResultKeyCache() {
        if (this.cqResultKeys != null) {
            HashMap<Object, Object> hashMap = this.cqResultKeys;
            synchronized (hashMap) {
                return Collections.synchronizedSet(new HashSet<Object>(this.cqResultKeys.keySet()));
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isPartOfCqResult(Object key2) {
        if (this.cqResultKeys == null) {
            logger.warn(LocalizedMessage.create(LocalizedStrings.CqQueryImpl_Null_CQ_Result_Key_Cache_0));
            return false;
        }
        HashMap<Object, Object> hashMap = this.cqResultKeys;
        synchronized (hashMap) {
            if (this.destroysWhileCqResultsInProgress != null) {
                for (Object k : this.destroysWhileCqResultsInProgress) {
                    this.cqResultKeys.remove(k);
                }
                this.destroysWhileCqResultsInProgress = null;
            }
            return this.cqResultKeys.containsKey(key2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addToCqResultKeys(Object key2) {
        if (!CqService.MAINTAIN_KEYS) {
            return;
        }
        if (this.cqResultKeys != null) {
            HashMap<Object, Object> hashMap = this.cqResultKeys;
            synchronized (hashMap) {
                this.cqResultKeys.put(key2, TOKEN);
                if (!this.cqResultKeysInitialized && this.destroysWhileCqResultsInProgress != null) {
                    this.destroysWhileCqResultsInProgress.remove(key2);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFromCqResultKeys(Object key2, boolean isTokenMode) {
        if (!CqService.MAINTAIN_KEYS) {
            return;
        }
        if (this.cqResultKeys != null) {
            HashMap<Object, Object> hashMap = this.cqResultKeys;
            synchronized (hashMap) {
                if (isTokenMode && this.cqResultKeys.get(key2) != Token.DESTROYED) {
                    return;
                }
                this.cqResultKeys.remove(key2);
                if (!this.cqResultKeysInitialized && this.destroysWhileCqResultsInProgress != null) {
                    this.destroysWhileCqResultsInProgress.add(key2);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markAsDestroyedInCqResultKeys(Object key2) {
        if (!CqService.MAINTAIN_KEYS) {
            return;
        }
        if (this.cqResultKeys != null) {
            HashMap<Object, Object> hashMap = this.cqResultKeys;
            synchronized (hashMap) {
                this.cqResultKeys.put(key2, Token.DESTROYED);
                if (!this.cqResultKeysInitialized && this.destroysWhileCqResultsInProgress != null) {
                    this.destroysWhileCqResultsInProgress.add(key2);
                }
            }
        }
    }

    public void setCqResultsCacheInitialized() {
        if (CqService.MAINTAIN_KEYS) {
            this.cqResultKeysInitialized = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCqResultKeysSize() {
        if (this.cqResultKeys == null) {
            return 0;
        }
        HashMap<Object, Object> hashMap = this.cqResultKeys;
        synchronized (hashMap) {
            return this.cqResultKeys.size();
        }
    }

    public boolean isOldValueRequiredForQueryProcessing(Object key2) {
        return !this.cqResultKeysInitialized || !this.isPartOfCqResult(key2);
    }

    private Query constructServerSideQuery() throws QueryException {
        GemFireCacheImpl cache = (GemFireCacheImpl)this.cqService.getCache();
        DefaultQuery locQuery = (DefaultQuery)cache.getLocalQueryService().newQuery(this.queryString);
        CompiledSelect select2 = locQuery.getSimpleSelect();
        CompiledIteratorDef from = (CompiledIteratorDef)select2.getIterators().get(0);
        this.regionName = ((CompiledRegion)from.getCollectionExpr()).getRegionPath();
        from.setCollectionExpr(new CompiledBindArgument(1));
        return locQuery;
    }

    public ServerCQProxy getCQProxy() {
        return this.cqProxy;
    }

    public void initConnectionProxy() throws CqException, RegionNotFoundException {
        this.cqBaseRegion = (LocalRegion)this.cqService.getCache().getRegion(this.regionName);
        if (this.cqBaseRegion == null) {
            throw new RegionNotFoundException(LocalizedStrings.CqQueryImpl_REGION_ON_WHICH_QUERY_IS_SPECIFIED_NOT_FOUND_LOCALLY_REGIONNAME_0.toLocalizedString(this.regionName));
        }
        ServerRegionProxy srp = this.cqBaseRegion.getServerProxy();
        if (srp != null) {
            if (logger.isTraceEnabled()) {
                logger.trace("Found server region proxy on region. RegionName: {}", this.regionName);
            }
            this.cqProxy = new ServerCQProxy(srp);
            if (!srp.getPool().getSubscriptionEnabled()) {
                throw new CqException("The 'queueEnabled' flag on Pool installed on Region " + this.regionName + " is set to false.");
            }
        } else {
            throw new CqException("Unable to get the connection pool. The Region does not have a pool configured.");
        }
    }

    @Override
    public void close() throws CqClosedException, CqException {
        this.close(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(boolean sendRequestToServer) throws CqClosedException, CqException {
        CqListener[] cqListeners;
        boolean isDebugEnabled = logger.isDebugEnabled();
        if (isDebugEnabled) {
            logger.debug("Started closing CQ CqName: {} SendRequestToServer: {}", this.cqName, sendRequestToServer);
        }
        CqStateImpl cqStateImpl = this.cqState;
        synchronized (cqStateImpl) {
            if (this.isClosed()) {
                if (isDebugEnabled) {
                    logger.debug("CQ is already closed, CqName: {}", this.cqName);
                }
                return;
            }
            int stateBeforeClosing = this.cqState.getState();
            this.cqState.setState(3);
            boolean isClosed = false;
            Exception exception = null;
            if (this.cqProxy != null && sendRequestToServer) {
                try {
                    if (this.proxyCache != null) {
                        if (this.proxyCache.isClosed()) {
                            throw new CacheClosedException("Cache is closed for this user.");
                        }
                        UserAttributes.userAttributes.set(this.proxyCache.getUserAttributes());
                    }
                    this.cqProxy.close(this);
                    isClosed = true;
                }
                catch (CancelException e) {
                    throw e;
                }
                catch (Exception ex) {
                    if (this.shutdownInProgress()) {
                        return;
                    }
                    exception = ex;
                }
                finally {
                    UserAttributes.userAttributes.set(null);
                }
            }
            this.removeFromCqMap();
            if (this.cqProxy == null || !sendRequestToServer || isClosed) {
                if (stateBeforeClosing == 1) {
                    this.cqService.stats.decCqsActive();
                } else if (stateBeforeClosing == 0) {
                    this.cqService.stats.decCqsStopped();
                }
                if (this.cqResultKeys != null) {
                    HashMap<Object, Object> hashMap = this.cqResultKeys;
                    synchronized (hashMap) {
                        this.cqResultKeys.clear();
                    }
                }
                this.cqState.setState(2);
                this.cqService.stats.incCqsClosed();
                this.cqService.stats.decCqsOnClient();
                if (this.stats != null) {
                    this.stats.close();
                }
            } else {
                if (this.shutdownInProgress()) {
                    return;
                }
                if (exception != null) {
                    throw new CqException(LocalizedStrings.CqQueryImpl_FAILED_TO_CLOSE_THE_CQ_CQNAME_0_ERROR_FROM_LAST_ENDPOINT_1.toLocalizedString(this.cqName, exception.getLocalizedMessage()), exception.getCause());
                }
                throw new CqException(LocalizedStrings.CqQueryImpl_FAILED_TO_CLOSE_THE_CQ_CQNAME_0_THE_SERVER_ENDPOINTS_ON_WHICH_THIS_CQ_WAS_REGISTERED_WERE_NOT_FOUND.toLocalizedString(this.cqName));
            }
        }
        if (this.cqAttributes != null && (cqListeners = this.getCqAttributes().getCqListeners()) != null) {
            if (isDebugEnabled) {
                logger.debug("Invoking CqListeners close() api for the CQ, CqName: {} Number of CqListeners: {}", this.cqName, cqListeners.length);
            }
            for (int lCnt = 0; lCnt < cqListeners.length; ++lCnt) {
                try {
                    cqListeners[lCnt].close();
                    continue;
                }
                catch (Exception ex) {
                    logger.warn(LocalizedMessage.create(LocalizedStrings.CqQueryImpl_EXCEPTION_OCCOURED_IN_THE_CQLISTENER_OF_THE_CQ_CQNAME_0_ERROR_1, new Object[]{this.cqName, ex.getLocalizedMessage()}));
                    if (!isDebugEnabled) continue;
                    logger.debug(ex.getMessage(), (Throwable)ex);
                    continue;
                }
                catch (VirtualMachineError err) {
                    SystemFailure.initiateFailure(err);
                    throw err;
                }
                catch (Throwable t) {
                    SystemFailure.checkFailure();
                    logger.warn(LocalizedMessage.create(LocalizedStrings.CqQueryImpl_RUNTIMEEXCEPTION_OCCOURED_IN_THE_CQLISTENER_OF_THE_CQ_CQNAME_0_ERROR_1, new Object[]{this.cqName, t.getLocalizedMessage()}));
                    if (!isDebugEnabled) continue;
                    logger.debug(t.getMessage(), t);
                }
            }
        }
        if (isDebugEnabled) {
            logger.debug("Successfully closed the CQ. {}", this.cqName);
        }
    }

    private void removeFromCqMap() throws CqException {
        try {
            this.cqService.removeCq(this.serverCqName);
        }
        catch (Exception ex) {
            StringId errMsg = LocalizedStrings.CqQueryImpl_FAILED_TO_REMOVE_CONTINUOUS_QUERY_FROM_THE_REPOSITORY_CQNAME_0_ERROR_1;
            Object[] errMsgArgs = new Object[]{this.cqName, ex.getLocalizedMessage()};
            String msg = errMsg.toLocalizedString(errMsgArgs);
            logger.error(msg);
            throw new CqException(msg, ex);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Removed CQ from the CQ repository. CQ Name: {}", this.cqName);
        }
    }

    @Override
    public String getQueryString() {
        return this.queryString;
    }

    @Override
    public Query getQuery() {
        return this.query;
    }

    @Override
    public CqStatistics getStatistics() {
        return this.cqStats;
    }

    public ClientProxyMembershipID getClientProxyId() {
        return this.clientProxyId;
    }

    public CacheClientNotifier getCacheClientNotifier() {
        return this.ccn;
    }

    @Override
    public CqAttributes getCqAttributes() {
        return this.cqAttributes;
    }

    public LocalRegion getCqBaseRegion() {
        return this.cqBaseRegion;
    }

    private void cleanup() throws CqException {
        block5: {
            try {
                if (this.cqBaseRegion != null && !this.cqBaseRegion.isDestroyed() && this.cqService.isServer()) {
                    this.cqBaseRegion.getFilterProfile().closeCq(this);
                    CacheClientProxy clientProxy = this.ccn.getClientProxy(this.clientProxyId);
                    clientProxy.decCqCount();
                    if (clientProxy.hasNoCq()) {
                        this.cqService.stats.decClientsWithCqs();
                    }
                }
            }
            catch (Exception ex) {
                if (!logger.isDebugEnabled()) break block5;
                logger.debug("Failed to remove CQ from the base region. CqName :{}", this.cqName);
            }
        }
        if (!this.cqService.isServer()) {
            this.cqService.removeFromBaseRegionToCqNameMap(this.regionName, this.serverCqName);
        }
    }

    public String getBaseRegionName() {
        return this.regionName;
    }

    public String getServerCqName() {
        return this.serverCqName;
    }

    public void setServerCqName(String serverCqName) {
        this.serverCqName = serverCqName;
    }

    public CqListener[] getCqListeners() {
        return this.cqAttributes.getCqListeners();
    }

    @Override
    public void execute() throws CqClosedException, RegionNotFoundException, CqException {
        this.executeCqOnRedundantsAndPrimary(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CqResults executeWithInitialResults() throws CqClosedException, RegionNotFoundException, CqException {
        CqResults initialResults;
        Object object = this.queuedEventsSynchObject;
        synchronized (object) {
            while (this.queuedEvents != null) {
                try {
                    this.queuedEventsSynchObject.wait();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
            this.queuedEvents = new ConcurrentLinkedQueue();
        }
        if (testHook != null) {
            testHook.pauseUntilReady();
        }
        try {
            initialResults = (CqResults)this.executeCqOnRedundantsAndPrimary(true);
        }
        catch (CqClosedException e) {
            this.queuedEvents = null;
            throw e;
        }
        catch (RegionNotFoundException e) {
            this.queuedEvents = null;
            throw e;
        }
        catch (CqException e) {
            this.queuedEvents = null;
            throw e;
        }
        catch (RuntimeException e) {
            this.queuedEvents = null;
            throw e;
        }
        Object object2 = this.queuedEventsSynchObject;
        synchronized (object2) {
            try {
                if (!this.queuedEvents.isEmpty()) {
                    try {
                        Runnable r = new Runnable(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void run() {
                                Object[] eventArray = null;
                                if (testHook != null) {
                                    testHook.setEventCount(CqQueryImpl.this.queuedEvents.size());
                                }
                                Object object = CqQueryImpl.this.queuedEventsSynchObject;
                                synchronized (object) {
                                    try {
                                        for (Object cqEvent : eventArray = CqQueryImpl.this.queuedEvents.toArray()) {
                                            CqQueryImpl.this.cqService.invokeListeners(CqQueryImpl.this.cqName, CqQueryImpl.this, (CqEventImpl)cqEvent);
                                            CqQueryImpl.this.stats.decQueuedCqListenerEvents();
                                        }
                                    }
                                    finally {
                                        CqQueryImpl.this.queuedEvents.clear();
                                        CqQueryImpl.this.queuedEvents = null;
                                        CqQueryImpl.this.queuedEventsSynchObject.notify();
                                    }
                                }
                            }
                        };
                        LoggingThreadGroup group = LoggingThreadGroup.createThreadGroup("CQEventHandler", logger);
                        Thread thread = new Thread(group, r, "CQEventHandler For " + this.cqName);
                        thread.setDaemon(true);
                        thread.start();
                    }
                    catch (Exception ex) {
                        if (logger.isDebugEnabled()) {
                            logger.debug("Exception while invoking the CQ Listener with queued events.", (Throwable)ex);
                        }
                    }
                } else {
                    this.queuedEvents = null;
                }
            }
            finally {
                this.queuedEventsSynchObject.notify();
            }
            return initialResults;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object executeCqOnRedundantsAndPrimary(boolean executeWithInitialResults) throws CqClosedException, RegionNotFoundException, CqException {
        SelectResults initialResults = null;
        CqStateImpl cqStateImpl = this.cqState;
        synchronized (cqStateImpl) {
            if (this.isClosed()) {
                throw new CqClosedException(LocalizedStrings.CqQueryImpl_CQ_IS_CLOSED_CQNAME_0.toLocalizedString(this.cqName));
            }
            if (this.isRunning()) {
                throw new IllegalStateException(LocalizedStrings.CqQueryImpl_CQ_IS_IN_RUNNING_STATE_CQNAME_0.toLocalizedString(this.cqName));
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Performing Execute {} request for CQ. CqName: {}", executeWithInitialResults ? "WithInitialResult" : "", this.cqName);
            }
            this.cqBaseRegion = (LocalRegion)this.cqService.getCache().getRegion(this.regionName);
            if (!this.cqService.isServer()) {
                if (this.cqProxy == null) {
                    this.initConnectionProxy();
                }
                boolean success = false;
                try {
                    if (this.proxyCache != null) {
                        if (this.proxyCache.isClosed()) {
                            throw new CacheClosedException("Cache is closed for this user.");
                        }
                        UserAttributes.userAttributes.set(this.proxyCache.getUserAttributes());
                    }
                    if (executeWithInitialResults) {
                        initialResults = this.cqProxy.createWithIR(this);
                        if (initialResults == null) {
                            String errMsg = "Failed to execute the CQ.  CqName: " + this.cqName + ", Query String is: " + this.queryString;
                            throw new CqException(errMsg);
                        }
                    } else {
                        this.cqProxy.create(this);
                    }
                    success = true;
                }
                catch (Exception ex) {
                    if (this.shutdownInProgress()) {
                        throw new CqException("System shutdown in progress.");
                    }
                    if (ex.getCause() instanceof GemFireSecurityException) {
                        if (this.securityLogWriter.warningEnabled()) {
                            this.securityLogWriter.warning(LocalizedStrings.CqQueryImpl_EXCEPTION_WHILE_EXECUTING_CQ_EXCEPTION_0, ex, null);
                        }
                        throw new CqException(LocalizedStrings.CqQueryImpl_GOT_SECURITY_EXCEPTION_WHILE_EXECUTING_CQ_ON_SERVER.toLocalizedString(), ex.getCause());
                    }
                    if (ex instanceof CqException) {
                        throw (CqException)ex;
                    }
                    String errMsg = LocalizedStrings.CqQueryImpl_FAILED_TO_EXECUTE_THE_CQ_CQNAME_0_QUERY_STRING_IS_1_ERROR_FROM_LAST_SERVER_2.toLocalizedString(this.cqName, this.queryString, ex.getLocalizedMessage());
                    if (logger.isDebugEnabled()) {
                        logger.debug(errMsg, (Throwable)ex);
                    }
                    throw new CqException(errMsg, ex);
                }
                finally {
                    if (!success && !this.shutdownInProgress()) {
                        try {
                            this.cqProxy.close(this);
                        }
                        catch (Exception e) {
                            if (logger.isDebugEnabled()) {
                                logger.debug("Exception cleaning up failed cq", (Throwable)e);
                            }
                            UserAttributes.userAttributes.set(null);
                        }
                    }
                    UserAttributes.userAttributes.set(null);
                }
            }
            this.cqState.setState(1);
        }
        if (!this.cqService.isServer()) {
            this.connected = true;
            CqListener[] cqListeners = this.getCqAttributes().getCqListeners();
            for (int lCnt = 0; lCnt < cqListeners.length; ++lCnt) {
                if (cqListeners[lCnt] == null || !(cqListeners[lCnt] instanceof CqStatusListener)) continue;
                CqStatusListener listener = (CqStatusListener)cqListeners[lCnt];
                listener.onCqConnected();
            }
        }
        this.cqService.stats.incCqsActive();
        this.cqService.stats.decCqsStopped();
        return initialResults;
    }

    private boolean shutdownInProgress() {
        GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
        if (cache == null || cache.isClosed()) {
            return true;
        }
        String reason = this.cqProxy.getPool().getCancelCriterion().cancelInProgress();
        return reason != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() throws CqClosedException, CqException {
        boolean isStopped = false;
        CqStateImpl cqStateImpl = this.cqState;
        synchronized (cqStateImpl) {
            if (this.isClosed()) {
                throw new CqClosedException(LocalizedStrings.CqQueryImpl_CQ_IS_CLOSED_CQNAME_0.toLocalizedString(this.cqName));
            }
            if (!this.isRunning()) {
                throw new IllegalStateException(LocalizedStrings.CqQueryImpl_CQ_IS_NOT_IN_RUNNING_STATE_STOP_CQ_DOES_NOT_APPLY_CQNAME_0.toLocalizedString(this.cqName));
            }
            Exception exception = null;
            try {
                if (this.proxyCache != null) {
                    if (this.proxyCache.isClosed()) {
                        throw new CacheClosedException("Cache is closed for this user.");
                    }
                    UserAttributes.userAttributes.set(this.proxyCache.getUserAttributes());
                }
                if (this.cqProxy != null) {
                    this.cqProxy.stop(this);
                    isStopped = true;
                }
            }
            catch (Exception e) {
                exception = e;
            }
            finally {
                UserAttributes.userAttributes.set(null);
            }
            if (this.cqProxy == null || isStopped) {
                this.cqState.setState(0);
                this.cqService.stats.incCqsStopped();
                this.cqService.stats.decCqsActive();
                if (logger.isDebugEnabled()) {
                    logger.debug("Successfully stopped the CQ. {}", this.cqName);
                }
            } else {
                if (exception != null) {
                    throw new CqException(LocalizedStrings.CqQueryImpl_FAILED_TO_STOP_THE_CQ_CQNAME_0_ERROR_FROM_LAST_SERVER_1.toLocalizedString(this.cqName, exception.getLocalizedMessage()), exception.getCause());
                }
                throw new CqException(LocalizedStrings.CqQueryImpl_FAILED_TO_STOP_THE_CQ_CQNAME_0_THE_SERVER_ENDPOINTS_ON_WHICH_THIS_CQ_WAS_REGISTERED_WERE_NOT_FOUND.toLocalizedString(this.cqName));
            }
        }
    }

    @Override
    public CqState getState() {
        return this.cqState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCqState(int state) {
        if (this.isClosed()) {
            throw new CqClosedException(LocalizedStrings.CqQueryImpl_CQ_IS_CLOSED_CQNAME_0.toLocalizedString(this.cqName));
        }
        CqStateImpl cqStateImpl = this.cqState;
        synchronized (cqStateImpl) {
            if (state == 1) {
                if (this.isRunning()) {
                    // empty if block
                }
                this.cqState.setState(1);
                this.cqService.stats.incCqsActive();
                this.cqService.stats.decCqsStopped();
            } else if (state == 0) {
                this.cqState.setState(0);
                this.cqService.stats.incCqsStopped();
                this.cqService.stats.decCqsActive();
            } else if (state == 3) {
                this.cqState.setState(state);
            }
        }
    }

    @Override
    public CqAttributesMutator getCqAttributesMutator() {
        return (CqAttributesMutator)((Object)this.cqAttributes);
    }

    public EnumListenerEvent getCqOperation() {
        return this.cqOperation;
    }

    public void setCqOperation(EnumListenerEvent cqOperation) {
        this.cqOperation = cqOperation;
    }

    public void updateStats(CqEvent cqEvent) {
        this.stats.updateStats(cqEvent);
    }

    @Override
    public boolean isRunning() {
        return this.cqState.isRunning();
    }

    @Override
    public boolean isStopped() {
        return this.cqState.isStopped();
    }

    @Override
    public boolean isClosed() {
        return this.cqState.isClosed();
    }

    public boolean isClosing() {
        return this.cqState.isClosing();
    }

    @Override
    public boolean isDurable() {
        return this.isDurable;
    }

    public CqQueryVsdStats getVsdStats() {
        return this.stats;
    }

    public ExecutionContext getQueryExecutionContext() {
        return this.queryExecutionContext;
    }

    public void setQueryExecutionContext(ExecutionContext queryExecutionContext) {
        this.queryExecutionContext = queryExecutionContext;
    }

    public ConcurrentLinkedQueue getQueuedEvents() {
        return this.queuedEvents;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        CqStateImpl cqStateImpl = this.cqState;
        synchronized (cqStateImpl) {
            this.cqState.setState(DataSerializer.readInteger(in));
        }
        this.isDurable = DataSerializer.readBoolean(in);
        this.queryString = DataSerializer.readString(in);
        this.filterID = in.readLong();
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        DataSerializer.writeInteger(this.cqState.getState(), out);
        DataSerializer.writeBoolean(this.isDurable, out);
        DataSerializer.writeString(this.queryString, out);
        out.writeLong(this.filterID);
    }

    void setProxyCache(ProxyCache proxyCache) {
        this.proxyCache = proxyCache;
    }

    boolean isConnected() {
        return this.connected;
    }

    void setConnected(boolean connected) {
        this.connected = connected;
    }

    public static interface TestHook {
        public void pauseUntilReady();

        public void ready();

        public int numQueuedEvents();

        public void setEventCount(int var1);
    }
}

