/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.query.internal;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheClosedException;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.query.NameResolutionException;
import com.gemstone.gemfire.cache.query.RegionNotFoundException;
import com.gemstone.gemfire.cache.query.internal.AbstractCompiledValue;
import com.gemstone.gemfire.cache.query.internal.ExecutionContext;
import com.gemstone.gemfire.cache.query.internal.QRegion;
import com.gemstone.gemfire.internal.cache.BucketRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import java.util.Set;

public class CompiledRegion
extends AbstractCompiledValue {
    private String regionPath;

    public CompiledRegion(String regionPath) {
        this.regionPath = regionPath;
    }

    @Override
    public int getType() {
        return 35;
    }

    public String getRegionPath() {
        return this.regionPath;
    }

    @Override
    public Object evaluate(ExecutionContext context) throws RegionNotFoundException {
        Region rgn;
        Cache cache = context.getCache();
        PartitionedRegion pr2 = context.getPartitionedRegion();
        if (pr2 != null && pr2.getFullPath().equals(this.regionPath)) {
            rgn = context.getBucketRegion();
        } else if (pr2 != null) {
            BucketRegion br = context.getBucketRegion();
            int bucketID = br.getId();
            rgn = cache.getRegion(this.regionPath);
            if (rgn.getAttributes().getDataPolicy().withPartitioning()) {
                PartitionedRegion prLocal = (PartitionedRegion)rgn;
                rgn = prLocal.getDataStore().getLocalBucketById(bucketID);
            }
        } else {
            rgn = cache.getRegion(this.regionPath);
        }
        if (rgn == null) {
            if (cache.isClosed()) {
                throw new CacheClosedException();
            }
            throw new RegionNotFoundException(LocalizedStrings.CompiledRegion_REGION_NOT_FOUND_0.toLocalizedString(this.regionPath));
        }
        if (context.isCqQueryContext()) {
            return new QRegion(rgn, true, context);
        }
        return new QRegion(rgn, false, context);
    }

    @Override
    public void generateCanonicalizedExpression(StringBuffer clauseBuffer, ExecutionContext context) throws NameResolutionException {
        clauseBuffer.insert(0, this.regionPath);
    }

    @Override
    public void getRegionsInQuery(Set regionsInQuery, Object[] parameters) {
        regionsInQuery.add(this.regionPath);
    }
}

