/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.query.internal;

import com.gemstone.gemfire.cache.query.AmbiguousNameException;
import com.gemstone.gemfire.cache.query.FunctionDomainException;
import com.gemstone.gemfire.cache.query.NameResolutionException;
import com.gemstone.gemfire.cache.query.QueryInvocationTargetException;
import com.gemstone.gemfire.cache.query.QueryService;
import com.gemstone.gemfire.cache.query.SelectResults;
import com.gemstone.gemfire.cache.query.TypeMismatchException;
import com.gemstone.gemfire.cache.query.internal.AbstractCompiledValue;
import com.gemstone.gemfire.cache.query.internal.CompiledComparison;
import com.gemstone.gemfire.cache.query.internal.CompiledLiteral;
import com.gemstone.gemfire.cache.query.internal.CompiledValue;
import com.gemstone.gemfire.cache.query.internal.ExecutionContext;
import com.gemstone.gemfire.cache.query.internal.GroupJunction;
import com.gemstone.gemfire.cache.query.internal.IndexInfo;
import com.gemstone.gemfire.cache.query.internal.OrganizedOperands;
import com.gemstone.gemfire.cache.query.internal.PlanInfo;
import com.gemstone.gemfire.cache.query.internal.QueryUtils;
import com.gemstone.gemfire.cache.query.internal.RangeJunction;
import com.gemstone.gemfire.cache.query.internal.RuntimeIterator;
import com.gemstone.gemfire.cache.query.internal.index.IndexManager;
import com.gemstone.gemfire.cache.query.internal.index.IndexProtocol;
import com.gemstone.gemfire.cache.query.internal.index.PrimaryKeyIndex;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.pdx.internal.PdxString;
import java.util.regex.Pattern;

public class CompiledLike
extends CompiledComparison {
    static final int WILDCARD_PERCENT = 0;
    static final int WILDCARD_UNDERSCORE = 1;
    private int wildcardType = -1;
    private int wildcardPosition = -1;
    private int patternLength = 0;
    static final String LOWEST_STRING = "";
    static final char BOUNDARY_CHAR = '\u00ff';
    static final char UNDERSCORE = '_';
    static final char PERCENT = '%';
    static final char BACKSLASH = '\\';
    private final CompiledValue var;
    private boolean isIndexEvaluated = false;
    private final CompiledValue bindArg;

    public CompiledLike(CompiledValue var, CompiledValue pattern) {
        super(var, pattern, 13);
        this.var = var;
        this.bindArg = pattern;
    }

    OrganizedOperands organizeOperands(ExecutionContext context, boolean completeExpansionNeeded, RuntimeIterator[] indpndntItrs) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
        CompiledValue[] cvs = this.getExpandedOperandsWithIndexInfoSetIfAny(context);
        AbstractCompiledValue filter = null;
        filter = cvs.length == 1 ? cvs[0] : (this.getOperator() == 20 && this.wildcardPosition == this.patternLength - 1 && this.wildcardType == 0 ? new GroupJunction(82, indpndntItrs, completeExpansionNeeded, cvs) : new RangeJunction(84, indpndntItrs, completeExpansionNeeded, cvs));
        OrganizedOperands result = new OrganizedOperands();
        result.isSingleFilter = true;
        result.filterOperand = filter;
        return result;
    }

    CompiledComparison[] getExpandedOperandsWithIndexInfoSetIfAny(ExecutionContext context) throws AmbiguousNameException, TypeMismatchException, NameResolutionException, FunctionDomainException, QueryInvocationTargetException {
        CompiledComparison[] cvs;
        String pattern = (String)this.bindArg.evaluate(context);
        for (CompiledComparison cc : cvs = this.getRangeIfSargable(this.var, pattern)) {
            if (this.getOperator() == 20 && this.wildcardPosition == this.patternLength - 1 && this.wildcardType == 0) {
                cc.negate();
            }
            cc.computeDependencies(context);
            IndexInfo[] thisIndexInfo = (IndexInfo[])context.cacheGet(this);
            if (thisIndexInfo == null || thisIndexInfo.length <= 0) continue;
            IndexInfo indexInfo = new IndexInfo(cc.getKey(context), thisIndexInfo[0]._path, thisIndexInfo[0]._index, thisIndexInfo[0]._matchLevel, thisIndexInfo[0].mapping, cc.getOperator());
            context.cachePut(cc, new IndexInfo[]{indexInfo});
        }
        if (IndexManager.testHook != null) {
            if (GemFireCacheImpl.getInstance().getLogger().fineEnabled()) {
                GemFireCacheImpl.getInstance().getLogger().fine("IndexManager TestHook is set in getExpandedOperandsWithIndexInfoSetIfAny.");
            }
            IndexManager.testHook.hook(12);
        }
        return cvs;
    }

    @Override
    public SelectResults filterEvaluate(ExecutionContext context, SelectResults intermediateResults, boolean completeExpansionNeeded, CompiledValue iterOperands, RuntimeIterator[] indpndntItrs, boolean isIntersection, boolean conditioningNeeded, boolean evaluateProjection) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
        OrganizedOperands newOperands = this.organizeOperands(context, completeExpansionNeeded, indpndntItrs);
        assert (newOperands.iterateOperand == null);
        SelectResults result = intermediateResults;
        result = newOperands.filterOperand.filterEvaluate(context, intermediateResults, completeExpansionNeeded, iterOperands, indpndntItrs, isIntersection, conditioningNeeded, evaluateProjection);
        return result;
    }

    @Override
    public SelectResults filterEvaluate(ExecutionContext context, SelectResults intermediateResults) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
        RuntimeIterator grpItr = (RuntimeIterator)QueryUtils.getCurrentScopeUltimateRuntimeIteratorsIfAny(this, context).iterator().next();
        OrganizedOperands newOperands = this.organizeOperands(context, true, new RuntimeIterator[]{grpItr});
        assert (newOperands.iterateOperand == null);
        SelectResults result = intermediateResults;
        result = newOperands.filterOperand.filterEvaluate(context, intermediateResults);
        return result;
    }

    CompiledComparison[] getRangeIfSargable(CompiledValue var, String pattern) {
        CompiledComparison[] cv = null;
        StringBuffer buffer = new StringBuffer(pattern);
        this.wildcardPosition = this.checkIfSargableAndRemoveEscapeChars(buffer);
        this.patternLength = buffer.length();
        this.isIndexEvaluated = true;
        if (this.wildcardPosition >= 0) {
            int len = this.patternLength;
            if (this.wildcardPosition == 0) {
                cv = new CompiledComparison[]{new CompiledComparison(var, new CompiledLiteral(LOWEST_STRING), 19), this};
            } else {
                char upperBoundChar;
                for (int k = len - 1; k >= this.wildcardPosition; --k) {
                    buffer.deleteCharAt(k);
                    --len;
                }
                String lowerBound = buffer.toString();
                int upperBoundPosition = len - 1;
                while ((upperBoundChar = buffer.charAt(upperBoundPosition)) == '\u00ff') {
                    --upperBoundPosition;
                }
                upperBoundChar = (char)(buffer.charAt(upperBoundPosition) + '\u0001');
                buffer.delete(upperBoundPosition, len);
                buffer.append(upperBoundChar);
                String upperBound = buffer.toString();
                CompiledComparison c1 = new CompiledComparison(var, new CompiledLiteral(lowerBound), 19);
                CompiledComparison c2 = new CompiledComparison(var, new CompiledLiteral(upperBound), 22);
                cv = len < this.patternLength - 1 || this.wildcardType == 1 ? (this.getOperator() == 20 ? new CompiledComparison[]{new CompiledComparison(var, new CompiledLiteral(LOWEST_STRING), 19), this} : new CompiledComparison[]{c1, c2, this}) : new CompiledComparison[]{c1, c2};
            }
        } else {
            cv = new CompiledComparison[]{new CompiledComparison(var, new CompiledLiteral(buffer.toString()), this.getOperator())};
        }
        return cv;
    }

    private String getRegexPattern(String pattern) {
        StringBuffer sb = new StringBuffer();
        boolean prevMetaChar = false;
        int len = pattern.length();
        block4: for (int i = 0; i < len; ++i) {
            char ch = pattern.charAt(i);
            switch (ch) {
                case '(': 
                case ')': 
                case '*': 
                case '+': 
                case '.': 
                case '?': 
                case '[': 
                case '\\': 
                case ']': 
                case '^': 
                case '{': 
                case '|': 
                case '}': {
                    if (ch == '\\') {
                        if (i + 1 >= len || pattern.charAt(i + 1) != '\\') continue block4;
                        ++i;
                    }
                    if (!prevMetaChar) {
                        sb.append('\\');
                        sb.append('Q');
                        prevMetaChar = true;
                    }
                    sb.append(ch);
                    continue block4;
                }
                case '%': 
                case '_': {
                    if (prevMetaChar) {
                        sb.append('\\');
                        sb.append('E');
                        prevMetaChar = false;
                    }
                    int numConsecutiveBackSlash = 0;
                    for (int j = i - 1; j > -1 && pattern.charAt(j) == '\\'; --j) {
                        ++numConsecutiveBackSlash;
                    }
                    if (numConsecutiveBackSlash % 2 == 0) {
                        if (ch == '%') {
                            sb.append(".*");
                            while (i + 1 < len && pattern.charAt(i + 1) == '%') {
                                ++i;
                            }
                            continue block4;
                        }
                        sb.append(".");
                        continue block4;
                    }
                    sb.append(ch);
                    continue block4;
                }
                default: {
                    if (prevMetaChar) {
                        sb.append('\\');
                        sb.append('E');
                        prevMetaChar = false;
                    }
                    sb.append(ch);
                }
            }
        }
        return sb.toString();
    }

    int checkIfSargableAndRemoveEscapeChars(StringBuffer buffer) {
        int len = buffer.length();
        int wildcardPosition = -1;
        for (int i = 0; i < len; ++i) {
            char ch = buffer.charAt(i);
            if (ch == '_') {
                this.wildcardType = 1;
                wildcardPosition = i;
                break;
            }
            if (ch == '%') {
                this.wildcardType = 0;
                wildcardPosition = i;
                break;
            }
            if (ch != '\\' || i + 1 >= len) continue;
            if (buffer.charAt(i + 1) == '%' || buffer.charAt(i + 1) == '_') {
                wildcardPosition = -1;
            }
            buffer.deleteCharAt(i);
            --len;
        }
        return wildcardPosition;
    }

    @Override
    public Object evaluate(ExecutionContext context) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
        Object value2;
        this.isIndexEvaluated = false;
        Pattern pattern = (Pattern)context.cacheGet(this.bindArg);
        if (pattern == null) {
            String strPattern = this.bindArg.evaluate(context).toString();
            if (strPattern == null) {
                throw new UnsupportedOperationException("Null values are not supported with LIKE predicate.");
            }
            pattern = Pattern.compile(this.getRegexPattern(strPattern), 40);
            context.cachePut(this.bindArg, pattern);
        }
        if ((value2 = this.var.evaluate(context)) == null) {
            return null;
        }
        if (!(value2 instanceof String) && !(value2 instanceof PdxString) && value2 != QueryService.UNDEFINED) {
            throw new TypeMismatchException(LocalizedStrings.TypeUtils_UNABLE_TO_COMPARE_OBJECT_OF_TYPE_0_WITH_OBJECT_OF_TYPE_1.toLocalizedString("java.lang.String", value2.getClass().getName()));
        }
        boolean isMatched = pattern.matcher(value2.toString()).matches();
        if (this.getOperator() == 20) {
            isMatched = !isMatched;
        }
        return isMatched;
    }

    @Override
    protected PlanInfo protGetPlanInfo(ExecutionContext context) throws TypeMismatchException, AmbiguousNameException, NameResolutionException {
        PlanInfo result = null;
        if (this.isIndexEvaluated) {
            result = new PlanInfo();
            result.evalAsFilter = false;
        } else {
            result = super.protGetPlanInfo(context);
            if (result.indexes.size() > 0 && result.indexes.get(0) instanceof PrimaryKeyIndex) {
                result.evalAsFilter = false;
            }
        }
        return result;
    }

    @Override
    public int getType() {
        return -15;
    }

    @Override
    public boolean isLimitApplicableAtIndexLevel(ExecutionContext context) {
        return true;
    }

    @Override
    public boolean isOrderByApplicableAtIndexLevel(ExecutionContext context, String canonicalizedOrderByClause) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
        if (this.getPlanInfo((ExecutionContext)context).evalAsFilter) {
            IndexProtocol ip;
            PlanInfo pi = this.getPlanInfo(context);
            if (pi.indexes.size() == 1 && (ip = (IndexProtocol)pi.indexes.get(0)).getCanonicalizedIndexedExpression().equals(canonicalizedOrderByClause)) {
                return true;
            }
        }
        return false;
    }
}

