/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.query.internal;

import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.query.AmbiguousNameException;
import com.gemstone.gemfire.cache.query.NameResolutionException;
import com.gemstone.gemfire.cache.query.TypeMismatchException;
import com.gemstone.gemfire.cache.query.internal.AbstractCompiledValue;
import com.gemstone.gemfire.cache.query.internal.ExecutionContext;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.pdx.internal.PdxString;
import java.util.Set;

public class CompiledBindArgument
extends AbstractCompiledValue {
    private int index;

    public CompiledBindArgument(int index2) {
        this.index = index2;
    }

    @Override
    public int getType() {
        return 47;
    }

    @Override
    public void generateCanonicalizedExpression(StringBuffer clauseBuffer, ExecutionContext context) throws AmbiguousNameException, TypeMismatchException, NameResolutionException {
        Object rgn = context.getBindArgument(this.index);
        if (rgn instanceof Region) {
            clauseBuffer.insert(0, ((Region)rgn).getFullPath());
        } else {
            super.generateCanonicalizedExpression(clauseBuffer, context);
        }
    }

    @Override
    public Object evaluate(ExecutionContext context) {
        PartitionedRegion pr2;
        Object obj = context.getBindArgument(this.index);
        if (obj instanceof Region && (pr2 = context.getPartitionedRegion()) != null && pr2.getFullPath().equals(((Region)obj).getFullPath())) {
            obj = context.getBucketRegion();
        }
        return obj;
    }

    public Object evaluate(Object[] bindArguments) {
        if (this.index > bindArguments.length) {
            throw new IllegalArgumentException(LocalizedStrings.ExecutionContext_TOO_FEW_QUERY_PARAMETERS.toLocalizedString());
        }
        return bindArguments[this.index - 1];
    }

    @Override
    public void getRegionsInQuery(Set regionsInQuery, Object[] parameters) {
        Object v = parameters[this.index - 1];
        if (v instanceof Region) {
            regionsInQuery.add(((Region)v).getFullPath());
        }
    }

    public PdxString getSavedPdxString(ExecutionContext context) {
        return context.getSavedPdxString(this.index);
    }
}

