/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.query.internal;

import com.gemstone.gemfire.cache.query.AmbiguousNameException;
import com.gemstone.gemfire.cache.query.FunctionDomainException;
import com.gemstone.gemfire.cache.query.NameResolutionException;
import com.gemstone.gemfire.cache.query.QueryInvocationTargetException;
import com.gemstone.gemfire.cache.query.QueryService;
import com.gemstone.gemfire.cache.query.SelectResults;
import com.gemstone.gemfire.cache.query.TypeMismatchException;
import com.gemstone.gemfire.cache.query.internal.CompiledValue;
import com.gemstone.gemfire.cache.query.internal.ExecutionContext;
import com.gemstone.gemfire.cache.query.internal.Filter;
import com.gemstone.gemfire.cache.query.internal.PlanInfo;
import com.gemstone.gemfire.cache.query.internal.ResultsBag;
import com.gemstone.gemfire.cache.query.internal.RuntimeIterator;
import com.gemstone.gemfire.cache.query.internal.StructBag;
import com.gemstone.gemfire.cache.query.internal.Support;
import com.gemstone.gemfire.cache.query.internal.parse.OQLLexerTokenTypes;
import com.gemstone.gemfire.cache.query.internal.types.StructTypeImpl;
import com.gemstone.gemfire.cache.query.types.ObjectType;
import com.gemstone.gemfire.cache.query.types.StructType;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public abstract class AbstractCompiledValue
implements CompiledValue,
Filter,
OQLLexerTokenTypes {
    ObjectType typecast = null;

    @Override
    public ObjectType getTypecast() {
        return this.typecast;
    }

    void setTypecast(ObjectType objectType) {
        this.typecast = objectType;
    }

    @Override
    public List getPathOnIterator(RuntimeIterator itr, ExecutionContext context) throws TypeMismatchException, AmbiguousNameException {
        return null;
    }

    @Override
    public SelectResults filterEvaluate(ExecutionContext context, SelectResults iterationLimit, boolean completeExpansionNeeded, CompiledValue iterOperands, RuntimeIterator[] indpndntItrs, boolean isIntersection, boolean conditioningNeeded, boolean evalProj) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
        Support.assertionFailed("This method should not have invoked as CompieldComparison & CompiledUndefined are the only classes on which this invocation should have occured ");
        return null;
    }

    @Override
    public PlanInfo getPlanInfo(ExecutionContext context) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
        if (!this.isDependentOnCurrentScope(context)) {
            PlanInfo planInfo = new PlanInfo();
            Object result = this.evaluate(context);
            if (!(result instanceof Boolean)) {
                throw new TypeMismatchException(LocalizedStrings.AbstractCompiledValue_BOOLEAN_VALUE_EXPECTED_NOT_TYPE_0.toLocalizedString(result.getClass().getName()));
            }
            boolean b = (Boolean)result;
            planInfo.evalAsFilter = !b;
            return planInfo;
        }
        PlanInfo planInfo = this.protGetPlanInfo(context);
        return planInfo;
    }

    @Override
    public Set computeDependencies(ExecutionContext context) throws TypeMismatchException, AmbiguousNameException, NameResolutionException {
        return Collections.EMPTY_SET;
    }

    @Override
    public boolean isDependentOnIterator(RuntimeIterator itr, ExecutionContext context) {
        return context.isDependentOn(this, itr);
    }

    @Override
    public boolean isDependentOnCurrentScope(ExecutionContext context) {
        return context.isDependentOnCurrentScope(this);
    }

    protected PlanInfo protGetPlanInfo(ExecutionContext context) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
        return new PlanInfo();
    }

    protected int reflectOperator(int op) {
        switch (op) {
            case 13: {
                return 13;
            }
            case 20: {
                return 20;
            }
            case 22: {
                return 23;
            }
            case 19: {
                return 18;
            }
            case 18: {
                return 19;
            }
            case 23: {
                return 22;
            }
        }
        Support.assertionFailed("unknown operator: " + op);
        throw new Error("this line of code can never be executed");
    }

    protected int inverseOperator(int op) {
        switch (op) {
            case 84: {
                return 82;
            }
            case 82: {
                return 84;
            }
            case 13: {
                return 20;
            }
            case 20: {
                return 13;
            }
            case 22: {
                return 19;
            }
            case 19: {
                return 22;
            }
            case 18: {
                return 23;
            }
            case 23: {
                return 18;
            }
        }
        Support.assertionFailed("unknown operator: " + op);
        throw new Error("this line of code can never be executed");
    }

    @Override
    public SelectResults auxFilterEvaluate(ExecutionContext context, SelectResults intermediateResults) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
        return this.filterEvaluate(context, intermediateResults);
    }

    @Override
    public SelectResults filterEvaluate(ExecutionContext context, SelectResults intermediateResults) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
        Support.Assert(!this.isDependentOnCurrentScope(context));
        Object result = this.evaluate(context);
        if (result == null || result == QueryService.UNDEFINED) {
            return new ResultsBag(intermediateResults.getCollectionType().getElementType(), 0, context.getCachePerfStats());
        }
        if (!(result instanceof Boolean)) {
            throw new TypeMismatchException(LocalizedStrings.AbstractCompiledValue_BOOLEAN_VALUE_EXPECTED_NOT_TYPE_0.toLocalizedString(result.getClass().getName()));
        }
        boolean b = (Boolean)result;
        if (b) {
            return null;
        }
        ResultsBag emptySet = null;
        List iterators = context.getCurrentIterators();
        int len = iterators.size();
        if (len == 1) {
            emptySet = new ResultsBag(((RuntimeIterator)iterators.get(0)).getElementType(), 0, context.getCachePerfStats());
        } else {
            String[] fieldNames = new String[len];
            ObjectType[] fieldTypes = new ObjectType[len];
            for (int i = 0; i < len; ++i) {
                RuntimeIterator iter = (RuntimeIterator)iterators.get(i);
                fieldNames[i] = iter.getInternalId();
                fieldTypes[i] = iter.getElementType();
            }
            emptySet = new StructBag(0, (StructType)new StructTypeImpl(fieldNames, fieldTypes), context.getCachePerfStats());
        }
        return emptySet;
    }

    @Override
    public void generateCanonicalizedExpression(StringBuffer clauseBuffer, ExecutionContext context) throws AmbiguousNameException, TypeMismatchException, NameResolutionException {
        clauseBuffer.insert(0, System.currentTimeMillis());
        clauseBuffer.insert(0, this.getClass());
        clauseBuffer.insert(0, '.');
    }

    @Override
    public void getRegionsInQuery(Set regionsInQuery, Object[] parameters) {
        for (CompiledValue v : this.getChildren()) {
            if (v == null) {
                throw new NullPointerException(LocalizedStrings.AbstractCompiledValue_GOT_NULL_AS_A_CHILD_FROM_0.toLocalizedString(this));
            }
            v.getRegionsInQuery(regionsInQuery, parameters);
        }
    }

    @Override
    public List getChildren() {
        return Collections.EMPTY_LIST;
    }

    @Override
    public int getSizeEstimate(ExecutionContext context) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
        throw new UnsupportedOperationException("This method should not have been invoked");
    }

    @Override
    public void visitNodes(CompiledValue.NodeVisitor visitor) {
        visitor.visit(this);
        Iterator itr = this.getChildren().iterator();
        while (itr.hasNext() && visitor.visit((CompiledValue)itr.next())) {
        }
    }

    @Override
    public boolean isProjectionEvaluationAPossibility(ExecutionContext context) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
        throw new UnsupportedOperationException("This method should not have been invoked");
    }

    @Override
    public boolean isLimitApplicableAtIndexLevel(ExecutionContext context) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
        throw new UnsupportedOperationException("This method should not have been invoked");
    }

    @Override
    public boolean isOrderByApplicableAtIndexLevel(ExecutionContext context, String canonicalizedOrderByClause) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
        throw new UnsupportedOperationException("This method should not have been invoked");
    }

    @Override
    public boolean isConditioningNeededForIndex(RuntimeIterator independentIter, ExecutionContext context, boolean completeExpnsNeeded) throws AmbiguousNameException, TypeMismatchException, NameResolutionException {
        throw new UnsupportedOperationException("This method should not have been invoked");
    }

    @Override
    public int getOperator() {
        throw new UnsupportedOperationException("This method should not have been invoked");
    }

    @Override
    public boolean isBetterFilter(Filter comparedTo, ExecutionContext context, int thisSize) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
        throw new UnsupportedOperationException("This method should not have been invoked");
    }

    @Override
    public CompiledValue getReceiver() {
        throw new UnsupportedOperationException("This method should not have been invoked");
    }
}

