/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.query;

import com.gemstone.gemfire.SystemFailure;
import com.gemstone.gemfire.cache.query.CqAttributes;
import com.gemstone.gemfire.cache.query.CqAttributesMutator;
import com.gemstone.gemfire.cache.query.CqListener;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.internal.logging.log4j.LocalizedMessage;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.logging.log4j.Logger;

public class CqAttributesFactory {
    private static final Logger logger = LogService.getLogger();
    private final CqAttributesImpl cqAttributes;

    public CqAttributesFactory() {
        this.cqAttributes = new CqAttributesImpl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CqAttributesFactory(CqAttributes cqAttributes) {
        CqAttributesImpl cqAttributesImpl = this.cqAttributes = new CqAttributesImpl();
        synchronized (cqAttributesImpl) {
            this.cqAttributes.cqListeners = new ArrayList<CqListener>(Arrays.asList(cqAttributes.getCqListeners()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCqListener(CqListener cqListener) {
        if (cqListener == null) {
            throw new IllegalArgumentException(LocalizedStrings.CqAttributesFactory_ADDCQLISTENER_PARAMETER_WAS_NULL.toLocalizedString());
        }
        CqAttributesImpl cqAttributesImpl = this.cqAttributes;
        synchronized (cqAttributesImpl) {
            this.cqAttributes.addCqListener(cqListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initCqListeners(CqListener[] cqListeners) {
        CqAttributesImpl cqAttributesImpl = this.cqAttributes;
        synchronized (cqAttributesImpl) {
            if (cqListeners == null || cqListeners.length == 0) {
                this.cqAttributes.cqListeners = null;
            } else {
                List<CqListener> nl = Arrays.asList(cqListeners);
                if (nl.contains(null)) {
                    throw new IllegalArgumentException(LocalizedStrings.CqAttributesFactory_INITCQLISTENERS_PARAMETER_HAD_A_NULL_ELEMENT.toLocalizedString());
                }
                this.cqAttributes.cqListeners = new ArrayList<CqListener>(nl);
            }
        }
    }

    public CqAttributes create() {
        return (CqAttributes)this.cqAttributes.clone();
    }

    protected static class CqAttributesImpl
    implements CqAttributes,
    CqAttributesMutator,
    Cloneable,
    Serializable {
        private static final long serialVersionUID = -959395592883099100L;
        ArrayList cqListeners = null;
        boolean dataPolicyHasBeenSet = false;
        private static final CqListener[] EMPTY_LISTENERS = new CqListener[0];
        private final Object clSync = new Object();

        protected CqAttributesImpl() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public CqListener[] getCqListeners() {
            if (this.cqListeners == null) {
                return EMPTY_LISTENERS;
            }
            CqListener[] result = null;
            Object object = this.clSync;
            synchronized (object) {
                result = new CqListener[this.cqListeners.size()];
                this.cqListeners.toArray(result);
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public CqListener getCqListener() {
            ArrayList listeners = this.cqListeners;
            if (listeners == null) {
                return null;
            }
            Object object = this.clSync;
            synchronized (object) {
                if (listeners.size() == 0) {
                    return null;
                }
                if (listeners.size() == 1) {
                    return (CqListener)this.cqListeners.get(0);
                }
            }
            throw new IllegalStateException(LocalizedStrings.CqAttributesFactory_MORE_THAN_ONE_CQLISTENER_EXISTS.toLocalizedString());
        }

        public Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new InternalError(LocalizedStrings.CqAttributesFactory_CLONENOTSUPPORTEDEXCEPTION_THROWN_IN_CLASS_THAT_IMPLEMENTS_CLONEABLE.toLocalizedString());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addCqListener(CqListener cql) {
            if (cql == null) {
                throw new IllegalArgumentException(LocalizedStrings.CqAttributesFactory_ADDCQLISTENER_PARAMETER_WAS_NULL.toLocalizedString());
            }
            Object object = this.clSync;
            synchronized (object) {
                ArrayList oldListeners = this.cqListeners;
                if (oldListeners == null || oldListeners.size() == 0) {
                    ArrayList<CqListener> al = new ArrayList<CqListener>(1);
                    al.add(cql);
                    this.cqListeners = al;
                } else if (!oldListeners.contains(cql)) {
                    oldListeners.add(cql);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void initCqListeners(CqListener[] addedListeners) {
            ArrayList oldListeners = null;
            Object object = this.clSync;
            synchronized (object) {
                oldListeners = this.cqListeners;
                if (addedListeners == null || addedListeners.length == 0) {
                    this.cqListeners = null;
                } else {
                    List<CqListener> nl = Arrays.asList(addedListeners);
                    if (nl.contains(null)) {
                        throw new IllegalArgumentException(LocalizedStrings.CqAttributesFactory_INITCQLISTENERS_PARAMETER_HAD_A_NULL_ELEMENT.toLocalizedString());
                    }
                    this.cqListeners = new ArrayList<CqListener>(nl);
                }
            }
            if (oldListeners != null) {
                CqListener cql = null;
                Iterator iter = oldListeners.iterator();
                while (iter.hasNext()) {
                    try {
                        cql = (CqListener)iter.next();
                        cql.close();
                    }
                    catch (Exception ex) {
                        logger.warn(LocalizedMessage.create(LocalizedStrings.CqAttributesFactory_EXCEPTION_OCCURED_WHILE_CLOSING_CQ_LISTENER_ERROR_0, ex.getLocalizedMessage()));
                        if (!logger.isDebugEnabled()) continue;
                        logger.debug(ex.getMessage(), (Throwable)ex);
                    }
                    catch (VirtualMachineError err) {
                        SystemFailure.initiateFailure(err);
                        throw err;
                    }
                    catch (Throwable t) {
                        SystemFailure.checkFailure();
                        logger.warn(LocalizedMessage.create(LocalizedStrings.CqAttributesFactory_RUNTIME_EXCEPTION_OCCURED_WHILE_CLOSING_CQ_LISTENER_ERROR_0, t.getLocalizedMessage()));
                        if (!logger.isDebugEnabled()) continue;
                        logger.debug(t.getMessage(), t);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeCqListener(CqListener cql) {
            if (cql == null) {
                throw new IllegalArgumentException(LocalizedStrings.CqAttributesFactory_REMOVECQLISTENER_PARAMETER_WAS_NULL.toLocalizedString());
            }
            Object object = this.clSync;
            synchronized (object) {
                block11: {
                    ArrayList oldListeners = this.cqListeners;
                    if (oldListeners != null && oldListeners.remove(cql)) {
                        if (oldListeners.isEmpty()) {
                            this.cqListeners = null;
                        }
                        try {
                            cql.close();
                        }
                        catch (Exception ex) {
                            logger.warn(LocalizedMessage.create(LocalizedStrings.CqAttributesFactory_EXCEPTION_CLOSING_CQ_LISTENER_ERROR_0, ex.getLocalizedMessage()));
                            if (logger.isDebugEnabled()) {
                                logger.debug(ex.getMessage(), (Throwable)ex);
                            }
                        }
                        catch (VirtualMachineError err) {
                            SystemFailure.initiateFailure(err);
                            throw err;
                        }
                        catch (Throwable t) {
                            SystemFailure.checkFailure();
                            logger.warn(LocalizedMessage.create(LocalizedStrings.CqAttributesFactory_RUNTIME_EXCEPTION_OCCURED_CLOSING_CQ_LISTENER_ERROR_0, t.getLocalizedMessage()));
                            if (!logger.isDebugEnabled()) break block11;
                            logger.debug(t.getMessage(), t);
                        }
                    }
                }
            }
        }
    }
}

