/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.partition;

import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.cache.FixedPartitionAttributesImpl;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegionDataStore;
import com.gemstone.gemfire.internal.cache.partitioned.RemoveBucketMessage;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.LogService;
import java.util.List;
import java.util.Set;
import org.apache.logging.log4j.Logger;

public final class PartitionManager {
    private static final Logger logger = LogService.getLogger();

    private PartitionManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean createPrimaryBucket(Region<?, ?> region, int bucketId, boolean destroyExistingRemote, boolean destroyExistingLocal) {
        boolean createdBucket;
        block14: {
            PartitionedRegion pr2 = PartitionManager.prCheck(region, bucketId);
            createdBucket = false;
            PartitionedRegion.RecoveryLock recovLock = pr2.getRecoveryLock();
            recovLock.lock();
            try {
                DistributedMember primary = PartitionManager.getPrimaryMemberForBucket(pr2, bucketId);
                InternalDistributedMember self = pr2.getCache().getDistributedSystem().getDistributedMember();
                if (primary == null) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("createPrimaryBucket: {} bucket {} no existing primary, creating primary", pr2, bucketId);
                    }
                    createdBucket = PartitionManager.createBucket(self, pr2, bucketId, destroyExistingRemote);
                    break block14;
                }
                if (self.equals(primary)) {
                    if (destroyExistingLocal) {
                        if (logger.isDebugEnabled()) {
                            logger.debug("createPrimaryBucket: {} bucket {} already primary, destroying local primary", pr2, bucketId);
                        }
                        if (PartitionManager.dumpBucket(self, region, bucketId)) {
                            createdBucket = PartitionManager.createBucket(self, region, bucketId, destroyExistingRemote);
                        }
                    } else if (logger.isDebugEnabled()) {
                        logger.debug("createPrimaryBucket: {} bucket {} already primary, no action needed", pr2, bucketId);
                    }
                    break block14;
                }
                if (destroyExistingRemote) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("createPrimaryBucket: {} bucket {},{} is primary, destroying it", pr2, bucketId, primary);
                    }
                    if (PartitionManager.dumpBucket(primary, region, bucketId)) {
                        createdBucket = PartitionManager.createBucket(self, region, bucketId, destroyExistingRemote);
                    }
                    break block14;
                }
                Object[] params = new Object[]{self, primary};
                throw new IllegalStateException(LocalizedStrings.PartitionManager_BUCKET_CANNOT_BE_MOVED_AS_DESTROYEXISTING_IS_FALSE.toLocalizedString(params));
            }
            finally {
                recovLock.unlock();
            }
        }
        return createdBucket;
    }

    private static DistributedMember getPrimaryMemberForBucket(Region<?, ?> region, int bucketId) {
        PartitionedRegion pr2 = PartitionManager.prCheck(region, bucketId);
        if (pr2.getRegionAdvisor().isStorageAssignedForBucket(bucketId)) {
            return pr2.getBucketPrimary(bucketId);
        }
        return null;
    }

    private static boolean createBucket(DistributedMember target, Region<?, ?> region, int bucketId, boolean destroyExistingRemote) {
        InternalDistributedMember createTarget;
        PartitionedRegion pr2 = PartitionManager.prCheck(region, bucketId);
        InternalDistributedMember moveSource = createTarget = PartitionManager.dataStoreCheck(target, pr2);
        boolean createdBucket = pr2.getRedundancyProvider().createBackupBucketOnMember(bucketId, createTarget, false, false, moveSource, true);
        Set<InternalDistributedMember> currentBucketOwners = pr2.getRegionAdvisor().getBucketOwners(bucketId);
        boolean includesTarget = currentBucketOwners.remove(target);
        if (currentBucketOwners.size() > pr2.getRedundantCopies() && includesTarget) {
            InternalDistributedMember remoteBucket = currentBucketOwners.iterator().next();
            if (destroyExistingRemote) {
                if (logger.isDebugEnabled()) {
                    logger.debug("createPrimaryBucket: {}, bucket {} Redundancy is exceeded due to concurrent bucket create, destroying remote bucket: {}", pr2, bucketId, remoteBucket);
                }
                PartitionManager.dumpBucket(remoteBucket, region, bucketId);
            } else {
                if (logger.isDebugEnabled()) {
                    logger.debug("createPrimaryBucket: {}, bucket {} Redundancy is exceeded due to concurrent bucket create, destroying my bucket", pr2, bucketId);
                }
                PartitionManager.dumpBucket(target, region, bucketId);
                Object[] params = new Object[]{target, remoteBucket};
                throw new IllegalStateException(LocalizedStrings.PartitionManager_BUCKET_CANNOT_BE_MOVED_AS_DESTROYEXISTING_IS_FALSE.toLocalizedString(params));
            }
        }
        return createdBucket;
    }

    private static boolean dumpBucket(DistributedMember source, Region<?, ?> region, int bucketId) {
        PartitionedRegion pr2 = PartitionManager.prCheck(region, bucketId);
        InternalDistributedMember bucketSource = PartitionManager.dataStoreCheck(source, pr2);
        Set<InternalDistributedMember> currentBucketOwners = pr2.getRegionAdvisor().getBucketOwners(bucketId);
        if (!currentBucketOwners.contains(bucketSource)) {
            Object[] params = new Object[]{bucketSource, bucketId};
            throw new IllegalArgumentException(LocalizedStrings.PartitionManager_SOURCE_MEMBER_0_BUCKETID_1_DOES_NOT_HAVE_THE_BUCKET.toLocalizedString(params));
        }
        InternalDistributedMember self = pr2.getCache().getDistributedSystem().getDistributedMember();
        if (bucketSource.equals(self)) {
            PartitionedRegionDataStore dataStore = pr2.getDataStore();
            return dataStore.removeBucket(bucketId, true);
        }
        RemoveBucketMessage.RemoveBucketResponse response = RemoveBucketMessage.send(bucketSource, pr2, bucketId, true);
        if (response != null) {
            return response.waitForResponse();
        }
        return false;
    }

    private static PartitionedRegion prCheck(Region<?, ?> region, int bucketId) {
        if (region == null) {
            throw new IllegalArgumentException(LocalizedStrings.PartitionRegionHelper_ARGUMENT_REGION_IS_NULL.toString());
        }
        if (!(region instanceof PartitionedRegion)) {
            throw new IllegalArgumentException(LocalizedStrings.PartitionManager_REGION_0_IS_NOT_A_PARTITIONED_REGION.toLocalizedString(region.getFullPath()));
        }
        PartitionedRegion pr2 = (PartitionedRegion)region;
        if (bucketId < 0 || bucketId >= pr2.getTotalNumberOfBuckets()) {
            throw new IllegalArgumentException(LocalizedStrings.PartitionManager_BUCKETID_ARG0_RANGE_0_TO_ARG1_PR_ARG2.toLocalizedString(bucketId, pr2.getTotalNumberOfBuckets() - 1, pr2.getFullPath()));
        }
        if (pr2.isFixedPartitionedRegion()) {
            boolean containsBucket = false;
            List<FixedPartitionAttributesImpl> fpas = pr2.getFixedPartitionAttributesImpl();
            for (FixedPartitionAttributesImpl fpa : fpas) {
                if (!fpa.isPrimary() || !fpa.hasBucket(bucketId)) continue;
                containsBucket = true;
                break;
            }
            if (!containsBucket) {
                throw new IllegalArgumentException(LocalizedStrings.FixedPartitionManager_BUCKETID_ARG_PR_ARG2.toLocalizedString(bucketId, pr2.getFullPath()));
            }
        }
        return pr2;
    }

    private static InternalDistributedMember dataStoreCheck(DistributedMember target, PartitionedRegion pr2) {
        boolean localIsDatastore;
        InternalDistributedMember idmTarget = (InternalDistributedMember)target;
        boolean bl = localIsDatastore = pr2.isDataStore() && pr2.getCache().getDistributedSystem().getDistributedMember().equals(target);
        if (!localIsDatastore && !pr2.getRegionAdvisor().adviseDataStore().contains(idmTarget)) {
            throw new IllegalArgumentException(LocalizedStrings.PartitionManager_PROVIDED_MEMBER_0_NO_PR_OR_NO_DATASTORE.toLocalizedString(target));
        }
        return idmTarget;
    }
}

