/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.operations;

import java.util.HashMap;
import java.util.Map;

public abstract class OperationContext {
    public abstract OperationCode getOperationCode();

    public abstract boolean isPostOperation();

    public boolean isClientUpdate() {
        if (this.isPostOperation()) {
            switch (this.getOperationCode().opCode) {
                case 2: 
                case 3: 
                case 4: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 19: {
                    return true;
                }
            }
        }
        return false;
    }

    @Deprecated
    public boolean isClientUpdate(OperationContext context) {
        OperationCode opCode = context.getOperationCode();
        return context.isPostOperation() && (opCode.isPut() || opCode.isPutAll() || opCode.isDestroy() || opCode.isRemoveAll() || opCode.isInvalidate() || opCode.isRegionCreate() || opCode.isRegionDestroy() || opCode.isRegionClear());
    }

    public static final class OperationCode {
        private static final byte OP_GET = 1;
        private static final byte OP_PUT = 2;
        private static final byte OP_DESTROY = 3;
        private static final byte OP_INVALIDATE = 4;
        private static final byte OP_REGISTER_INTEREST = 5;
        private static final byte OP_UNREGISTER_INTEREST = 6;
        private static final byte OP_CONTAINS_KEY = 7;
        private static final byte OP_KEY_SET = 8;
        private static final byte OP_QUERY = 9;
        private static final byte OP_EXECUTE_CQ = 10;
        private static final byte OP_STOP_CQ = 11;
        private static final byte OP_CLOSE_CQ = 12;
        private static final byte OP_REGION_CLEAR = 13;
        private static final byte OP_REGION_CREATE = 14;
        private static final byte OP_REGION_DESTROY = 15;
        private static final byte OP_PUTALL = 16;
        private static final byte OP_EXECUTE_FUNCTION = 17;
        private static final byte OP_GET_DURABLE_CQS = 18;
        private static final byte OP_REMOVEALL = 19;
        private static final OperationCode[] VALUES = new OperationCode[21];
        private static final Map OperationNameMap = new HashMap();
        public static final OperationCode GET = new OperationCode("GET", 1);
        public static final OperationCode PUT = new OperationCode("PUT", 2);
        public static final OperationCode PUTALL = new OperationCode("PUTALL", 16);
        public static final OperationCode REMOVEALL = new OperationCode("REMOVEALL", 19);
        public static final OperationCode DESTROY = new OperationCode("DESTROY", 3);
        public static final OperationCode INVALIDATE = new OperationCode("INVALIDATE", 4);
        public static final OperationCode REGISTER_INTEREST = new OperationCode("REGISTER_INTEREST", 5);
        public static final OperationCode UNREGISTER_INTEREST = new OperationCode("UNREGISTER_INTEREST", 6);
        public static final OperationCode CONTAINS_KEY = new OperationCode("CONTAINS_KEY", 7);
        public static final OperationCode KEY_SET = new OperationCode("KEY_SET", 8);
        public static final OperationCode QUERY = new OperationCode("QUERY", 9);
        public static final OperationCode EXECUTE_CQ = new OperationCode("EXECUTE_CQ", 10);
        public static final OperationCode STOP_CQ = new OperationCode("STOP_CQ", 11);
        public static final OperationCode CLOSE_CQ = new OperationCode("CLOSE_CQ", 12);
        public static final OperationCode REGION_CLEAR = new OperationCode("REGION_CLEAR", 13);
        public static final OperationCode REGION_CREATE = new OperationCode("REGION_CREATE", 14);
        public static final OperationCode REGION_DESTROY = new OperationCode("REGION_DESTROY", 15);
        public static final OperationCode EXECUTE_FUNCTION = new OperationCode("EXECUTE_FUNCTION", 17);
        public static final OperationCode GET_DURABLE_CQS = new OperationCode("GET_DURABLE_CQS", 18);
        private final String name;
        private final byte opCode;

        private OperationCode(String name, byte opCode) {
            this.name = name;
            this.opCode = opCode;
            OperationCode.VALUES[opCode] = this;
            OperationNameMap.put(name, this);
        }

        public boolean isGet() {
            return this.opCode == 1;
        }

        public boolean isPut() {
            return this.opCode == 2;
        }

        public boolean isPutAll() {
            return this.opCode == 16;
        }

        public boolean isRemoveAll() {
            return this.opCode == 19;
        }

        public boolean isDestroy() {
            return this.opCode == 3;
        }

        public boolean isInvalidate() {
            return this.opCode == 4;
        }

        public boolean isRegisterInterest() {
            return this.opCode == 5;
        }

        public boolean isUnregisterInterest() {
            return this.opCode == 6;
        }

        public boolean isContainsKey() {
            return this.opCode == 7;
        }

        public boolean isKeySet() {
            return this.opCode == 8;
        }

        public boolean isQuery() {
            return this.opCode == 9;
        }

        public boolean isExecuteCQ() {
            return this.opCode == 10;
        }

        public boolean isStopCQ() {
            return this.opCode == 11;
        }

        public boolean isCloseCQ() {
            return this.opCode == 12;
        }

        public boolean isRegionClear() {
            return this.opCode == 13;
        }

        public boolean isRegionCreate() {
            return this.opCode == 14;
        }

        public boolean isRegionDestroy() {
            return this.opCode == 15;
        }

        public boolean isExecuteRegionFunction() {
            return this.opCode == 17;
        }

        public boolean isGetDurableCQs() {
            return this.opCode == 18;
        }

        public static OperationCode fromOrdinal(byte opCode) {
            return VALUES[opCode];
        }

        public static OperationCode parse(String operationName) {
            return (OperationCode)OperationNameMap.get(operationName);
        }

        public byte toOrdinal() {
            return this.opCode;
        }

        public final String toString() {
            return this.name;
        }

        public final boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof OperationCode)) {
                return false;
            }
            OperationCode other = (OperationCode)obj;
            return other.opCode == this.opCode;
        }

        public final boolean equals(OperationCode opCode) {
            return opCode != null && opCode.opCode == this.opCode;
        }

        public final int hashCode() {
            return this.opCode;
        }
    }
}

