/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.execute.internal;

import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionService;
import com.gemstone.gemfire.cache.client.Pool;
import com.gemstone.gemfire.cache.client.PoolManager;
import com.gemstone.gemfire.cache.client.internal.ProxyCache;
import com.gemstone.gemfire.cache.client.internal.ProxyRegion;
import com.gemstone.gemfire.cache.execute.Execution;
import com.gemstone.gemfire.cache.execute.Function;
import com.gemstone.gemfire.cache.execute.FunctionException;
import com.gemstone.gemfire.cache.partition.PartitionRegionHelper;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.internal.InternalEntity;
import com.gemstone.gemfire.internal.cache.AbstractRegion;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.execute.DistributedRegionFunctionExecutor;
import com.gemstone.gemfire.internal.cache.execute.MemberFunctionExecutor;
import com.gemstone.gemfire.internal.cache.execute.PartitionedRegionFunctionExecutor;
import com.gemstone.gemfire.internal.cache.execute.ServerFunctionExecutor;
import com.gemstone.gemfire.internal.cache.execute.ServerRegionFunctionExecutor;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public final class FunctionServiceManager {
    private static final ConcurrentHashMap<String, Function> idToFunctionMap = new ConcurrentHashMap();
    public static final boolean RANDOM_onMember = Boolean.getBoolean("gemfire.randomizeOnMember");

    public final Execution onRegion(Region region) {
        Pool pool;
        if (region == null) {
            throw new FunctionException(LocalizedStrings.FunctionService_0_PASSED_IS_NULL.toLocalizedString("Region instance "));
        }
        ProxyCache proxyCache = null;
        String poolName = region.getAttributes().getPoolName();
        if (poolName != null && (pool = PoolManager.find(poolName)).getMultiuserAuthentication()) {
            if (region instanceof ProxyRegion) {
                ProxyRegion pr2 = (ProxyRegion)region;
                region = pr2.getRealRegion();
                proxyCache = pr2.getAuthenticatedCache();
            } else {
                throw new UnsupportedOperationException();
            }
        }
        if (this.isClientRegion(region)) {
            return new ServerRegionFunctionExecutor(region, proxyCache);
        }
        if (PartitionRegionHelper.isPartitionedRegion(region)) {
            return new PartitionedRegionFunctionExecutor(region);
        }
        return new DistributedRegionFunctionExecutor(region);
    }

    public final Execution onServer(Pool pool, String ... groups) {
        if (pool == null) {
            throw new FunctionException(LocalizedStrings.FunctionService_0_PASSED_IS_NULL.toLocalizedString("Pool instance "));
        }
        if (pool.getMultiuserAuthentication()) {
            throw new UnsupportedOperationException();
        }
        return new ServerFunctionExecutor(pool, false, groups);
    }

    public final Execution onServers(Pool pool, String ... groups) {
        if (pool == null) {
            throw new FunctionException(LocalizedStrings.FunctionService_0_PASSED_IS_NULL.toLocalizedString("Pool instance "));
        }
        if (pool.getMultiuserAuthentication()) {
            throw new UnsupportedOperationException();
        }
        return new ServerFunctionExecutor(pool, true, groups);
    }

    public final Execution onServer(RegionService regionService, String ... groups) {
        if (regionService == null) {
            throw new FunctionException(LocalizedStrings.FunctionService_0_PASSED_IS_NULL.toLocalizedString("RegionService instance "));
        }
        if (regionService instanceof GemFireCacheImpl) {
            GemFireCacheImpl gfc = (GemFireCacheImpl)regionService;
            if (!gfc.isClient()) {
                throw new FunctionException("The cache was not a client cache");
            }
            if (gfc.getDefaultPool() != null) {
                return this.onServer(gfc.getDefaultPool(), groups);
            }
            throw new FunctionException("The client cache does not have a default pool");
        }
        ProxyCache pc = (ProxyCache)regionService;
        return new ServerFunctionExecutor(pc.getUserAttributes().getPool(), false, pc, groups);
    }

    public final Execution onServers(RegionService regionService, String ... groups) {
        if (regionService == null) {
            throw new FunctionException(LocalizedStrings.FunctionService_0_PASSED_IS_NULL.toLocalizedString("RegionService instance "));
        }
        if (regionService instanceof GemFireCacheImpl) {
            GemFireCacheImpl gfc = (GemFireCacheImpl)regionService;
            if (!gfc.isClient()) {
                throw new FunctionException("The cache was not a client cache");
            }
            if (gfc.getDefaultPool() != null) {
                return this.onServers(gfc.getDefaultPool(), groups);
            }
            throw new FunctionException("The client cache does not have a default pool");
        }
        ProxyCache pc = (ProxyCache)regionService;
        return new ServerFunctionExecutor(pc.getUserAttributes().getPool(), true, pc, groups);
    }

    public final Execution onMember(DistributedSystem system, DistributedMember distributedMember) {
        if (system == null) {
            throw new FunctionException(LocalizedStrings.FunctionService_0_PASSED_IS_NULL.toLocalizedString("DistributedSystem instance "));
        }
        if (distributedMember == null) {
            throw new FunctionException(LocalizedStrings.FunctionService_0_PASSED_IS_NULL.toLocalizedString("DistributedMember instance "));
        }
        return new MemberFunctionExecutor(system, distributedMember);
    }

    public final Execution onMembers(DistributedSystem system, String ... groups) {
        if (system == null) {
            throw new FunctionException(LocalizedStrings.FunctionService_0_PASSED_IS_NULL.toLocalizedString("DistributedSystem instance "));
        }
        if (groups.length == 0) {
            return new MemberFunctionExecutor(system);
        }
        HashSet<DistributedMember> members = new HashSet<DistributedMember>();
        for (String group : groups) {
            members.addAll(system.getGroupMembers(group));
        }
        if (members.isEmpty()) {
            throw new FunctionException(LocalizedStrings.FunctionService_NO_MEMBERS_FOUND_IN_GROUPS.toLocalizedString(Arrays.toString(groups)));
        }
        return new MemberFunctionExecutor(system, members);
    }

    public final Execution onMembers(DistributedSystem system, Set<DistributedMember> distributedMembers) {
        if (system == null) {
            throw new FunctionException(LocalizedStrings.FunctionService_0_PASSED_IS_NULL.toLocalizedString("DistributedSystem instance "));
        }
        if (distributedMembers == null) {
            throw new FunctionException(LocalizedStrings.FunctionService_0_PASSED_IS_NULL.toLocalizedString("distributedMembers set "));
        }
        return new MemberFunctionExecutor(system, distributedMembers);
    }

    public final Function getFunction(String functionId) {
        if (functionId == null) {
            throw new FunctionException(LocalizedStrings.FunctionService_0_PASSED_IS_NULL.toLocalizedString("functionId instance "));
        }
        return idToFunctionMap.get(functionId);
    }

    public final void registerFunction(Function function) {
        if (function == null) {
            throw new FunctionException(LocalizedStrings.FunctionService_0_PASSED_IS_NULL.toLocalizedString("function instance "));
        }
        if (function.getId() == null) {
            throw new FunctionException(LocalizedStrings.FunctionService_FUNCTION_GET_ID_RETURNED_NULL.toLocalizedString());
        }
        if (function.isHA() && !function.hasResult()) {
            throw new FunctionException(LocalizedStrings.FunctionService_FUNCTION_ATTRIBUTE_MISMATCH.toLocalizedString());
        }
        idToFunctionMap.put(function.getId(), function);
    }

    public final void unregisterFunction(String functionId) {
        if (functionId == null) {
            throw new FunctionException(LocalizedStrings.FunctionService_0_PASSED_IS_NULL.toLocalizedString("functionId instance "));
        }
        idToFunctionMap.remove(functionId);
    }

    public final boolean isRegistered(String functionId) {
        if (functionId == null) {
            throw new FunctionException(LocalizedStrings.FunctionService_0_PASSED_IS_NULL.toLocalizedString("functionId instance "));
        }
        return idToFunctionMap.containsKey(functionId);
    }

    public final Map<String, Function> getRegisteredFunctions() {
        HashMap<String, Function> tempIdToFunctionMap = new HashMap<String, Function>();
        for (Map.Entry<String, Function> entry : idToFunctionMap.entrySet()) {
            if (entry.getValue() instanceof InternalEntity) continue;
            tempIdToFunctionMap.put(entry.getKey(), entry.getValue());
        }
        return tempIdToFunctionMap;
    }

    public final void unregisterAllFunctions() {
        HashMap<String, Function> functions = new HashMap<String, Function>(idToFunctionMap);
        for (String functionId : idToFunctionMap.keySet()) {
            this.unregisterFunction(functionId);
        }
    }

    private final boolean isClientRegion(Region region) {
        LocalRegion localRegion = (LocalRegion)region;
        return localRegion.hasServerProxy() || AbstractRegion.isBridgeLoader(localRegion.getCacheLoader()) || AbstractRegion.isBridgeWriter(localRegion.getCacheWriter());
    }

    public final Execution onMember(DistributedSystem system, String ... groups) {
        if (system == null) {
            throw new FunctionException(LocalizedStrings.FunctionService_0_PASSED_IS_NULL.toLocalizedString("DistributedSystem instance "));
        }
        HashSet<DistributedMember> members = new HashSet<DistributedMember>();
        for (String group : groups) {
            ArrayList<DistributedMember> grpMembers = new ArrayList<DistributedMember>(system.getGroupMembers(group));
            if (grpMembers.isEmpty()) continue;
            if (!RANDOM_onMember && grpMembers.contains(system.getDistributedMember())) {
                members.add(system.getDistributedMember());
                continue;
            }
            Collections.shuffle(grpMembers);
            members.add((DistributedMember)grpMembers.get(0));
        }
        if (members.isEmpty()) {
            throw new FunctionException(LocalizedStrings.FunctionService_NO_MEMBERS_FOUND_IN_GROUPS.toLocalizedString(Arrays.toString(groups)));
        }
        return new MemberFunctionExecutor(system, members);
    }
}

