/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.client.internal.locator.wan;

import com.gemstone.gemfire.cache.client.internal.locator.wan.LocatorJoinMessage;
import com.gemstone.gemfire.cache.client.internal.locator.wan.LocatorMembershipListener;
import com.gemstone.gemfire.distributed.Locator;
import com.gemstone.gemfire.distributed.internal.DistributionConfig;
import com.gemstone.gemfire.distributed.internal.InternalLocator;
import com.gemstone.gemfire.internal.CopyOnWriteHashSet;
import com.gemstone.gemfire.internal.admin.remote.DistributionLocatorId;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.internal.logging.log4j.LocalizedMessage;
import com.gemstone.org.jgroups.stack.tcpserver.TcpClient;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.apache.logging.log4j.Logger;

public class LocatorMembershipListenerImpl
implements LocatorMembershipListener {
    private static final Logger logger = LogService.getLogger();
    private final DistributionConfig config;
    private final int port;
    private InternalLocator internalLocator;
    public final Object locatorLock = new Object();

    public LocatorMembershipListenerImpl(Locator locator) {
        this.internalLocator = (InternalLocator)locator;
        this.port = this.internalLocator.getPort();
        this.config = this.internalLocator.getConfig();
    }

    @Override
    public void locatorJoined(final int distributedSystemId, final DistributionLocatorId locator, final DistributionLocatorId sourceLocator) {
        Thread distributeLocator = new Thread(new Runnable(){

            @Override
            public void run() {
                ConcurrentMap<Integer, Set<DistributionLocatorId>> remoteLocators = LocatorMembershipListenerImpl.this.internalLocator.getAllLocatorsInfo();
                ArrayList<DistributionLocatorId> locatorsToRemove = new ArrayList<DistributionLocatorId>();
                String localLocator = LocatorMembershipListenerImpl.this.config.getStartLocator();
                DistributionLocatorId localLocatorId = null;
                localLocatorId = localLocator.equals("") ? new DistributionLocatorId(LocatorMembershipListenerImpl.this.port, LocatorMembershipListenerImpl.this.config.getBindAddress()) : new DistributionLocatorId(localLocator);
                locatorsToRemove.add(localLocatorId);
                locatorsToRemove.add(locator);
                locatorsToRemove.add(sourceLocator);
                HashMap localCopy = new HashMap();
                for (Map.Entry entry : remoteLocators.entrySet()) {
                    CopyOnWriteHashSet value2 = new CopyOnWriteHashSet((Set)entry.getValue());
                    localCopy.put(entry.getKey(), value2);
                }
                for (Map.Entry entry : localCopy.entrySet()) {
                    for (DistributionLocatorId removeLocId : locatorsToRemove) {
                        if (!((Set)entry.getValue()).contains(removeLocId)) continue;
                        ((Set)entry.getValue()).remove(removeLocId);
                    }
                    for (DistributionLocatorId value3 : (Set)entry.getValue()) {
                        block8: {
                            try {
                                TcpClient.requestToServer(value3.getHost(), value3.getPort(), new LocatorJoinMessage(distributedSystemId, locator, localLocatorId, ""), 1000, false);
                            }
                            catch (Exception e) {
                                if (!logger.isDebugEnabled()) break block8;
                                logger.debug(LocalizedMessage.create(LocalizedStrings.LOCATOR_MEMBERSHIP_LISTENER_COULD_NOT_EXCHANGE_LOCATOR_INFORMATION_0_1_WIHT_2_3, new Object[]{locator.getHost(), locator.getPort(), value3.getHost(), value3.getPort()}));
                            }
                        }
                        try {
                            TcpClient.requestToServer(locator.getHost(), locator.getPort(), new LocatorJoinMessage((Integer)entry.getKey(), value3, localLocatorId, ""), 1000, false);
                        }
                        catch (Exception e) {
                            if (!logger.isDebugEnabled()) continue;
                            logger.debug(LocalizedMessage.create(LocalizedStrings.LOCATOR_MEMBERSHIP_LISTENER_COULD_NOT_EXCHANGE_LOCATOR_INFORMATION_0_1_WIHT_2_3, new Object[]{value3.getHost(), value3.getPort(), locator.getHost(), locator.getPort()}));
                        }
                    }
                }
            }
        });
        distributeLocator.setDaemon(true);
        distributeLocator.start();
    }
}

