/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.client.internal.locator.wan;

import com.gemstone.gemfire.cache.client.internal.locator.wan.LocatorMembershipListener;
import com.gemstone.gemfire.distributed.internal.InternalLocator;
import com.gemstone.gemfire.internal.CopyOnWriteHashSet;
import com.gemstone.gemfire.internal.admin.remote.DistributionLocatorId;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class LocatorHelper {
    public static final Object locatorObject = new Object();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean addLocator(int distributedSystemId, DistributionLocatorId locator, InternalLocator internalLocator, LocatorMembershipListener locatorListener, DistributionLocatorId sourceLocator) {
        ConcurrentHashMap allLocatorsInfo = (ConcurrentHashMap)internalLocator.getAllLocatorsInfo();
        CopyOnWriteHashSet locatorsSet = new CopyOnWriteHashSet();
        locatorsSet.add(locator);
        Set existingValue = allLocatorsInfo.putIfAbsent(distributedSystemId, locatorsSet);
        if (existingValue != null) {
            if (existingValue.contains(locator)) return false;
            existingValue.add(locator);
            LocatorHelper.addServerLocator(distributedSystemId, internalLocator, locator);
            locatorListener.locatorJoined(distributedSystemId, locator, sourceLocator);
            return true;
        } else {
            LocatorHelper.addServerLocator(distributedSystemId, internalLocator, locator);
            locatorListener.locatorJoined(distributedSystemId, locator, sourceLocator);
        }
        return true;
    }

    private static void addServerLocator(Integer distributedSystemId, InternalLocator internalLocator, DistributionLocatorId locator) {
        if (!locator.isServerLocator()) {
            return;
        }
        ConcurrentHashMap allServerLocatorsInfo = (ConcurrentHashMap)internalLocator.getAllServerLocatorsInfo();
        CopyOnWriteHashSet locatorsSet = new CopyOnWriteHashSet();
        locatorsSet.add(locator.toString());
        Set existingValue = allServerLocatorsInfo.putIfAbsent(distributedSystemId, locatorsSet);
        if (existingValue != null && !existingValue.contains(locator.toString())) {
            existingValue.add(locator.toString());
        }
    }

    public static boolean addExchnagedLocators(InternalLocator internalLocator, Map<Integer, Set<DistributionLocatorId>> locators, LocatorMembershipListener locatorListener) {
        ConcurrentHashMap allLocators = (ConcurrentHashMap)internalLocator.getAllLocatorsInfo();
        if (!allLocators.equals(locators)) {
            for (Map.Entry<Integer, Set<DistributionLocatorId>> entry : locators.entrySet()) {
                Set existingValue = allLocators.putIfAbsent(entry.getKey(), new CopyOnWriteHashSet<DistributionLocatorId>(entry.getValue()));
                if (existingValue != null) {
                    Set localLocators = (Set)allLocators.get(entry.getKey());
                    if (localLocators.equals(entry.getValue())) continue;
                    entry.getValue().removeAll(localLocators);
                    for (DistributionLocatorId locator : entry.getValue()) {
                        localLocators.add(locator);
                        LocatorHelper.addServerLocator(entry.getKey(), internalLocator, locator);
                        locatorListener.locatorJoined(entry.getKey(), locator, null);
                    }
                    continue;
                }
                for (DistributionLocatorId locator : entry.getValue()) {
                    LocatorHelper.addServerLocator(entry.getKey(), internalLocator, locator);
                    locatorListener.locatorJoined(entry.getKey(), locator, null);
                }
            }
            return true;
        }
        return false;
    }
}

