/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.client.internal;

import com.gemstone.gemfire.cache.client.internal.AbstractOp;
import com.gemstone.gemfire.cache.client.internal.ConnectionStats;
import com.gemstone.gemfire.cache.client.internal.ExecutablePool;
import com.gemstone.gemfire.internal.cache.tier.sockets.Message;
import java.util.Iterator;
import java.util.List;

public class UnregisterInterestListOp {
    public static void execute(ExecutablePool pool, String region, List keys, boolean isClosing, boolean keepAlive) {
        UnregisterInterestListOpImpl op = new UnregisterInterestListOpImpl(region, keys, isClosing, keepAlive);
        pool.executeOnAllQueueServers(op);
    }

    private UnregisterInterestListOp() {
    }

    private static class UnregisterInterestListOpImpl
    extends AbstractOp {
        public UnregisterInterestListOpImpl(String region, List keys, boolean isClosing, boolean keepAlive) {
            super(25, 4 + keys.size());
            this.getMessage().addStringPart(region);
            byte closingByte = (byte)(isClosing ? 1 : 0);
            this.getMessage().addBytesPart(new byte[]{closingByte});
            byte keepAliveByte = (byte)(keepAlive ? 1 : 0);
            this.getMessage().addBytesPart(new byte[]{keepAliveByte});
            this.getMessage().addIntPart(keys.size());
            Iterator i = keys.iterator();
            while (i.hasNext()) {
                this.getMessage().addStringOrObjPart(i.next());
            }
        }

        @Override
        protected Object processResponse(Message msg) throws Exception {
            this.processAck(msg, "unregisterInterestList");
            return null;
        }

        @Override
        protected boolean isErrorResponse(int msgType) {
            return msgType == 23;
        }

        @Override
        protected long startAttempt(ConnectionStats stats) {
            return stats.startUnregisterInterest();
        }

        @Override
        protected void endSendAttempt(ConnectionStats stats, long start) {
            stats.endUnregisterInterestSend(start, this.hasFailed());
        }

        @Override
        protected void endAttempt(ConnectionStats stats, long start) {
            stats.endUnregisterInterest(start, this.hasTimedOut(), this.hasFailed());
        }
    }
}

