/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.client.internal;

import com.gemstone.gemfire.cache.client.internal.AbstractOp;
import com.gemstone.gemfire.cache.client.internal.Connection;
import com.gemstone.gemfire.cache.client.internal.ConnectionStats;
import com.gemstone.gemfire.cache.client.internal.ExecutablePool;
import com.gemstone.gemfire.internal.cache.tier.sockets.Message;

public class TXFailoverOp {
    public static void execute(ExecutablePool pool, int txId) {
        pool.execute(new TXFailoverOpImpl(txId));
    }

    private TXFailoverOp() {
    }

    private static class TXFailoverOpImpl
    extends AbstractOp {
        int txId;

        protected TXFailoverOpImpl(int txId) {
            super(88, 1);
            this.getMessage().setTransactionId(txId);
            this.txId = txId;
        }

        public String toString() {
            return "TXFailoverOp(txId=" + this.txId + ")";
        }

        @Override
        protected Object processResponse(Message msg) throws Exception {
            this.processAck(msg, "txFailover");
            return null;
        }

        @Override
        protected boolean isErrorResponse(int msgType) {
            return msgType == 2;
        }

        @Override
        protected long startAttempt(ConnectionStats stats) {
            return stats.startTxFailover();
        }

        @Override
        protected void endSendAttempt(ConnectionStats stats, long start) {
            stats.endTxFailoverSend(start, this.hasFailed());
        }

        @Override
        protected void endAttempt(ConnectionStats stats, long start) {
            stats.endTxFailover(start, this.hasTimedOut(), this.hasFailed());
        }

        @Override
        protected void processSecureBytes(Connection cnx, Message message) throws Exception {
        }

        @Override
        protected boolean needsUserId() {
            return false;
        }

        @Override
        protected void sendMessage(Connection cnx) throws Exception {
            this.getMessage().setEarlyAck((byte)(this.getMessage().getEarlyAckByte() & 2));
            this.getMessage().send(false);
        }
    }
}

