/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.client.internal;

import com.gemstone.gemfire.cache.client.internal.Connection;
import com.gemstone.gemfire.cache.client.internal.GatewayBatchOp;
import com.gemstone.gemfire.cache.client.internal.GatewaySenderBatchOp;
import com.gemstone.gemfire.cache.client.internal.InternalPool;
import com.gemstone.gemfire.cache.client.internal.PingOp;
import com.gemstone.gemfire.cache.client.internal.QueryOp;
import com.gemstone.gemfire.cache.query.SelectResults;
import com.gemstone.gemfire.distributed.internal.ServerLocation;
import java.util.List;

public class ServerProxy {
    protected final InternalPool pool;

    public ServerProxy(InternalPool pool) {
        this.pool = pool;
    }

    public InternalPool getPool() {
        return this.pool;
    }

    public void detach() {
        this.pool.detach();
    }

    public void dispatchBatch(Connection con, List events, int batchId, boolean earlyAck) {
        GatewayBatchOp.executeOn(con, this.pool, events, batchId, earlyAck);
    }

    public void dispatchBatch_NewWAN(Connection con, List events, int batchId, boolean removeFromQueueOnException, boolean isRetry) {
        GatewaySenderBatchOp.executeOn(con, this.pool, events, batchId, removeFromQueueOnException, isRetry);
    }

    public Object receiveAckFromReceiver(Connection con) {
        return GatewaySenderBatchOp.executeOn(con, this.pool);
    }

    public void ping(ServerLocation server) {
        PingOp.execute(this.pool, server);
    }

    public SelectResults query(String queryPredicate, Object[] queryParams) {
        return QueryOp.execute(this.pool, queryPredicate, queryParams);
    }
}

