/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.client.internal;

import com.gemstone.gemfire.cache.client.internal.CloseCQOp;
import com.gemstone.gemfire.cache.client.internal.Connection;
import com.gemstone.gemfire.cache.client.internal.CreateCQOp;
import com.gemstone.gemfire.cache.client.internal.CreateCQWithIROp;
import com.gemstone.gemfire.cache.client.internal.GetDurableCQsOp;
import com.gemstone.gemfire.cache.client.internal.InternalPool;
import com.gemstone.gemfire.cache.client.internal.ServerProxy;
import com.gemstone.gemfire.cache.client.internal.StopCQOp;
import com.gemstone.gemfire.cache.query.SelectResults;
import com.gemstone.gemfire.cache.query.internal.CqQueryImpl;
import java.util.List;

public class ServerCQProxy
extends ServerProxy {
    public ServerCQProxy(InternalPool pool) {
        super(pool);
    }

    public ServerCQProxy(ServerProxy sp) {
        this(sp.pool);
    }

    public Object create(CqQueryImpl cq) {
        this.pool.getRITracker().addCq(cq, cq.isDurable());
        byte regionDataPolicyOrdinal = cq.getCqBaseRegion() == null ? (byte)0 : cq.getCqBaseRegion().getAttributes().getDataPolicy().ordinal;
        return CreateCQOp.execute(this.pool, cq.getName(), cq.getQueryString(), 1, cq.isDurable(), regionDataPolicyOrdinal);
    }

    public Object createOn(String cqName, Connection conn, String queryStr, int cqState, boolean isDurable, byte regionDataPolicy) {
        return CreateCQOp.executeOn(this.pool, conn, cqName, queryStr, cqState, isDurable, regionDataPolicy);
    }

    public SelectResults createWithIR(CqQueryImpl cq) {
        this.pool.getRITracker().addCq(cq, cq.isDurable());
        byte regionDataPolicyOrdinal = cq.getCqBaseRegion() == null ? (byte)0 : cq.getCqBaseRegion().getAttributes().getDataPolicy().ordinal;
        return CreateCQWithIROp.execute(this.pool, cq.getName(), cq.getQueryString(), 1, cq.isDurable(), regionDataPolicyOrdinal);
    }

    public void stop(CqQueryImpl cq) {
        this.pool.getRITracker().removeCq(cq, cq.isDurable());
        StopCQOp.execute(this.pool, cq.getName());
    }

    public void close(CqQueryImpl cq) {
        this.pool.getRITracker().removeCq(cq, cq.isDurable());
        CloseCQOp.execute(this.pool, cq.getName());
    }

    public List<String> getAllDurableCqsFromServer() {
        return GetDurableCQsOp.execute(this.pool);
    }
}

