/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.client.internal;

import com.gemstone.gemfire.InternalGemFireError;
import com.gemstone.gemfire.cache.InterestResultPolicy;
import com.gemstone.gemfire.cache.client.internal.ServerRegionProxy;
import com.gemstone.gemfire.cache.client.internal.UnregisterInterestOp;
import com.gemstone.gemfire.cache.query.internal.CqQueryImpl;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.tier.InterestType;
import com.gemstone.gemfire.internal.cache.tier.sockets.UnregisterAllInterest;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.internal.logging.log4j.LocalizedMessage;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.logging.log4j.Logger;

public class RegisterInterestTracker {
    private static final Logger logger = LogService.getLogger();
    public static final int interestListIndex = 0;
    public static final int durableInterestListIndex = 1;
    public static final int interestListIndexForUpdatesAsInvalidates = 2;
    public static final int durableInterestListIndexForUpdatesAsInvalidates = 3;
    private final FailoverInterestList[] fils = new FailoverInterestList[4];
    private final ConcurrentMap cqs = new ConcurrentHashMap();

    public RegisterInterestTracker() {
        this.fils[0] = new FailoverInterestList();
        this.fils[2] = new FailoverInterestList();
        this.fils[1] = new FailoverInterestList();
        this.fils[3] = new FailoverInterestList();
    }

    public static int getInterestLookupIndex(boolean isDurable, boolean receiveUpdatesAsInvalidates) {
        if (isDurable) {
            if (receiveUpdatesAsInvalidates) {
                return 3;
            }
            return 1;
        }
        if (receiveUpdatesAsInvalidates) {
            return 2;
        }
        return 0;
    }

    public List getInterestList(String regionName, int interestType2) {
        RegionInterestEntry rie1 = this.readRegionInterests(regionName, interestType2, false, false);
        RegionInterestEntry rie2 = this.readRegionInterests(regionName, interestType2, false, true);
        RegionInterestEntry rie3 = this.readRegionInterests(regionName, interestType2, true, false);
        RegionInterestEntry rie4 = this.readRegionInterests(regionName, interestType2, true, true);
        ArrayList result = new ArrayList();
        if (rie1 != null) {
            result.addAll(rie1.getInterests().keySet());
        }
        if (rie2 != null) {
            result.addAll(rie2.getInterests().keySet());
        }
        if (rie3 != null) {
            result.addAll(rie3.getInterests().keySet());
        }
        if (rie4 != null) {
            result.addAll(rie4.getInterests().keySet());
        }
        return result;
    }

    public void addSingleInterest(LocalRegion r, Object key2, int interestType2, InterestResultPolicy pol, boolean isDurable, boolean receiveUpdatesAsInvalidates) {
        RegionInterestEntry rie = this.getRegionInterests(r, interestType2, false, isDurable, receiveUpdatesAsInvalidates);
        rie.getInterests().put(key2, pol);
    }

    public boolean removeSingleInterest(LocalRegion r, Object key2, int interestType2, boolean isDurable, boolean receiveUpdatesAsInvalidates) {
        Object interest;
        RegionInterestEntry rie = this.getRegionInterests(r, interestType2, true, isDurable, receiveUpdatesAsInvalidates);
        if (rie == null) {
            return false;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("removeSingleInterest region={} key={}", r.getFullPath(), key2);
        }
        if ((interest = rie.getInterests().remove(key2)) == null) {
            logger.warn(LocalizedMessage.create(LocalizedStrings.RegisterInterestTracker_REMOVESINGLEINTEREST_KEY_0_NOT_REGISTERED_IN_THE_CLIENT, key2));
            return false;
        }
        return true;
    }

    public void addInterestList(LocalRegion r, List keys, InterestResultPolicy pol, boolean isDurable, boolean receiveUpdatesAsInvalidates) {
        RegionInterestEntry rie = this.getRegionInterests(r, 0, false, isDurable, receiveUpdatesAsInvalidates);
        for (int i = 0; i < keys.size(); ++i) {
            rie.getInterests().put(keys.get(i), pol);
        }
    }

    public void addCq(CqQueryImpl cqi, boolean isDurable) {
        this.cqs.put(cqi, isDurable);
    }

    public void removeCq(CqQueryImpl cqi, boolean isDurable) {
        this.cqs.remove(cqi);
    }

    public Map getCqsMap() {
        return this.cqs;
    }

    public void unregisterRegion(ServerRegionProxy srp, boolean keepalive) {
        this.removeAllInterests(srp, 0, false, keepalive, false);
        this.removeAllInterests(srp, 2, false, keepalive, false);
        this.removeAllInterests(srp, 3, false, keepalive, false);
        this.removeAllInterests(srp, 1, false, keepalive, false);
        this.removeAllInterests(srp, 0, false, keepalive, true);
        this.removeAllInterests(srp, 2, false, keepalive, true);
        this.removeAllInterests(srp, 3, false, keepalive, true);
        this.removeAllInterests(srp, 1, false, keepalive, true);
        if (srp.getPool().isDurableClient()) {
            this.removeAllInterests(srp, 0, true, keepalive, true);
            this.removeAllInterests(srp, 2, true, keepalive, true);
            this.removeAllInterests(srp, 3, true, keepalive, true);
            this.removeAllInterests(srp, 1, true, keepalive, true);
            this.removeAllInterests(srp, 0, true, keepalive, false);
            this.removeAllInterests(srp, 2, true, keepalive, false);
            this.removeAllInterests(srp, 3, true, keepalive, false);
            this.removeAllInterests(srp, 1, true, keepalive, false);
        }
    }

    private void removeAllInterests(ServerRegionProxy srp, int interestType2, boolean durable, boolean keepAlive, boolean receiveUpdatesAsInvalidates) {
        block4: {
            String regName = srp.getRegionName();
            ConcurrentMap allInterests = this.getRegionToInterestsMap(interestType2, durable, receiveUpdatesAsInvalidates);
            if (allInterests.remove(regName) != null) {
                if (logger.isDebugEnabled()) {
                    logger.debug("removeAllInterests region={} type={}", regName, InterestType.getString(interestType2));
                }
                try {
                    UnregisterAllInterest key2 = UnregisterAllInterest.singleton();
                    UnregisterInterestOp.execute(srp.getPool(), regName, key2, interestType2, true, keepAlive);
                }
                catch (Exception e) {
                    if (srp.getPool().getCancelCriterion().cancelInProgress() != null) break block4;
                    logger.warn(LocalizedMessage.create(LocalizedStrings.RegisterInterestTracker_PROBLEM_REMOVING_ALL_INTEREST_ON_REGION_0_INTERESTTYPE_1_2, new Object[]{regName, InterestType.getString(interestType2), e.getLocalizedMessage()}));
                }
            }
        }
    }

    public boolean removeInterestList(LocalRegion r, List keys, boolean isDurable, boolean receiveUpdatesAsInvalidates) {
        RegionInterestEntry rie = this.getRegionInterests(r, 0, true, isDurable, receiveUpdatesAsInvalidates);
        if (rie == null) {
            return false;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("removeInterestList region={} keys={}", r.getFullPath(), keys);
        }
        int removeCount = 0;
        for (int i = 0; i < keys.size(); ++i) {
            Object key2 = keys.get(i);
            Object interest = rie.getInterests().remove(key2);
            if (interest != null) {
                ++removeCount;
                continue;
            }
            logger.warn(LocalizedMessage.create(LocalizedStrings.RegisterInterestTracker_REMOVEINTERESTLIST_KEY_0_NOT_REGISTERED_IN_THE_CLIENT, key2));
        }
        return removeCount != 0;
    }

    public ConcurrentMap getRegionToInterestsMap(int interestType2, boolean isDurable, boolean receiveUpdatesAsInvalidates) {
        FailoverInterestList fil = this.fils[RegisterInterestTracker.getInterestLookupIndex(isDurable, receiveUpdatesAsInvalidates)];
        ConcurrentMap mapOfInterest = null;
        switch (interestType2) {
            case 0: {
                mapOfInterest = fil.keysOfInterest;
                break;
            }
            case 1: {
                mapOfInterest = fil.regexOfInterest;
                break;
            }
            case 2: {
                mapOfInterest = fil.filtersOfInterest;
                break;
            }
            case 4: {
                mapOfInterest = fil.cqsOfInterest;
                break;
            }
            case 3: {
                mapOfInterest = fil.queriesOfInterest;
                break;
            }
            default: {
                throw new InternalGemFireError("Unknown interestType");
            }
        }
        return mapOfInterest;
    }

    private RegionInterestEntry getRegionInterests(LocalRegion r, int interestType2, boolean forRemoval, boolean isDurable, boolean receiveUpdatesAsInvalidates) {
        RegionInterestEntry rie;
        String regionName = r.getFullPath();
        ConcurrentMap mapOfInterest = this.getRegionToInterestsMap(interestType2, isDurable, receiveUpdatesAsInvalidates);
        RegionInterestEntry result = (RegionInterestEntry)mapOfInterest.get(regionName);
        if (result == null && !forRemoval && (result = mapOfInterest.putIfAbsent(regionName, rie = new RegionInterestEntry(r))) == null) {
            result = rie;
        }
        return result;
    }

    private RegionInterestEntry readRegionInterests(String regionName, int interestType2, boolean isDurable, boolean receiveUpdatesAsInvalidates) {
        ConcurrentMap mapOfInterest = this.getRegionToInterestsMap(interestType2, isDurable, receiveUpdatesAsInvalidates);
        return (RegionInterestEntry)mapOfInterest.get(regionName);
    }

    public static class RegionInterestEntry {
        private final LocalRegion region;
        private final ConcurrentMap interests;

        RegionInterestEntry(LocalRegion r) {
            this.region = r;
            this.interests = new ConcurrentHashMap();
        }

        public LocalRegion getRegion() {
            return this.region;
        }

        public ConcurrentMap getInterests() {
            return this.interests;
        }
    }

    protected static class FailoverInterestList {
        final ConcurrentMap keysOfInterest = new ConcurrentHashMap();
        final ConcurrentMap regexOfInterest = new ConcurrentHashMap();
        final ConcurrentMap filtersOfInterest = new ConcurrentHashMap();
        final ConcurrentMap queriesOfInterest = new ConcurrentHashMap();
        final ConcurrentMap cqsOfInterest = new ConcurrentHashMap();

        protected FailoverInterestList() {
        }
    }
}

