/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.client.internal;

import com.gemstone.gemfire.SerializationException;
import com.gemstone.gemfire.cache.client.ServerOperationException;
import com.gemstone.gemfire.cache.client.internal.AbstractOp;
import com.gemstone.gemfire.cache.client.internal.ConnectionStats;
import com.gemstone.gemfire.cache.client.internal.ExecutablePool;
import com.gemstone.gemfire.cache.query.SelectResults;
import com.gemstone.gemfire.cache.query.internal.QueryUtils;
import com.gemstone.gemfire.cache.query.internal.StructImpl;
import com.gemstone.gemfire.cache.query.internal.types.StructTypeImpl;
import com.gemstone.gemfire.cache.query.internal.types.TypeUtils;
import com.gemstone.gemfire.cache.query.types.CollectionType;
import com.gemstone.gemfire.cache.query.types.ObjectType;
import com.gemstone.gemfire.internal.Version;
import com.gemstone.gemfire.internal.cache.tier.sockets.ChunkedMessage;
import com.gemstone.gemfire.internal.cache.tier.sockets.Message;
import com.gemstone.gemfire.internal.cache.tier.sockets.ObjectPartList;
import com.gemstone.gemfire.internal.cache.tier.sockets.Part;
import java.util.Arrays;

public class QueryOp {
    public static SelectResults execute(ExecutablePool pool, String queryPredicate, Object[] queryParams) {
        QueryOpImpl op = null;
        op = queryParams != null && queryParams.length > 0 ? new QueryOpImpl(queryPredicate, queryParams) : new QueryOpImpl(queryPredicate);
        return (SelectResults)pool.execute(op);
    }

    private QueryOp() {
    }

    protected static class QueryOpImpl
    extends AbstractOp {
        public QueryOpImpl(String queryPredicate) {
            super(34, 1);
            this.getMessage().addStringPart(queryPredicate);
        }

        public QueryOpImpl(String queryPredicate, Object[] queryParams) {
            super(80, 2 + queryParams.length);
            this.getMessage().addStringPart(queryPredicate);
            this.getMessage().addIntPart(queryParams.length);
            for (Object param : queryParams) {
                this.getMessage().addObjPart(param);
            }
        }

        protected QueryOpImpl(int msgType, int numParts) {
            super(msgType, numParts);
        }

        @Override
        protected Message createResponseMessage() {
            return new ChunkedMessage(2, Version.CURRENT);
        }

        @Override
        protected Object processResponse(Message msg) throws Exception {
            final SelectResults[] resultRef = new SelectResults[1];
            final Exception[] exceptionRef = new Exception[1];
            AbstractOp.ChunkHandler ch = new AbstractOp.ChunkHandler(){

                @Override
                public void handle(ChunkedMessage cm) throws Exception {
                    Part collectionTypePart = cm.getPart(0);
                    Object o = collectionTypePart.getObject();
                    if (o instanceof Throwable) {
                        String s = "While performing a remote " + QueryOpImpl.this.getOpName();
                        exceptionRef[0] = new ServerOperationException(s, (Throwable)o);
                        return;
                    }
                    CollectionType collectionType = (CollectionType)o;
                    Part resultPart = cm.getPart(1);
                    Object queryResult = null;
                    try {
                        queryResult = resultPart.getObject();
                    }
                    catch (Exception e) {
                        String s = "While deserializing " + QueryOpImpl.this.getOpName() + " result";
                        exceptionRef[0] = new SerializationException(s, e);
                        return;
                    }
                    if (queryResult instanceof Throwable) {
                        String s = "While performing a remote " + QueryOpImpl.this.getOpName();
                        exceptionRef[0] = new ServerOperationException(s, (Throwable)queryResult);
                        return;
                    }
                    if (queryResult instanceof Integer) {
                        if (resultRef[0] == null) {
                            resultRef[0] = QueryUtils.getEmptySelectResults(TypeUtils.OBJECT_TYPE, null);
                        }
                        resultRef[0].add(queryResult);
                    } else {
                        Object[] resultArray;
                        if (resultRef[0] == null) {
                            resultRef[0] = QueryUtils.getEmptySelectResults(collectionType, null);
                        }
                        SelectResults selectResults = resultRef[0];
                        ObjectType objectType = collectionType.getElementType();
                        boolean isObjectPartList = false;
                        if (queryResult instanceof ObjectPartList) {
                            isObjectPartList = true;
                            resultArray = ((ObjectPartList)queryResult).getObjects().toArray();
                        } else {
                            resultArray = (Object[])queryResult;
                        }
                        if (objectType.isStructType()) {
                            for (int i = 0; i < resultArray.length; ++i) {
                                if (isObjectPartList) {
                                    selectResults.add(new StructImpl((StructTypeImpl)objectType, ((ObjectPartList)resultArray[i]).getObjects().toArray()));
                                    continue;
                                }
                                selectResults.add(new StructImpl((StructTypeImpl)objectType, (Object[])resultArray[i]));
                            }
                        } else {
                            selectResults.addAll(Arrays.asList(resultArray));
                        }
                    }
                }
            };
            this.processChunkedResponse((ChunkedMessage)msg, this.getOpName(), ch);
            if (exceptionRef[0] != null) {
                throw exceptionRef[0];
            }
            return resultRef[0];
        }

        protected String getOpName() {
            return "query";
        }

        @Override
        protected boolean isErrorResponse(int msgType) {
            return msgType == 35 || msgType == 47 || msgType == 50;
        }

        @Override
        protected long startAttempt(ConnectionStats stats) {
            return stats.startQuery();
        }

        @Override
        protected void endSendAttempt(ConnectionStats stats, long start) {
            stats.endQuerySend(start, this.hasFailed());
        }

        @Override
        protected void endAttempt(ConnectionStats stats, long start) {
            stats.endQuery(start, this.hasTimedOut(), this.hasFailed());
        }
    }
}

