/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.client.internal;

import com.gemstone.gemfire.cache.AttributesMutator;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheClosedException;
import com.gemstone.gemfire.cache.CacheLoaderException;
import com.gemstone.gemfire.cache.CacheStatistics;
import com.gemstone.gemfire.cache.CacheWriterException;
import com.gemstone.gemfire.cache.EntryExistsException;
import com.gemstone.gemfire.cache.EntryNotFoundException;
import com.gemstone.gemfire.cache.InterestResultPolicy;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.RegionExistsException;
import com.gemstone.gemfire.cache.RegionService;
import com.gemstone.gemfire.cache.StatisticsDisabledException;
import com.gemstone.gemfire.cache.TimeoutException;
import com.gemstone.gemfire.cache.client.internal.ProxyCache;
import com.gemstone.gemfire.cache.client.internal.UserAttributes;
import com.gemstone.gemfire.cache.query.FunctionDomainException;
import com.gemstone.gemfire.cache.query.NameResolutionException;
import com.gemstone.gemfire.cache.query.QueryInvocationTargetException;
import com.gemstone.gemfire.cache.query.SelectResults;
import com.gemstone.gemfire.cache.query.TypeMismatchException;
import com.gemstone.gemfire.cache.snapshot.RegionSnapshotService;
import com.gemstone.gemfire.internal.cache.snapshot.RegionSnapshotServiceImpl;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;

public class ProxyRegion
implements Region {
    private final ProxyCache proxyCache;
    private final Region realRegion;

    public ProxyRegion(ProxyCache proxyCache, Region realRegion) {
        this.proxyCache = proxyCache;
        this.realRegion = realRegion;
    }

    @Override
    public void becomeLockGrantor() {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        try {
            this.preOp();
            this.realRegion.clear();
        }
        finally {
            this.postOp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        try {
            this.preOp();
            this.realRegion.close();
        }
        finally {
            this.postOp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsKey(Object key2) {
        try {
            this.preOp();
            boolean bl = this.realRegion.containsKey(key2);
            return bl;
        }
        finally {
            this.postOp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsKeyOnServer(Object key2) {
        try {
            this.preOp();
            boolean bl = this.realRegion.containsKeyOnServer(key2);
            return bl;
        }
        finally {
            this.postOp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsValue(Object value2) {
        try {
            this.preOp();
            boolean bl = this.realRegion.containsValue(value2);
            return bl;
        }
        finally {
            this.postOp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsValueForKey(Object key2) {
        try {
            this.preOp();
            boolean bl = this.realRegion.containsValueForKey(key2);
            return bl;
        }
        finally {
            this.postOp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void create(Object key2, Object value2) throws TimeoutException, EntryExistsException, CacheWriterException {
        try {
            this.preOp();
            this.realRegion.create(key2, value2);
        }
        finally {
            this.postOp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void create(Object key2, Object value2, Object callbackArgument) throws TimeoutException, EntryExistsException, CacheWriterException {
        try {
            this.preOp();
            this.realRegion.create(key2, value2, callbackArgument);
        }
        finally {
            this.postOp();
        }
    }

    public Region createSubregion(String subregionName, RegionAttributes regionAttributes) throws RegionExistsException, TimeoutException {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object destroy(Object key2) throws TimeoutException, EntryNotFoundException, CacheWriterException {
        try {
            this.preOp();
            Object v = this.realRegion.destroy(key2);
            return v;
        }
        finally {
            this.postOp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object destroy(Object key2, Object callbackArgument) throws TimeoutException, EntryNotFoundException, CacheWriterException {
        try {
            this.preOp();
            Object v = this.realRegion.destroy(key2, callbackArgument);
            return v;
        }
        finally {
            this.postOp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroyRegion() throws CacheWriterException, TimeoutException {
        try {
            this.preOp();
            this.realRegion.destroyRegion();
        }
        finally {
            this.postOp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroyRegion(Object callbackArgument) throws CacheWriterException, TimeoutException {
        try {
            this.preOp();
            this.realRegion.destroyRegion(callbackArgument);
        }
        finally {
            this.postOp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set entries(boolean recursive) {
        try {
            this.preOp();
            Set<Region.Entry<?, ?>> set = this.realRegion.entries(recursive);
            return set;
        }
        finally {
            this.postOp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set entrySet(boolean recursive) {
        try {
            this.preOp();
            Set<Region.Entry<?, ?>> set = this.realRegion.entrySet(recursive);
            return set;
        }
        finally {
            this.postOp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set entrySet() {
        try {
            this.preOp();
            Set set = this.realRegion.entrySet();
            return set;
        }
        finally {
            this.postOp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean existsValue(String queryPredicate) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
        try {
            this.preOp();
            boolean bl = this.realRegion.existsValue(queryPredicate);
            return bl;
        }
        finally {
            this.postOp();
        }
    }

    @Override
    public void forceRolling() {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object get(Object key2) throws CacheLoaderException, TimeoutException {
        try {
            this.preOp();
            Object v = this.realRegion.get(key2);
            return v;
        }
        finally {
            this.postOp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(Object key2, Object callbackArgument) throws TimeoutException, CacheLoaderException {
        try {
            this.preOp();
            Object v = this.realRegion.get(key2, callbackArgument);
            return v;
        }
        finally {
            this.postOp();
        }
    }

    public Map getAll(Collection keys) {
        return this.getAll(keys, (Object)null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getAll(Collection keys, Object callback) {
        try {
            this.preOp();
            Map map = this.realRegion.getAll(keys, callback);
            return map;
        }
        finally {
            this.postOp();
        }
    }

    public RegionAttributes getAttributes() {
        return this.realRegion.getAttributes();
    }

    public AttributesMutator getAttributesMutator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Cache getCache() {
        throw new UnsupportedOperationException();
    }

    @Override
    public RegionService getRegionService() {
        return this.proxyCache;
    }

    public ProxyCache getAuthenticatedCache() {
        return this.proxyCache;
    }

    @Override
    public Lock getDistributedLock(Object key2) throws IllegalStateException {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Region.Entry getEntry(Object key2) {
        try {
            this.preOp();
            Region.Entry entry = this.realRegion.getEntry(key2);
            return entry;
        }
        finally {
            this.postOp();
        }
    }

    @Override
    public String getFullPath() {
        return this.realRegion.getFullPath();
    }

    public List getInterestList() {
        throw new UnsupportedOperationException();
    }

    public List getInterestListRegex() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getName() {
        return this.realRegion.getName();
    }

    public Region getParentRegion() {
        return this.realRegion.getParentRegion();
    }

    @Override
    public Lock getRegionDistributedLock() throws IllegalStateException {
        throw new UnsupportedOperationException();
    }

    @Override
    public CacheStatistics getStatistics() throws StatisticsDisabledException {
        return this.realRegion.getStatistics();
    }

    public Region getSubregion(String path) {
        Region region = this.realRegion.getSubregion(path);
        return region != null ? new ProxyRegion(this.proxyCache, region) : null;
    }

    @Override
    public Object getUserAttribute() {
        return this.realRegion.getUserAttribute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invalidate(Object key2) throws TimeoutException, EntryNotFoundException {
        try {
            this.preOp();
            this.realRegion.invalidate(key2);
        }
        finally {
            this.postOp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invalidate(Object key2, Object callbackArgument) throws TimeoutException, EntryNotFoundException {
        try {
            this.preOp();
            this.realRegion.invalidate(key2, callbackArgument);
        }
        finally {
            this.postOp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invalidateRegion() throws TimeoutException {
        try {
            this.preOp();
            this.realRegion.invalidateRegion();
        }
        finally {
            this.postOp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invalidateRegion(Object callbackArgument) throws TimeoutException {
        try {
            this.preOp();
            this.realRegion.invalidateRegion(callbackArgument);
        }
        finally {
            this.postOp();
        }
    }

    @Override
    public boolean isDestroyed() {
        return this.realRegion.isDestroyed();
    }

    @Override
    public boolean isEmpty() {
        return this.realRegion.isEmpty();
    }

    @Override
    public Set keySet() {
        return this.realRegion.keySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set keySetOnServer() {
        try {
            this.preOp();
            Set set = this.realRegion.keySetOnServer();
            return set;
        }
        finally {
            this.postOp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set keys() {
        try {
            this.preOp();
            Set set = this.realRegion.keys();
            return set;
        }
        finally {
            this.postOp();
        }
    }

    @Override
    public void loadSnapshot(InputStream inputStream) throws IOException, ClassNotFoundException, CacheWriterException, TimeoutException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void localClear() {
        throw new UnsupportedOperationException("Local operations are not supported when multiuser-authentication is true.");
    }

    @Override
    public void localDestroy(Object key2) throws EntryNotFoundException {
        throw new UnsupportedOperationException("Local operations are not supported when multiuser-authentication is true.");
    }

    @Override
    public void localDestroy(Object key2, Object callbackArgument) throws EntryNotFoundException {
        throw new UnsupportedOperationException("Local operations are not supported when multiuser-authentication is true.");
    }

    @Override
    public void localDestroyRegion() {
        throw new UnsupportedOperationException("Local operations are not supported when multiuser-authentication is true.");
    }

    @Override
    public void localDestroyRegion(Object callbackArgument) {
        throw new UnsupportedOperationException("Local operations are not supported when multiuser-authentication is true.");
    }

    @Override
    public void localInvalidate(Object key2) throws EntryNotFoundException {
        throw new UnsupportedOperationException("Local operations are not supported when multiuser-authentication is true.");
    }

    @Override
    public void localInvalidate(Object key2, Object callbackArgument) throws EntryNotFoundException {
        throw new UnsupportedOperationException("Local operations are not supported when multiuser-authentication is true.");
    }

    @Override
    public void localInvalidateRegion() {
        throw new UnsupportedOperationException("Local operations are not supported when multiuser-authentication is true.");
    }

    @Override
    public void localInvalidateRegion(Object callbackArgument) {
        throw new UnsupportedOperationException("Local operations are not supported when multiuser-authentication is true.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object put(Object key2, Object value2) throws TimeoutException, CacheWriterException {
        try {
            this.preOp();
            Object object = this.realRegion.put(key2, value2);
            return object;
        }
        finally {
            this.postOp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object put(Object key2, Object value2, Object callbackArgument) throws TimeoutException, CacheWriterException {
        try {
            this.preOp();
            Object object = this.realRegion.put(key2, value2, callbackArgument);
            return object;
        }
        finally {
            this.postOp();
        }
    }

    @Override
    public void putAll(Map map) {
        this.putAll(map, (Object)null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putAll(Map map, Object callbackArg) {
        try {
            this.preOp();
            this.realRegion.putAll(map, callbackArg);
        }
        finally {
            this.postOp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SelectResults query(String queryPredicate) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
        try {
            this.preOp();
            SelectResults selectResults = this.realRegion.query(queryPredicate);
            return selectResults;
        }
        finally {
            this.postOp();
        }
    }

    public void registerInterest(Object key2) {
        throw new UnsupportedOperationException();
    }

    public void registerInterest(Object key2, InterestResultPolicy policy) {
        throw new UnsupportedOperationException();
    }

    public void registerInterest(Object key2, boolean isDurable) {
        throw new UnsupportedOperationException();
    }

    public void registerInterest(Object key2, boolean isDurable, boolean receiveValues) {
        throw new UnsupportedOperationException();
    }

    public void registerInterest(Object key2, InterestResultPolicy policy, boolean isDurable, boolean receiveValues) {
        throw new UnsupportedOperationException();
    }

    public void registerInterest(Object key2, InterestResultPolicy policy, boolean isDurable) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void registerInterestRegex(String regex) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void registerInterestRegex(String regex, InterestResultPolicy policy) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void registerInterestRegex(String regex, boolean isDurable) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void registerInterestRegex(String regex, boolean isDurable, boolean receiveValues) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void registerInterestRegex(String regex, InterestResultPolicy policy, boolean isDurable) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void registerInterestRegex(String regex, InterestResultPolicy policy, boolean isDurable, boolean receiveValues) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object remove(Object key2) {
        try {
            this.preOp();
            Object v = this.realRegion.remove(key2);
            return v;
        }
        finally {
            this.postOp();
        }
    }

    @Override
    public void saveSnapshot(OutputStream outputStream) throws IOException {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object selectValue(String queryPredicate) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
        try {
            this.preOp();
            Object object = this.realRegion.selectValue(queryPredicate);
            return object;
        }
        finally {
            this.postOp();
        }
    }

    @Override
    public void setUserAttribute(Object value2) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        try {
            this.preOp();
            int n = this.realRegion.size();
            return n;
        }
        finally {
            this.postOp();
        }
    }

    public Set subregions(boolean recursive) {
        return this.realRegion.subregions(recursive);
    }

    public void unregisterInterest(Object key2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void unregisterInterestRegex(String regex) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection values() {
        try {
            this.preOp();
            Collection collection = this.realRegion.values();
            return collection;
        }
        finally {
            this.postOp();
        }
    }

    @Override
    public void writeToDisk() {
        throw new UnsupportedOperationException();
    }

    private void preOp() {
        if (this.proxyCache.isClosed()) {
            throw new CacheClosedException("Cache is closed for this user.");
        }
        UserAttributes.userAttributes.set(this.proxyCache.getUserAttributes());
    }

    private void postOp() {
        this.proxyCache.setUserAttributes(UserAttributes.userAttributes.get());
        UserAttributes.userAttributes.set(null);
    }

    public Region getRealRegion() {
        return this.realRegion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object putIfAbsent(Object key2, Object value2) {
        try {
            this.preOp();
            Object object = this.realRegion.putIfAbsent(key2, value2);
            return object;
        }
        finally {
            this.postOp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object key2, Object value2) {
        try {
            this.preOp();
            boolean bl = this.realRegion.remove(key2, value2);
            return bl;
        }
        finally {
            this.postOp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object replace(Object key2, Object value2) {
        try {
            this.preOp();
            Object object = this.realRegion.replace(key2, value2);
            return object;
        }
        finally {
            this.postOp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean replace(Object key2, Object oldValue, Object newValue) {
        try {
            this.preOp();
            boolean bl = this.realRegion.replace(key2, oldValue, newValue);
            return bl;
        }
        finally {
            this.postOp();
        }
    }

    public RegionSnapshotService<?, ?> getSnapshotService() {
        return new RegionSnapshotServiceImpl(this);
    }

    public void removeAll(Collection keys) {
        this.removeAll(keys, (Object)null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAll(Collection keys, Object aCallbackArgument) {
        try {
            this.preOp();
            this.realRegion.removeAll(keys, aCallbackArgument);
        }
        finally {
            this.postOp();
        }
    }
}

