/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.client.internal;

import com.gemstone.gemfire.InternalGemFireError;
import com.gemstone.gemfire.cache.client.ServerOperationException;
import com.gemstone.gemfire.cache.client.internal.AbstractOp;
import com.gemstone.gemfire.cache.client.internal.Connection;
import com.gemstone.gemfire.cache.client.internal.ConnectionStats;
import com.gemstone.gemfire.cache.client.internal.ExecutablePool;
import com.gemstone.gemfire.internal.cache.tier.MessageType;
import com.gemstone.gemfire.internal.cache.tier.sockets.Message;
import com.gemstone.gemfire.internal.cache.tier.sockets.Part;
import com.gemstone.gemfire.pdx.internal.EnumInfo;
import java.util.Map;

public class GetPDXEnumsOp {
    public static Map<Integer, EnumInfo> execute(ExecutablePool pool) {
        GetPDXEnumsOpImpl op = new GetPDXEnumsOpImpl();
        return (Map)pool.execute(op);
    }

    private GetPDXEnumsOp() {
    }

    private static class GetPDXEnumsOpImpl
    extends AbstractOp {
        public GetPDXEnumsOpImpl() {
            super(102, 1);
            this.getMessage().addIntPart(0);
        }

        @Override
        protected Object processResponse(Message msg) throws Exception {
            Part part = msg.getPart(0);
            int msgType = msg.getMessageType();
            if (msgType == 1) {
                return (Map)part.getObject();
            }
            if (msgType == 2) {
                String s = "While performing a remote getPdxEnums";
                throw new ServerOperationException(s, (Throwable)part.getObject());
            }
            if (this.isErrorResponse(msgType)) {
                throw new ServerOperationException(part.getString());
            }
            throw new InternalGemFireError("Unexpected message type " + MessageType.getString(msgType));
        }

        @Override
        protected boolean isErrorResponse(int msgType) {
            return false;
        }

        @Override
        protected long startAttempt(ConnectionStats stats) {
            return 0L;
        }

        @Override
        protected void endSendAttempt(ConnectionStats stats, long start) {
        }

        @Override
        protected void endAttempt(ConnectionStats stats, long start) {
        }

        @Override
        protected void processSecureBytes(Connection cnx, Message message) throws Exception {
        }

        @Override
        protected boolean needsUserId() {
            return false;
        }

        @Override
        protected boolean participateInTransaction() {
            return false;
        }

        @Override
        protected void sendMessage(Connection cnx) throws Exception {
            this.getMessage().setEarlyAck((byte)(this.getMessage().getEarlyAckByte() & 2));
            this.getMessage().send(false);
        }
    }
}

