/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.client.internal;

import com.gemstone.gemfire.cache.CacheClosedException;
import com.gemstone.gemfire.cache.CacheLoaderException;
import com.gemstone.gemfire.cache.Operation;
import com.gemstone.gemfire.cache.client.AllConnectionsInUseException;
import com.gemstone.gemfire.cache.client.ServerConnectivityException;
import com.gemstone.gemfire.cache.client.ServerOperationException;
import com.gemstone.gemfire.cache.client.internal.AbstractOp;
import com.gemstone.gemfire.cache.client.internal.ClientMetadataService;
import com.gemstone.gemfire.cache.client.internal.Connection;
import com.gemstone.gemfire.cache.client.internal.ConnectionStats;
import com.gemstone.gemfire.cache.client.internal.ExecutablePool;
import com.gemstone.gemfire.cache.client.internal.PoolImpl;
import com.gemstone.gemfire.cache.util.BridgeWriterException;
import com.gemstone.gemfire.distributed.internal.ServerLocation;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.cache.EntryEventImpl;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.Token;
import com.gemstone.gemfire.internal.cache.tier.sockets.Message;
import com.gemstone.gemfire.internal.cache.tier.sockets.Part;
import com.gemstone.gemfire.internal.cache.versions.VersionTag;
import com.gemstone.gemfire.internal.logging.LogService;
import org.apache.logging.log4j.Logger;

public class GetOp {
    private static final Logger logger = LogService.getLogger();
    public static final int HAS_CALLBACK_ARG = 1;
    public static final int HAS_VERSION_TAG = 2;
    public static final int KEY_NOT_PRESENT = 4;
    public static final int VALUE_IS_INVALID = 8;

    public static Object execute(ExecutablePool pool, LocalRegion region, Object key2, Object callbackArg, boolean prSingleHopEnabled, EntryEventImpl clientEvent) {
        GetOpImpl op;
        block9: {
            ServerLocation server;
            ClientMetadataService cms = region.getCache().getClientMetadataService();
            op = new GetOpImpl(region, key2, callbackArg, prSingleHopEnabled, clientEvent);
            if (logger.isDebugEnabled()) {
                logger.debug("GetOp invoked for key {}", key2);
            }
            if (prSingleHopEnabled && (server = cms.getBucketServerLocation(region, Operation.GET, key2, null, callbackArg)) != null) {
                try {
                    PoolImpl poolImpl = (PoolImpl)pool;
                    boolean onlyUseExistingCnx = poolImpl.getMaxConnections() != -1 && poolImpl.getConnectionCount() >= poolImpl.getMaxConnections();
                    return pool.executeOn(new ServerLocation(server.getHostName(), server.getPort()), op, true, onlyUseExistingCnx);
                }
                catch (AllConnectionsInUseException e) {
                }
                catch (ServerConnectivityException e) {
                    if (e instanceof ServerOperationException) {
                        throw e;
                    }
                    cms.removeBucketServerLocation(server);
                }
                catch (BridgeWriterException e) {
                    if (e.getCause() instanceof ServerConnectivityException) {
                        cms.removeBucketServerLocation(server);
                    }
                }
                catch (CacheLoaderException e) {
                    if (!(e.getCause() instanceof ServerConnectivityException)) break block9;
                    cms.removeBucketServerLocation(server);
                }
            }
        }
        return pool.execute(op);
    }

    private GetOp() {
    }

    static class GetOpImpl
    extends AbstractOp {
        private LocalRegion region = null;
        private boolean prSingleHopEnabled = false;
        private Object key;
        private Object callbackArg;
        private EntryEventImpl clientEvent;

        public String toString() {
            return "GetOpImpl(key=" + this.key + ")";
        }

        public GetOpImpl(LocalRegion region, Object key2, Object callbackArg, boolean prSingleHopEnabled, EntryEventImpl clientEvent) {
            super(0, callbackArg != null ? 3 : 2);
            if (logger.isDebugEnabled()) {
                logger.debug("constructing a GetOp for key {}", key2);
            }
            this.region = region;
            this.prSingleHopEnabled = prSingleHopEnabled;
            this.key = key2;
            this.callbackArg = callbackArg;
            this.clientEvent = clientEvent;
            this.getMessage().addStringPart(region.getFullPath());
            this.getMessage().addStringOrObjPart(key2);
            if (callbackArg != null) {
                this.getMessage().addObjPart(callbackArg);
            }
        }

        @Override
        protected Object processResponse(Message msg) throws Exception {
            throw new UnsupportedOperationException();
        }

        @Override
        protected Object processResponse(Message msg, Connection con) throws Exception {
            Object object = this.processObjResponse(msg, "get");
            if (msg.getNumberOfParts() > 1) {
                int flags;
                int partIdx = 1;
                if (((flags = msg.getPart(partIdx++).getInt()) & 1) != 0) {
                    msg.getPart(partIdx++).getObject();
                }
                if (object == null && (flags & 8) != 0) {
                    object = Token.INVALID;
                }
                if ((flags & 2) != 0) {
                    VersionTag tag = (VersionTag)msg.getPart(partIdx++).getObject();
                    assert (con != null);
                    assert (con.getEndpoint() != null);
                    assert (tag != null);
                    tag.replaceNullIDs((InternalDistributedMember)con.getEndpoint().getMemberId());
                    if (this.clientEvent != null) {
                        this.clientEvent.setVersionTag(tag);
                    }
                    if ((flags & 4) != 0) {
                        object = Token.TOMBSTONE;
                    }
                }
                if (this.prSingleHopEnabled && msg.getNumberOfParts() > partIdx) {
                    byte version = 0;
                    int noOfMsgParts = msg.getNumberOfParts();
                    if (noOfMsgParts == partIdx + 1) {
                        byte[] bytesReceived;
                        Part part;
                        if ((part = msg.getPart(partIdx++)).isBytes() && (bytesReceived = part.getSerializedForm())[0] != 0 && bytesReceived.length == 2) {
                            ClientMetadataService cms;
                            try {
                                cms = this.region.getCache().getClientMetadataService();
                                version = cms.getMetaDataVersion(this.region, Operation.UPDATE, this.key, null, this.callbackArg);
                            }
                            catch (CacheClosedException e) {
                                return null;
                            }
                            if (bytesReceived[0] != version) {
                                cms.scheduleGetPRMetaData(this.region, false, bytesReceived[1]);
                            }
                        }
                    } else if (noOfMsgParts == partIdx + 2) {
                        msg.getPart(partIdx++).getObject();
                        Part part = msg.getPart(partIdx++);
                        if (part.isBytes()) {
                            byte[] bytesReceived = part.getSerializedForm();
                            if (this.region != null && bytesReceived.length == 2) {
                                ClientMetadataService cms;
                                try {
                                    cms = this.region.getCache().getClientMetadataService();
                                    version = cms.getMetaDataVersion(this.region, Operation.UPDATE, this.key, null, this.callbackArg);
                                }
                                catch (CacheClosedException e) {
                                    return null;
                                }
                                if (bytesReceived[0] != version) {
                                    cms.scheduleGetPRMetaData(this.region, false, bytesReceived[1]);
                                }
                            }
                        }
                    }
                }
            }
            return object;
        }

        @Override
        protected boolean isErrorResponse(int msgType) {
            return msgType == 3;
        }

        @Override
        protected long startAttempt(ConnectionStats stats) {
            return stats.startGet();
        }

        @Override
        protected void endSendAttempt(ConnectionStats stats, long start) {
            stats.endGetSend(start, this.hasFailed());
        }

        @Override
        protected void endAttempt(ConnectionStats stats, long start) {
            stats.endGet(start, this.hasTimedOut(), this.hasFailed());
        }
    }
}

