/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.client.internal;

import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.client.ServerConnectivityException;
import com.gemstone.gemfire.cache.client.ServerOperationException;
import com.gemstone.gemfire.cache.client.internal.AbstractOp;
import com.gemstone.gemfire.cache.client.internal.ClientMetadataService;
import com.gemstone.gemfire.cache.client.internal.Connection;
import com.gemstone.gemfire.cache.client.internal.ConnectionStats;
import com.gemstone.gemfire.cache.client.internal.ExecutablePool;
import com.gemstone.gemfire.cache.client.internal.PoolImpl;
import com.gemstone.gemfire.cache.client.internal.SingleHopClientExecutor;
import com.gemstone.gemfire.cache.client.internal.SingleHopOperationCallable;
import com.gemstone.gemfire.cache.client.internal.UserAttributes;
import com.gemstone.gemfire.distributed.internal.ServerLocation;
import com.gemstone.gemfire.internal.Version;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.tier.sockets.ChunkedMessage;
import com.gemstone.gemfire.internal.cache.tier.sockets.Message;
import com.gemstone.gemfire.internal.cache.tier.sockets.Part;
import com.gemstone.gemfire.internal.cache.tier.sockets.VersionedObjectList;
import com.gemstone.gemfire.internal.logging.LogService;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.Logger;

public class GetAllOp {
    private static final Logger logger = LogService.getLogger();

    public static VersionedObjectList execute(ExecutablePool pool, String region, List keys, Object callback) {
        GetAllOpImpl op = new GetAllOpImpl(region, keys, callback);
        ((AbstractOp)op).initMessagePart();
        return ((VersionedObjectList)pool.execute(op)).setKeys(keys);
    }

    public static VersionedObjectList execute(ExecutablePool pool, Region region, List keys, int retryAttempts, Object callback) {
        GetAllOpImpl op = new GetAllOpImpl(region.getFullPath(), keys, callback);
        ClientMetadataService cms = ((LocalRegion)region).getCache().getClientMetadataService();
        Map<ServerLocation, HashSet> serverToFilterMap = cms.getServerToFilterMap(keys, region, true);
        if (serverToFilterMap == null || serverToFilterMap.isEmpty()) {
            ((AbstractOp)op).initMessagePart();
            return ((VersionedObjectList)pool.execute(op)).setKeys(keys);
        }
        VersionedObjectList result = null;
        ServerConnectivityException se = null;
        ArrayList retryList = new ArrayList();
        List callableTasks = GetAllOp.constructGetAllTasks(region.getFullPath(), serverToFilterMap, (PoolImpl)pool, callback);
        Map<ServerLocation, Object> results = SingleHopClientExecutor.submitGetAll(serverToFilterMap, callableTasks, cms, (LocalRegion)region);
        for (ServerLocation server : results.keySet()) {
            Object serverResult = results.get(server);
            if (serverResult instanceof ServerConnectivityException) {
                se = (ServerConnectivityException)serverResult;
                retryList.addAll(serverToFilterMap.get(server));
                continue;
            }
            if (result == null) {
                result = (VersionedObjectList)serverResult;
                continue;
            }
            result.addAll((VersionedObjectList)serverResult);
        }
        if (se != null) {
            if (retryAttempts == 0) {
                throw se;
            }
            VersionedObjectList retryResult = GetAllOp.execute(pool, region.getFullPath(), retryList, callback);
            if (result == null) {
                result = retryResult;
            } else {
                result.addAll(retryResult);
            }
        }
        return result;
    }

    private GetAllOp() {
    }

    static List constructGetAllTasks(String region, Map<ServerLocation, HashSet> serverToFilterMap, PoolImpl pool, Object callback) {
        ArrayList<SingleHopOperationCallable> tasks = new ArrayList<SingleHopOperationCallable>();
        ArrayList<ServerLocation> servers = new ArrayList<ServerLocation>(serverToFilterMap.keySet());
        if (logger.isDebugEnabled()) {
            logger.debug("Constructing tasks for the servers {}", servers);
        }
        for (ServerLocation server : servers) {
            Set filterSet = serverToFilterMap.get(server);
            GetAllOpImpl getAllOp = new GetAllOpImpl(region, new ArrayList(filterSet), callback);
            SingleHopOperationCallable task = new SingleHopOperationCallable(new ServerLocation(server.getHostName(), server.getPort()), pool, getAllOp, UserAttributes.userAttributes.get());
            tasks.add(task);
        }
        return tasks;
    }

    static class GetAllOpImpl
    extends AbstractOp {
        private List keyList;
        private final Object callback;

        public GetAllOpImpl(String region, List keys, Object callback) {
            super(callback != null ? 107 : 100, 3);
            this.keyList = keys;
            this.callback = callback;
            this.getMessage().addStringPart(region);
        }

        @Override
        protected void initMessagePart() {
            Object[] keysArray = new Object[this.keyList.size()];
            this.keyList.toArray(keysArray);
            this.getMessage().addObjPart(keysArray);
            if (this.callback != null) {
                this.getMessage().addObjPart(this.callback);
            } else {
                this.getMessage().addIntPart(0);
            }
        }

        public List getKeyList() {
            return this.keyList;
        }

        @Override
        protected Message createResponseMessage() {
            return new ChunkedMessage(1, Version.CURRENT);
        }

        @Override
        protected Object processResponse(Message msg) throws Exception {
            throw new UnsupportedOperationException();
        }

        @Override
        protected Object processResponse(Message msg, final Connection con) throws Exception {
            final VersionedObjectList result = new VersionedObjectList(false);
            final Exception[] exceptionRef = new Exception[1];
            this.processChunkedResponse((ChunkedMessage)msg, "getAll", new AbstractOp.ChunkHandler(){

                @Override
                public void handle(ChunkedMessage cm) throws Exception {
                    Part part = cm.getPart(0);
                    try {
                        Object o = part.getObject();
                        if (o instanceof Throwable) {
                            String s = "While performing a remote getAll";
                            exceptionRef[0] = new ServerOperationException(s, (Throwable)o);
                        } else {
                            VersionedObjectList chunk = (VersionedObjectList)o;
                            chunk.replaceNullIDs(con.getEndpoint().getMemberId());
                            result.addAll(chunk);
                        }
                    }
                    catch (Exception e) {
                        exceptionRef[0] = new ServerOperationException("Unable to deserialize value", e);
                    }
                }
            });
            if (exceptionRef[0] != null) {
                throw exceptionRef[0];
            }
            return result;
        }

        @Override
        protected boolean isErrorResponse(int msgType) {
            return msgType == 58;
        }

        @Override
        protected long startAttempt(ConnectionStats stats) {
            return stats.startGetAll();
        }

        @Override
        protected void endSendAttempt(ConnectionStats stats, long start) {
            stats.endGetAllSend(start, this.hasFailed());
        }

        @Override
        protected void endAttempt(ConnectionStats stats, long start) {
            stats.endGetAll(start, this.hasTimedOut(), this.hasFailed());
        }
    }
}

