/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.client.internal;

import com.gemstone.gemfire.InternalGemFireException;
import com.gemstone.gemfire.cache.FixedPartitionAttributes;
import com.gemstone.gemfire.cache.PartitionResolver;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.client.internal.ClientMetadataService;
import com.gemstone.gemfire.distributed.internal.ServerLocation;
import com.gemstone.gemfire.internal.ClassPathLoader;
import com.gemstone.gemfire.internal.cache.BucketServerLocation66;
import com.gemstone.gemfire.internal.cache.FixedPartitionAttributesImpl;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class ClientPartitionAdvisor {
    private final ConcurrentMap<Integer, List<BucketServerLocation66>> bucketServerLocationsMap = new ConcurrentHashMap<Integer, List<BucketServerLocation66>>();
    private final int totalNumBuckets;
    private String serverGroup = "";
    private final String colocatedWith;
    private PartitionResolver partitionResolver = null;
    private Map<String, List<Integer>> fixedPAMap = null;
    private boolean fpaAttrsCompletes = false;

    public ClientPartitionAdvisor(int totalNumBuckets, String colocatedWith, String partitionResolverName, Set<FixedPartitionAttributes> fpaSet) {
        this.totalNumBuckets = totalNumBuckets;
        this.colocatedWith = colocatedWith;
        try {
            if (partitionResolverName != null) {
                this.partitionResolver = (PartitionResolver)ClassPathLoader.getLatest().forName(partitionResolverName).newInstance();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new InternalGemFireException(LocalizedStrings.ClientPartitionAdvisor_CANNOT_CREATE_AN_INSTANCE_OF_PARTITION_RESOLVER_0.toLocalizedString(partitionResolverName));
        }
        if (fpaSet != null) {
            this.fixedPAMap = new ConcurrentHashMap<String, List<Integer>>();
            int totalFPABuckets = 0;
            for (FixedPartitionAttributes fpa : fpaSet) {
                ArrayList<Integer> attrList = new ArrayList<Integer>();
                totalFPABuckets += fpa.getNumBuckets();
                attrList.add(fpa.getNumBuckets());
                attrList.add(((FixedPartitionAttributesImpl)fpa).getStartingBucketID());
                this.fixedPAMap.put(fpa.getPartitionName(), attrList);
            }
            if (totalFPABuckets == this.totalNumBuckets) {
                this.fpaAttrsCompletes = true;
            }
        }
    }

    public ServerLocation adviseServerLocation(int bucketId) {
        if (this.bucketServerLocationsMap.containsKey(bucketId)) {
            List locations = (List)this.bucketServerLocationsMap.get(bucketId);
            ArrayList locationsCopy = new ArrayList(locations);
            if (locationsCopy.isEmpty()) {
                return null;
            }
            if (locationsCopy.size() == 1) {
                return (ServerLocation)locationsCopy.get(0);
            }
            int index2 = new Random().nextInt(locationsCopy.size() - 1);
            return (ServerLocation)locationsCopy.get(index2);
        }
        return null;
    }

    public ServerLocation adviseRandomServerLocation() {
        ArrayList bucketList = new ArrayList(this.bucketServerLocationsMap.keySet());
        if (bucketList.size() > 0) {
            Collections.shuffle(bucketList);
            List locations = (List)this.bucketServerLocationsMap.get(bucketList.get(0));
            if (locations != null) {
                ArrayList serverList = new ArrayList(locations);
                if (serverList.size() == 0) {
                    return null;
                }
                return (ServerLocation)serverList.get(0);
            }
        }
        return null;
    }

    public List<BucketServerLocation66> adviseServerLocations(int bucketId) {
        if (this.bucketServerLocationsMap.containsKey(bucketId)) {
            ArrayList<BucketServerLocation66> locationsCopy = new ArrayList<BucketServerLocation66>((Collection)this.bucketServerLocationsMap.get(bucketId));
            return locationsCopy;
        }
        return null;
    }

    public ServerLocation advisePrimaryServerLocation(int bucketId) {
        if (this.bucketServerLocationsMap.containsKey(bucketId)) {
            List locations = (List)this.bucketServerLocationsMap.get(bucketId);
            ArrayList locationsCopy = new ArrayList(locations);
            for (BucketServerLocation66 loc : locationsCopy) {
                if (!loc.isPrimary()) continue;
                return loc;
            }
        }
        return null;
    }

    public void updateBucketServerLocations(int bucketId, List<BucketServerLocation66> bucketServerLocations, ClientMetadataService cms) {
        List<BucketServerLocation66> locations;
        ArrayList<BucketServerLocation66> locationCopy = new ArrayList<BucketServerLocation66>();
        boolean honourSeverGroup = cms.honourServerGroup();
        if (this.serverGroup.length() != 0 && honourSeverGroup) {
            block0: for (BucketServerLocation66 s : bucketServerLocations) {
                String[] groups = s.getServerGroups();
                if (groups.length > 0) {
                    for (String str : groups) {
                        if (!str.equals(this.serverGroup)) continue;
                        locationCopy.add(s);
                        continue block0;
                    }
                    continue;
                }
                locationCopy.add(s);
            }
            locations = Collections.unmodifiableList(locationCopy);
        } else {
            locations = Collections.unmodifiableList(bucketServerLocations);
        }
        this.bucketServerLocationsMap.put(bucketId, locations);
    }

    public void removeBucketServerLocation(ServerLocation serverLocation) {
        for (Map.Entry entry : this.bucketServerLocationsMap.entrySet()) {
            Integer key2 = (Integer)entry.getKey();
            List oldLocations = (List)entry.getValue();
            ArrayList newLocations = new ArrayList(oldLocations);
            while (newLocations.remove(serverLocation) && !this.bucketServerLocationsMap.replace(key2, oldLocations, newLocations)) {
                oldLocations = (List)this.bucketServerLocationsMap.get(key2);
                newLocations = new ArrayList(oldLocations);
            }
        }
    }

    public Map<Integer, List<BucketServerLocation66>> getBucketServerLocationsMap_TEST_ONLY() {
        return this.bucketServerLocationsMap;
    }

    public int getTotalNumBuckets() {
        return this.totalNumBuckets;
    }

    public String getServerGroup() {
        return this.serverGroup;
    }

    public void setServerGroup(String group) {
        this.serverGroup = group;
    }

    public String getColocatedWith() {
        return this.colocatedWith;
    }

    public PartitionResolver getPartitionResolver() {
        return this.partitionResolver;
    }

    public Set<String> getFixedPartitionNames() {
        return this.fixedPAMap.keySet();
    }

    public int assignFixedBucketId(Region region, String partition, Object resolveKey) {
        if (this.fixedPAMap.containsKey(partition)) {
            List<Integer> attList = this.fixedPAMap.get(partition);
            int hc = resolveKey.hashCode();
            int bucketId = Math.abs(hc % attList.get(0));
            int partitionBucketID = bucketId + attList.get(1);
            return partitionBucketID;
        }
        return -1;
    }

    public Map<String, List<Integer>> getFixedPAMap() {
        return this.fixedPAMap;
    }

    public void updateFixedPAMap(Map<String, List<Integer>> map) {
        this.fixedPAMap.putAll(map);
    }

    public boolean isFPAAttrsComplete() {
        return this.fpaAttrsCompletes;
    }
}

