/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.client.internal;

import com.gemstone.gemfire.CancelException;
import com.gemstone.gemfire.cache.CacheLoaderException;
import com.gemstone.gemfire.cache.CacheWriterException;
import com.gemstone.gemfire.cache.NoSubscriptionServersAvailableException;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.client.Pool;
import com.gemstone.gemfire.cache.client.PoolManager;
import com.gemstone.gemfire.cache.client.ServerConnectivityException;
import com.gemstone.gemfire.cache.client.SubscriptionNotEnabledException;
import com.gemstone.gemfire.cache.client.internal.Connection;
import com.gemstone.gemfire.cache.client.internal.ExplicitConnectionSourceImpl;
import com.gemstone.gemfire.cache.client.internal.GetOp;
import com.gemstone.gemfire.cache.client.internal.Op;
import com.gemstone.gemfire.cache.client.internal.PoolImpl;
import com.gemstone.gemfire.cache.util.BridgeWriterException;
import com.gemstone.gemfire.cache.util.EndpointDoesNotExistException;
import com.gemstone.gemfire.cache.util.EndpointExistsException;
import com.gemstone.gemfire.cache.util.EndpointInUseException;
import com.gemstone.gemfire.distributed.internal.ServerLocation;
import com.gemstone.gemfire.internal.cache.PoolFactoryImpl;
import com.gemstone.gemfire.internal.cache.PoolManagerImpl;
import com.gemstone.gemfire.internal.cache.tier.ConnectionProxy;
import com.gemstone.gemfire.internal.logging.LogService;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.logging.log4j.Logger;

public class BridgePoolImpl
extends PoolImpl
implements ConnectionProxy {
    private static final Logger logger = LogService.getLogger();
    private static final AtomicInteger ID_COUNTER = new AtomicInteger();
    public static final int DEFAULT_CONNECTIONSPERSERVER = 1;
    public static final int DEFAULT_HANDSHAKE_TIMEOUT = 59000;
    public static final String DEFAULT_LBPOLICY = "Sticky";
    private boolean keepAlive;

    private static int getBridgePoolId() {
        return ID_COUNTER.incrementAndGet();
    }

    public static BridgePoolImpl create(Properties props, boolean usedByBridgeWriter) {
        return BridgePoolImpl.create(props, usedByBridgeWriter, false);
    }

    public static BridgePoolImpl create(Properties props, boolean usedByBridgeWriter, boolean usedByGateway) {
        String name = (usedByGateway ? "GatewayPool-" : "BridgePool-") + BridgePoolImpl.getBridgePoolId();
        PoolFactoryImpl pf = (PoolFactoryImpl)PoolManager.createFactory();
        pf.init(props, usedByBridgeWriter, usedByGateway);
        BridgePoolImpl result = (BridgePoolImpl)pf.create(name);
        if (!result.isDestroyed()) {
            result.attach();
        }
        return result;
    }

    public BridgePoolImpl(PoolManagerImpl pm, String name, Pool attributes) {
        super(pm, name, attributes);
        this.finishCreate(pm);
    }

    public static void loadEmergencyClasses() {
    }

    public void initialize(Properties p) {
        throw new IllegalStateException("nyi");
    }

    @Override
    public void finalizeProxy() {
        this.detach();
        if (this.getAttachCount() <= 0) {
            this.destroy(this.keepAlive);
        }
    }

    @Override
    public String getLBPolicy() {
        if (this.getThreadLocalConnections()) {
            return DEFAULT_LBPOLICY;
        }
        return "RoundRobin";
    }

    @Override
    public int getRetryInterval() {
        return (int)this.getPingInterval();
    }

    @Override
    public void close() {
        if (logger.isDebugEnabled()) {
            logger.debug("BridgePoolImpl - closing");
        }
        this.finalizeProxy();
    }

    @Override
    public boolean isOpen() {
        return !this.isDestroyed();
    }

    @Override
    public void detachRegion(Region r) {
    }

    @Override
    public int getConnectionsPerServer() {
        return this.getMinConnections();
    }

    @Override
    public void setServerUnavailable(String name) {
        throw new IllegalStateException("nyi");
    }

    @Override
    public void setServerAvailable(String name) {
        throw new IllegalStateException("nyi");
    }

    @Override
    public void terminate() {
        this.finalizeProxy();
    }

    @Override
    public void release() {
    }

    @Override
    public boolean getEstablishCallbackConnection() {
        return this.getSubscriptionEnabled();
    }

    @Override
    public void addEndpoint(String name, String host, int port) throws EndpointExistsException {
        ((ExplicitConnectionSourceImpl)this.getConnectionSource()).addEndpoint(host, port);
    }

    @Override
    public void removeEndpoint(String name, String host, int port) throws EndpointDoesNotExistException, EndpointInUseException {
        ((ExplicitConnectionSourceImpl)this.getConnectionSource()).removeEndpoint(host, port);
    }

    @Override
    public int getRedundancyLevel() {
        return this.getSubscriptionRedundancy();
    }

    @Override
    public long getMessageTrackingTimeout() {
        return this.getSubscriptionMessageTrackingTimeout();
    }

    @Override
    public void reuse() {
        this.attach();
    }

    public static boolean isLoaderOp(Op op) {
        return op instanceof GetOp.GetOpImpl;
    }

    private RuntimeException transformException(RuntimeException ex, Op op) {
        if (BridgePoolImpl.isLoaderOp(op)) {
            if (ex instanceof SubscriptionNotEnabledException) {
                return new CacheLoaderException("establishCallbackConnection must be set to true", ex);
            }
            if (ex instanceof CacheLoaderException) {
                return ex;
            }
            if (ex instanceof CancelException) {
                return ex;
            }
            if (ex instanceof ServerConnectivityException && ex.getCause() != null) {
                return new CacheLoaderException(ex.getCause());
            }
            return new CacheLoaderException(ex);
        }
        if (ex instanceof SubscriptionNotEnabledException) {
            return new BridgeWriterException("establishCallbackConnection must be set to true", ex);
        }
        if (ex instanceof CacheWriterException) {
            return ex;
        }
        if (ex instanceof CancelException) {
            return ex;
        }
        if (ex instanceof ServerConnectivityException && ex.getCause() != null) {
            return new BridgeWriterException(ex.getCause());
        }
        return new BridgeWriterException(ex);
    }

    @Override
    public Object execute(Op op) {
        try {
            return super.execute(op);
        }
        catch (RuntimeException ex) {
            throw this.transformException(ex, op);
        }
    }

    @Override
    public Object executeOn(ServerLocation server, Op op) {
        try {
            return super.executeOn(server, op);
        }
        catch (RuntimeException ex) {
            throw this.transformException(ex, op);
        }
    }

    @Override
    public Object executeOn(Connection con, Op op) {
        try {
            return super.executeOn(con, op);
        }
        catch (RuntimeException ex) {
            throw this.transformException(ex, op);
        }
    }

    @Override
    public Object executeOn(Connection con, Op op, boolean timeoutFatal) {
        try {
            return super.executeOn(con, op, timeoutFatal);
        }
        catch (RuntimeException ex) {
            throw this.transformException(ex, op);
        }
    }

    @Override
    public Object executeOnQueuesAndReturnPrimaryResult(Op op) {
        try {
            return super.executeOnQueuesAndReturnPrimaryResult(op);
        }
        catch (RuntimeException ex) {
            throw this.transformException(ex, op);
        }
    }

    @Override
    public void executeOnAllQueueServers(Op op) throws NoSubscriptionServersAvailableException, SubscriptionNotEnabledException {
        try {
            super.executeOnAllQueueServers(op);
        }
        catch (RuntimeException ex) {
            throw this.transformException(ex, op);
        }
    }

    @Override
    public Object executeOnPrimary(Op op) {
        try {
            return super.executeOnPrimary(op);
        }
        catch (RuntimeException ex) {
            throw this.transformException(ex, op);
        }
    }

    public void setKeepAlive(boolean keepAlive) {
        this.keepAlive = keepAlive;
    }

    public static class LBPolicy {
        public static final String STICKY_PROPERTY_NAME = "Sticky";
        public static final String RANDOMSTICKY_PROPERTY_NAME = "RandomSticky";
        public static final String ROUNDROBIN_PROPERTY_NAME = "RoundRobin";
        public static final String RANDOM_PROPERTY_NAME = "Random";
        public static final String APPASSISTED_PROPERTY_NAME = "AppAssisted";
        public static final int STICKY = 0;
        public static final int ROUNDROBIN = 1;
        public static final int APPASSISTED = 2;
        public static final int RANDOM = 3;
        public static final int RANDOMSTICKY = 4;
        public final int thePolicy;

        public LBPolicy(String name) {
            this.thePolicy = name.equalsIgnoreCase("Sticky") ? 0 : (name.equalsIgnoreCase(ROUNDROBIN_PROPERTY_NAME) ? 1 : (name.equalsIgnoreCase(APPASSISTED_PROPERTY_NAME) ? 2 : (name.equalsIgnoreCase(RANDOM_PROPERTY_NAME) ? 3 : (name.equalsIgnoreCase(RANDOMSTICKY_PROPERTY_NAME) ? 4 : 0))));
        }

        public int getPolicy() {
            return this.thePolicy;
        }

        public boolean isSticky() {
            return this.getPolicy() == 0 || this.getPolicy() == 4;
        }

        public boolean isRandom() {
            return this.getPolicy() == 3 || this.getPolicy() == 4;
        }

        public String getPolicyPropertyName(int pol) {
            String retStr;
            switch (pol) {
                case 0: {
                    retStr = "Sticky";
                    break;
                }
                case 1: {
                    retStr = ROUNDROBIN_PROPERTY_NAME;
                    break;
                }
                case 2: {
                    retStr = APPASSISTED_PROPERTY_NAME;
                    break;
                }
                case 3: {
                    retStr = RANDOM_PROPERTY_NAME;
                    break;
                }
                case 4: {
                    retStr = RANDOMSTICKY_PROPERTY_NAME;
                    break;
                }
                default: {
                    return Integer.toString(pol);
                }
            }
            return retStr;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof LBPolicy) {
                LBPolicy other = (LBPolicy)obj;
                return this.thePolicy == other.thePolicy;
            }
            return false;
        }

        public int hashCode() {
            return this.thePolicy;
        }

        public String toString() {
            return this.getPolicyPropertyName(this.thePolicy);
        }
    }
}

