/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.client.internal;

import com.gemstone.gemfire.cache.client.NoAvailableLocatorsException;
import com.gemstone.gemfire.cache.client.internal.ConnectionSource;
import com.gemstone.gemfire.cache.client.internal.InternalPool;
import com.gemstone.gemfire.cache.client.internal.LocatorDiscoveryCallback;
import com.gemstone.gemfire.cache.client.internal.LocatorDiscoveryCallbackAdapter;
import com.gemstone.gemfire.cache.client.internal.PoolImpl;
import com.gemstone.gemfire.cache.client.internal.locator.ClientConnectionRequest;
import com.gemstone.gemfire.cache.client.internal.locator.ClientConnectionResponse;
import com.gemstone.gemfire.cache.client.internal.locator.ClientReplacementRequest;
import com.gemstone.gemfire.cache.client.internal.locator.GetAllServersRequest;
import com.gemstone.gemfire.cache.client.internal.locator.GetAllServersResponse;
import com.gemstone.gemfire.cache.client.internal.locator.LocatorListRequest;
import com.gemstone.gemfire.cache.client.internal.locator.LocatorListResponse;
import com.gemstone.gemfire.cache.client.internal.locator.QueueConnectionRequest;
import com.gemstone.gemfire.cache.client.internal.locator.QueueConnectionResponse;
import com.gemstone.gemfire.cache.client.internal.locator.ServerLocationRequest;
import com.gemstone.gemfire.cache.client.internal.locator.ServerLocationResponse;
import com.gemstone.gemfire.distributed.internal.ServerLocation;
import com.gemstone.gemfire.internal.cache.tier.sockets.ClientProxyMembershipID;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.internal.logging.log4j.LocalizedMessage;
import com.gemstone.org.jgroups.stack.tcpserver.TcpClient;
import java.io.IOException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.logging.log4j.Logger;

public class AutoConnectionSourceImpl
implements ConnectionSource {
    private static final Logger logger = LogService.getLogger();
    protected static final LocatorListRequest LOCATOR_LIST_REQUEST = new LocatorListRequest();
    private static final Comparator<InetSocketAddress> SOCKET_ADDRESS_COMPARATOR = new Comparator<InetSocketAddress>(){

        @Override
        public int compare(InetSocketAddress o1, InetSocketAddress o2) {
            if (o1.getAddress() == null || o2.getAddress() == null) {
                return 0;
            }
            int result = o1.getAddress().getCanonicalHostName().compareTo(o1.getAddress().getCanonicalHostName());
            if (result != 0) {
                return result;
            }
            return o1.getPort() - o2.getPort();
        }
    };
    protected final List<InetSocketAddress> initialLocators;
    private final String serverGroup;
    private AtomicReference<LocatorList> locators = new AtomicReference();
    protected InternalPool pool;
    private final int connectionTimeout;
    private long pingInterval;
    private volatile LocatorDiscoveryCallback locatorCallback = new LocatorDiscoveryCallbackAdapter();
    private volatile boolean isBalanced = true;
    private final Map<InetSocketAddress, Exception> locatorState = new HashMap<InetSocketAddress, Exception>();

    public AutoConnectionSourceImpl(List<InetSocketAddress> contacts, String serverGroup, int handshakeTimeout) {
        ArrayList<InetSocketAddress> tmpContacts = new ArrayList<InetSocketAddress>(contacts);
        this.locators.set(new LocatorList(tmpContacts));
        this.initialLocators = Collections.unmodifiableList(tmpContacts);
        this.connectionTimeout = handshakeTimeout;
        this.serverGroup = serverGroup;
    }

    @Override
    public boolean isBalanced() {
        return this.isBalanced;
    }

    @Override
    public ServerLocation findReplacementServer(ServerLocation currentServer, Set excludedServers) {
        if (PoolImpl.TEST_DURABLE_IS_NET_DOWN) {
            return null;
        }
        ClientReplacementRequest request = new ClientReplacementRequest(currentServer, excludedServers, this.serverGroup);
        ClientConnectionResponse response = (ClientConnectionResponse)this.queryLocators(request);
        if (response == null) {
            throw new NoAvailableLocatorsException("Unable to connect to any locators in the list " + this.locators);
        }
        return response.getServer();
    }

    @Override
    public ServerLocation findServer(Set excludedServers) {
        if (PoolImpl.TEST_DURABLE_IS_NET_DOWN) {
            return null;
        }
        ClientConnectionRequest request = new ClientConnectionRequest(excludedServers, this.serverGroup);
        ClientConnectionResponse response = (ClientConnectionResponse)this.queryLocators(request);
        if (response == null) {
            throw new NoAvailableLocatorsException("Unable to connect to any locators in the list " + this.locators);
        }
        return response.getServer();
    }

    public ArrayList<ServerLocation> findAllServers() {
        if (PoolImpl.TEST_DURABLE_IS_NET_DOWN) {
            return null;
        }
        GetAllServersRequest request = new GetAllServersRequest(this.serverGroup);
        GetAllServersResponse response = (GetAllServersResponse)this.queryLocators(request);
        if (response != null) {
            return response.getServers();
        }
        return null;
    }

    @Override
    public List findServersForQueue(Set excludedServers, int numServers, ClientProxyMembershipID proxyId, boolean findDurableQueue) {
        if (PoolImpl.TEST_DURABLE_IS_NET_DOWN) {
            return new ArrayList();
        }
        QueueConnectionRequest request = new QueueConnectionRequest(proxyId, numServers, excludedServers, this.serverGroup, findDurableQueue);
        QueueConnectionResponse response = (QueueConnectionResponse)this.queryLocators(request);
        if (response == null) {
            throw new NoAvailableLocatorsException("Unable to connect to any locators in the list " + this.locators);
        }
        List result = response.getServers();
        return result;
    }

    private ServerLocationResponse queryOneLocator(InetSocketAddress locator, ServerLocationRequest request) {
        InetAddress addr = locator.getAddress();
        int port = locator.getPort();
        Object returnObj = null;
        try {
            this.pool.getStats().incLocatorRequests();
            returnObj = TcpClient.requestToServer(addr, port, request, this.connectionTimeout);
            ServerLocationResponse response = (ServerLocationResponse)returnObj;
            this.pool.getStats().incLocatorResponses();
            if (response != null) {
                this.reportLiveLocator(locator);
            }
            return response;
        }
        catch (IOException ioe) {
            this.reportDeadLocator(locator, ioe);
            return null;
        }
        catch (ClassNotFoundException e) {
            logger.warn(LocalizedMessage.create(LocalizedStrings.AutoConnectionSourceImpl_RECEIVED_EXCEPTION_FROM_LOCATOR_0, locator), (Throwable)e);
            return null;
        }
        catch (ClassCastException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("Received odd response object from the locator: {}", returnObj);
            }
            this.reportDeadLocator(locator, e);
            return null;
        }
    }

    protected ServerLocationResponse queryLocators(ServerLocationRequest request) {
        Iterator<InetSocketAddress> controllerItr = this.locators.get().iterator();
        ServerLocationResponse response = null;
        boolean isDebugEnabled = logger.isDebugEnabled();
        do {
            InetSocketAddress locator = controllerItr.next();
            if (isDebugEnabled) {
                logger.debug("Sending query to locator {}: {}", locator, request);
            }
            response = this.queryOneLocator(locator, request);
            if (!isDebugEnabled) continue;
            logger.debug("Received query response from locator {}: {}", locator, response);
        } while (controllerItr.hasNext() && (response == null || !response.hasResult()));
        if (response == null) {
            return null;
        }
        return response;
    }

    protected void updateLocatorList(LocatorListResponse response) {
        if (response == null) {
            return;
        }
        this.isBalanced = response.isBalanced();
        ArrayList locatorResponse = response.getLocators();
        ArrayList<InetSocketAddress> newLocators = new ArrayList<InetSocketAddress>(locatorResponse.size());
        HashSet<InetSocketAddress> badLocators = new HashSet<InetSocketAddress>(this.initialLocators);
        for (ServerLocation locator : locatorResponse) {
            InetSocketAddress address = new InetSocketAddress(locator.getHostName(), locator.getPort());
            newLocators.add(address);
            badLocators.remove(address);
        }
        newLocators.addAll(badLocators);
        if (logger.isInfoEnabled()) {
            LocatorList oldLocators = this.locators.get();
            ArrayList<InetSocketAddress> removedLocators = new ArrayList<InetSocketAddress>(oldLocators.getLocators());
            removedLocators.removeAll(newLocators);
            ArrayList<InetSocketAddress> addedLocators = new ArrayList<InetSocketAddress>(newLocators);
            addedLocators.removeAll(oldLocators.getLocators());
            if (!addedLocators.isEmpty()) {
                this.locatorCallback.locatorsDiscovered(Collections.unmodifiableList(addedLocators));
                logger.info(LocalizedMessage.create(LocalizedStrings.AutoConnectionSourceImpl_AUTOCONNECTIONSOURCE_DISCOVERED_NEW_LOCATORS_0, addedLocators));
            }
            if (!removedLocators.isEmpty()) {
                this.locatorCallback.locatorsRemoved(Collections.unmodifiableList(removedLocators));
                logger.info(LocalizedMessage.create(LocalizedStrings.AutoConnectionSourceImpl_AUTOCONNECTIONSOURCE_DROPPING_PREVIOUSLY_DISCOVERED_LOCATORS_0, removedLocators));
            }
        }
        LocatorList newLocatorList = new LocatorList(newLocators);
        this.locators.set(newLocatorList);
        this.pool.getStats().setLocatorCount(newLocators.size());
    }

    @Override
    public void start(InternalPool pool) {
        this.pool = pool;
        pool.getStats().setInitialContacts(this.locators.get().size());
        this.pingInterval = pool.getPingInterval();
        pool.getBackgroundProcessor().scheduleWithFixedDelay(new UpdateLocatorListTask(), 0L, this.pingInterval, TimeUnit.MILLISECONDS);
    }

    @Override
    public void stop() {
    }

    public void setLocatorDiscoveryCallback(LocatorDiscoveryCallback callback) {
        this.locatorCallback = callback;
    }

    private synchronized void reportLiveLocator(InetSocketAddress l) {
        Object prevState = this.locatorState.put(l, null);
        if (prevState != null) {
            logger.info(LocalizedMessage.create(LocalizedStrings.AutoConnectionSourceImpl_COMMUNICATION_HAS_BEEN_RESTORED_WITH_LOCATOR_0, l));
        }
    }

    private synchronized void reportDeadLocator(InetSocketAddress l, Exception ex) {
        Exception prevState = this.locatorState.put(l, ex);
        if (prevState == null) {
            if (ex instanceof ConnectException) {
                logger.info(LocalizedMessage.create(LocalizedStrings.AutoConnectionSourceImpl_LOCATOR_0_IS_NOT_RUNNING, l), (Throwable)ex);
            } else {
                logger.info(LocalizedMessage.create(LocalizedStrings.AutoConnectionSourceImpl_COMMUNICATION_WITH_LOCATOR_0_FAILED_WITH_1, new Object[]{l, ex}), (Throwable)ex);
            }
        }
    }

    protected class UpdateLocatorListTask
    extends PoolImpl.PoolTask {
        protected UpdateLocatorListTask() {
        }

        @Override
        public void run2() {
            if (AutoConnectionSourceImpl.this.pool.getCancelCriterion().cancelInProgress() != null) {
                return;
            }
            LocatorListResponse response = (LocatorListResponse)AutoConnectionSourceImpl.this.queryLocators(LOCATOR_LIST_REQUEST);
            AutoConnectionSourceImpl.this.updateLocatorList(response);
        }
    }

    private static class LocatorList {
        protected final List<InetSocketAddress> locators;
        protected AtomicInteger currentLocatorIndex = new AtomicInteger();

        public LocatorList(List<InetSocketAddress> locators) {
            Collections.sort(locators, SOCKET_ADDRESS_COMPARATOR);
            this.locators = Collections.unmodifiableList(locators);
        }

        public Collection<InetSocketAddress> getLocators() {
            return this.locators;
        }

        public int size() {
            return this.locators.size();
        }

        public Iterator<InetSocketAddress> iterator() {
            return new LocatorIterator();
        }

        public String toString() {
            return this.locators.toString();
        }

        protected class LocatorIterator
        implements Iterator<InetSocketAddress> {
            private int startLocator;
            private int locatorNum;

            protected LocatorIterator() {
                this.startLocator = LocatorList.this.currentLocatorIndex.get();
                this.locatorNum = 0;
            }

            @Override
            public boolean hasNext() {
                return this.locatorNum < LocatorList.this.locators.size();
            }

            @Override
            public InetSocketAddress next() {
                if (!this.hasNext()) {
                    return null;
                }
                int index2 = (this.locatorNum + this.startLocator) % LocatorList.this.locators.size();
                InetSocketAddress nextLocator = LocatorList.this.locators.get(index2);
                LocatorList.this.currentLocatorIndex.set(index2);
                ++this.locatorNum;
                return nextLocator;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        }
    }
}

